/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.readers;

import java.io.IOException;
import java.io.Reader;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterChannelReader
extends Reader {
    private static final Logger log = LoggerFactory.getLogger(CharacterChannelReader.class);
    private CharacterChannel channel;

    public CharacterChannelReader(CharacterChannel channel) {
        this.channel = channel;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Read offset: %d length: %d", off, len));
        }
        if (!this.channel.hasReachedEnd()) {
            try {
                String content = this.channel.read(len);
                if (!content.isEmpty()) {
                    char[] chars = content.toCharArray();
                    System.arraycopy(chars, 0, cbuf, off, chars.length);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("No of characters read: %d", chars.length));
                    }
                    return chars.length;
                }
            }
            catch (BallerinaIOException e) {
                throw new IOException(e);
            }
        }
        return -1;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

