/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.ballerinalang.jvm.BallerinaErrors;
import org.ballerinalang.jvm.BallerinaValues;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BPackage;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ArrayValueImpl;
import org.ballerinalang.jvm.values.ErrorValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.utils.Base64ByteChannel;
import org.ballerinalang.stdlib.io.utils.Base64Wrapper;
import org.ballerinalang.stdlib.io.utils.IOConstants;

public class Utils {
    private static final int READABLE_BUFFER_SIZE = 8192;
    private static final BPackage PACKAGE_ID_MIME = new BPackage("ballerina", "mime");
    private static final String MIME_ERROR_MESSAGE = "message";
    private static final String ERROR_RECORD_TYPE = "Detail";
    private static final String STRUCT_TYPE = "ReadableByteChannel";
    private static final String ERROR_CAUSE_FIELD = "cause";
    private static final String ENCODING_ERROR = "{ballerina/mime}EncodingFailed";
    private static final String DECODING_ERROR = "{ballerina/mime}DecodingFailed";

    private static ErrorValue createBase64Error(String reason, String msg, boolean isMimeSpecific) {
        if (isMimeSpecific) {
            return BallerinaErrors.createError((String)reason, (MapValue)Utils.populateMimeErrorRecord(null, msg));
        }
        return BallerinaErrors.createError((String)IOConstants.ErrorCode.GenericError.errorCode(), (String)msg);
    }

    public static MapValue populateMimeErrorRecord(ErrorValue errorValue, String msg) {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        if (errorValue != null) {
            valueMap.put(ERROR_CAUSE_FIELD, (Object)errorValue);
        }
        if (msg != null) {
            valueMap.put(MIME_ERROR_MESSAGE, msg);
        }
        return BallerinaValues.createRecordValue((BPackage)PACKAGE_ID_MIME, (String)ERROR_RECORD_TYPE, valueMap);
    }

    private static byte[] getByteArray(InputStream input) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = input.read(buffer)) != -1) {
                output.write(buffer, 0, len);
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static Object encode(Object input, String charset, boolean isMimeSpecific) {
        switch (TypeChecker.getType((Object)input).getTag()) {
            case 20: {
                return Utils.encodeBlob(((ArrayValue)input).getBytes(), isMimeSpecific);
            }
            case 12: 
            case 34: {
                ObjectValue byteChannel = (ObjectValue)input;
                if (STRUCT_TYPE.equals(byteChannel.getType().getName())) {
                    return Utils.encodeByteChannel(byteChannel, isMimeSpecific);
                }
                return Utils.createBase64Error(ENCODING_ERROR, "incompatible object", isMimeSpecific);
            }
            case 5: {
                return Utils.encodeString(input.toString(), charset, isMimeSpecific);
            }
        }
        return Utils.createBase64Error(ENCODING_ERROR, "incompatible input", isMimeSpecific);
    }

    public static Object decode(Object encodedInput, String charset, boolean isMimeSpecific) {
        switch (TypeChecker.getType((Object)encodedInput).getTag()) {
            case 20: {
                return Utils.decodeBlob(((ArrayValue)encodedInput).getBytes(), isMimeSpecific);
            }
            case 12: 
            case 34: {
                return Utils.decodeByteChannel((ObjectValue)encodedInput, isMimeSpecific);
            }
            case 5: {
                return Utils.decodeString(encodedInput, charset, isMimeSpecific);
            }
        }
        return Utils.createBase64Error(DECODING_ERROR, "incompatible input", isMimeSpecific);
    }

    public static Object encodeString(String stringToBeEncoded, String charset, boolean isMimeSpecific) {
        try {
            byte[] encodedValue = isMimeSpecific ? Base64.getMimeEncoder().encode(stringToBeEncoded.getBytes(charset)) : Base64.getEncoder().encode(stringToBeEncoded.getBytes(charset));
            return new String(encodedValue, StandardCharsets.ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            return Utils.createBase64Error(DECODING_ERROR, e.getMessage(), isMimeSpecific);
        }
    }

    private static Object decodeString(Object stringToBeDecoded, String charset, boolean isMimeSpecific) {
        try {
            byte[] decodedValue = isMimeSpecific ? Base64.getMimeDecoder().decode(stringToBeDecoded.toString().getBytes(StandardCharsets.ISO_8859_1)) : Base64.getDecoder().decode(stringToBeDecoded.toString().getBytes(StandardCharsets.ISO_8859_1));
            return new String(decodedValue, charset);
        }
        catch (UnsupportedEncodingException e) {
            return Utils.createBase64Error(DECODING_ERROR, e.getMessage(), isMimeSpecific);
        }
    }

    public static Object encodeByteChannel(ObjectValue byteChannel, boolean isMimeSpecific) {
        Channel channel = (Channel)byteChannel.getNativeData("byteChannel");
        try {
            byte[] encodedByteArray = isMimeSpecific ? Base64.getMimeEncoder().encode(Utils.getByteArray(channel.getInputStream())) : Base64.getEncoder().encode(Utils.getByteArray(channel.getInputStream()));
            ByteArrayInputStream encodedStream = new ByteArrayInputStream(encodedByteArray);
            Base64ByteChannel decodedByteChannel = new Base64ByteChannel(encodedStream);
            ObjectValue byteChannelObj = BallerinaValues.createObjectValue((BPackage)IOConstants.IO_PACKAGE_ID, (String)STRUCT_TYPE, (Object[])new Object[0]);
            byteChannelObj.addNativeData("byteChannel", (Object)new Base64Wrapper(decodedByteChannel));
            return byteChannelObj;
        }
        catch (IOException e) {
            return Utils.createBase64Error(ENCODING_ERROR, e.getMessage(), isMimeSpecific);
        }
    }

    public static Object decodeByteChannel(ObjectValue byteChannel, boolean isMimeSpecific) {
        Channel channel = (Channel)byteChannel.getNativeData("byteChannel");
        try {
            byte[] decodedByteArray = isMimeSpecific ? Base64.getMimeDecoder().decode(Utils.getByteArray(channel.getInputStream())) : Base64.getDecoder().decode(Utils.getByteArray(channel.getInputStream()));
            ByteArrayInputStream decodedStream = new ByteArrayInputStream(decodedByteArray);
            Base64ByteChannel decodedByteChannel = new Base64ByteChannel(decodedStream);
            ObjectValue byteChannelObj = BallerinaValues.createObjectValue((BPackage)IOConstants.IO_PACKAGE_ID, (String)STRUCT_TYPE, (Object[])new Object[0]);
            byteChannelObj.addNativeData("byteChannel", (Object)new Base64Wrapper(decodedByteChannel));
            return byteChannelObj;
        }
        catch (IOException e) {
            return Utils.createBase64Error(DECODING_ERROR, e.getMessage(), isMimeSpecific);
        }
    }

    public static ArrayValue encodeBlob(byte[] bytes, boolean isMimeSpecific) {
        byte[] encodedContent = isMimeSpecific ? Base64.getMimeEncoder().encode(bytes) : Base64.getEncoder().encode(bytes);
        return new ArrayValueImpl(encodedContent);
    }

    public static ArrayValue decodeBlob(byte[] encodedContent, boolean isMimeSpecific) {
        byte[] decodedContent = isMimeSpecific ? Base64.getMimeDecoder().decode(encodedContent) : Base64.getDecoder().decode(encodedContent);
        return new ArrayValueImpl(decodedContent);
    }

    public static String sanitizeText(String text) {
        return text.replace("\r", " ").replace("\n", " ");
    }
}

