/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class BlobChannel
implements ByteChannel {
    private ReadableByteChannel readableChannel;
    private WritableByteChannel writableChannel;

    public BlobChannel(ReadableByteChannel channel) {
        this.readableChannel = channel;
    }

    public BlobChannel(WritableByteChannel channel) {
        this.writableChannel = channel;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (this.readableChannel == null) {
            throw new UnsupportedOperationException();
        }
        return this.readableChannel.read(dst);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        if (this.writableChannel == null) {
            throw new UnsupportedOperationException();
        }
        return this.writableChannel.write(src);
    }

    @Override
    public boolean isOpen() {
        if (this.readableChannel != null) {
            return this.readableChannel.isOpen();
        }
        return this.writableChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this.readableChannel != null) {
            this.readableChannel.close();
        } else {
            this.writableChannel.close();
        }
    }

    public boolean isReadable() {
        return this.readableChannel != null;
    }
}

