/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.XmlUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import java.io.IOException;
import java.io.Reader;
import java.nio.channels.ClosedChannelException;
import org.ballerinalang.stdlib.io.channels.base.Channel;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.readers.CharacterChannelReader;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.ballerinalang.stdlib.io.utils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterChannelUtils {
    private static final Logger log = LoggerFactory.getLogger(CharacterChannelUtils.class);

    private CharacterChannelUtils() {
    }

    public static void initCharacterChannel(BObject characterChannel, BObject byteChannelInfo, BString encoding) {
        try {
            Channel byteChannel = (Channel)byteChannelInfo.getNativeData("byteChannel");
            CharacterChannel bCharacterChannel = new CharacterChannel(byteChannel, encoding.getValue());
            characterChannel.addNativeData("char_channel", (Object)bCharacterChannel);
        }
        catch (Exception e) {
            String message = "error occurred while converting byte channel to character channel: " + e.getMessage();
            log.error(message, (Throwable)e);
            throw IOUtils.createError(message);
        }
    }

    public static Object read(BObject channel, long numberOfCharacters) {
        CharacterChannel characterChannel = (CharacterChannel)channel.getNativeData("char_channel");
        if (characterChannel.hasReachedEnd()) {
            return IOUtils.createEoFError();
        }
        try {
            return StringUtils.fromString((String)characterChannel.read((int)numberOfCharacters));
        }
        catch (BallerinaIOException e) {
            log.error("error occurred while reading characters.", (Throwable)e);
            return IOUtils.createError(e);
        }
    }

    public static Object readJson(BObject channel) {
        CharacterChannel charChannel = (CharacterChannel)channel.getNativeData("char_channel");
        CharacterChannelReader reader = new CharacterChannelReader(charChannel);
        try {
            Object returnValue = JsonUtils.parse((Reader)reader, (JsonUtils.NonStringValueProcessingMode)JsonUtils.NonStringValueProcessingMode.FROM_JSON_STRING);
            if (returnValue instanceof String) {
                return StringUtils.fromString((String)((String)returnValue));
            }
            return returnValue;
        }
        catch (BError e) {
            log.error("unable to read json from character channel", (Throwable)e);
            return IOUtils.createError(e);
        }
    }

    public static Object readXml(BObject channel) {
        CharacterChannel charChannel = (CharacterChannel)channel.getNativeData("char_channel");
        CharacterChannelReader reader = new CharacterChannelReader(charChannel);
        try {
            return XmlUtils.parse((Reader)reader);
        }
        catch (BError e) {
            return IOUtils.createError(e);
        }
    }

    public static Object readProperty(BObject channel, BString key, BString defaultValue) {
        CharacterChannel charChannel = (CharacterChannel)channel.getNativeData("char_channel");
        CharacterChannelReader reader = new CharacterChannelReader(charChannel);
        try {
            return PropertyUtils.readProperty(reader, key, defaultValue, Integer.toString(charChannel.id()));
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object readAllProperties(BObject channel) {
        CharacterChannel charChannel = (CharacterChannel)channel.getNativeData("char_channel");
        CharacterChannelReader reader = new CharacterChannelReader(charChannel);
        try {
            return PropertyUtils.readAllProperties(reader, Integer.toString(charChannel.id()));
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object close(BObject channel) {
        CharacterChannel charChannel = (CharacterChannel)channel.getNativeData("char_channel");
        try {
            charChannel.close();
        }
        catch (ClosedChannelException e) {
            return IOUtils.createError("channel already closed.");
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object write(BObject channel, BString content, long startOffset) {
        CharacterChannel characterChannel = (CharacterChannel)channel.getNativeData("char_channel");
        try {
            return characterChannel.write(content.getValue(), (int)startOffset);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
    }

    public static Object writeJson(BObject characterChannelObj, Object content) {
        try {
            CharacterChannel characterChannel = (CharacterChannel)characterChannelObj.getNativeData("char_channel");
            IOUtils.writeFull(characterChannel, StringUtils.getJsonString((Object)content));
        }
        catch (BallerinaIOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeXml(BObject characterChannelObj, BXml content) {
        try {
            CharacterChannel characterChannel = (CharacterChannel)characterChannelObj.getNativeData("char_channel");
            IOUtils.writeFull(characterChannel, content.toString());
        }
        catch (BallerinaIOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object writeProperties(BObject characterChannelObj, BMap<BString, BString> propertyMap, BString comment) {
        try {
            CharacterChannel characterChannel = (CharacterChannel)characterChannelObj.getNativeData("char_channel");
            PropertyUtils.writePropertyContent(characterChannel, propertyMap, comment);
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }
}

