/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.ballerinalang.stdlib.io.channels.base.CharacterChannel;
import org.ballerinalang.stdlib.io.channels.base.DelimitedRecordChannel;
import org.ballerinalang.stdlib.io.csv.Format;
import org.ballerinalang.stdlib.io.utils.BallerinaIOException;
import org.ballerinalang.stdlib.io.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordChannelUtils {
    private static final Logger log = LoggerFactory.getLogger(RecordChannelUtils.class);
    private static final String DEFAULT = "default";

    private RecordChannelUtils() {
    }

    public static void initRecordChannel(BObject textRecordChannel, BObject characterChannelInfo, BString fieldSeparator, BString recordSeparator, BString format) {
        try {
            CharacterChannel characterChannel = (CharacterChannel)characterChannelInfo.getNativeData("char_channel");
            DelimitedRecordChannel delimitedRecordChannel = DEFAULT.equals(format.getValue()) ? new DelimitedRecordChannel(characterChannel, recordSeparator.getValue(), fieldSeparator.getValue()) : new DelimitedRecordChannel(characterChannel, Format.valueOf(format.getValue()));
            textRecordChannel.addNativeData("txt_record", (Object)delimitedRecordChannel);
        }
        catch (Exception e) {
            String message = "error occurred while converting character channel to textRecord channel: " + e.getMessage();
            log.error(message, (Throwable)e);
            throw IOUtils.createError(message);
        }
    }

    public static boolean hasNext(BObject channel) {
        Object textChannel = channel.getNativeData("txt_record");
        if (textChannel == null) {
            return false;
        }
        DelimitedRecordChannel textRecordChannel = (DelimitedRecordChannel)textChannel;
        if (!textRecordChannel.hasReachedEnd()) {
            try {
                return textRecordChannel.hasNext();
            }
            catch (BallerinaIOException e) {
                String msg = "error occurred while checking hasNext on ReadableTextRecordChannel: " + e.getMessage();
                log.error(msg, (Throwable)e);
                throw IOUtils.createError(msg);
            }
        }
        return false;
    }

    public static Object getNext(BObject channel) {
        DelimitedRecordChannel textRecordChannel = (DelimitedRecordChannel)channel.getNativeData("txt_record");
        if (textRecordChannel.hasReachedEnd()) {
            return IOUtils.createEoFError();
        }
        try {
            String[] records = textRecordChannel.read();
            return StringUtils.fromStringArray((String[])records);
        }
        catch (BallerinaIOException e) {
            log.error("error occurred while reading next text record from ReadableTextRecordChannel", (Throwable)e);
            return IOUtils.createError(e);
        }
    }

    public static Object write(BObject channel, BArray content) {
        DelimitedRecordChannel delimitedRecordChannel = (DelimitedRecordChannel)channel.getNativeData("txt_record");
        try {
            delimitedRecordChannel.write(content.getStringArray());
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }

    public static Object close(BObject channel) {
        DelimitedRecordChannel recordChannel = (DelimitedRecordChannel)channel.getNativeData("txt_record");
        try {
            recordChannel.close();
        }
        catch (ClosedChannelException e) {
            return IOUtils.createError("channel already closed.");
        }
        catch (IOException e) {
            return IOUtils.createError(e);
        }
        return null;
    }
}

