/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.stdlib.io.nativeimpl;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BString;
import java.util.IllegalFormatConversionException;

public class Sprintf {
    private static final BString NOT_ENOUGH_FORMAT_ARGUMENTS = StringUtils.fromString((String)"not enough format arguments");

    private Sprintf() {
    }

    public static BString sprintf(BString format, Object ... args) {
        StringBuilder result = new StringBuilder();
        int k = 0;
        for (int i = 0; i < format.length(); ++i) {
            if (format.getValue().charAt(i) == '%' && i + 1 < format.length()) {
                int j = i + 1;
                if (k >= args.length) {
                    throw ErrorCreator.createError((BString)NOT_ENOUGH_FORMAT_ARGUMENTS);
                }
                StringBuilder padding = new StringBuilder();
                while (Character.isDigit(format.getValue().charAt(j)) || format.getValue().charAt(j) == '.') {
                    padding.append(format.getValue().charAt(j));
                    ++j;
                }
                try {
                    char formatSpecifier = format.getValue().charAt(j);
                    Object ref = args[k];
                    switch (formatSpecifier) {
                        case 'B': 
                        case 'b': 
                        case 'd': 
                        case 'f': {
                            if (ref == null) {
                                throw ErrorCreator.createError((BString)StringUtils.fromString((String)("illegal format conversion '" + format.getValue().charAt(j) + " != ()'")));
                            }
                            result.append(String.format("%" + padding + formatSpecifier, ref));
                            break;
                        }
                        case 'X': 
                        case 'x': {
                            if (ref == null) {
                                throw ErrorCreator.createError((BString)StringUtils.fromString((String)("illegal format conversion '" + format.getValue().charAt(j) + " != ()'")));
                            }
                            Sprintf.formatHexString(result, k, padding, formatSpecifier, args);
                            break;
                        }
                        case 's': {
                            if (ref != null) {
                                result.append(String.format("%" + padding + "s", StringUtils.getStringValue((Object)ref, null)));
                            }
                            break;
                        }
                        case '%': {
                            result.append("%");
                            break;
                        }
                        default: {
                            throw ErrorCreator.createError((BString)StringUtils.fromString((String)("unknown format conversion '" + format.getValue().charAt(j) + "'")));
                        }
                    }
                }
                catch (IllegalFormatConversionException e) {
                    throw ErrorCreator.createError((BString)StringUtils.fromString((String)("illegal format conversion '" + format.getValue().charAt(j) + " != " + TypeUtils.getType((Object)args[k]) + "'")));
                }
                if (format.getValue().charAt(j) == '%') {
                    ++i;
                    continue;
                }
                ++k;
                i = j;
                continue;
            }
            result.append(format.getValue().charAt(i));
        }
        return StringUtils.fromString((String)result.toString());
    }

    private static void formatHexString(StringBuilder result, int k, StringBuilder padding, char x, Object ... args) {
        Object argsValues = args[k];
        Type type = TypeUtils.getType((Object)argsValues);
        if (20 == type.getTag() && 2 == ((ArrayType)type).getElementType().getTag()) {
            BArray byteArray = (BArray)argsValues;
            for (int i = 0; i < byteArray.size(); ++i) {
                result.append(String.format("%" + padding + x, byteArray.getByte((long)i)));
            }
        } else {
            result.append(String.format("%" + padding + x, argsValues));
        }
    }
}

