/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.ballerinalang.connector.api.Annotation;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.net.jms.BallerinaJMSMessage;
import org.ballerinalang.net.jms.Constants;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JMSUtils.class);

    private JMSUtils() {
    }

    public static Map<String, String> preProcessServiceConfig(Annotation jmsConfig) {
        HashMap<String, String> configParams = new HashMap<String, String>();
        Struct configStruct = jmsConfig.getValue();
        if (Objects.isNull(configStruct)) {
            return configParams;
        }
        JMSUtils.addStringParamIfPresent("destination", configStruct, configParams);
        JMSUtils.addStringParamIfPresent("connectionFactoryName", configStruct, configParams);
        JMSUtils.addStringParamIfPresent("destinationType", configStruct, configParams);
        JMSUtils.addStringParamIfPresent("clientId", configStruct, configParams);
        JMSUtils.addStringParamIfPresent("subscriptionId", configStruct, configParams);
        JMSUtils.addStringParamIfPresent("acknowledgementMode", configStruct, configParams);
        JMSUtils.preProcessMapField(configParams, configStruct.getMapField("properties"));
        return configParams;
    }

    public static Connection createConnection(Struct connectionConfig) {
        HashMap<String, String> configParams = new HashMap<String, String>();
        String initialContextFactory = connectionConfig.getStringField("initialContextFactory");
        configParams.put("initialContextFactory", initialContextFactory);
        String providerUrl = connectionConfig.getStringField("providerUrl");
        configParams.put("providerUrl", providerUrl);
        String factoryName = connectionConfig.getStringField("connectionFactoryName");
        configParams.put("connectionFactoryName", factoryName);
        JMSUtils.preProcessIfWso2MB(configParams);
        JMSUtils.updateMappedParameters(configParams);
        Properties properties = new Properties();
        configParams.forEach(properties::put);
        try {
            InitialContext initialContext = new InitialContext(properties);
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup(factoryName);
            return connectionFactory.createConnection();
        }
        catch (JMSException | NamingException e) {
            String message = "Error while connecting to broker.";
            LOGGER.error(message, e);
            throw new BallerinaException(message + " " + e.getMessage(), e);
        }
    }

    public static Session createSession(Connection connection, Struct sessionConfig) {
        int sessionAckMode;
        String ackModeString;
        boolean transactedSession = false;
        switch (ackModeString = sessionConfig.getStringField("acknowledgementMode")) {
            case "CLIENT_ACKNOWLEDGE": {
                sessionAckMode = 2;
                break;
            }
            case "SESSION_TRANSACTED": {
                sessionAckMode = 0;
                transactedSession = true;
                break;
            }
            case "DUPS_OK_ACKNOWLEDGE": {
                sessionAckMode = 3;
                break;
            }
            case "AUTO_ACKNOWLEDGE": {
                sessionAckMode = 1;
                break;
            }
            default: {
                throw new BallerinaException("Unknown acknowledgment mode: " + ackModeString);
            }
        }
        try {
            return connection.createSession(transactedSession, sessionAckMode);
        }
        catch (JMSException e) {
            String message = "Error while creating session.";
            LOGGER.error(message, (Throwable)e);
            throw new BallerinaException(message + " " + e.getMessage(), (Throwable)e);
        }
    }

    public static boolean isNullOrEmptyAfterTrim(String str) {
        return str == null || str.trim().isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void preProcessIfWso2MB(Map<String, String> configParams) {
        String initialConnectionFactoryName = configParams.get("initialContextFactory");
        if (!"bmbInitialContextFactory".equalsIgnoreCase(initialConnectionFactoryName) && !"wso2mbInitialContextFactory".equalsIgnoreCase(initialConnectionFactoryName)) return;
        configParams.put("initialContextFactory", "org.wso2.andes.jndi.PropertiesFileInitialContextFactory");
        String connectionFactoryName = configParams.get("connectionFactoryName");
        if (configParams.get("providerUrl") != null) {
            System.setProperty("qpid.dest_syntax", "BURL");
            if (JMSUtils.isNullOrEmptyAfterTrim(connectionFactoryName)) throw new BallerinaException("connectionFactoryName property should be set");
            configParams.put("connectionfactory." + connectionFactoryName, configParams.get("providerUrl"));
            configParams.remove("providerUrl");
            return;
        } else {
            if (configParams.get("configFilePath") == null) return;
            configParams.put("providerUrl", configParams.get("configFilePath"));
            configParams.remove("configFilePath");
        }
    }

    public static void updateMappedParameters(Map<String, String> configParams) {
        Iterator<Map.Entry<String, String>> iterator = configParams.entrySet().iterator();
        HashMap<String, String> tempMap = new HashMap<String, String>();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String mappedParam = Constants.MAPPING_PARAMETERS.get(entry.getKey());
            if (mappedParam == null) continue;
            tempMap.put(mappedParam, entry.getValue());
            iterator.remove();
        }
        configParams.putAll(tempMap);
    }

    private static void addStringParamIfPresent(String paramName, Struct configStruct, Map<String, String> paramsMap) {
        String param = configStruct.getStringField(paramName);
        if (Objects.nonNull(param) && !param.isEmpty()) {
            paramsMap.put(paramName, param);
        }
    }

    private static void preProcessMapField(Map<String, String> configParams, Map<String, Value> properties) {
        if (Objects.isNull(properties)) {
            return;
        }
        for (Map.Entry<String, Value> entry : properties.entrySet()) {
            configParams.put(entry.getKey(), entry.getValue().getStringValue());
        }
    }

    public static Message getJMSMessage(BStruct messageStruct) {
        Object nativeData = messageStruct.getNativeData("jms_message_object");
        if (nativeData instanceof Message) {
            return (Message)nativeData;
        }
        throw new BallerinaException("JMS message has not been created.");
    }

    public static BallerinaJMSMessage buildBallerinaJMSMessage(Message message) {
        BallerinaJMSMessage ballerinaJMSMessage = new BallerinaJMSMessage(message);
        try {
            if (message.getJMSReplyTo() != null) {
                if (message.getJMSReplyTo() instanceof Queue) {
                    ballerinaJMSMessage.setReplyDestinationName(((Queue)message.getJMSReplyTo()).getQueueName());
                } else if (message.getJMSReplyTo() instanceof Topic) {
                    ballerinaJMSMessage.setReplyDestinationName(((Topic)message.getJMSReplyTo()).getTopicName());
                } else {
                    LOGGER.warn("ignore unexpected jms destination type received as ReplyTo header.");
                }
            }
        }
        catch (JMSException e) {
            throw new BallerinaException("error retrieving reply destination from the message. " + e.getMessage(), (Throwable)e);
        }
        return ballerinaJMSMessage;
    }

    public static Resource extractJMSResource(Service service) {
        Resource[] resources = service.getResources();
        if (resources.length == 0) {
            throw new BallerinaException("No resources found to handle the JMS message in " + service.getName());
        }
        if (resources.length > 1) {
            throw new BallerinaException("More than one resources found in JMS service " + service.getName() + ". JMS Service should only have one resource");
        }
        return resources[0];
    }

    public static Topic getTopic(Session session, String topicPattern) throws JMSException {
        return session.createTopic(topicPattern);
    }
}

