/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.net.jms.nativeimpl.endpoint.queue.sender;

import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.model.NativeCallableUnit;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.ballerinalang.net.jms.JMSUtils;
import org.ballerinalang.net.jms.nativeimpl.endpoint.common.SessionConnector;
import org.ballerinalang.net.jms.utils.BallerinaAdapter;
import org.ballerinalang.util.exceptions.BallerinaException;

@BallerinaFunction(orgName="ballerina", packageName="jms", functionName="initQueueSender", receiver=@Receiver(type=TypeKind.STRUCT, structType="QueueSender", structPackage="ballerina.jms"), args={@Argument(name="session", type=TypeKind.STRUCT, structType="Session")}, isPublic=true)
public class InitQueueSender
implements NativeCallableUnit {
    public void execute(Context context, CallableUnitCallback callableUnitCallback) {
        Struct queueSenderBObject = BallerinaAdapter.getReceiverObject(context);
        Struct queueSenderConfig = queueSenderBObject.getStructField("config");
        String queueName = queueSenderConfig.getStringField("queueName");
        if (JMSUtils.isNullOrEmptyAfterTrim(queueName)) {
            throw new BallerinaException("Queue name cannot be null", context);
        }
        BStruct sessionBObject = (BStruct)context.getRefArgument(1);
        Session session = BallerinaAdapter.getNativeObject(sessionBObject, "jms_session_object", Session.class, context);
        try {
            Queue queue = null;
            if (!JMSUtils.isNullOrEmptyAfterTrim(queueName)) {
                queue = session.createQueue(queueName);
            }
            MessageProducer producer = session.createProducer(queue);
            Struct queueSenderConnectorBObject = queueSenderBObject.getStructField("producerActions");
            queueSenderConnectorBObject.addNativeData("jms_producer_object", (Object)producer);
            queueSenderConnectorBObject.addNativeData("jms_session_connector_object", (Object)new SessionConnector(session));
        }
        catch (JMSException e) {
            BallerinaAdapter.throwBallerinaException("Error creating queue sender.", context, e);
        }
    }

    public boolean isBlocking() {
        return true;
    }
}

