/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm.interop;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.ballerinalang.jvm.TypeChecker;
import org.ballerinalang.jvm.types.BArrayType;
import org.ballerinalang.jvm.types.BFiniteType;
import org.ballerinalang.jvm.types.BFunctionType;
import org.ballerinalang.jvm.types.BObjectType;
import org.ballerinalang.jvm.types.BRecordType;
import org.ballerinalang.jvm.types.BTupleType;
import org.ballerinalang.jvm.types.BType;
import org.ballerinalang.jvm.types.BTypes;
import org.ballerinalang.jvm.types.BUnionType;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.nativeimpl.jvm.interop.JInterop;
import org.ballerinalang.nativeimpl.jvm.interop.JMethodKind;
import org.ballerinalang.nativeimpl.jvm.interop.ParamTypeConstraint;

class JMethodRequest {
    Class<?> declaringClass;
    String methodName;
    JMethodKind kind;
    ParamTypeConstraint[] paramTypeConstraints = new ParamTypeConstraint[0];
    int bFuncParamCount;
    BType[] bParamTypes = null;
    BType bReturnType = null;
    boolean returnsBErrorType = false;
    boolean restParamExist = false;

    private JMethodRequest() {
    }

    static JMethodRequest build(MapValue jMethodReqBValue, ClassLoader classLoader) {
        BType returnType;
        JMethodRequest jMethodReq = new JMethodRequest();
        jMethodReq.kind = JMethodKind.getKind((String)jMethodReqBValue.get((Object)"kind"));
        jMethodReq.methodName = (String)jMethodReqBValue.get((Object)"name");
        jMethodReq.declaringClass = JInterop.loadClass((String)jMethodReqBValue.get((Object)"class"), classLoader);
        jMethodReq.paramTypeConstraints = JInterop.buildParamTypeConstraints((ArrayValue)jMethodReqBValue.get((Object)"paramTypeConstraints"), classLoader);
        MapValue bFuncType = (MapValue)jMethodReqBValue.get((Object)"bFuncType");
        ArrayValue paramTypes = (ArrayValue)bFuncType.get((Object)"paramTypes");
        Object restType = bFuncType.get((Object)"restType");
        if (restType != null) {
            paramTypes.append(restType);
        }
        jMethodReq.bFuncParamCount = paramTypes.size();
        jMethodReq.bParamTypes = JMethodRequest.getBParamTypes(paramTypes);
        jMethodReq.bReturnType = returnType = JMethodRequest.getBType(bFuncType.get((Object)"retType"));
        jMethodReq.returnsBErrorType = returnType.toString().contains("error");
        jMethodReq.restParamExist = jMethodReqBValue.getBooleanValue("restParamExist");
        return jMethodReq;
    }

    private static BType[] getBParamTypes(ArrayValue paramTypes) {
        BType[] bParamTypes = new BType[paramTypes.size()];
        for (int i = 0; i < paramTypes.size(); ++i) {
            bParamTypes[i] = JMethodRequest.getBType(paramTypes.get((long)i));
        }
        return bParamTypes;
    }

    private static BType getBType(Object bTypeValue) {
        BType bType = TypeChecker.getType((Object)bTypeValue);
        if (bType.getTag() == 5) {
            String typeName;
            switch (typeName = (String)bTypeValue) {
                case "int": {
                    return BTypes.typeInt;
                }
                case "string": {
                    return BTypes.typeString;
                }
                case "byte": {
                    return BTypes.typeByte;
                }
                case "boolean": {
                    return BTypes.typeBoolean;
                }
                case "float": {
                    return BTypes.typeFloat;
                }
                case "decimal": {
                    return BTypes.typeDecimal;
                }
                case "any": {
                    return BTypes.typeAny;
                }
                case "anydata": {
                    return BTypes.typeAnydata;
                }
                case "()": {
                    return BTypes.typeNull;
                }
                case "json": {
                    return BTypes.typeJSON;
                }
                case "xml": {
                    return BTypes.typeXML;
                }
            }
            throw new UnsupportedOperationException("JInterop does not support type '" + bType + "'");
        }
        if (bType.getTag() == 12) {
            String typeName;
            BRecordType bRecordType = (BRecordType)bType;
            MapValue typeValue = (MapValue)bTypeValue;
            switch (typeName = typeValue.getStringValue("typeName")) {
                case "handle": {
                    return BTypes.typeHandle;
                }
                case "service": {
                    return BTypes.typeAnyService;
                }
                case "typedesc": {
                    return BTypes.typeTypedesc;
                }
                case "map": {
                    return BTypes.typeMap;
                }
                case "table": {
                    return BTypes.typeTable;
                }
                case "stream": {
                    return BTypes.typeStream;
                }
                case "error": {
                    return BTypes.typeError;
                }
                case "future": {
                    return BTypes.typeFuture;
                }
                case "union": {
                    ArrayValue members = typeValue.getArrayValue("members");
                    ArrayList<BType> memberTypes = new ArrayList<BType>();
                    for (int i = 0; i < members.size(); ++i) {
                        memberTypes.add(JMethodRequest.getBType(members.get((long)i)));
                    }
                    return new BUnionType(memberTypes);
                }
                case "object": {
                    return new BObjectType(bRecordType.getName(), bRecordType.getPackage(), bRecordType.flags);
                }
                case "tuple": {
                    ArrayValue members = typeValue.getArrayValue("tupleTypes");
                    ArrayList<BType> memberTypes = new ArrayList<BType>();
                    for (int i = 0; i < members.size(); ++i) {
                        memberTypes.add(JMethodRequest.getBType(members.get((long)i)));
                    }
                    return new BTupleType(memberTypes);
                }
                case "record": {
                    return new BRecordType(bRecordType.getName(), bRecordType.getPackage(), bRecordType.flags, bRecordType.sealed, bRecordType.typeFlags);
                }
                case "array": {
                    return new BArrayType(JMethodRequest.getBType(typeValue.get((Object)"eType")));
                }
                case "finite": {
                    String finiteTypeName = (String)((MapValue)typeValue.get((Object)"name")).get((Object)"value");
                    return new BFiniteType(finiteTypeName, JMethodRequest.getValueSpace((ArrayValue)typeValue.get((Object)"values")), bRecordType.typeFlags);
                }
                case "function": {
                    ArrayValue params = (ArrayValue)typeValue.get((Object)"paramTypes");
                    BType restType = null;
                    BType[] paramTypes = new BType[params.size()];
                    for (int i = 0; i < params.size(); ++i) {
                        paramTypes[i] = JMethodRequest.getBType(params.get((long)i));
                    }
                    Object restVar = typeValue.get((Object)"restType");
                    if (restVar != null) {
                        restType = JMethodRequest.getBType(restVar);
                    }
                    return new BFunctionType(paramTypes, restType, JMethodRequest.getBType(typeValue.get((Object)"retType")));
                }
            }
            throw new UnsupportedOperationException("JInterop does not support type '" + bType + "'");
        }
        throw new UnsupportedOperationException("JInterop does not support type '" + bType + "'");
    }

    private static Set<Object> getValueSpace(ArrayValue values) {
        HashSet<Object> valueSpace = new HashSet<Object>();
        for (int i = 0; i < values.size(); ++i) {
            ArrayValue value = (ArrayValue)values.get((long)i);
            valueSpace.add(value.get(0L));
        }
        return valueSpace;
    }
}

