/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm.methodvisitor;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.nativeimpl.jvm.ASMUtil;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@BallerinaFunction(orgName="ballerina", packageName="jvm", functionName="visitInvokeDynamicInsn", receiver=@Receiver(type=TypeKind.OBJECT, structType="MethodVisitor", structPackage="ballerina/jvm"), args={@Argument(name="className", type=TypeKind.STRING), @Argument(name="lambdaName", type=TypeKind.STRING), @Argument(name="closureMapCount", type=TypeKind.INT)})
public class VisitInvokeDynamicInsn {
    public static void visitInvokeDynamicInsn(Strand strand, ObjectValue oMv, String className, String lambdaName, long mapsCount) {
        String mapDesc = VisitInvokeDynamicInsn.getMapsDesc(mapsCount);
        MethodVisitor mv = (MethodVisitor)ASMUtil.getRefArgumentNativeData(oMv);
        Handle handle = new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false);
        mv.visitInvokeDynamicInsn("apply", "(" + mapDesc + ")" + "Ljava/util/function/Function;", handle, new Object[]{Type.getType((String)"(Ljava/lang/Object;)Ljava/lang/Object;"), new Handle(6, className, lambdaName, "(" + mapDesc + "[" + "Ljava/lang/Object;" + ")" + "Ljava/lang/Object;", false), Type.getType((String)"([Ljava/lang/Object;)Ljava/lang/Object;")});
    }

    private static String getMapsDesc(long count) {
        StringBuffer buf = new StringBuffer();
        for (long i = count; i > 0L; --i) {
            buf.append("Lorg/ballerinalang/jvm/values/MapValue;");
        }
        return buf.toString();
    }
}

