/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm.interop;

import java.lang.reflect.Field;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.nativeimpl.jvm.interop.JInterop;
import org.ballerinalang.nativeimpl.jvm.interop.JInteropException;
import org.ballerinalang.nativeimpl.jvm.interop.JavaField;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;

@BallerinaFunction(orgName="ballerina", packageName="jvm", receiver=@Receiver(type=TypeKind.OBJECT, structType="InteropValidator", structPackage="ballerina/jvm"), functionName="validateAndGetJField")
public class JInteropFieldValidator {
    public static Object validateAndGetJField(Strand strand, ObjectValue interopValidatorStruct, MapValue<String, Object> jFieldValidationRequest) {
        try {
            JavaField javaField;
            ClassLoader classLoader = (ClassLoader)interopValidatorStruct.getNativeData("class_loader");
            JavaField.JFieldMethod method = JInteropFieldValidator.getFieldMethod(jFieldValidationRequest);
            String className = (String)jFieldValidationRequest.get((Object)"class");
            Class<?> clazz = JInterop.loadClass(className, classLoader);
            String fieldName = (String)jFieldValidationRequest.get((Object)"name");
            try {
                Field field = clazz.getField(fieldName);
                javaField = new JavaField(method, field);
            }
            catch (NoSuchFieldException e) {
                throw new JInteropException("FIELD_NOT_FOUND", "No such field '" + fieldName + "' found in class '" + className + "'");
            }
            return JInteropFieldValidator.createJFieldBValue(javaField);
        }
        catch (JInteropException e) {
            return JInterop.createErrorBValue(e.getReason(), e.getMessage());
        }
    }

    private static JavaField.JFieldMethod getFieldMethod(MapValue<String, Object> jFieldValidationRequest) {
        return JavaField.JFieldMethod.getKind((String)jFieldValidationRequest.get((Object)"method"));
    }

    private static MapValue<String, Object> createJFieldBValue(JavaField javaField) {
        MapValue<String, Object> jFieldBRecord = JInterop.createRecordBValue("Field");
        jFieldBRecord.put((Object)"name", (Object)javaField.getName());
        jFieldBRecord.put((Object)"class", (Object)javaField.getDeclaringClassName().replace('.', '/'));
        jFieldBRecord.put((Object)"isStatic", (Object)javaField.isStatic());
        jFieldBRecord.put((Object)"method", (Object)javaField.getMethod().getStringValue());
        jFieldBRecord.put((Object)"sig", (Object)javaField.getSignature());
        jFieldBRecord.put((Object)"fType", JInterop.createJTypeBValue(javaField.getFieldType()));
        return jFieldBRecord;
    }
}

