/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm.methodvisitor;

import java.util.Arrays;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.nativeimpl.jvm.ASMUtil;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

@BallerinaFunction(orgName="ballerina", packageName="jvm", functionName="visitLookupSwitchInsn", receiver=@Receiver(type=TypeKind.OBJECT, structType="MethodVisitor", structPackage="ballerina/jvm"), args={@Argument(name="defaultLabel", type=TypeKind.OBJECT, structType="Label"), @Argument(name="keys", type=TypeKind.ARRAY, elementType=TypeKind.INT), @Argument(name="labels", type=TypeKind.ARRAY, elementType=TypeKind.OBJECT)})
public class VisitLookupSwitchInsn {
    public static void visitLookupSwitchInsn(Strand strand, ObjectValue oMv, ObjectValue oDefaultLabel, ArrayValue oKeys, ArrayValue oLabels) {
        MethodVisitor mv = (MethodVisitor)ASMUtil.getRefArgumentNativeData(oMv);
        Label defaultLabel = (Label)ASMUtil.getRefArgumentNativeData(oDefaultLabel);
        long[] lKeys = oKeys.getIntArray();
        int[] iKeys = Arrays.stream(lKeys).mapToInt(l -> (int)l).toArray();
        Label[] labels = VisitLookupSwitchInsn.convertToLabel(oLabels);
        mv.visitLookupSwitchInsn(defaultLabel, iKeys, labels);
    }

    private static Label[] convertToLabel(ArrayValue refArray) {
        Label[] labels = new Label[refArray.size()];
        for (int i = 0; i < refArray.size(); ++i) {
            Label label;
            ObjectValue oLabel = (ObjectValue)refArray.getRefValue((long)i);
            labels[i] = label = (Label)ASMUtil.getRefArgumentNativeData(oLabel);
        }
        return labels;
    }
}

