/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm.interop;

import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.nativeimpl.jvm.interop.JInterop;
import org.ballerinalang.nativeimpl.jvm.interop.JInteropException;
import org.ballerinalang.nativeimpl.jvm.interop.JMethod;
import org.ballerinalang.nativeimpl.jvm.interop.JMethodRequest;
import org.ballerinalang.nativeimpl.jvm.interop.JMethodResolver;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;

@BallerinaFunction(orgName="ballerina", packageName="jvm", receiver=@Receiver(type=TypeKind.OBJECT, structType="InteropValidator", structPackage="ballerina/jvm"), functionName="validateAndGetJMethod")
public class JInteropMethodValidator {
    public static Object validateAndGetJMethod(Strand strand, ObjectValue interopValidatorStruct, MapValue<String, Object> jMethodReqBValue) {
        try {
            ClassLoader classLoader = (ClassLoader)interopValidatorStruct.getNativeData("class_loader");
            JMethodRequest jMethodRequest = JMethodRequest.build(jMethodReqBValue, classLoader);
            JInteropMethodValidator.validateBExternalFunction(jMethodRequest);
            JMethod jMethod = JInteropMethodValidator.resolveJMethod(jMethodRequest, classLoader);
            return JInteropMethodValidator.createJMethodBValue(jMethod, classLoader);
        }
        catch (JInteropException e) {
            return JInterop.createErrorBValue(e.getReason(), e.getMessage());
        }
    }

    private static void validateBExternalFunction(JMethodRequest jMethodRequest) {
    }

    private static JMethod resolveJMethod(JMethodRequest jMethodRequest, ClassLoader classLoader) {
        JMethodResolver methodResolver = new JMethodResolver(classLoader);
        return methodResolver.resolve(jMethodRequest);
    }

    private static MapValue createJMethodBValue(JMethod jMethod, ClassLoader classLoader) {
        MapValue<String, Object> jMethodRecord = JInterop.createRecordBValue("Method");
        jMethodRecord.put((Object)"name", (Object)jMethod.getName());
        jMethodRecord.put((Object)"class", (Object)jMethod.getClassName().replace('.', '/'));
        jMethodRecord.put((Object)"isInterface", (Object)jMethod.isDeclaringClassInterface());
        jMethodRecord.put((Object)"kind", (Object)jMethod.getKind().getStringValue());
        jMethodRecord.put((Object)"isStatic", (Object)jMethod.isStatic());
        jMethodRecord.put((Object)"sig", (Object)jMethod.getSignature());
        jMethodRecord.put((Object)"mType", JInterop.createJMethodTypeBValue(jMethod));
        jMethodRecord.put((Object)"throws", (Object)jMethod.getExceptionTypes(classLoader));
        return jMethodRecord;
    }
}

