/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.nativeimpl.jvm.interop;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.security.AccessController;
import org.ballerinalang.jvm.scheduling.Strand;
import org.ballerinalang.jvm.values.ArrayValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.nativeimpl.jvm.interop.JInteropException;
import org.ballerinalang.natives.annotations.Argument;
import org.ballerinalang.natives.annotations.BallerinaFunction;
import org.ballerinalang.natives.annotations.Receiver;

@BallerinaFunction(orgName="ballerina", packageName="jvm", functionName="init", receiver=@Receiver(type=TypeKind.OBJECT, structType="InteropValidator", structPackage="ballerina/jvm"), args={@Argument(name="urls", type=TypeKind.ARRAY)})
public class Init {
    public static void init(Strand strand, ObjectValue interopValidatorStruct, ArrayValue jarUrls, boolean useSystemClassLoader) {
        try {
            String[] moduleDependencySet = jarUrls.getStringArray();
            URL[] urls = new URL[moduleDependencySet.length];
            int i = 0;
            for (String jarPath : moduleDependencySet) {
                urls[i] = Paths.get(jarPath, new String[0]).toUri().toURL();
                ++i;
            }
            AccessController.doPrivileged(() -> {
                if (useSystemClassLoader) {
                    interopValidatorStruct.addNativeData("class_loader", (Object)new URLClassLoader(urls));
                } else {
                    interopValidatorStruct.addNativeData("class_loader", (Object)new URLClassLoader(urls, null));
                }
                return null;
            });
        }
        catch (MalformedURLException e) {
            throw new JInteropException("CLASS_LOADER_INIT_FAILED", e.getMessage());
        }
    }
}

