/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.KafkaException;
import org.ballerinalang.messaging.kafka.api.KafkaListener;
import org.ballerinalang.messaging.kafka.api.KafkaServerConnector;
import org.ballerinalang.messaging.kafka.exceptions.KafkaConnectorException;
import org.ballerinalang.messaging.kafka.impl.KafkaRecordConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaServerConnectorImpl
implements KafkaServerConnector {
    private static final Logger logger = LoggerFactory.getLogger(KafkaServerConnectorImpl.class);
    private String serviceId;
    private KafkaListener kafkaListener;
    private Properties configParams;
    private int numOfConcurrentConsumers = 1;
    private List<KafkaRecordConsumer> messageConsumers;
    private KafkaConsumer kafkaConsumer;

    public KafkaServerConnectorImpl(String serviceId, Properties configParams, KafkaListener kafkaListener, KafkaConsumer kafkaConsumer) throws KafkaConnectorException {
        this.kafkaListener = kafkaListener;
        this.serviceId = serviceId;
        if (configParams.get("concurrentConsumers") != null) {
            this.numOfConcurrentConsumers = (Integer)configParams.get("concurrentConsumers");
        }
        if (this.numOfConcurrentConsumers <= 0) {
            throw new KafkaConnectorException("Number of Concurrent consumers should be a positive integer value greater than zero.");
        }
        this.configParams = configParams;
        this.kafkaConsumer = kafkaConsumer;
    }

    @Override
    public void start() throws KafkaConnectorException {
        try {
            this.messageConsumers = new ArrayList<KafkaRecordConsumer>();
            for (int counter = 0; counter < this.numOfConcurrentConsumers; ++counter) {
                KafkaRecordConsumer consumer = new KafkaRecordConsumer(this.kafkaListener, this.configParams, this.serviceId, counter, this.kafkaConsumer);
                this.messageConsumers.add(consumer);
                consumer.consume();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Started Kafka consumer " + counter + " on service : " + this.serviceId + ".");
            }
        }
        catch (KafkaException e) {
            throw new KafkaConnectorException("Error creating Kafka consumer to connect with remote broker and subscribe to provided topics", e);
        }
    }

    @Override
    public boolean stop() throws KafkaConnectorException {
        Throwable ex = null;
        for (KafkaRecordConsumer consumer : this.messageConsumers) {
            try {
                consumer.stopConsume();
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Stopped Kafka consumer " + consumer.getConsumerId() + " on service : " + this.serviceId + ".");
            }
            catch (KafkaException e) {
                if (ex == null) {
                    ex = new KafkaConnectorException("Error closing the Kafka consumers for service " + this.serviceId, e);
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        this.messageConsumers = null;
        if (ex != null) {
            throw ex;
        }
        return true;
    }
}

