/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.nativeimpl.consumer;

import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.ballerinalang.jvm.scheduling.Scheduler;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.messaging.kafka.observability.KafkaMetricsUtil;
import org.ballerinalang.messaging.kafka.observability.KafkaTracingUtil;
import org.ballerinalang.messaging.kafka.utils.KafkaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Commit {
    private static final Logger logger = LoggerFactory.getLogger(Commit.class);

    public static Object commit(ObjectValue consumerObject) {
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        try {
            kafkaConsumer.commitSync();
        }
        catch (KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "commit");
            return KafkaUtils.createKafkaError("Failed to commit offsets: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
        return null;
    }

    public static Object commitOffset(ObjectValue consumerObject, BArray offsets, long duration) {
        KafkaTracingUtil.traceResourceInvocation(Scheduler.getStrand(), consumerObject);
        KafkaConsumer kafkaConsumer = (KafkaConsumer)consumerObject.getNativeData("KafkaConsumer");
        Properties consumerProperties = (Properties)consumerObject.getNativeData("KafkaConsumerConfig");
        int defaultApiTimeout = KafkaUtils.getDefaultApiTimeout(consumerProperties);
        int apiTimeout = KafkaUtils.getIntFromLong(duration, logger, "duration");
        Map<TopicPartition, OffsetAndMetadata> partitionToMetadataMap = KafkaUtils.getPartitionToMetadataMap(offsets);
        try {
            if (apiTimeout > -1) {
                Commit.consumerCommitSyncWithDuration(kafkaConsumer, partitionToMetadataMap, apiTimeout);
            } else if (defaultApiTimeout > -1) {
                Commit.consumerCommitSyncWithDuration(kafkaConsumer, partitionToMetadataMap, defaultApiTimeout);
            } else {
                kafkaConsumer.commitSync(partitionToMetadataMap);
            }
        }
        catch (KafkaException e) {
            KafkaMetricsUtil.reportConsumerError(consumerObject, "commit");
            return KafkaUtils.createKafkaError("Failed to commit the offset: " + e.getMessage(), "{ballerina/kafka}ConsumerError");
        }
        return null;
    }

    private static void consumerCommitSyncWithDuration(KafkaConsumer consumer, Map<TopicPartition, OffsetAndMetadata> metadataMap, long timeout) {
        Duration duration = Duration.ofMillis(timeout);
        consumer.commitSync(metadataMap, duration);
    }
}

