/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.nativeimpl.producer;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.messaging.kafka.nativeimpl.producer.Send;
import org.ballerinalang.messaging.kafka.utils.KafkaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendAvroKeys {
    private static final Logger logger = LoggerFactory.getLogger(SendAvroKeys.class);

    public static Object sendStringValuesAvroKeys(ObjectValue producer, String value, String topic, MapValue<String, Object> key, Object partition, Object timestamp) {
        GenericRecord genericRecord = SendAvroKeys.createGenericRecord(key);
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)genericRecord, (Object)value);
        return Send.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendIntValuesAvroKeys(ObjectValue producer, long value, String topic, MapValue<String, Object> key, Object partition, Object timestamp) {
        GenericRecord genericRecord = SendAvroKeys.createGenericRecord(key);
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)genericRecord, (Object)value);
        return Send.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendFloatValuesAvroKeys(ObjectValue producer, double value, String topic, MapValue<String, Object> key, Object partition, Object timestamp) {
        GenericRecord genericRecord = SendAvroKeys.createGenericRecord(key);
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)genericRecord, (Object)value);
        return Send.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendByteArrayValuesAvroKeys(ObjectValue producer, BArray value, String topic, MapValue<String, Object> key, Object partition, Object timestamp) {
        GenericRecord genericRecord = SendAvroKeys.createGenericRecord(key);
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)genericRecord, (Object)value.getBytes());
        return Send.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendAvroValuesAvroKeys(ObjectValue producer, MapValue<String, Object> value, String topic, MapValue<String, Object> key, Object partition, Object timestamp) {
        GenericRecord valueRecord = SendAvroKeys.createGenericRecord(value);
        GenericRecord keyRecord = SendAvroKeys.createGenericRecord(key);
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)keyRecord, (Object)valueRecord);
        return Send.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendCustomValuesAvroKeys(ObjectValue producer, Object value, String topic, MapValue<String, Object> key, Object partition, Object timestamp) {
        GenericRecord genericRecord = SendAvroKeys.createGenericRecord(key);
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)genericRecord, value);
        return Send.sendKafkaRecord(kafkaRecord, producer);
    }

    protected static GenericRecord createGenericRecord(MapValue<String, Object> value) {
        GenericRecord genericRecord = SendAvroKeys.createRecord(value);
        MapValue data = value.getMapValue("dataRecord");
        SendAvroKeys.populateAvroRecord(genericRecord, (MapValue<String, Object>)data);
        return genericRecord;
    }

    protected static void populateAvroRecord(GenericRecord record, MapValue<String, Object> data) {
        String[] keys;
        for (String key : keys = (String[])data.getKeys()) {
            GenericData.Record subRecord;
            Schema childSchema;
            Object value = data.get((Object)key);
            if (value instanceof String || value instanceof Number || value == null) {
                record.put(key, value);
                continue;
            }
            if (value instanceof MapValue) {
                childSchema = record.getSchema().getField(key).schema();
                subRecord = new GenericData.Record(childSchema);
                SendAvroKeys.populateAvroRecord((GenericRecord)subRecord, (MapValue<String, Object>)((MapValue)value));
                record.put(key, (Object)subRecord);
                continue;
            }
            if (value instanceof BArray) {
                childSchema = record.getSchema().getField(key).schema().getElementType();
                subRecord = new GenericData.Record(childSchema);
                SendAvroKeys.populateAvroRecordArray((GenericRecord)subRecord, (BArray)value);
                record.put(key, (Object)subRecord);
                continue;
            }
            throw KafkaUtils.createKafkaError("Invalid data type received for avro data", "{ballerina/kafka}AvroError");
        }
    }

    protected static void populateAvroRecordArray(GenericRecord record, BArray bArray) {
        for (int i = 0; i < bArray.size(); ++i) {
            record.put(i, bArray.get((long)i));
        }
    }

    protected static GenericRecord createRecord(MapValue value) {
        String schemaString = value.getStringValue("schemaString");
        Schema avroSchema = new Schema.Parser().parse(schemaString);
        return new GenericData.Record(avroSchema);
    }
}

