/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.nativeimpl.producer;

import org.apache.avro.generic.GenericRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.messaging.kafka.nativeimpl.producer.Send;
import org.ballerinalang.messaging.kafka.nativeimpl.producer.SendAvroKeys;
import org.ballerinalang.messaging.kafka.utils.KafkaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendAvroValues
extends Send {
    private static final Logger logger = LoggerFactory.getLogger(SendAvroValues.class);

    public static Object sendAvroValuesNilKeys(ObjectValue producer, MapValue<String, Object> value, String topic, Object partition, Object timestamp) {
        GenericRecord genericRecord = SendAvroKeys.createGenericRecord(value);
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, null, (Object)genericRecord);
        return SendAvroValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendAvroValuesStringKeys(ObjectValue producer, MapValue<String, Object> value, String topic, String key, Object partition, Object timestamp) {
        GenericRecord genericRecord = SendAvroKeys.createGenericRecord(value);
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key, (Object)genericRecord);
        return SendAvroValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendAvroValuesIntKeys(ObjectValue producer, MapValue<String, Object> value, String topic, long key, Object partition, Object timestamp) {
        GenericRecord genericRecord = SendAvroKeys.createGenericRecord(value);
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key, (Object)genericRecord);
        return SendAvroValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendAvroValuesFloatKeys(ObjectValue producer, MapValue<String, Object> value, String topic, double key, Object partition, Object timestamp) {
        GenericRecord genericRecord = SendAvroKeys.createGenericRecord(value);
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key, (Object)genericRecord);
        return SendAvroValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendAvroValuesByteArrayKeys(ObjectValue producer, MapValue<String, Object> value, String topic, BArray key, Object partition, Object timestamp) {
        GenericRecord genericRecord = SendAvroKeys.createGenericRecord(value);
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, (Object)key.getBytes(), (Object)genericRecord);
        return SendAvroValues.sendKafkaRecord(kafkaRecord, producer);
    }

    public static Object sendAvroValuesCustomKeys(ObjectValue producer, MapValue<String, Object> value, String topic, Object key, Object partition, Object timestamp) {
        GenericRecord genericRecord = SendAvroKeys.createGenericRecord(value);
        Integer partitionValue = KafkaUtils.getIntValue(partition, "partition", logger);
        Long timestampValue = KafkaUtils.getLongValue(timestamp);
        ProducerRecord kafkaRecord = new ProducerRecord(topic, partitionValue, timestampValue, key, (Object)genericRecord);
        return SendAvroValues.sendKafkaRecord(kafkaRecord, producer);
    }
}

