/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.messaging.kafka.serdes;

import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Deserializer;
import org.ballerinalang.jvm.BRuntime;
import org.ballerinalang.jvm.values.ObjectValue;
import org.ballerinalang.jvm.values.api.BArray;
import org.ballerinalang.jvm.values.api.BValueCreator;

public class BallerinaKafkaDeserializer
implements Deserializer {
    private ObjectValue deserializerObject = null;
    private BRuntime runtime = null;
    private int timeout = 30000;

    public void configure(Map configs, boolean isKey) {
        this.runtime = (BRuntime)configs.get("ballerina.strand");
        this.deserializerObject = isKey ? (ObjectValue)configs.get("keyDeserializer") : (ObjectValue)configs.get("valueDeserializer");
        if (Objects.nonNull(configs.get("request.timeout.ms"))) {
            this.timeout = (Integer)configs.get("request.timeout.ms");
        }
    }

    public Object deserialize(String topic, byte[] data) {
        BArray bData = BValueCreator.createArrayValue((byte[])data);
        Object[] args = new Object[]{bData, false};
        return this.runtime.getSyncMethodInvokeResult(this.deserializerObject, "deserialize", this.timeout, args);
    }

    public void close() {
        this.runtime.getSyncMethodInvokeResult(this.deserializerObject, "close", this.timeout, new Object[0]);
    }
}

