/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.BlockNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.bir.BIRGenEnv;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.bir.optimizer.BIROptimizer;
import org.wso2.ballerinalang.compiler.bir.writer.BIRBinaryWriter;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.TaintRecord;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangConstantValue;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttributeAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.util.BArrayState;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.CompilerUtils;
import org.wso2.ballerinalang.compiler.util.FieldKind;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;
import org.wso2.ballerinalang.programfile.CompiledBinaryFile;

public class BIRGen
extends BLangNodeVisitor {
    private static final CompilerContext.Key<BIRGen> BIR_GEN = new CompilerContext.Key();
    public static final String DEFAULT_WORKER_NAME = "default";
    private BIRGenEnv env;
    private Names names;
    private final SymbolTable symTable;
    private BIROptimizer birOptimizer;
    private boolean varAssignment = false;
    private Map<BTypeSymbol, BIRNode.BIRTypeDefinition> typeDefs = new LinkedHashMap<BTypeSymbol, BIRNode.BIRTypeDefinition>();
    private BlockNode currentBlock;
    private Map<BlockNode, List<BIRNode.BIRVariableDcl>> varDclsByBlock = new HashMap<BlockNode, List<BIRNode.BIRVariableDcl>>();
    public Map<BSymbol, BIRNode.BIRGlobalVariableDcl> globalVarMap = new HashMap<BSymbol, BIRNode.BIRGlobalVariableDcl>();
    private static final String MOCK_ANNOTATION_DELIMITER = "#";
    private static final String MOCK_OBJECT_DELIMITER = ":";

    public static BIRGen getInstance(CompilerContext context) {
        BIRGen birGen = context.get(BIR_GEN);
        if (birGen == null) {
            birGen = new BIRGen(context);
        }
        return birGen;
    }

    private BIRGen(CompilerContext context) {
        context.put(BIR_GEN, this);
        this.names = Names.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.birOptimizer = BIROptimizer.getInstance(context);
    }

    public BLangPackage genBIR(BLangPackage astPkg) {
        BIRNode.BIRPackage birPkg;
        astPkg.symbol.bir = birPkg = new BIRNode.BIRPackage(astPkg.pos, astPkg.packageID.orgName, astPkg.packageID.name, astPkg.packageID.version, astPkg.packageID.sourceFileName);
        this.env = new BIRGenEnv(birPkg);
        astPkg.accept(this);
        this.birOptimizer.optimizePackage(birPkg);
        astPkg.symbol.birPackageFile = new CompiledBinaryFile.BIRPackageFile(new BIRBinaryWriter(birPkg).serialize());
        if (astPkg.hasTestablePackage()) {
            BIRNode.BIRPackage testBirPkg = new BIRNode.BIRPackage(astPkg.pos, astPkg.packageID.orgName, astPkg.packageID.name, astPkg.packageID.version, astPkg.packageID.sourceFileName);
            this.env = new BIRGenEnv(testBirPkg);
            astPkg.accept(this);
            astPkg.getTestablePkgs().forEach(testPkg -> {
                this.visitBuiltinFunctions((BLangPackage)testPkg, testPkg.initFunction);
                this.visitBuiltinFunctions((BLangPackage)testPkg, testPkg.startFunction);
                this.visitBuiltinFunctions((BLangPackage)testPkg, testPkg.stopFunction);
                for (BLangImportPackage mod : astPkg.imports) {
                    testPkg.imports.remove(mod);
                }
                testPkg.accept(this);
                this.birOptimizer.optimizePackage(testBirPkg);
                testPkg.symbol.bir = testBirPkg;
                Map<String, String> mockFunctionMap = astPkg.getTestablePkg().getMockFunctionNamesMap();
                if (!mockFunctionMap.isEmpty()) {
                    this.replaceMockedFunctions(testBirPkg, mockFunctionMap);
                }
            });
        }
        this.setEntryPoints(astPkg);
        return astPkg;
    }

    private void setEntryPoints(BLangPackage pkgNode) {
        BLangFunction mainFunc = this.getMainFunction(pkgNode);
        if (mainFunc != null) {
            pkgNode.symbol.entryPointExists = true;
        }
        if (pkgNode.services.size() != 0) {
            pkgNode.symbol.entryPointExists = true;
        }
    }

    private BLangFunction getMainFunction(BLangPackage pkgNode) {
        for (BLangFunction funcNode : pkgNode.functions) {
            if (!CompilerUtils.isMainFunction(funcNode)) continue;
            return funcNode;
        }
        return null;
    }

    private void visitBuiltinFunctions(BLangPackage pkgNode, BLangFunction function) {
        if (Symbols.isFlagOn(pkgNode.symbol.flags, 16384)) {
            String funcName = function.getName().value;
            String builtinFuncName = funcName.substring(funcName.indexOf("<") + 1, funcName.indexOf(">"));
            String modifiedFuncName = funcName.replace(builtinFuncName, "test" + builtinFuncName);
            function.name.setValue(modifiedFuncName);
            function.originalFuncSymbol.name.value = modifiedFuncName;
            function.symbol.name.value = modifiedFuncName;
        }
    }

    private void replaceMockedFunctions(BIRNode.BIRPackage birPkg, Map<String, String> mockFunctionMap) {
        for (BIRNode.BIRFunction function : birPkg.functions) {
            List<BIRNode.BIRBasicBlock> functionBasicBlocks = function.basicBlocks;
            for (BIRNode.BIRBasicBlock functionBasicBlock : functionBasicBlocks) {
                BIRTerminator bbTerminator = functionBasicBlock.terminator;
                if (!bbTerminator.kind.equals((Object)InstructionKind.CALL)) continue;
                BIRTerminator.Call callTerminator = (BIRTerminator.Call)bbTerminator;
                String functionKey = null;
                if (callTerminator.isVirtual) {
                    String objectPkg = callTerminator.args.get((int)0).variableDcl.type.toString();
                    functionKey = objectPkg + MOCK_ANNOTATION_DELIMITER + callTerminator.name.toString();
                } else {
                    functionKey = callTerminator.calleePkg.toString() + MOCK_ANNOTATION_DELIMITER + callTerminator.name.toString();
                }
                if (mockFunctionMap.get(functionKey) == null) continue;
                String mockFunctionName = mockFunctionMap.get(functionKey);
                callTerminator.name = new Name(mockFunctionName);
                callTerminator.calleePkg = function.pos.src.pkgID;
                if (!callTerminator.isVirtual) continue;
                callTerminator.isVirtual = false;
                callTerminator.args.remove(0);
            }
        }
    }

    @Override
    public void visit(BLangPackage astPkg) {
        astPkg.imports.forEach(impPkg -> impPkg.accept(this));
        astPkg.constants.forEach(astConst -> astConst.accept(this));
        astPkg.typeDefinitions.forEach(astTypeDef -> astTypeDef.accept(this));
        astPkg.globalVars.forEach(astGlobalVar -> astGlobalVar.accept(this));
        astPkg.initFunction.accept(this);
        astPkg.startFunction.accept(this);
        astPkg.stopFunction.accept(this);
        astPkg.functions.forEach(astFunc -> astFunc.accept(this));
        astPkg.annotations.forEach(astAnn -> astAnn.accept(this));
    }

    @Override
    public void visit(BLangTypeDefinition astTypeDefinition) {
        BIRNode.BIRTypeDefinition typeDef = new BIRNode.BIRTypeDefinition(astTypeDefinition.pos, astTypeDefinition.symbol.name, astTypeDefinition.symbol.flags, astTypeDefinition.symbol.isLabel, astTypeDefinition.isBuiltinTypeDef, astTypeDefinition.typeNode.type, new ArrayList<BIRNode.BIRFunction>());
        this.typeDefs.put(astTypeDefinition.symbol, typeDef);
        this.env.enclPkg.typeDefs.add(typeDef);
        typeDef.index = this.env.enclPkg.typeDefs.size() - 1;
        typeDef.setMarkdownDocAttachment(astTypeDefinition.symbol.markdownDocumentation);
        if (astTypeDefinition.typeNode.getKind() == NodeKind.RECORD_TYPE || astTypeDefinition.typeNode.getKind() == NodeKind.OBJECT_TYPE) {
            BLangStructureTypeNode typeNode = (BLangStructureTypeNode)astTypeDefinition.typeNode;
            for (BLangType typeRef : typeNode.typeRefs) {
                typeDef.referencedTypes.add(typeRef.type);
            }
        }
        if (astTypeDefinition.symbol.tag != 196700 || !Symbols.isFlagOn(astTypeDefinition.symbol.flags, 4096)) {
            return;
        }
        for (BAttachedFunction func : ((BObjectTypeSymbol)astTypeDefinition.symbol).referencedFunctions) {
            if (!Symbols.isFlagOn(func.symbol.flags, 128)) {
                return;
            }
            BInvokableSymbol funcSymbol = func.symbol;
            BIRNode.BIRFunction birFunc = new BIRNode.BIRFunction(astTypeDefinition.pos, func.funcName, funcSymbol.flags, func.type, this.names.fromString(DEFAULT_WORKER_NAME), 0, new BIRNode.TaintTable());
            if (funcSymbol.receiverSymbol != null) {
                birFunc.receiver = this.getSelf(funcSymbol.receiverSymbol, funcSymbol.receiverSymbol.type, funcSymbol.receiverSymbol.name);
            }
            birFunc.setMarkdownDocAttachment(funcSymbol.markdownDocumentation);
            int defaultableParamsCount = 0;
            birFunc.argsCount = funcSymbol.params.size() + defaultableParamsCount + (funcSymbol.restParam != null ? 1 : 0);
            funcSymbol.params.forEach(requiredParam -> this.addParam(birFunc, (BVarSymbol)requiredParam, astTypeDefinition.pos));
            if (funcSymbol.restParam != null) {
                this.addRestParam(birFunc, funcSymbol.restParam, astTypeDefinition.pos);
            }
            birFunc.returnVariable = new BIRNode.BIRVariableDcl(astTypeDefinition.pos, funcSymbol.retType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.RETURN, null);
            birFunc.localVars.add(0, birFunc.returnVariable);
            typeDef.attachedFuncs.add(birFunc);
        }
    }

    @Override
    public void visit(BLangConstant astConstant) {
        BConstantSymbol constantSymbol = astConstant.symbol;
        Name constName = constantSymbol.name;
        BType type = constantSymbol.type;
        BIRNode.ConstValue constantValue = this.getBIRConstantVal(constantSymbol.value);
        BIRNode.BIRConstant birConstant = new BIRNode.BIRConstant(astConstant.pos, constName, constantSymbol.flags, type, constantValue);
        birConstant.constValue = constantValue;
        birConstant.setMarkdownDocAttachment(astConstant.symbol.markdownDocumentation);
        this.env.enclPkg.constants.add(birConstant);
    }

    private BIRNode.ConstValue getBIRConstantVal(BLangConstantValue constValue) {
        if (constValue.type.tag == 15) {
            HashMap mapConstVal = new HashMap();
            ((Map)constValue.value).forEach((key, value) -> mapConstVal.put(key, this.getBIRConstantVal((BLangConstantValue)value)));
            return new BIRNode.ConstValue(mapConstVal, constValue.type);
        }
        return new BIRNode.ConstValue(constValue.value, constValue.type);
    }

    @Override
    public void visit(BLangImportPackage impPkg) {
        this.env.enclPkg.importModules.add(new BIRNode.BIRImportModule(impPkg.pos, impPkg.symbol.pkgID.orgName, impPkg.symbol.pkgID.name, impPkg.symbol.pkgID.version));
    }

    @Override
    public void visit(BLangFunction astFunc) {
        BIRNode.BIRFunction birFunc;
        Name funcName;
        BInvokableType type = astFunc.symbol.getType();
        boolean isTypeAttachedFunction = astFunc.flagSet.contains((Object)Flag.ATTACHED) && !this.typeDefs.containsKey(astFunc.receiver.type.tsymbol);
        Name workerName = this.names.fromIdNode(astFunc.defaultWorkerName);
        this.env.unlockVars.push(new BIRNode.BIRLockDetailsHolder());
        BIRNode.TaintTable taintTable = this.populateTaintTable(astFunc.symbol.taintTable);
        if (isTypeAttachedFunction) {
            funcName = this.names.fromString(astFunc.symbol.name.value);
            birFunc = new BIRNode.BIRFunction(astFunc.pos, funcName, astFunc.symbol.flags, type, workerName, astFunc.sendsToThis.size(), taintTable);
        } else {
            funcName = this.getFuncName(astFunc.symbol);
            birFunc = new BIRNode.BIRFunction(astFunc.pos, funcName, astFunc.symbol.flags, type, workerName, astFunc.sendsToThis.size(), taintTable);
        }
        if (astFunc.receiver != null) {
            BIRNode.BIRFunctionParameter birVarDcl = new BIRNode.BIRFunctionParameter(astFunc.pos, astFunc.receiver.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.ARG, astFunc.receiver.name.value, false);
            this.env.symbolVarMap.put(astFunc.receiver.symbol, birVarDcl);
        }
        if (astFunc.receiver != null) {
            birFunc.receiver = this.getSelf(astFunc.receiver.symbol, astFunc.receiver.type, astFunc.receiver.symbol.name);
        }
        birFunc.setMarkdownDocAttachment(astFunc.symbol.markdownDocumentation);
        int i = 0;
        for (String channelName : astFunc.sendsToThis) {
            birFunc.workerChannels[i] = new BIRNode.ChannelDetails(channelName, astFunc.defaultWorkerName.value.equals(DEFAULT_WORKER_NAME), this.isWorkerSend(channelName, astFunc.defaultWorkerName.value));
            ++i;
        }
        if (astFunc.hasBody() && astFunc.body.getKind() == NodeKind.EXTERN_FUNCTION_BODY) {
            this.populateBIRAnnotAttachments(((BLangExternalFunctionBody)astFunc.body).annAttachments, birFunc.annotAttachments, this.env);
        }
        this.populateBIRAnnotAttachments(astFunc.annAttachments, birFunc.annotAttachments, this.env);
        birFunc.argsCount = astFunc.requiredParams.size() + (astFunc.restParam != null ? 1 : 0) + astFunc.paramClosureMap.size();
        if (astFunc.flagSet.contains((Object)Flag.ATTACHED) && this.typeDefs.containsKey(astFunc.receiver.type.tsymbol)) {
            this.typeDefs.get((Object)astFunc.receiver.type.tsymbol).attachedFuncs.add(birFunc);
        } else {
            this.env.enclPkg.functions.add(birFunc);
        }
        this.env.enclFunc = birFunc;
        birFunc.returnVariable = new BIRNode.BIRVariableDcl(astFunc.pos, astFunc.symbol.type.getReturnType(), this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.RETURN, null);
        birFunc.localVars.add(0, birFunc.returnVariable);
        astFunc.paramClosureMap.forEach((k, v) -> this.addRequiredParam(birFunc, (BVarSymbol)v, astFunc.pos));
        astFunc.requiredParams.forEach(requiredParam -> this.addParam(birFunc, (BLangVariable)requiredParam));
        if (astFunc.restParam != null) {
            this.addRestParam(birFunc, astFunc.restParam.symbol, astFunc.restParam.pos);
        }
        if (astFunc.interfaceFunction || Symbols.isNative(astFunc.symbol)) {
            this.env.clear();
            return;
        }
        BIRNode.BIRBasicBlock entryBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.env.enclBasicBlocks = birFunc.basicBlocks;
        birFunc.basicBlocks.add(entryBB);
        this.env.enclBB = entryBB;
        this.addToTrapStack(entryBB);
        astFunc.body.accept(this);
        birFunc.basicBlocks.add(this.env.returnBB);
        BIRNode.BIRBasicBlock enclBB = this.env.enclBB;
        if (enclBB.instructions.size() == 0 && enclBB.terminator == null && this.env.returnBB != null) {
            enclBB.terminator = new BIRTerminator.GOTO(null, this.env.returnBB);
        }
        this.env.clear();
        this.env.unlockVars.clear();
        birFunc.parameters.values().forEach(basicBlocks -> basicBlocks.forEach(bb -> {
            bb.id = this.env.nextBBId(this.names);
        }));
        birFunc.basicBlocks.forEach(bb -> {
            bb.id = this.env.nextBBId(this.names);
        });
        birFunc.errorTable.sort(Comparator.comparingInt(o -> Integer.parseInt(o.trapBB.id.value.replace("bb", ""))));
        this.env.clear();
    }

    private BIRNode.BIRVariableDcl getSelf(BSymbol receiver, BType type, Name name) {
        BIRNode.BIRVariableDcl self = this.env.symbolVarMap.get(receiver);
        if (self == null) {
            return new BIRNode.BIRVariableDcl(null, receiver.type, receiver.name, VarScope.FUNCTION, VarKind.SELF, null);
        }
        self.kind = VarKind.SELF;
        self.name = new Name("%self");
        return self;
    }

    @Override
    public void visit(BLangBlockFunctionBody astBody) {
        BlockNode prevBlock = this.currentBlock;
        this.currentBlock = astBody;
        this.varDclsByBlock.computeIfAbsent(astBody, k -> new ArrayList());
        for (BLangStatement astStmt : astBody.stmts) {
            astStmt.accept(this);
        }
        List<BIRNode.BIRVariableDcl> varDecls = this.varDclsByBlock.get(astBody);
        for (BIRNode.BIRVariableDcl birVariableDcl : varDecls) {
            birVariableDcl.endBB = this.env.enclBasicBlocks.get(this.env.enclBasicBlocks.size() - 1);
        }
        this.currentBlock = prevBlock;
    }

    @Override
    public void visit(BLangAnnotationAttachment astAnnotAttach) {
        BIRNode.BIRAnnotationValue annotationValue;
        if (astAnnotAttach.expr == null) {
            annotationValue = new BIRNode.BIRAnnotationLiteralValue(this.symTable.booleanType, true);
        } else {
            if (!this.isCompileTimeAnnotationValue(astAnnotAttach.expr)) {
                return;
            }
            annotationValue = this.createAnnotationValue(astAnnotAttach.expr);
        }
        Name annotTagRef = this.names.fromIdNode(astAnnotAttach.annotationName);
        BIRNode.BIRAnnotationAttachment annotAttachment = new BIRNode.BIRAnnotationAttachment(astAnnotAttach.pos, annotTagRef);
        annotAttachment.packageID = astAnnotAttach.annotationSymbol.pkgID;
        annotAttachment.annotValues.add(annotationValue);
        this.env.enclAnnotAttachments.add(annotAttachment);
    }

    private boolean isCompileTimeAnnotationValue(BLangExpression expr) {
        switch (expr.getKind()) {
            case LITERAL: 
            case NUMERIC_LITERAL: {
                return true;
            }
            case RECORD_LITERAL_EXPR: {
                BLangRecordLiteral recordLiteral = (BLangRecordLiteral)expr;
                for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
                    if (this.isCompileTimeAnnotationValue(((BLangRecordLiteral.BLangRecordKeyValueField)field).valueExpr)) continue;
                    return false;
                }
                return true;
            }
            case ARRAY_LITERAL_EXPR: {
                BLangListConstructorExpr.BLangArrayLiteral arrayLiteral = (BLangListConstructorExpr.BLangArrayLiteral)expr;
                for (BLangExpression bLangExpr : arrayLiteral.exprs) {
                    if (this.isCompileTimeAnnotationValue(bLangExpr)) continue;
                    return false;
                }
                return true;
            }
            case TYPE_CONVERSION_EXPR: {
                return this.isCompileTimeAnnotationValue(((BLangTypeConversionExpr)expr).expr);
            }
            case STATEMENT_EXPRESSION: {
                BLangStatementExpression stmtExpr = (BLangStatementExpression)expr;
                List<BLangStatement> stmts = ((BLangBlockStmt)stmtExpr.stmt).stmts;
                if (!((BLangSimpleVarRef.BLangLocalVarRef)stmtExpr.expr).varSymbol.name.value.startsWith("$mapping$var$")) {
                    return false;
                }
                for (int i = 1; i < stmts.size(); ++i) {
                    BLangAssignment assignmentStmt = (BLangAssignment)stmts.get(i);
                    if (this.isCompileTimeAnnotationValue(((BLangIndexBasedAccess)assignmentStmt.varRef).indexExpr) && this.isCompileTimeAnnotationValue(assignmentStmt.expr)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private BIRNode.BIRAnnotationValue createAnnotationValue(BLangExpression expr) {
        switch (expr.getKind()) {
            case LITERAL: 
            case NUMERIC_LITERAL: {
                return this.createAnnotationLiteralValue((BLangLiteral)expr);
            }
            case RECORD_LITERAL_EXPR: {
                return this.createAnnotationRecordValue((BLangRecordLiteral)expr);
            }
            case ARRAY_LITERAL_EXPR: {
                return this.createAnnotationArrayValue((BLangListConstructorExpr.BLangArrayLiteral)expr);
            }
            case TYPE_CONVERSION_EXPR: {
                return this.createAnnotationValue(((BLangTypeConversionExpr)expr).expr);
            }
            case STATEMENT_EXPRESSION: {
                return this.createAnnotationRecordValue((BLangStatementExpression)expr);
            }
        }
        throw new IllegalStateException("Invalid annotation value expression kind: " + (Object)((Object)expr.getKind()));
    }

    private BIRNode.BIRAnnotationRecordValue createAnnotationRecordValue(BLangRecordLiteral recordLiteral) {
        HashMap<String, BIRNode.BIRAnnotationValue> annotValueEntryMap = new HashMap<String, BIRNode.BIRAnnotationValue>();
        for (RecordLiteralNode.RecordField field : recordLiteral.fields) {
            BLangRecordLiteral.BLangRecordKeyValueField keyValuePair = (BLangRecordLiteral.BLangRecordKeyValueField)field;
            BLangLiteral keyLiteral = (BLangLiteral)keyValuePair.key.expr;
            String entryKey = (String)keyLiteral.value;
            BIRNode.BIRAnnotationValue annotationValue = this.createAnnotationValue(keyValuePair.valueExpr);
            annotValueEntryMap.put(entryKey, annotationValue);
        }
        return new BIRNode.BIRAnnotationRecordValue(recordLiteral.type, annotValueEntryMap);
    }

    private BIRNode.BIRAnnotationRecordValue createAnnotationRecordValue(BLangStatementExpression stmtExpr) {
        HashMap<String, BIRNode.BIRAnnotationValue> annotValueEntryMap = new HashMap<String, BIRNode.BIRAnnotationValue>();
        List<BLangStatement> stmts = ((BLangBlockStmt)stmtExpr.stmt).stmts;
        for (int i = 1; i < stmts.size(); ++i) {
            BLangAssignment assignmentStmt = (BLangAssignment)stmts.get(i);
            annotValueEntryMap.put((String)((BLangLiteral)((BLangIndexBasedAccess)assignmentStmt.varRef).indexExpr).value, this.createAnnotationValue(assignmentStmt.expr));
        }
        return new BIRNode.BIRAnnotationRecordValue(stmtExpr.type, annotValueEntryMap);
    }

    private BIRNode.BIRAnnotationArrayValue createAnnotationArrayValue(BLangListConstructorExpr.BLangArrayLiteral arrayLiteral) {
        BIRNode.BIRAnnotationValue[] annotValues = new BIRNode.BIRAnnotationValue[arrayLiteral.exprs.size()];
        for (int exprIndex = 0; exprIndex < arrayLiteral.exprs.size(); ++exprIndex) {
            annotValues[exprIndex] = this.createAnnotationValue((BLangExpression)arrayLiteral.exprs.get(exprIndex));
        }
        return new BIRNode.BIRAnnotationArrayValue(arrayLiteral.type, annotValues);
    }

    private BIRNode.BIRAnnotationLiteralValue createAnnotationLiteralValue(BLangLiteral literalValue) {
        return new BIRNode.BIRAnnotationLiteralValue(literalValue.type, literalValue.value);
    }

    private BIRNode.TaintTable populateTaintTable(Map<Integer, TaintRecord> taintRecords) {
        BIRNode.TaintTable taintTable = new BIRNode.TaintTable();
        if (taintRecords == null) {
            return taintTable;
        }
        int rowCount = 0;
        for (Integer paramIndex : taintRecords.keySet()) {
            TaintRecord taintRecord = taintRecords.get(paramIndex);
            boolean added = this.addTaintTableEntry(taintTable, paramIndex, taintRecord);
            if (!added) continue;
            taintTable.columnCount = taintRecord.parameterTaintedStatusList.size() + 1;
            ++rowCount;
        }
        taintTable.rowCount = rowCount;
        return taintTable;
    }

    private boolean addTaintTableEntry(BIRNode.TaintTable taintTable, int index, TaintRecord taintRecord) {
        if (taintRecord.taintError == null || taintRecord.taintError.isEmpty()) {
            ArrayList<Byte> storedTaintTableValue = new ArrayList<Byte>();
            storedTaintTableValue.add(taintRecord.returnTaintedStatus.getByteValue());
            storedTaintTableValue.addAll(taintRecord.parameterTaintedStatusList.stream().map(taintedStatus -> taintedStatus.getByteValue()).collect(Collectors.toList()));
            taintTable.taintTable.put(index, storedTaintTableValue);
            return true;
        }
        return false;
    }

    @Override
    public void visit(BLangAnnotation astAnnotation) {
        BAnnotationSymbol annSymbol = (BAnnotationSymbol)astAnnotation.symbol;
        BIRNode.BIRAnnotation birAnn = new BIRNode.BIRAnnotation(astAnnotation.pos, annSymbol.name, annSymbol.flags, annSymbol.points, annSymbol.attachedType == null ? this.symTable.trueType : annSymbol.attachedType.type);
        birAnn.setMarkdownDocAttachment(annSymbol.markdownDocumentation);
        this.env.enclPkg.annotations.add(birAnn);
    }

    private boolean isWorkerSend(String chnlName, String workerName) {
        return chnlName.startsWith(workerName) && chnlName.split(workerName)[1].startsWith("->");
    }

    @Override
    public void visit(BLangLambdaFunction lambdaExpr) {
        BIRNode.BIRVariableDcl tempVarLambda = new BIRNode.BIRVariableDcl(lambdaExpr.pos, lambdaExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP, null);
        this.env.enclFunc.localVars.add(tempVarLambda);
        BIROperand lhsOp = new BIROperand(tempVarLambda);
        Name funcName = this.getFuncName(lambdaExpr.function.symbol);
        ArrayList<BIRNode.BIRVariableDcl> params = new ArrayList<BIRNode.BIRVariableDcl>();
        lambdaExpr.function.requiredParams.forEach(param -> {
            String metaVarName = param.name.isLiteral ? null : param.name.value;
            BIRNode.BIRVariableDcl birVarDcl = new BIRNode.BIRVariableDcl(param.pos, param.symbol.type, this.env.nextLambdaVarId(this.names), VarScope.FUNCTION, VarKind.ARG, metaVarName);
            params.add(birVarDcl);
        });
        BLangSimpleVariable restParam = lambdaExpr.function.restParam;
        if (restParam != null) {
            BIRNode.BIRVariableDcl birVarDcl = new BIRNode.BIRVariableDcl(restParam.pos, restParam.symbol.type, this.env.nextLambdaVarId(this.names), VarScope.FUNCTION, VarKind.ARG, null);
            params.add(birVarDcl);
        }
        this.emit(new BIRNonTerminator.FPLoad(lambdaExpr.pos, lambdaExpr.function.symbol.pkgID, funcName, lhsOp, params, this.getClosureMapOperands(lambdaExpr), lambdaExpr.type, lambdaExpr.function.symbol.schedulerPolicy));
        this.env.targetOperand = lhsOp;
    }

    private List<BIROperand> getClosureMapOperands(BLangLambdaFunction lambdaExpr) {
        ArrayList<BIROperand> closureMaps = new ArrayList<BIROperand>();
        lambdaExpr.function.paramClosureMap.forEach((k, v) -> {
            BVarSymbol symbol = lambdaExpr.enclMapSymbols.get(k);
            if (symbol == null) {
                symbol = lambdaExpr.paramMapSymbolsOfEnclInvokable.get(k);
            }
            BIROperand varRef = new BIROperand(this.env.symbolVarMap.get(symbol));
            closureMaps.add(varRef);
        });
        return closureMaps;
    }

    private Name getFuncName(BInvokableSymbol symbol) {
        if (symbol.receiverSymbol == null) {
            return symbol.name;
        }
        int offset = symbol.receiverSymbol.type.tsymbol.name.value.length() + 1;
        String attachedFuncName = symbol.name.value;
        return this.names.fromString(attachedFuncName.substring(offset, attachedFuncName.length()));
    }

    private void addParam(BIRNode.BIRFunction birFunc, BLangVariable functionParam) {
        this.addParam(birFunc, functionParam.symbol, functionParam.expr, functionParam.pos);
    }

    private void addParam(BIRNode.BIRFunction birFunc, BVarSymbol paramSymbol, DiagnosticPos pos) {
        this.addParam(birFunc, paramSymbol, null, pos);
    }

    private void addParam(BIRNode.BIRFunction birFunc, BVarSymbol paramSymbol, BLangExpression defaultValExpr, DiagnosticPos pos) {
        BIRNode.BIRFunctionParameter birVarDcl = new BIRNode.BIRFunctionParameter(pos, paramSymbol.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.ARG, paramSymbol.name.value, defaultValExpr != null);
        birFunc.localVars.add(birVarDcl);
        ArrayList<BIRNode.BIRBasicBlock> bbsOfDefaultValueExpr = new ArrayList<BIRNode.BIRBasicBlock>();
        if (defaultValExpr != null) {
            BIRNode.BIRBasicBlock defaultExprBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
            bbsOfDefaultValueExpr.add(defaultExprBB);
            this.env.enclBB = defaultExprBB;
            this.env.enclBasicBlocks = bbsOfDefaultValueExpr;
            defaultValExpr.accept(this);
            BIROperand varRef = new BIROperand(birVarDcl);
            this.emit(new BIRNonTerminator.Move(birFunc.pos, this.env.targetOperand, varRef));
            this.env.enclBB.terminator = new BIRTerminator.Return(birFunc.pos);
        }
        BIRNode.BIRParameter parameter = new BIRNode.BIRParameter(pos, paramSymbol.name, paramSymbol.flags);
        birFunc.requiredParams.add(parameter);
        birFunc.parameters.put(birVarDcl, bbsOfDefaultValueExpr);
        this.env.symbolVarMap.put(paramSymbol, birVarDcl);
    }

    private void addRestParam(BIRNode.BIRFunction birFunc, BVarSymbol paramSymbol, DiagnosticPos pos) {
        BIRNode.BIRFunctionParameter birVarDcl = new BIRNode.BIRFunctionParameter(pos, paramSymbol.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.ARG, paramSymbol.name.value, false);
        birFunc.parameters.put(birVarDcl, new ArrayList());
        birFunc.localVars.add(birVarDcl);
        birFunc.restParam = new BIRNode.BIRParameter(pos, paramSymbol.name, paramSymbol.flags);
        this.env.symbolVarMap.put(paramSymbol, birVarDcl);
    }

    private void addRequiredParam(BIRNode.BIRFunction birFunc, BVarSymbol paramSymbol, DiagnosticPos pos) {
        BIRNode.BIRFunctionParameter birVarDcl = new BIRNode.BIRFunctionParameter(pos, paramSymbol.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.ARG, paramSymbol.name.value, false);
        birFunc.parameters.put(birVarDcl, new ArrayList());
        birFunc.localVars.add(birVarDcl);
        BIRNode.BIRParameter parameter = new BIRNode.BIRParameter(pos, paramSymbol.name, paramSymbol.flags);
        birFunc.requiredParams.add(parameter);
        this.env.symbolVarMap.put(paramSymbol, birVarDcl);
    }

    @Override
    public void visit(BLangBlockStmt astBlockStmt) {
        BlockNode prevBlock = this.currentBlock;
        this.currentBlock = astBlockStmt;
        this.varDclsByBlock.computeIfAbsent(astBlockStmt, k -> new ArrayList());
        for (BLangStatement astStmt : astBlockStmt.stmts) {
            astStmt.accept(this);
        }
        this.varDclsByBlock.get(astBlockStmt).forEach(birVariableDcl -> {
            birVariableDcl.endBB = this.env.enclBasicBlocks.get(this.env.enclBasicBlocks.size() - 1);
        });
        this.currentBlock = prevBlock;
    }

    @Override
    public void visit(BLangSimpleVariableDef astVarDefStmt) {
        String metaVarName = astVarDefStmt.var.name.isLiteral ? null : astVarDefStmt.var.name.value;
        BIRNode.BIRVariableDcl birVarDcl = new BIRNode.BIRVariableDcl(astVarDefStmt.pos, astVarDefStmt.var.symbol.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.LOCAL, metaVarName);
        birVarDcl.startBB = this.env.enclBB;
        this.varDclsByBlock.get(this.currentBlock).add(birVarDcl);
        this.env.enclFunc.localVars.add(birVarDcl);
        this.env.symbolVarMap.put(astVarDefStmt.var.symbol, birVarDcl);
        if (astVarDefStmt.var.expr == null) {
            return;
        }
        astVarDefStmt.var.expr.accept(this);
        BIROperand varRef = new BIROperand(birVarDcl);
        this.emit(new BIRNonTerminator.Move(astVarDefStmt.pos, this.env.targetOperand, varRef));
        birVarDcl.insOffset = this.env.enclBB.instructions.size() - 1;
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        String name = "$annotation_data".equals(varNode.symbol.name.value) ? "$annotation_data" : varNode.name.value;
        BIRNode.BIRGlobalVariableDcl birVarDcl = new BIRNode.BIRGlobalVariableDcl(varNode.pos, varNode.symbol.flags, varNode.symbol.type, varNode.symbol.pkgID, this.names.fromString(name), VarScope.GLOBAL, VarKind.GLOBAL, varNode.name.value);
        birVarDcl.setMarkdownDocAttachment(varNode.symbol.markdownDocumentation);
        this.env.enclPkg.globalVars.add(birVarDcl);
        this.globalVarMap.put(varNode.symbol, birVarDcl);
    }

    @Override
    public void visit(BLangAssignment astAssignStmt) {
        astAssignStmt.expr.accept(this);
        this.varAssignment = true;
        astAssignStmt.varRef.accept(this);
        this.varAssignment = false;
    }

    @Override
    public void visit(BLangExpressionStmt exprStmtNode) {
        exprStmtNode.expr.accept(this);
    }

    @Override
    public void visit(BLangInvocation invocationExpr) {
        if (invocationExpr.symbol.kind == SymbolKind.ERROR_CONSTRUCTOR) {
            this.createErrorConstructorInvocation(invocationExpr);
            return;
        }
        this.createCall(invocationExpr, false);
    }

    @Override
    public void visit(BLangStatementExpression statementExpression) {
        statementExpression.stmt.accept(this);
        statementExpression.expr.accept(this);
    }

    @Override
    public void visit(BLangInvocation.BLangAttachedFunctionInvocation invocationExpr) {
        this.createCall(invocationExpr, true);
    }

    @Override
    public void visit(BLangInvocation.BFunctionPointerInvocation invocation) {
        invocation.functionPointerInvocation = true;
        this.createCall(invocation, false);
    }

    @Override
    public void visit(BLangForkJoin forkJoin) {
        forkJoin.workers.forEach(worker -> worker.accept(this));
    }

    @Override
    public void visit(BLangWorkerReceive workerReceive) {
        BIROperand lhsOp;
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(thenBB);
        String channel = workerReceive.workerIdentifier.value + "->" + this.env.enclFunc.workerName.value;
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(workerReceive.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        boolean isOnSameStrand = DEFAULT_WORKER_NAME.equals(this.env.enclFunc.workerName.value);
        this.env.enclBB.terminator = new BIRTerminator.WorkerReceive(workerReceive.pos, this.names.fromString(channel), lhsOp, isOnSameStrand, thenBB);
        this.env.enclBasicBlocks.add(thenBB);
        this.env.enclBB = thenBB;
    }

    @Override
    public void visit(BLangWorkerSend workerSend) {
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(thenBB);
        this.env.enclBasicBlocks.add(thenBB);
        workerSend.expr.accept(this);
        String channelName = this.env.enclFunc.workerName.value + "->" + workerSend.workerIdentifier.value;
        boolean isOnSameStrand = DEFAULT_WORKER_NAME.equals(this.env.enclFunc.workerName.value);
        this.env.enclBB.terminator = new BIRTerminator.WorkerSend(workerSend.pos, this.names.fromString(channelName), this.env.targetOperand, isOnSameStrand, false, null, thenBB);
        this.env.enclBB = thenBB;
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr syncSend) {
        BIROperand lhsOp;
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(thenBB);
        syncSend.expr.accept(this);
        BIROperand dataOp = this.env.targetOperand;
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(syncSend.receive.matchingSendsError, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        String channelName = this.env.enclFunc.workerName.value + "->" + syncSend.workerIdentifier.value;
        boolean isOnSameStrand = DEFAULT_WORKER_NAME.equals(this.env.enclFunc.workerName.value);
        this.env.enclBB.terminator = new BIRTerminator.WorkerSend(syncSend.pos, this.names.fromString(channelName), dataOp, isOnSameStrand, true, lhsOp, thenBB);
        this.env.enclBasicBlocks.add(thenBB);
        this.env.enclBB = thenBB;
    }

    @Override
    public void visit(BLangWorkerFlushExpr flushExpr) {
        BIROperand lhsOp;
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(thenBB);
        BIRNode.ChannelDetails[] channels = new BIRNode.ChannelDetails[flushExpr.workerIdentifierList.size()];
        int i = 0;
        for (BLangIdentifier workerIdentifier : flushExpr.workerIdentifierList) {
            String channelName = this.env.enclFunc.workerName.value + "->" + workerIdentifier.value;
            boolean isOnSameStrand = DEFAULT_WORKER_NAME.equals(this.env.enclFunc.workerName.value);
            channels[i] = new BIRNode.ChannelDetails(channelName, isOnSameStrand, true);
            ++i;
        }
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(flushExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        this.env.enclBB.terminator = new BIRTerminator.Flush(flushExpr.pos, channels, lhsOp, thenBB);
        this.env.enclBasicBlocks.add(thenBB);
        this.env.enclBB = thenBB;
    }

    private void createWait(BLangWaitExpr waitExpr) {
        BIROperand lhsOp;
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(thenBB);
        ArrayList<BIROperand> exprList = new ArrayList<BIROperand>();
        waitExpr.exprList.forEach(expr -> {
            expr.accept(this);
            exprList.add(this.env.targetOperand);
        });
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(waitExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        this.env.enclBB.terminator = new BIRTerminator.Wait(waitExpr.pos, exprList, lhsOp, thenBB);
        this.env.enclBasicBlocks.add(thenBB);
        this.env.enclBB = thenBB;
    }

    private void createErrorConstructorInvocation(BLangInvocation invocationExpr) {
        BIROperand lhsOp;
        BIRNode.BIRVariableDcl tempVarError = new BIRNode.BIRVariableDcl(invocationExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarError);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarError);
        invocationExpr.requiredArgs.get(0).accept(this);
        BIROperand reasonOp = this.env.targetOperand;
        invocationExpr.requiredArgs.get(1).accept(this);
        BIROperand detailsOp = this.env.targetOperand;
        BIRNonTerminator.NewError newError = new BIRNonTerminator.NewError(invocationExpr.pos, invocationExpr.type, lhsOp, reasonOp, detailsOp);
        this.emit(newError);
        this.env.targetOperand = lhsOp;
    }

    private void createCall(BLangInvocation invocationExpr, boolean isVirtual) {
        BIROperand lhsOp;
        List<BLangExpression> requiredArgs = invocationExpr.requiredArgs;
        List<BLangExpression> restArgs = invocationExpr.restArgs;
        ArrayList<BIROperand> args = new ArrayList<BIROperand>();
        for (BLangExpression requiredArg : requiredArgs) {
            if (requiredArg.getKind() != NodeKind.IGNORE_EXPR) {
                requiredArg.accept(this);
                args.add(this.env.targetOperand);
                continue;
            }
            BIRNode.BIRVariableDcl birVariableDcl = new BIRNode.BIRVariableDcl(requiredArg.type, new Name("_"), VarScope.FUNCTION, VarKind.ARG);
            birVariableDcl.ignoreVariable = true;
            args.add(new BIROperand(birVariableDcl));
        }
        for (BLangExpression arg : restArgs) {
            arg.accept(this);
            args.add(this.env.targetOperand);
        }
        BIROperand fp = null;
        if (invocationExpr.functionPointerInvocation) {
            invocationExpr.expr.accept(this);
            fp = this.env.targetOperand;
        }
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(invocationExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(thenBB);
        this.env.enclBasicBlocks.add(thenBB);
        if (invocationExpr.functionPointerInvocation) {
            this.env.enclBB.terminator = new BIRTerminator.FPCall(invocationExpr.pos, InstructionKind.FP_CALL, fp, args, lhsOp, invocationExpr.async, thenBB);
        } else if (invocationExpr.async) {
            List<BIRNode.BIRAnnotationAttachment> annots = this.getStatementAnnotations(invocationExpr.annAttachments, this.env);
            this.env.enclBB.terminator = new BIRTerminator.AsyncCall(invocationExpr.pos, InstructionKind.ASYNC_CALL, isVirtual, invocationExpr.symbol.pkgID, this.getFuncName((BInvokableSymbol)invocationExpr.symbol), args, lhsOp, thenBB, annots);
        } else {
            this.env.enclBB.terminator = new BIRTerminator.Call(invocationExpr.pos, InstructionKind.CALL, isVirtual, invocationExpr.symbol.pkgID, this.getFuncName((BInvokableSymbol)invocationExpr.symbol), args, lhsOp, thenBB);
        }
        this.env.enclBB = thenBB;
    }

    @Override
    public void visit(BLangReturn astReturnStmt) {
        astReturnStmt.expr.accept(this);
        BIROperand retVarRef = new BIROperand(this.env.enclFunc.returnVariable);
        this.emit(new BIRNonTerminator.Move(astReturnStmt.pos, this.env.targetOperand, retVarRef));
        if (this.env.returnBB == null) {
            BIRNode.BIRBasicBlock returnBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
            this.addToTrapStack(returnBB);
            returnBB.terminator = new BIRTerminator.Return(astReturnStmt.pos);
            this.env.returnBB = returnBB;
        }
        if (this.env.enclBB.terminator == null) {
            this.env.unlockVars.forEach(s -> {
                for (long i = s.numLocks; i > 0L; --i) {
                    BIRNode.BIRBasicBlock unlockBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
                    this.env.enclBasicBlocks.add(unlockBB);
                    this.env.enclBB.terminator = new BIRTerminator.Unlock(null, unlockBB);
                    this.env.enclBB = unlockBB;
                }
            });
            this.env.enclBB.terminator = new BIRTerminator.GOTO(astReturnStmt.pos, this.env.returnBB);
            BIRNode.BIRBasicBlock nextBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
            this.env.enclBasicBlocks.add(nextBB);
            this.env.enclBB = nextBB;
            this.addToTrapStack(nextBB);
        }
    }

    @Override
    public void visit(BLangPanic panicNode) {
        panicNode.expr.accept(this);
        if (this.env.returnBB == null) {
            BIRNode.BIRBasicBlock returnBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
            this.addToTrapStack(returnBB);
            returnBB.terminator = new BIRTerminator.Return(panicNode.pos);
            this.env.returnBB = returnBB;
        }
        this.env.enclBB.terminator = new BIRTerminator.Panic(panicNode.pos, this.env.targetOperand);
        BIRNode.BIRBasicBlock unlockBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(unlockBB);
        this.env.enclBasicBlocks.add(unlockBB);
        this.env.enclBB = unlockBB;
    }

    @Override
    public void visit(BLangIf astIfStmt) {
        astIfStmt.expr.accept(this);
        BIROperand ifExprResult = this.env.targetOperand;
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(thenBB);
        this.env.enclBasicBlocks.add(thenBB);
        BIRNode.BIRBasicBlock nextBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        BIRTerminator.Branch branchIns = new BIRTerminator.Branch(astIfStmt.pos, ifExprResult, thenBB, null);
        this.env.enclBB.terminator = branchIns;
        this.env.enclBB = thenBB;
        astIfStmt.body.accept(this);
        if (this.env.enclBB.terminator == null) {
            this.env.enclBB.terminator = new BIRTerminator.GOTO(null, nextBB);
        }
        if (astIfStmt.elseStmt != null) {
            BIRNode.BIRBasicBlock elseBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
            this.addToTrapStack(elseBB);
            this.env.enclBasicBlocks.add(elseBB);
            branchIns.falseBB = elseBB;
            this.env.enclBB = elseBB;
            astIfStmt.elseStmt.accept(this);
            if (this.env.enclBB.terminator == null) {
                this.env.enclBB.terminator = new BIRTerminator.GOTO(null, nextBB);
            }
        } else {
            branchIns.falseBB = nextBB;
        }
        this.addToTrapStack(nextBB);
        this.env.enclBasicBlocks.add(nextBB);
        this.env.enclBB = nextBB;
    }

    @Override
    public void visit(BLangWhile astWhileStmt) {
        BIRNode.BIRBasicBlock currentEnclLoopBB = this.env.enclLoopBB;
        BIRNode.BIRBasicBlock currentEnclLoopEndBB = this.env.enclLoopEndBB;
        BIRNode.BIRBasicBlock whileExprBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(whileExprBB);
        this.env.enclBasicBlocks.add(whileExprBB);
        this.env.enclBB.terminator = new BIRTerminator.GOTO(astWhileStmt.pos, whileExprBB);
        this.env.enclBB = whileExprBB;
        astWhileStmt.expr.accept(this);
        BIROperand whileExprResult = this.env.targetOperand;
        BIRNode.BIRBasicBlock whileBodyBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(whileBodyBB);
        this.env.enclBasicBlocks.add(whileBodyBB);
        BIRNode.BIRBasicBlock whileEndBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(whileEndBB);
        this.env.enclBB.terminator = new BIRTerminator.Branch(astWhileStmt.pos, whileExprResult, whileBodyBB, whileEndBB);
        this.env.enclBB = whileBodyBB;
        this.env.enclLoopBB = whileExprBB;
        this.env.enclLoopEndBB = whileEndBB;
        this.env.unlockVars.push(new BIRNode.BIRLockDetailsHolder());
        astWhileStmt.body.accept(this);
        this.env.unlockVars.pop();
        if (this.env.enclBB.terminator == null) {
            this.env.enclBB.terminator = new BIRTerminator.GOTO(null, whileExprBB);
        }
        this.env.enclBasicBlocks.add(whileEndBB);
        this.env.enclBB = whileEndBB;
        this.env.enclLoopBB = currentEnclLoopBB;
        this.env.enclLoopEndBB = currentEnclLoopEndBB;
    }

    @Override
    public void visit(BLangLiteral astLiteralExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astLiteralExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        this.emit(new BIRNonTerminator.ConstantLoad(astLiteralExpr.pos, astLiteralExpr.value, astLiteralExpr.type, toVarRef));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangMapLiteral astMapLiteralExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astMapLiteralExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        this.emit(new BIRNonTerminator.NewStructure(astMapLiteralExpr.pos, astMapLiteralExpr.type, toVarRef));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangTypeConversionExpr astTypeConversionExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astTypeConversionExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        astTypeConversionExpr.expr.accept(this);
        BIROperand rhsOp = this.env.targetOperand;
        this.emit(new BIRNonTerminator.TypeCast(astTypeConversionExpr.pos, toVarRef, rhsOp, toVarRef.variableDcl.type, astTypeConversionExpr.checkTypes));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangRecordLiteral.BLangStructLiteral astStructLiteralExpr) {
        BIRNonTerminator.NewStructure instruction;
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astStructLiteralExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        BTypeSymbol structTypeSymbol = this.getRecordTypeSymbol(astStructLiteralExpr.type);
        if (this.isInSamePackage(structTypeSymbol, this.env.enclPkg)) {
            instruction = new BIRNonTerminator.NewStructure(astStructLiteralExpr.pos, astStructLiteralExpr.type, toVarRef);
        } else {
            String recordName = ((BRecordTypeSymbol)astStructLiteralExpr.type.tsymbol).name.value;
            instruction = new BIRNonTerminator.NewStructure(astStructLiteralExpr.pos, structTypeSymbol.pkgID, recordName, astStructLiteralExpr.type, toVarRef);
        }
        this.emit(instruction);
        this.env.targetOperand = toVarRef;
        if (astStructLiteralExpr.initializer != null) {
            // empty if block
        }
    }

    @Override
    public void visit(BLangTypeInit connectorInitExpr) {
        BIRNonTerminator.NewInstance instruction;
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(connectorInitExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        BTypeSymbol objectTypeSymbol = this.getObjectTypeSymbol(connectorInitExpr.type);
        if (this.isInSamePackage(objectTypeSymbol, this.env.enclPkg)) {
            BIRNode.BIRTypeDefinition def = this.typeDefs.get(objectTypeSymbol);
            instruction = new BIRNonTerminator.NewInstance(connectorInitExpr.pos, def, toVarRef);
        } else {
            BType objectType = connectorInitExpr.type.tag != 20 ? connectorInitExpr.type : ((BUnionType)connectorInitExpr.type).getMemberTypes().stream().filter(bType -> bType.tag != 27).findFirst().get();
            String objectName = objectType.tsymbol.name.value;
            instruction = new BIRNonTerminator.NewInstance(connectorInitExpr.pos, objectTypeSymbol.pkgID, objectName, toVarRef);
        }
        this.emit(instruction);
        this.env.targetOperand = toVarRef;
    }

    private boolean isInSamePackage(BSymbol objectTypeSymbol, BIRNode.BIRPackage enclPkg) {
        return objectTypeSymbol.pkgID.orgName.equals(enclPkg.org) && objectTypeSymbol.pkgID.name.equals(enclPkg.name) && objectTypeSymbol.pkgID.version.equals(enclPkg.version);
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFieldVarRef fieldVarRef) {
    }

    @Override
    public void visit(BLangTableLiteral tableLiteral) {
        this.generateTableLiteral(tableLiteral);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangArrayLiteral astArrayLiteralExpr) {
        this.generateListConstructorExpr(astArrayLiteralExpr);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangTupleLiteral tupleLiteral) {
        this.generateListConstructorExpr(tupleLiteral);
    }

    @Override
    public void visit(BLangGroupExpr groupExpr) {
        groupExpr.expression.accept(this);
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangJSONArrayLiteral jsonArrayLiteralExpr) {
        this.generateListConstructorExpr(jsonArrayLiteralExpr);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangMapAccessExpr astMapAccessExpr) {
        boolean variableStore = this.varAssignment;
        this.varAssignment = false;
        BIROperand rhsOp = this.env.targetOperand;
        astMapAccessExpr.expr.accept(this);
        BIROperand varRefRegIndex = this.env.targetOperand;
        astMapAccessExpr.indexExpr.accept(this);
        BIROperand keyRegIndex = this.env.targetOperand;
        if (variableStore) {
            this.emit(new BIRNonTerminator.FieldAccess(astMapAccessExpr.pos, InstructionKind.MAP_STORE, varRefRegIndex, keyRegIndex, rhsOp));
            return;
        }
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astMapAccessExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand tempVarRef = new BIROperand(tempVarDcl);
        this.emit(new BIRNonTerminator.FieldAccess(astMapAccessExpr.pos, InstructionKind.MAP_LOAD, tempVarRef, keyRegIndex, varRefRegIndex, astMapAccessExpr.optionalFieldAccess, astMapAccessExpr.lhsVar && !astMapAccessExpr.leafNode));
        this.env.targetOperand = tempVarRef;
        this.varAssignment = variableStore;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStructFieldAccessExpr astStructFieldAccessExpr) {
        this.generateMappingAccess(astStructFieldAccessExpr, astStructFieldAccessExpr.optionalFieldAccess);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangJSONAccessExpr astJSONFieldAccessExpr) {
        if (astJSONFieldAccessExpr.indexExpr.type.tag == 1) {
            this.generateArrayAccess(astJSONFieldAccessExpr);
            return;
        }
        this.generateMappingAccess(astJSONFieldAccessExpr, astJSONFieldAccessExpr.optionalFieldAccess);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStringAccessExpr stringAccessExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(stringAccessExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand tempVarRef = new BIROperand(tempVarDcl);
        stringAccessExpr.expr.accept(this);
        BIROperand varRefRegIndex = this.env.targetOperand;
        stringAccessExpr.indexExpr.accept(this);
        BIROperand keyRegIndex = this.env.targetOperand;
        this.emit(new BIRNonTerminator.FieldAccess(stringAccessExpr.pos, InstructionKind.STRING_LOAD, tempVarRef, keyRegIndex, varRefRegIndex));
        this.env.targetOperand = tempVarRef;
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangArrayAccessExpr astArrayAccessExpr) {
        this.generateArrayAccess(astArrayAccessExpr);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTupleAccessExpr tupleAccessExpr) {
        this.generateArrayAccess(tupleAccessExpr);
    }

    @Override
    public void visit(BLangIsLikeExpr isLikeExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(this.symTable.booleanType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        isLikeExpr.expr.accept(this);
        BIROperand exprIndex = this.env.targetOperand;
        this.emit(new BIRNonTerminator.IsLike(isLikeExpr.pos, isLikeExpr.typeNode.type, toVarRef, exprIndex));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangTypeTestExpr typeTestExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(this.symTable.booleanType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        typeTestExpr.expr.accept(this);
        BIROperand exprIndex = this.env.targetOperand;
        this.emit(new BIRNonTerminator.TypeTest(typeTestExpr.pos, typeTestExpr.typeNode.type, toVarRef, exprIndex));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangLocalVarRef astVarRefExpr) {
        boolean variableStore = this.varAssignment;
        this.varAssignment = false;
        BSymbol varSymbol = astVarRefExpr.symbol;
        if (variableStore) {
            if (astVarRefExpr.symbol.name != Names.IGNORE) {
                BIROperand varRef = new BIROperand(this.env.symbolVarMap.get(varSymbol));
                this.emit(new BIRNonTerminator.Move(astVarRefExpr.pos, this.env.targetOperand, varRef));
            }
        } else {
            BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(varSymbol.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
            this.env.enclFunc.localVars.add(tempVarDcl);
            BIROperand tempVarRef = new BIROperand(tempVarDcl);
            BIRNode.BIRVariableDcl varDecl = this.isSelfVar(varSymbol) ? this.getSelf(varSymbol, varSymbol.type, varSymbol.name) : this.env.symbolVarMap.get(varSymbol);
            BIROperand fromVarRef = new BIROperand(varDecl);
            this.emit(new BIRNonTerminator.Move(astVarRefExpr.pos, fromVarRef, tempVarRef));
            this.env.targetOperand = tempVarRef;
        }
        this.varAssignment = variableStore;
    }

    private boolean isSelfVar(BSymbol symbol) {
        return Names.SELF.equals(symbol.name);
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangPackageVarRef astPackageVarRefExpr) {
        boolean variableStore = this.varAssignment;
        this.varAssignment = false;
        if (variableStore) {
            if (astPackageVarRefExpr.symbol.name != Names.IGNORE) {
                BIROperand varRef = new BIROperand(this.getVarRef(astPackageVarRefExpr));
                this.emit(new BIRNonTerminator.Move(astPackageVarRefExpr.pos, this.env.targetOperand, varRef));
            }
        } else {
            BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astPackageVarRefExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
            this.env.enclFunc.localVars.add(tempVarDcl);
            BIROperand tempVarRef = new BIROperand(tempVarDcl);
            BIROperand fromVarRef = new BIROperand(this.getVarRef(astPackageVarRefExpr));
            this.emit(new BIRNonTerminator.Move(astPackageVarRefExpr.pos, fromVarRef, tempVarRef));
            this.env.targetOperand = tempVarRef;
        }
        this.varAssignment = variableStore;
    }

    private BIRNode.BIRGlobalVariableDcl getVarRef(BLangSimpleVarRef.BLangPackageVarRef astPackageVarRefExpr) {
        BSymbol symbol = astPackageVarRefExpr.symbol;
        if ((symbol.tag & 0x100001C) == 0x100001C || !this.isInSamePackage(astPackageVarRefExpr.varSymbol, this.env.enclPkg)) {
            return new BIRNode.BIRGlobalVariableDcl(astPackageVarRefExpr.pos, symbol.flags, symbol.type, symbol.pkgID, symbol.name, VarScope.GLOBAL, VarKind.CONSTANT, symbol.name.value);
        }
        return this.globalVarMap.get(symbol);
    }

    @Override
    public void visit(BLangBinaryExpr astBinaryExpr) {
        BIROperand lhsOp;
        astBinaryExpr.lhsExpr.accept(this);
        BIROperand rhsOp1 = this.env.targetOperand;
        astBinaryExpr.rhsExpr.accept(this);
        BIROperand rhsOp2 = this.env.targetOperand;
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astBinaryExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        this.env.targetOperand = lhsOp = new BIROperand(tempVarDcl);
        BIRNonTerminator.BinaryOp binaryIns = new BIRNonTerminator.BinaryOp(astBinaryExpr.pos, this.getBinaryInstructionKind(astBinaryExpr.opKind), astBinaryExpr.type, lhsOp, rhsOp1, rhsOp2);
        this.emit(binaryIns);
    }

    @Override
    public void visit(BLangUnaryExpr unaryExpr) {
        unaryExpr.expr.accept(this);
        BIROperand rhsOp = this.env.targetOperand;
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(unaryExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand lhsOp = new BIROperand(tempVarDcl);
        if (OperatorKind.ADD.equals((Object)unaryExpr.operator) || OperatorKind.UNTAINT.equals((Object)unaryExpr.operator)) {
            this.emit(new BIRNonTerminator.Move(unaryExpr.pos, rhsOp, lhsOp));
            this.env.targetOperand = lhsOp;
            return;
        }
        BIRNonTerminator.UnaryOP unaryIns = new BIRNonTerminator.UnaryOP(unaryExpr.pos, this.getUnaryInstructionKind(unaryExpr.operator), lhsOp, rhsOp);
        this.emit(unaryIns);
        this.env.targetOperand = lhsOp;
    }

    @Override
    public void visit(BLangTrapExpr trapExpr) {
        BIRNode.BIRBasicBlock trapBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.env.enclBasicBlocks.add(trapBB);
        this.env.enclBB.terminator = new BIRTerminator.GOTO(trapExpr.pos, trapBB);
        this.env.enclBB = trapBB;
        this.env.trapBlocks.push(new ArrayList());
        this.addToTrapStack(trapBB);
        trapExpr.expr.accept(this);
        List<BIRNode.BIRBasicBlock> trappedBlocks = this.env.trapBlocks.pop();
        BIRNode.BIRBasicBlock nextBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(nextBB);
        this.env.enclBasicBlocks.add(nextBB);
        this.env.enclBB.terminator = new BIRTerminator.GOTO(trapExpr.pos, nextBB);
        this.env.enclFunc.errorTable.add(new BIRNode.BIRErrorEntry(trappedBlocks.get(0), trappedBlocks.get(trappedBlocks.size() - 1), this.env.targetOperand, nextBB));
        this.env.enclBB = nextBB;
    }

    @Override
    public void visit(BLangWaitExpr waitExpr) {
        this.createWait(waitExpr);
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitLiteral waitLiteral) {
        BIRNode.BIRBasicBlock thenBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(thenBB);
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(waitLiteral.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        this.emit(new BIRNonTerminator.NewStructure(waitLiteral.pos, waitLiteral.type, toVarRef));
        this.env.targetOperand = toVarRef;
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<BIROperand> valueExprs = new ArrayList<BIROperand>();
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyValue : waitLiteral.keyValuePairs) {
            keys.add(keyValue.key.value);
            BLangExpression expr = keyValue.valueExpr != null ? keyValue.valueExpr : keyValue.keyExpr;
            expr.accept(this);
            BIROperand valueRegIndex = this.env.targetOperand;
            valueExprs.add(valueRegIndex);
        }
        this.env.enclBB.terminator = new BIRTerminator.WaitAll(waitLiteral.pos, toVarRef, keys, valueExprs, thenBB);
        this.env.targetOperand = toVarRef;
        this.env.enclFunc.basicBlocks.add(thenBB);
        this.env.enclBB = thenBB;
    }

    @Override
    public void visit(BLangIsAssignableExpr assignableExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(this.symTable.booleanType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        assignableExpr.lhsExpr.accept(this);
        BIROperand exprIndex = this.env.targetOperand;
        this.emit(new BIRNonTerminator.TypeTest(assignableExpr.pos, assignableExpr.targetType, toVarRef, exprIndex));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangXMLQName xmlQName) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(this.symTable.anyType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        if (!xmlQName.isUsedInXML) {
            String qName = xmlQName.namespaceURI == null ? xmlQName.localname.value : "{" + xmlQName.namespaceURI + "}" + xmlQName.localname;
            this.generateStringLiteral(qName);
            return;
        }
        BIROperand nsURIIndex = this.generateStringLiteral(xmlQName.namespaceURI);
        BIROperand localnameIndex = this.generateStringLiteral(xmlQName.localname.value);
        BIROperand prefixIndex = this.generateStringLiteral(xmlQName.prefix.value);
        BIRNonTerminator.NewXMLQName newXMLQName = new BIRNonTerminator.NewXMLQName(xmlQName.pos, toVarRef, localnameIndex, nsURIIndex, prefixIndex);
        this.emit(newXMLQName);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangXMLElementLiteral xmlElementLiteral) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(xmlElementLiteral.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        xmlElementLiteral.inlineNamespaces.forEach(xmlns -> xmlns.accept(this));
        BLangExpression startTagName = (BLangExpression)xmlElementLiteral.getStartTagName();
        startTagName.accept(this);
        BIROperand startTagNameIndex = this.env.targetOperand;
        BIROperand defaultNsURIVarRef = this.generateNamespaceRef(xmlElementLiteral.defaultNsSymbol, xmlElementLiteral.pos);
        BIRNonTerminator.NewXMLElement newXMLElement = new BIRNonTerminator.NewXMLElement(xmlElementLiteral.pos, toVarRef, startTagNameIndex, defaultNsURIVarRef);
        this.emit(newXMLElement);
        this.populateXML(xmlElementLiteral, toVarRef);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangXMLAttribute attribute) {
        BIROperand xmlVarRef = this.env.targetOperand;
        attribute.name.accept(this);
        BIROperand attrNameOp = this.env.targetOperand;
        attribute.value.accept(this);
        BIROperand attrValueOp = this.env.targetOperand;
        this.emit(new BIRNonTerminator.FieldAccess(attribute.pos, InstructionKind.XML_ATTRIBUTE_STORE, xmlVarRef, attrNameOp, attrValueOp));
    }

    @Override
    public void visit(BLangXMLTextLiteral xmlTextLiteral) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(xmlTextLiteral.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        xmlTextLiteral.concatExpr.accept(this);
        BIROperand xmlTextIndex = this.env.targetOperand;
        BIRNonTerminator.NewXMLText newXMLElement = new BIRNonTerminator.NewXMLText(xmlTextLiteral.pos, toVarRef, xmlTextIndex);
        this.emit(newXMLElement);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangXMLCommentLiteral xmlCommentLiteral) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(xmlCommentLiteral.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        xmlCommentLiteral.concatExpr.accept(this);
        BIROperand xmlCommentIndex = this.env.targetOperand;
        BIRNonTerminator.NewXMLComment newXMLComment = new BIRNonTerminator.NewXMLComment(xmlCommentLiteral.pos, toVarRef, xmlCommentIndex);
        this.emit(newXMLComment);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangXMLProcInsLiteral xmlProcInsLiteral) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(xmlProcInsLiteral.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        xmlProcInsLiteral.dataConcatExpr.accept(this);
        BIROperand dataIndex = this.env.targetOperand;
        xmlProcInsLiteral.target.accept(this);
        BIROperand targetIndex = this.env.targetOperand;
        BIRNonTerminator.NewXMLProcIns newXMLProcIns = new BIRNonTerminator.NewXMLProcIns(xmlProcInsLiteral.pos, toVarRef, dataIndex, targetIndex);
        this.emit(newXMLProcIns);
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangXMLQuotedString xmlQuotedString) {
        xmlQuotedString.concatExpr.accept(this);
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        xmlnsStmtNode.xmlnsDecl.accept(this);
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangXMLNS.BLangLocalXMLNS xmlnsNode) {
        this.generateXMLNamespace(xmlnsNode);
    }

    @Override
    public void visit(BLangXMLNS.BLangPackageXMLNS xmlnsNode) {
        this.generateXMLNamespace(xmlnsNode);
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangXMLAccessExpr xmlAccessExpr) {
        this.generateMappingAccess(xmlAccessExpr, false);
    }

    @Override
    public void visit(BLangXMLAttributeAccess xmlAttributeAccessExpr) {
        if (xmlAttributeAccessExpr.indexExpr != null) {
            this.generateMappingAccess(xmlAttributeAccessExpr, false);
            return;
        }
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(this.symTable.mapStringType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        xmlAttributeAccessExpr.expr.accept(this);
        BIROperand xmlVarOp = this.env.targetOperand;
        this.emit(new BIRNonTerminator.TypeCast(xmlAttributeAccessExpr.pos, toVarRef, xmlVarOp, this.symTable.mapStringType, true));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangTypedescExpr accessExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(accessExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        this.emit(new BIRNonTerminator.NewTypeDesc(accessExpr.pos, toVarRef, accessExpr.resolvedType));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangTypeLoad typeLoad) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(this.symTable.typeDesc, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        this.emit(new BIRNonTerminator.NewTypeDesc(typeLoad.pos, toVarRef, typeLoad.symbol.type));
        this.env.targetOperand = toVarRef;
    }

    @Override
    public void visit(BLangBreak breakStmt) {
        BIRNode.BIRLockDetailsHolder toUnlock = this.env.unlockVars.peek();
        if (!toUnlock.isEmpty()) {
            BIRNode.BIRBasicBlock goToBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
            this.env.enclBasicBlocks.add(goToBB);
            this.env.enclBB.terminator = new BIRTerminator.GOTO(breakStmt.pos, goToBB);
            this.env.enclBB = goToBB;
        }
        for (long numLocks = toUnlock.numLocks; numLocks > 0L; --numLocks) {
            BIRNode.BIRBasicBlock unlockBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
            this.env.enclBasicBlocks.add(unlockBB);
            this.env.enclBB.terminator = new BIRTerminator.Unlock(null, unlockBB);
            this.env.enclBB = unlockBB;
        }
        this.env.enclBB.terminator = new BIRTerminator.GOTO(breakStmt.pos, this.env.enclLoopEndBB);
    }

    @Override
    public void visit(BLangContinue continueStmt) {
        BIRNode.BIRLockDetailsHolder toUnlock = this.env.unlockVars.peek();
        if (!toUnlock.isEmpty()) {
            BIRNode.BIRBasicBlock goToBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
            this.env.enclBasicBlocks.add(goToBB);
            this.env.enclBB.terminator = new BIRTerminator.GOTO(continueStmt.pos, goToBB);
            this.env.enclBB = goToBB;
        }
        for (long numLocks = toUnlock.numLocks; numLocks > 0L; --numLocks) {
            BIRNode.BIRBasicBlock unlockBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
            this.env.enclBasicBlocks.add(unlockBB);
            this.env.enclBB.terminator = new BIRTerminator.Unlock(null, unlockBB);
            this.env.enclBB = unlockBB;
        }
        this.env.enclBB.terminator = new BIRTerminator.GOTO(continueStmt.pos, this.env.enclLoopBB);
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFunctionVarRef fpVarRef) {
        this.generateFPVarRef(fpVarRef, (BInvokableSymbol)fpVarRef.symbol);
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangStructFunctionVarRef structFpVarRef) {
        this.generateFPVarRef(structFpVarRef, (BInvokableSymbol)structFpVarRef.symbol);
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockStmt) {
        BIRNode.BIRBasicBlock lockedBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(lockedBB);
        this.env.enclBasicBlocks.add(lockedBB);
        this.env.enclBB.terminator = new BIRTerminator.Lock(null, lockedBB);
        this.env.enclBB = lockedBB;
        ++this.env.unlockVars.peek().numLocks;
    }

    @Override
    public void visit(BLangLock.BLangUnLockStmt unLockStmt) {
        BIRNode.BIRLockDetailsHolder lockDetailsHolder = this.env.unlockVars.peek();
        if (lockDetailsHolder.isEmpty()) {
            return;
        }
        BIRNode.BIRBasicBlock unLockedBB = new BIRNode.BIRBasicBlock(this.env.nextBBId(this.names));
        this.addToTrapStack(unLockedBB);
        this.env.enclBasicBlocks.add(unLockedBB);
        this.env.enclBB.terminator = new BIRTerminator.Unlock(null, unLockedBB);
        this.env.enclBB = unLockedBB;
        --lockDetailsHolder.numLocks;
    }

    private void emit(BIRNonTerminator instruction) {
        this.env.enclBB.instructions.add(instruction);
    }

    private InstructionKind getBinaryInstructionKind(OperatorKind opKind) {
        switch (opKind) {
            case ADD: {
                return InstructionKind.ADD;
            }
            case SUB: {
                return InstructionKind.SUB;
            }
            case MUL: {
                return InstructionKind.MUL;
            }
            case DIV: {
                return InstructionKind.DIV;
            }
            case MOD: {
                return InstructionKind.MOD;
            }
            case EQUAL: {
                return InstructionKind.EQUAL;
            }
            case NOT_EQUAL: {
                return InstructionKind.NOT_EQUAL;
            }
            case GREATER_THAN: {
                return InstructionKind.GREATER_THAN;
            }
            case GREATER_EQUAL: {
                return InstructionKind.GREATER_EQUAL;
            }
            case LESS_THAN: {
                return InstructionKind.LESS_THAN;
            }
            case LESS_EQUAL: {
                return InstructionKind.LESS_EQUAL;
            }
            case AND: {
                return InstructionKind.AND;
            }
            case OR: {
                return InstructionKind.OR;
            }
            case REF_EQUAL: {
                return InstructionKind.REF_EQUAL;
            }
            case REF_NOT_EQUAL: {
                return InstructionKind.REF_NOT_EQUAL;
            }
            case CLOSED_RANGE: {
                return InstructionKind.CLOSED_RANGE;
            }
            case HALF_OPEN_RANGE: {
                return InstructionKind.HALF_OPEN_RANGE;
            }
            case ANNOT_ACCESS: {
                return InstructionKind.ANNOT_ACCESS;
            }
            case BITWISE_AND: {
                return InstructionKind.BITWISE_AND;
            }
            case BITWISE_OR: {
                return InstructionKind.BITWISE_OR;
            }
            case BITWISE_XOR: {
                return InstructionKind.BITWISE_XOR;
            }
            case BITWISE_LEFT_SHIFT: {
                return InstructionKind.BITWISE_LEFT_SHIFT;
            }
            case BITWISE_RIGHT_SHIFT: {
                return InstructionKind.BITWISE_RIGHT_SHIFT;
            }
            case BITWISE_UNSIGNED_RIGHT_SHIFT: {
                return InstructionKind.BITWISE_UNSIGNED_RIGHT_SHIFT;
            }
        }
        throw new IllegalStateException("unsupported binary operation: " + opKind.value());
    }

    private InstructionKind getUnaryInstructionKind(OperatorKind opKind) {
        switch (opKind) {
            case TYPEOF: {
                return InstructionKind.TYPEOF;
            }
            case NOT: {
                return InstructionKind.NOT;
            }
            case SUB: {
                return InstructionKind.NEGATE;
            }
            case ADD: {
                return InstructionKind.MOVE;
            }
        }
        throw new IllegalStateException("unsupported unary operator: " + opKind.value());
    }

    private void generateListConstructorExpr(BLangListConstructorExpr listConstructorExpr) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(listConstructorExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        long size = -1L;
        if (listConstructorExpr.type.tag == 19 && ((BArrayType)listConstructorExpr.type).state != BArrayState.UNSEALED) {
            size = ((BArrayType)listConstructorExpr.type).size;
        } else if (listConstructorExpr.type.tag == 29) {
            size = listConstructorExpr.exprs.size();
        }
        BLangLiteral literal = new BLangLiteral();
        literal.pos = listConstructorExpr.pos;
        literal.value = size;
        literal.type = this.symTable.intType;
        literal.accept(this);
        BIROperand sizeOp = this.env.targetOperand;
        this.emit(new BIRNonTerminator.NewArray(listConstructorExpr.pos, listConstructorExpr.type, toVarRef, sizeOp));
        for (int i = 0; i < listConstructorExpr.exprs.size(); ++i) {
            BLangExpression argExpr = listConstructorExpr.exprs.get(i);
            argExpr.accept(this);
            BIROperand exprIndex = this.env.targetOperand;
            BLangLiteral indexLiteral = new BLangLiteral();
            indexLiteral.pos = listConstructorExpr.pos;
            indexLiteral.value = (long)i;
            indexLiteral.type = this.symTable.intType;
            indexLiteral.accept(this);
            BIROperand arrayIndex = this.env.targetOperand;
            this.emit(new BIRNonTerminator.FieldAccess(listConstructorExpr.pos, InstructionKind.ARRAY_STORE, toVarRef, arrayIndex, exprIndex));
        }
        this.env.targetOperand = toVarRef;
    }

    private void generateTableLiteral(BLangTableLiteral tableLiteral) {
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(tableLiteral.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand toVarRef = new BIROperand(tempVarDcl);
        BLangListConstructorExpr.BLangArrayLiteral columnLiteral = new BLangListConstructorExpr.BLangArrayLiteral();
        columnLiteral.pos = tableLiteral.pos;
        columnLiteral.type = this.symTable.arrayStringType;
        columnLiteral.exprs = new ArrayList();
        tableLiteral.columns.forEach(col -> {
            BLangLiteral colLiteral = new BLangLiteral();
            colLiteral.pos = tableLiteral.pos;
            colLiteral.type = this.symTable.stringType;
            colLiteral.value = col.columnName;
            columnLiteral.exprs.add(colLiteral);
        });
        columnLiteral.accept(this);
        BIROperand columnsOp = this.env.targetOperand;
        BLangListConstructorExpr.BLangArrayLiteral dataLiteral = new BLangListConstructorExpr.BLangArrayLiteral();
        dataLiteral.pos = tableLiteral.pos;
        dataLiteral.type = this.symTable.arrayAnydataType;
        dataLiteral.exprs = new ArrayList<BLangExpression>(tableLiteral.tableDataRows);
        dataLiteral.accept(this);
        BIROperand dataOp = this.env.targetOperand;
        tableLiteral.indexColumnsArrayLiteral.accept(this);
        tableLiteral.keyColumnsArrayLiteral.accept(this);
        BIROperand keyColOp = this.env.targetOperand;
        this.emit(new BIRNonTerminator.NewTable(tableLiteral.pos, tableLiteral.type, toVarRef, columnsOp, dataOp, keyColOp));
        this.env.targetOperand = toVarRef;
    }

    private void generateArrayAccess(BLangIndexBasedAccess astArrayAccessExpr) {
        boolean variableStore = this.varAssignment;
        this.varAssignment = false;
        BIROperand rhsOp = this.env.targetOperand;
        astArrayAccessExpr.expr.accept(this);
        BIROperand varRefRegIndex = this.env.targetOperand;
        astArrayAccessExpr.indexExpr.accept(this);
        BIROperand keyRegIndex = this.env.targetOperand;
        if (variableStore) {
            this.emit(new BIRNonTerminator.FieldAccess(astArrayAccessExpr.pos, InstructionKind.ARRAY_STORE, varRefRegIndex, keyRegIndex, rhsOp));
            return;
        }
        BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astArrayAccessExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarDcl);
        BIROperand tempVarRef = new BIROperand(tempVarDcl);
        this.emit(new BIRNonTerminator.FieldAccess(astArrayAccessExpr.pos, InstructionKind.ARRAY_LOAD, tempVarRef, keyRegIndex, varRefRegIndex, false, astArrayAccessExpr.lhsVar && !astArrayAccessExpr.leafNode));
        this.env.targetOperand = tempVarRef;
        this.varAssignment = variableStore;
    }

    private void generateMappingAccess(BLangIndexBasedAccess astIndexBasedAccessExpr, boolean except) {
        boolean variableStore = this.varAssignment;
        this.varAssignment = false;
        BType astAccessExprExprType = astIndexBasedAccessExpr.expr.type;
        if (variableStore) {
            InstructionKind insKind;
            BIROperand rhsOp = this.env.targetOperand;
            astIndexBasedAccessExpr.expr.accept(this);
            BIROperand varRefRegIndex = this.env.targetOperand;
            astIndexBasedAccessExpr.indexExpr.accept(this);
            BIROperand keyRegIndex = this.env.targetOperand;
            if (astIndexBasedAccessExpr.getKind() == NodeKind.XML_ATTRIBUTE_ACCESS_EXPR) {
                insKind = InstructionKind.XML_ATTRIBUTE_STORE;
                keyRegIndex = this.getQNameOP(astIndexBasedAccessExpr.indexExpr, keyRegIndex);
            } else {
                insKind = astAccessExprExprType.tag == 32 || astAccessExprExprType.tag == 20 && ((BUnionType)astAccessExprExprType).getMemberTypes().iterator().next().tag == 32 ? InstructionKind.OBJECT_STORE : InstructionKind.MAP_STORE;
            }
            this.emit(new BIRNonTerminator.FieldAccess(astIndexBasedAccessExpr.pos, insKind, varRefRegIndex, keyRegIndex, rhsOp));
        } else {
            InstructionKind insKind;
            BIRNode.BIRVariableDcl tempVarDcl = new BIRNode.BIRVariableDcl(astIndexBasedAccessExpr.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
            this.env.enclFunc.localVars.add(tempVarDcl);
            BIROperand tempVarRef = new BIROperand(tempVarDcl);
            astIndexBasedAccessExpr.expr.accept(this);
            BIROperand varRefRegIndex = this.env.targetOperand;
            astIndexBasedAccessExpr.indexExpr.accept(this);
            BIROperand keyRegIndex = this.env.targetOperand;
            if (astIndexBasedAccessExpr.getKind() == NodeKind.XML_ATTRIBUTE_ACCESS_EXPR) {
                insKind = InstructionKind.XML_ATTRIBUTE_LOAD;
                keyRegIndex = this.getQNameOP(astIndexBasedAccessExpr.indexExpr, keyRegIndex);
            } else {
                if (astAccessExprExprType.tag == 8) {
                    this.generateXMLAccess((BLangIndexBasedAccess.BLangXMLAccessExpr)astIndexBasedAccessExpr, tempVarRef, varRefRegIndex, keyRegIndex);
                    this.varAssignment = variableStore;
                    return;
                }
                insKind = astAccessExprExprType.tag == 32 || astAccessExprExprType.tag == 20 && ((BUnionType)astAccessExprExprType).getMemberTypes().iterator().next().tag == 32 ? InstructionKind.OBJECT_LOAD : InstructionKind.MAP_LOAD;
            }
            this.emit(new BIRNonTerminator.FieldAccess(astIndexBasedAccessExpr.pos, insKind, tempVarRef, keyRegIndex, varRefRegIndex, except, astIndexBasedAccessExpr.lhsVar && !astIndexBasedAccessExpr.leafNode));
            this.env.targetOperand = tempVarRef;
        }
        this.varAssignment = variableStore;
    }

    private BTypeSymbol getObjectTypeSymbol(BType type) {
        if (type.tag == 20) {
            return ((BUnionType)type).getMemberTypes().stream().filter((Predicate<BType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getObjectTypeSymbol$27(org.wso2.ballerinalang.compiler.semantics.model.types.BType ), (Lorg/wso2/ballerinalang/compiler/semantics/model/types/BType;)Z)()).findFirst().orElse((BType)this.symTable.noType).tsymbol;
        }
        return type.tsymbol;
    }

    private BTypeSymbol getRecordTypeSymbol(BType type) {
        if (type.tag == 20) {
            return ((BUnionType)type).getMemberTypes().stream().filter((Predicate<BType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getRecordTypeSymbol$28(org.wso2.ballerinalang.compiler.semantics.model.types.BType ), (Lorg/wso2/ballerinalang/compiler/semantics/model/types/BType;)Z)()).findFirst().orElse((BType)this.symTable.noType).tsymbol;
        }
        return type.tsymbol;
    }

    private BIROperand generateStringLiteral(String value) {
        BLangLiteral prefixLiteral = (BLangLiteral)TreeBuilder.createLiteralExpression();
        prefixLiteral.value = value;
        prefixLiteral.type = value == null ? this.symTable.nilType : this.symTable.stringType;
        prefixLiteral.accept(this);
        return this.env.targetOperand;
    }

    private void generateXMLNamespace(BLangXMLNS xmlnsNode) {
        BIRNode.BIRVariableDcl birVarDcl = new BIRNode.BIRVariableDcl(xmlnsNode.pos, this.symTable.stringType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.LOCAL, null);
        this.env.enclFunc.localVars.add(birVarDcl);
        this.env.symbolVarMap.put(xmlnsNode.symbol, birVarDcl);
        xmlnsNode.namespaceURI.accept(this);
        BIROperand varRef = new BIROperand(birVarDcl);
        this.emit(new BIRNonTerminator.Move(xmlnsNode.pos, this.env.targetOperand, varRef));
    }

    private BIROperand generateNamespaceRef(BXMLNSSymbol nsSymbol, DiagnosticPos pos) {
        if (nsSymbol == null) {
            return this.generateStringLiteral(null);
        }
        int ownerTag = nsSymbol.owner.tag;
        if ((ownerTag & 0x1001) == 4097 || (ownerTag & 0x3005C) == 196700 || (ownerTag & 0x5005C) == 327772) {
            return this.generateStringLiteral(nsSymbol.namespaceURI);
        }
        BIRNode.BIRVariableDcl nsURIVarDcl = new BIRNode.BIRVariableDcl(this.symTable.stringType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(nsURIVarDcl);
        BIROperand nsURIVarRef = new BIROperand(nsURIVarDcl);
        BIRNode.BIRVariableDcl varDecl = this.env.symbolVarMap.get(nsSymbol);
        BIROperand fromVarRef = new BIROperand(varDecl);
        this.emit(new BIRNonTerminator.Move(pos, fromVarRef, nsURIVarRef));
        return nsURIVarRef;
    }

    private void populateXML(BLangXMLElementLiteral xmlElementLiteral, BIROperand toVarRef) {
        xmlElementLiteral.namespacesInScope.forEach((name, symbol) -> {
            BLangXMLQName nsQName = new BLangXMLQName(name.getValue(), "xmlns");
            nsQName.type = this.symTable.stringType;
            nsQName.accept(this);
            BIROperand nsQNameIndex = this.env.targetOperand;
            BIROperand nsURIIndex = this.generateNamespaceRef((BXMLNSSymbol)symbol, xmlElementLiteral.pos);
            this.emit(new BIRNonTerminator.FieldAccess(xmlElementLiteral.pos, InstructionKind.XML_ATTRIBUTE_STORE, toVarRef, nsQNameIndex, nsURIIndex));
        });
        xmlElementLiteral.attributes.forEach(attribute -> {
            this.env.targetOperand = toVarRef;
            attribute.accept(this);
        });
        xmlElementLiteral.modifiedChildren.forEach(child -> {
            child.accept(this);
            BIROperand childOp = this.env.targetOperand;
            this.emit(new BIRNonTerminator.XMLAccess(child.pos, InstructionKind.XML_SEQ_STORE, toVarRef, childOp));
        });
    }

    private BIROperand getQNameOP(BLangExpression qnameExpr, BIROperand keyRegIndex) {
        if (qnameExpr.getKind() == NodeKind.XML_QNAME) {
            return keyRegIndex;
        }
        BIRNode.BIRVariableDcl tempQNameVarDcl = new BIRNode.BIRVariableDcl(this.symTable.anyType, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempQNameVarDcl);
        BIROperand qnameVarRef = new BIROperand(tempQNameVarDcl);
        this.emit(new BIRNonTerminator.NewStringXMLQName(qnameExpr.pos, qnameVarRef, keyRegIndex));
        return qnameVarRef;
    }

    private void generateXMLAccess(BLangIndexBasedAccess.BLangXMLAccessExpr xmlAccessExpr, BIROperand tempVarRef, BIROperand varRefRegIndex, BIROperand keyRegIndex) {
        this.env.targetOperand = tempVarRef;
        if (xmlAccessExpr.fieldType == FieldKind.ALL) {
            this.emit(new BIRNonTerminator.XMLAccess(xmlAccessExpr.pos, InstructionKind.XML_LOAD_ALL, tempVarRef, varRefRegIndex));
            return;
        }
        InstructionKind insKind = xmlAccessExpr.indexExpr.type.tag == 5 ? InstructionKind.XML_LOAD : InstructionKind.XML_SEQ_LOAD;
        this.emit(new BIRNonTerminator.FieldAccess(xmlAccessExpr.pos, insKind, tempVarRef, keyRegIndex, varRefRegIndex));
    }

    private void generateFPVarRef(BLangExpression fpVarRef, BInvokableSymbol funcSymbol) {
        BIRNode.BIRVariableDcl tempVarLambda = new BIRNode.BIRVariableDcl(fpVarRef.type, this.env.nextLocalVarId(this.names), VarScope.FUNCTION, VarKind.TEMP);
        this.env.enclFunc.localVars.add(tempVarLambda);
        BIROperand lhsOp = new BIROperand(tempVarLambda);
        Name funcName = this.getFuncName(funcSymbol);
        ArrayList<BIRNode.BIRVariableDcl> params = new ArrayList<BIRNode.BIRVariableDcl>();
        funcSymbol.params.forEach(param -> {
            BIRNode.BIRVariableDcl birVarDcl = new BIRNode.BIRVariableDcl(fpVarRef.pos, param.type, this.env.nextLambdaVarId(this.names), VarScope.FUNCTION, VarKind.ARG, null);
            params.add(birVarDcl);
        });
        BVarSymbol restParam = funcSymbol.restParam;
        if (restParam != null) {
            BIRNode.BIRVariableDcl birVarDcl = new BIRNode.BIRVariableDcl(fpVarRef.pos, restParam.type, this.env.nextLambdaVarId(this.names), VarScope.FUNCTION, VarKind.ARG, null);
            params.add(birVarDcl);
        }
        this.emit(new BIRNonTerminator.FPLoad(fpVarRef.pos, funcSymbol.pkgID, funcName, lhsOp, params, new ArrayList<BIROperand>(), funcSymbol.retType, funcSymbol.schedulerPolicy));
        this.env.targetOperand = lhsOp;
    }

    private void populateBIRAnnotAttachments(List<BLangAnnotationAttachment> astAnnotAttachments, List<BIRNode.BIRAnnotationAttachment> birAnnotAttachments, BIRGenEnv currentEnv) {
        currentEnv.enclAnnotAttachments = birAnnotAttachments;
        astAnnotAttachments.forEach(annotAttach -> annotAttach.accept(this));
        currentEnv.enclAnnotAttachments = null;
    }

    private void addToTrapStack(BIRNode.BIRBasicBlock birBasicBlock) {
        if (this.env.trapBlocks.isEmpty()) {
            return;
        }
        this.env.trapBlocks.peek().add(birBasicBlock);
    }

    private List<BIRNode.BIRAnnotationAttachment> getStatementAnnotations(List<BLangAnnotationAttachment> astAnnotAttachments, BIRGenEnv currentEnv) {
        List<BIRNode.BIRAnnotationAttachment> functionAnnotAttachments = currentEnv.enclAnnotAttachments;
        currentEnv.enclAnnotAttachments = new ArrayList<BIRNode.BIRAnnotationAttachment>();
        astAnnotAttachments.forEach(annotAttach -> annotAttach.accept(this));
        List<BIRNode.BIRAnnotationAttachment> statementAnnots = currentEnv.enclAnnotAttachments;
        currentEnv.enclAnnotAttachments = functionAnnotAttachments;
        return statementAnnots;
    }

    private static /* synthetic */ boolean lambda$getRecordTypeSymbol$28(BType t) {
        return t.tag == 12;
    }

    private static /* synthetic */ boolean lambda$getObjectTypeSymbol$27(BType t) {
        return t.tag == 32;
    }
}

