/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen.interop;

import java.util.ArrayList;
import java.util.List;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropValidationRequest;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JInterop;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.JMethodKind;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.ParamTypeConstraint;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;

class JMethodRequest {
    Class<?> declaringClass;
    String methodName;
    JMethodKind kind;
    ParamTypeConstraint[] paramTypeConstraints = new ParamTypeConstraint[0];
    int bFuncParamCount;
    BType[] bParamTypes = null;
    BType bReturnType = null;
    boolean returnsBErrorType = false;
    boolean restParamExist = false;

    private JMethodRequest() {
    }

    static JMethodRequest build(InteropValidationRequest.MethodValidationRequest methodValidationRequest, ClassLoader classLoader, boolean isEntryModuleValidation) {
        BType returnType;
        BType restType;
        JMethodRequest jMethodReq = new JMethodRequest();
        jMethodReq.kind = methodValidationRequest.methodKind;
        jMethodReq.methodName = methodValidationRequest.name;
        jMethodReq.declaringClass = JInterop.loadClass(methodValidationRequest.klass, classLoader);
        jMethodReq.paramTypeConstraints = JInterop.buildParamTypeConstraints(methodValidationRequest.paramTypeConstraints, classLoader);
        BInvokableType bFuncType = methodValidationRequest.bFuncType;
        List<BType> currentParamTypes = bFuncType.paramTypes;
        List<Object> paramTypes = new ArrayList();
        if (!isEntryModuleValidation) {
            for (int i = 0; i < currentParamTypes.size(); i += 2) {
                paramTypes.add(currentParamTypes.get(i));
            }
        } else {
            paramTypes = currentParamTypes;
        }
        if ((restType = bFuncType.restType) != null) {
            paramTypes.add(restType);
        }
        jMethodReq.bFuncParamCount = paramTypes.size();
        jMethodReq.bParamTypes = paramTypes.toArray(new BType[0]);
        jMethodReq.bReturnType = returnType = bFuncType.retType;
        if (returnType.tag == 20) {
            for (BType bType : ((BUnionType)returnType).getMemberTypes()) {
                if (bType.tag != 27) continue;
                jMethodReq.returnsBErrorType = true;
                break;
            }
        } else {
            jMethodReq.returnsBErrorType = returnType.tag == 27;
        }
        jMethodReq.restParamExist = methodValidationRequest.restParamExist;
        return jMethodReq;
    }
}

