/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.converters;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.values.MapValue;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.CompilerInput;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.model.Proxy;
import org.wso2.ballerinalang.compiler.packaging.converters.URIConverter;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.util.TomlParserUtils;

public class URIDryConverter
extends URIConverter {
    private static boolean loggedError = false;
    private static final Pattern semVerPatchPattern = Pattern.compile("(\\d+)\\.(\\d+)");
    private PrintStream errStream = System.err;
    private java.net.Proxy proxy;
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    public URIDryConverter(URI base, Map<PackageID, Manifest> dependencyManifests) {
        this(base, dependencyManifests, false);
    }

    public URIDryConverter(URI base, Map<PackageID, Manifest> dependencyManifests, boolean isBuild) {
        super(base, dependencyManifests, isBuild);
        this.base = URI.create(base.toString() + "/modules/info/");
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            this.proxy = this.getProxy();
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Stream<CompilerInput> finalize(URI remoteURI, PackageID moduleID) {
        try {
            matcher = URIDryConverter.semVerPatchPattern.matcher(moduleID.version.value);
            if ("".equals(moduleID.version.value) || "*".equals(moduleID.version.value) || matcher.matches()) {
                conn = null == this.proxy ? (HttpURLConnection)remoteURI.toURL().openConnection() : (HttpURLConnection)remoteURI.toURL().openConnection(this.proxy);
                conn.setInstanceFollowRedirects(false);
                conn.setRequestMethod("GET");
                statusCode = conn.getResponseCode();
                if (statusCode == 200) {
                    reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                    var7_9 = null;
                    try {
                        result = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            result.append(line);
                        }
                        payload = JSONParser.parse((String)result.toString());
                        if (!(payload instanceof MapValue)) ** GOTO lbl62
                        moduleInfo = ((MapValue)payload).getMapValue("module");
                        version = moduleInfo.getStringValue("version");
                        moduleID.version = new Name(version);
                    }
                    catch (Throwable result) {
                        var7_9 = result;
                        throw result;
                    }
                    finally {
                        if (reader != null) {
                            if (var7_9 != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable result) {
                                    var7_9.addSuppressed(result);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                } else if (statusCode == 400 && !URIDryConverter.loggedError) {
                    errorStream = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                    var7_10 = null;
                    try {
                        errorContent = errorStream.lines().collect(Collectors.joining("\n"));
                        this.errStream.println("error: could not connect to remote repository to find the latest version of module: " + moduleID.toString() + ". use '--offline' flag to build in offline mode. reason: " + errorContent);
                        URIDryConverter.setErrorLoggedStatusAsTrue();
                    }
                    catch (Throwable var8_16) {
                        var7_10 = var8_16;
                        throw var8_16;
                    }
                    finally {
                        if (errorStream != null) {
                            if (var7_10 != null) {
                                try {
                                    errorStream.close();
                                }
                                catch (Throwable var8_15) {
                                    var7_10.addSuppressed(var8_15);
                                }
                            } else {
                                errorStream.close();
                            }
                        }
                    }
                } else if (statusCode == 500 && !URIDryConverter.loggedError) {
                    this.errStream.println("error: could not connect to remote repository to find the latest version of module: " + moduleID.toString() + ". use '--offline' flag to build in offline mode.");
                    URIDryConverter.setErrorLoggedStatusAsTrue();
                }
lbl62:
                // 6 sources

                conn.disconnect();
                Authenticator.setDefault(null);
            }
        }
        catch (IOException var3_4) {
            // empty catch block
        }
        return Stream.empty();
    }

    private static void setErrorLoggedStatusAsTrue() {
        loggedError = true;
    }

    private java.net.Proxy getProxy() {
        Proxy proxy = TomlParserUtils.readSettings().getProxy();
        if (!"".equals(proxy.getHost())) {
            InetSocketAddress proxyInet = new InetSocketAddress(proxy.getHost(), proxy.getPort());
            if (!"".equals(proxy.getUserName()) && "".equals(proxy.getPassword())) {
                RemoteAuthenticator authenticator = new RemoteAuthenticator();
                Authenticator.setDefault(authenticator);
            }
            return new java.net.Proxy(Proxy.Type.HTTP, proxyInet);
        }
        return null;
    }

    static class RemoteAuthenticator
    extends Authenticator {
        Proxy proxy = TomlParserUtils.readSettings().getProxy();

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.proxy.getUserName(), this.proxy.getPassword().toCharArray());
        }
    }
}

