/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.parser.antlr4;

import org.antlr.v4.runtime.DefaultErrorStrategy;
import org.antlr.v4.runtime.FailedPredicateException;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.wso2.ballerinalang.compiler.parser.BLangParserListener;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaParser;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.diagnotic.BDiagnosticSource;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class BallerinaParserErrorStrategy
extends DefaultErrorStrategy {
    private BLangDiagnosticLogHelper dlog;
    protected BDiagnosticSource diagnosticSrc;

    public BallerinaParserErrorStrategy(CompilerContext context, BDiagnosticSource diagnosticSrc) {
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
        this.diagnosticSrc = diagnosticSrc;
    }

    public void reportInputMismatch(Parser parser, InputMismatchException e) {
        this.setErrorState(parser);
        Token offendingToken = e.getOffendingToken();
        String mismatchedToken = this.getTokenErrorDisplay(offendingToken);
        String expectedToken = e.getExpectedTokens().toString(parser.getVocabulary());
        DiagnosticPos pos = this.getPosition(offendingToken);
        this.dlog.error(pos, DiagnosticCode.MISMATCHED_INPUT, mismatchedToken, expectedToken);
    }

    public void reportNoViableAlternative(Parser parser, NoViableAltException e) {
        this.setErrorState(parser);
        String offendingToken = e.getOffendingToken().getText();
        DiagnosticPos pos = this.getPosition(e.getOffendingToken());
        this.dlog.error(pos, DiagnosticCode.INVALID_TOKEN, this.escapeWSAndQuote(offendingToken));
    }

    public void reportFailedPredicate(Parser parser, FailedPredicateException e) {
        this.setErrorState(parser);
        DiagnosticPos pos = this.getPosition(this.getMissingSymbol(parser));
        if (parser.getContext() instanceof BallerinaParser.ShiftExprPredicateContext) {
            this.dlog.error(pos, DiagnosticCode.INVALID_SHIFT_OPERATOR, new Object[0]);
        } else if (parser.getContext() instanceof BallerinaParser.RestDescriptorPredicateContext) {
            this.dlog.error(pos, DiagnosticCode.INVALID_RECORD_REST_DESCRIPTOR, new Object[0]);
        } else {
            this.dlog.error(pos, DiagnosticCode.FAILED_PREDICATE, e.getMessage());
        }
    }

    public void reportMissingToken(Parser parser) {
        if (parser.getContext().exception != null || this.inErrorRecoveryMode(parser)) {
            return;
        }
        this.beginErrorCondition(parser);
        this.setErrorState(parser);
        Token token = parser.getCurrentToken();
        IntervalSet expecting = this.getExpectedTokens(parser);
        String missingToken = expecting.toString(parser.getVocabulary());
        DiagnosticPos pos = this.getPosition(this.getMissingSymbol(parser));
        this.dlog.error(pos, DiagnosticCode.MISSING_TOKEN, missingToken, this.getTokenErrorDisplay(token));
    }

    public void reportUnwantedToken(Parser parser) {
        if (parser.getContext().exception != null || this.inErrorRecoveryMode(parser)) {
            return;
        }
        this.beginErrorCondition(parser);
        this.setErrorState(parser);
        Token token = parser.getCurrentToken();
        DiagnosticPos pos = this.getPosition(this.getMissingSymbol(parser));
        this.dlog.error(pos, DiagnosticCode.EXTRANEOUS_INPUT, this.getTokenErrorDisplay(token));
    }

    public void reportError(Parser parser, RecognitionException e) {
        if (this.inErrorRecoveryMode(parser)) {
            return;
        }
        this.beginErrorCondition(parser);
        if (e instanceof NoViableAltException) {
            this.reportNoViableAlternative(parser, (NoViableAltException)e);
        } else if (e instanceof InputMismatchException) {
            this.reportInputMismatch(parser, (InputMismatchException)e);
        } else if (e instanceof FailedPredicateException) {
            this.reportFailedPredicate(parser, (FailedPredicateException)e);
        } else {
            this.setErrorState(parser);
            DiagnosticPos pos = this.getPosition(this.getMissingSymbol(parser));
            this.dlog.error(pos, DiagnosticCode.INVALID_TOKEN, e.getMessage());
        }
    }

    public void setDiagnosticSrc(BDiagnosticSource diagnosticSrc) {
        this.diagnosticSrc = diagnosticSrc;
    }

    protected void setErrorState(Parser parser) {
        this.getListener(parser).setErrorState();
    }

    protected BLangParserListener getListener(Parser parser) {
        return (BLangParserListener)parser.getParseListeners().get(0);
    }

    private DiagnosticPos getPosition(Token token) {
        int startLine = token.getLine();
        int startCol = token.getCharPositionInLine() + 1;
        int endLine = -1;
        int endCol = -1;
        return new DiagnosticPos(this.diagnosticSrc, startLine, endLine, startCol, endCol);
    }
}

