/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.analyzer;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.compiler.CompilerPhase;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.ballerinalang.model.tree.IdentifierNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.TypeDefinition;
import org.ballerinalang.model.tree.statements.StatementNode;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.wso2.ballerinalang.compiler.PackageLoader;
import org.wso2.ballerinalang.compiler.SourceDirectory;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.TypeParamAnalyzer;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstantSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BConstructorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BServiceSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLAttributeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BAnnotationType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangEndpoint;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResource;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangWorker;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;
import org.wso2.ballerinalang.util.Flags;

public class SymbolEnter
extends BLangNodeVisitor {
    private static final CompilerContext.Key<SymbolEnter> SYMBOL_ENTER_KEY = new CompilerContext.Key();
    private final PackageLoader pkgLoader;
    private final SymbolTable symTable;
    private final Names names;
    private final SymbolResolver symResolver;
    private final BLangDiagnosticLogHelper dlog;
    private final Types types;
    private final SourceDirectory sourceDirectory;
    private List<TypeDefinition> unresolvedTypes;
    private List<PackageID> importedPackages;
    private int typePrecedence;
    private final TypeParamAnalyzer typeParamAnalyzer;
    private SymbolEnv env;
    private static final String DEPRECATION_ANNOTATION = "deprecated";

    public static SymbolEnter getInstance(CompilerContext context) {
        SymbolEnter symbolEnter = context.get(SYMBOL_ENTER_KEY);
        if (symbolEnter == null) {
            symbolEnter = new SymbolEnter(context);
        }
        return symbolEnter;
    }

    public SymbolEnter(CompilerContext context) {
        context.put(SYMBOL_ENTER_KEY, this);
        this.pkgLoader = PackageLoader.getInstance(context);
        this.symTable = SymbolTable.getInstance(context);
        this.names = Names.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
        this.types = Types.getInstance(context);
        this.typeParamAnalyzer = TypeParamAnalyzer.getInstance(context);
        this.sourceDirectory = context.get(SourceDirectory.class);
        this.importedPackages = new ArrayList<PackageID>();
    }

    public BLangPackage definePackage(BLangPackage pkgNode) {
        this.populatePackageNode(pkgNode);
        this.defineNode(pkgNode, this.symTable.pkgEnvMap.get(this.symTable.langAnnotationModuleSymbol));
        return pkgNode;
    }

    public void defineNode(BLangNode node, SymbolEnv env) {
        SymbolEnv prevEnv = this.env;
        this.env = env;
        node.accept(this);
        this.env = prevEnv;
    }

    public BLangPackage defineTestablePackage(BLangTestablePackage pkgNode, SymbolEnv env, List<BLangImportPackage> enclPkgImports) {
        this.populatePackageNode(pkgNode, enclPkgImports);
        this.defineNode(pkgNode, env);
        return pkgNode;
    }

    @Override
    public void visit(BLangPackage pkgNode) {
        if (pkgNode.completedPhases.contains((Object)CompilerPhase.DEFINE)) {
            return;
        }
        BPackageSymbol pkgSymbol = Symbols.isFlagOn(Flags.asMask(pkgNode.flagSet), 16384) ? Symbols.createPackageSymbol(pkgNode.packageID, this.symTable, Flags.asMask(pkgNode.flagSet)) : Symbols.createPackageSymbol(pkgNode.packageID, this.symTable);
        if (PackageID.isLangLibPackageID(pkgSymbol.pkgID)) {
            this.populateLangLibInSymTable(pkgSymbol);
        }
        pkgNode.symbol = pkgSymbol;
        SymbolEnv pkgEnv = SymbolEnv.createPkgEnv(pkgNode, pkgSymbol.scope, this.env);
        this.symTable.pkgEnvMap.put(pkgSymbol, pkgEnv);
        this.importedPackages.add(pkgNode.packageID);
        this.defineConstructs(pkgNode, pkgEnv);
        pkgNode.getTestablePkgs().forEach(testablePackage -> this.defineTestablePackage((BLangTestablePackage)testablePackage, pkgEnv, pkgNode.imports));
        pkgNode.completedPhases.add(CompilerPhase.DEFINE);
        this.importedPackages.remove(pkgNode.packageID);
    }

    private void defineConstructs(BLangPackage pkgNode, SymbolEnv pkgEnv) {
        HashMap importPkgHolder = new HashMap();
        pkgNode.imports.forEach(importNode -> {
            String qualifiedName = importNode.getQualifiedPackageName();
            if (importPkgHolder.containsKey(qualifiedName)) {
                ((ImportResolveHolder)importPkgHolder.get((Object)qualifiedName)).unresolved.add((BLangImportPackage)importNode);
                return;
            }
            this.defineNode((BLangNode)importNode, pkgEnv);
            if (importNode.symbol != null) {
                importPkgHolder.put(qualifiedName, new ImportResolveHolder((BLangImportPackage)importNode));
            }
        });
        for (ImportResolveHolder importHolder : importPkgHolder.values()) {
            BPackageSymbol pkgSymbol = importHolder.resolved.symbol;
            for (BLangImportPackage unresolvedPkg : importHolder.unresolved) {
                BPackageSymbol importSymbol = importHolder.resolved.symbol;
                Name resolvedPkgAlias = this.names.fromIdNode(importHolder.resolved.alias);
                Name unresolvedPkgAlias = this.names.fromIdNode(unresolvedPkg.alias);
                if (!Names.IGNORE.equals(unresolvedPkgAlias) && unresolvedPkgAlias.equals(resolvedPkgAlias) && importSymbol.compUnit.equals(this.names.fromIdNode(unresolvedPkg.compUnit))) {
                    if (this.isSameImport(unresolvedPkg, importSymbol)) {
                        this.dlog.error(unresolvedPkg.pos, DiagnosticCode.REDECLARED_IMPORT_MODULE, unresolvedPkg.getQualifiedPackageName());
                        continue;
                    }
                    this.dlog.error(unresolvedPkg.pos, DiagnosticCode.REDECLARED_SYMBOL, unresolvedPkgAlias);
                    continue;
                }
                unresolvedPkg.symbol = pkgSymbol;
                BPackageSymbol symbol = this.duplicatePackagSymbol(pkgSymbol);
                symbol.compUnit = this.names.fromIdNode(unresolvedPkg.compUnit);
                symbol.scope = pkgSymbol.scope;
                unresolvedPkg.symbol = symbol;
                pkgEnv.scope.define(unresolvedPkgAlias, symbol);
            }
        }
        this.typePrecedence = 0;
        ArrayList typDefs = new ArrayList();
        pkgNode.constants.forEach(constant -> typDefs.add(constant));
        pkgNode.typeDefinitions.forEach(typDef -> typDefs.add(typDef));
        this.defineTypeNodes(typDefs, pkgEnv);
        for (BLangSimpleVariable variable : pkgNode.globalVars) {
            if (variable.expr == null || variable.expr.getKind() != NodeKind.LAMBDA || !variable.isDeclaredWithVar) continue;
            this.resolveAndSetFunctionTypeFromRHSLambda(variable, pkgEnv);
        }
        pkgEnv.logErrors = true;
        pkgNode.typeDefinitions.sort(Comparator.comparing(t -> t.precedence));
        this.defineErrorDetails(pkgNode.typeDefinitions, pkgEnv);
        this.defineFields(pkgNode.typeDefinitions, pkgEnv);
        this.defineMembers(pkgNode.typeDefinitions, pkgEnv);
        pkgNode.services.forEach(service -> this.defineNode((BLangNode)service, pkgEnv));
        pkgNode.functions.forEach(func -> this.defineNode((BLangNode)func, pkgEnv));
        pkgNode.annotations.forEach(annot -> this.defineNode((BLangNode)annot, pkgEnv));
        pkgNode.globalVars.forEach(var -> this.defineNode((BLangNode)var, pkgEnv));
        pkgNode.globalVars.stream().filter(var -> var.symbol.type.tsymbol != null && Symbols.isFlagOn(var.symbol.type.tsymbol.flags, 131072)).map(varNode -> varNode.symbol).forEach(varSymbol -> {
            varSymbol.tag = 32820;
        });
    }

    @Override
    public void visit(BLangAnnotation annotationNode) {
        BAnnotationSymbol annotationSymbol = Symbols.createAnnotationSymbol(Flags.asMask(annotationNode.flagSet), annotationNode.getAttachPoints(), this.names.fromIdNode(annotationNode.name), this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner);
        annotationSymbol.markdownDocumentation = this.getMarkdownDocAttachment(annotationNode.markdownDocumentationAttachment);
        if (this.isDeprecated(annotationNode.annAttachments)) {
            annotationSymbol.flags |= 0x10;
        }
        annotationSymbol.type = new BAnnotationType(annotationSymbol);
        annotationNode.symbol = annotationSymbol;
        this.defineSymbol(annotationNode.name.pos, annotationSymbol);
        SymbolEnv annotationEnv = SymbolEnv.createAnnotationEnv(annotationNode, annotationSymbol.scope, this.env);
        BLangType annotTypeNode = annotationNode.typeNode;
        if (annotTypeNode != null) {
            BType type = this.symResolver.resolveTypeNode(annotTypeNode, annotationEnv);
            annotationSymbol.attachedType = type.tsymbol;
            if (!this.isValidAnnotationType(type)) {
                this.dlog.error(annotTypeNode.pos, DiagnosticCode.ANNOTATION_INVALID_TYPE, type);
            }
            if (annotationNode.flagSet.contains((Object)Flag.CONSTANT) && !type.isAnydata()) {
                this.dlog.error(annotTypeNode.pos, DiagnosticCode.ANNOTATION_INVALID_CONST_TYPE, type);
            }
        }
        if (!annotationNode.flagSet.contains((Object)Flag.CONSTANT) && annotationNode.getAttachPoints().stream().anyMatch(attachPoint -> attachPoint.source)) {
            this.dlog.error(annotationNode.pos, DiagnosticCode.ANNOTATION_REQUIRES_CONST, new Object[0]);
        }
    }

    private boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    @Override
    public void visit(BLangImportPackage importPkgNode) {
        Name version;
        Name orgName;
        BSymbol importSymbol;
        Name pkgAlias = this.names.fromIdNode(importPkgNode.alias);
        if (!Names.IGNORE.equals(pkgAlias) && (importSymbol = this.symResolver.resolvePrefixSymbol(this.env, pkgAlias, this.names.fromIdNode(importPkgNode.compUnit))) != this.symTable.notFoundSymbol) {
            if (this.isSameImport(importPkgNode, (BPackageSymbol)importSymbol)) {
                this.dlog.error(importPkgNode.pos, DiagnosticCode.REDECLARED_IMPORT_MODULE, importPkgNode.getQualifiedPackageName());
            } else {
                this.dlog.error(importPkgNode.pos, DiagnosticCode.REDECLARED_SYMBOL, pkgAlias);
            }
            return;
        }
        PackageID enclPackageID = this.env.enclPkg.packageID;
        if (!this.isNullOrEmpty(importPkgNode.orgName.value)) {
            orgName = this.names.fromIdNode(importPkgNode.orgName);
            if (!this.isNullOrEmpty(importPkgNode.version.value)) {
                version = this.names.fromIdNode(importPkgNode.version);
            } else {
                String pkgName = importPkgNode.getPackageName().stream().map(id -> id.value).collect(Collectors.joining("."));
                version = this.sourceDirectory.getSourcePackageNames().contains(pkgName) && orgName.value.equals(enclPackageID.orgName.value) ? enclPackageID.version : Names.EMPTY;
            }
        } else {
            orgName = enclPackageID.orgName;
            version = Names.DEFAULT_VERSION.equals(enclPackageID.version) ? Names.EMPTY : enclPackageID.version;
        }
        List<Name> nameComps = importPkgNode.pkgNameComps.stream().map(identifier -> this.names.fromIdNode((BLangIdentifier)identifier)).collect(Collectors.toList());
        PackageID pkgId = new PackageID(orgName, nameComps, version);
        if (!(!pkgId.equals(PackageID.ANNOTATIONS) && !pkgId.equals(PackageID.INTERNAL) || enclPackageID.orgName.equals(Names.BALLERINA_ORG) && enclPackageID.name.value.startsWith(Names.LANG.value))) {
            this.dlog.error(importPkgNode.pos, DiagnosticCode.MODULE_NOT_FOUND, importPkgNode.getQualifiedPackageName());
            return;
        }
        if (this.importedPackages.contains(pkgId)) {
            int index = this.importedPackages.indexOf(pkgId);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = index; i < this.importedPackages.size(); ++i) {
                stringBuilder.append(this.importedPackages.get(i).toString()).append(" -> ");
            }
            stringBuilder.append(pkgId);
            this.dlog.error(importPkgNode.pos, DiagnosticCode.CYCLIC_MODULE_IMPORTS_DETECTED, stringBuilder.toString());
            return;
        }
        boolean samePkg = false;
        PackageID entryPackage = this.importedPackages.get(0);
        if (entryPackage.isUnnamed == pkgId.isUnnamed) {
            boolean bl = samePkg = !entryPackage.isUnnamed || entryPackage.sourceFileName.equals(pkgId.sourceFileName);
        }
        if (samePkg && entryPackage.orgName.equals(pkgId.orgName) && entryPackage.name.equals(pkgId.name)) {
            StringBuilder stringBuilder = new StringBuilder();
            String entryPackageString = this.importedPackages.get(0).toString();
            int packageIndex = entryPackageString.indexOf(":");
            if (packageIndex != -1) {
                entryPackageString = entryPackageString.substring(0, packageIndex);
            }
            stringBuilder.append(entryPackageString).append(" -> ");
            for (int i = 1; i < this.importedPackages.size(); ++i) {
                stringBuilder.append(this.importedPackages.get(i).toString()).append(" -> ");
            }
            stringBuilder.append(pkgId);
            this.dlog.error(importPkgNode.pos, DiagnosticCode.CYCLIC_MODULE_IMPORTS_DETECTED, stringBuilder.toString());
            return;
        }
        BPackageSymbol pkgSymbol = this.pkgLoader.loadPackageSymbol(pkgId, enclPackageID, this.env.enclPkg.repos);
        if (pkgSymbol == null) {
            this.dlog.error(importPkgNode.pos, DiagnosticCode.MODULE_NOT_FOUND, importPkgNode.getQualifiedPackageName());
            return;
        }
        List<BPackageSymbol> imports = ((BPackageSymbol)this.env.scope.owner).imports;
        if (!imports.contains(pkgSymbol)) {
            imports.add(pkgSymbol);
        }
        BPackageSymbol symbol = this.duplicatePackagSymbol(pkgSymbol);
        symbol.compUnit = this.names.fromIdNode(importPkgNode.compUnit);
        symbol.scope = pkgSymbol.scope;
        importPkgNode.symbol = symbol;
        this.env.scope.define(pkgAlias, symbol);
    }

    @Override
    public void visit(BLangXMLNS xmlnsNode) {
        String nsURI = (String)((BLangLiteral)xmlnsNode.namespaceURI).value;
        if (!this.nullOrEmpty(xmlnsNode.prefix.value) && nsURI.isEmpty()) {
            this.dlog.error(xmlnsNode.pos, DiagnosticCode.INVALID_NAMESPACE_DECLARATION, xmlnsNode.prefix);
        }
        if (xmlnsNode.prefix.value == null) {
            xmlnsNode.prefix.value = "";
        }
        BXMLNSSymbol xmlnsSymbol = Symbols.createXMLNSSymbol(this.names.fromIdNode(xmlnsNode.prefix), nsURI, this.env.enclPkg.symbol.pkgID, this.env.scope.owner);
        xmlnsNode.symbol = xmlnsSymbol;
        BSymbol foundSym = this.symResolver.lookupSymbolInPrefixSpace(this.env, xmlnsSymbol.name);
        if ((foundSym.tag & 0x1001) != 4097) {
            foundSym = this.symTable.notFoundSymbol;
        }
        if (foundSym != this.symTable.notFoundSymbol) {
            this.dlog.error(xmlnsNode.pos, DiagnosticCode.REDECLARED_SYMBOL, xmlnsSymbol.name);
            return;
        }
        this.defineSymbol(xmlnsNode.prefix.pos, xmlnsSymbol);
    }

    private boolean nullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    @Override
    public void visit(BLangXMLNSStatement xmlnsStmtNode) {
        this.defineNode(xmlnsStmtNode.xmlnsDecl, this.env);
    }

    private void defineTypeNodes(List<? extends TypeDefinition> typeDefs, SymbolEnv env) {
        if (typeDefs.size() == 0) {
            return;
        }
        this.unresolvedTypes = new ArrayList<TypeDefinition>();
        for (TypeDefinition typeDefinition : typeDefs) {
            this.defineNode((BLangNode)((Object)typeDefinition), env);
        }
        if (typeDefs.size() <= this.unresolvedTypes.size()) {
            LinkedList<LocationData> unknownTypes = new LinkedList<LocationData>();
            for (TypeDefinition unresolvedType : this.unresolvedTypes) {
                LinkedList<String> references = new LinkedList<String>();
                references.add(unresolvedType.getName().getValue());
                this.checkErrors(unresolvedType, (BLangType)unresolvedType.getTypeNode(), references, unknownTypes);
            }
            this.unresolvedTypes.forEach(type -> this.defineNode((BLangNode)((Object)type), env));
            return;
        }
        this.defineTypeNodes(this.unresolvedTypes, env);
    }

    private void checkErrors(TypeDefinition unresolvedType, BLangType currentTypeNode, List<String> visitedNodes, List<LocationData> encounteredUnknownTypes) {
        String unresolvedTypeNodeName = unresolvedType.getName().getValue();
        switch (currentTypeNode.getKind()) {
            case ARRAY_TYPE: {
                this.checkErrors(unresolvedType, ((BLangArrayType)currentTypeNode).elemtype, visitedNodes, encounteredUnknownTypes);
                break;
            }
            case UNION_TYPE_NODE: {
                List<BLangType> memberTypeNodes = ((BLangUnionTypeNode)currentTypeNode).memberTypeNodes;
                for (BLangType memberTypeNode : memberTypeNodes) {
                    this.checkErrors(unresolvedType, memberTypeNode, visitedNodes, encounteredUnknownTypes);
                }
                break;
            }
            case TUPLE_TYPE_NODE: {
                List<BLangType> memberTypeNodes = ((BLangTupleTypeNode)currentTypeNode).memberTypeNodes;
                for (BLangType memberTypeNode : memberTypeNodes) {
                    this.checkErrors(unresolvedType, memberTypeNode, visitedNodes, encounteredUnknownTypes);
                }
                break;
            }
            case CONSTRAINED_TYPE: {
                this.checkErrors(unresolvedType, ((BLangConstrainedType)currentTypeNode).constraint, visitedNodes, encounteredUnknownTypes);
                break;
            }
            case USER_DEFINED_TYPE: {
                String currentTypeNodeName = ((BLangUserDefinedType)currentTypeNode).typeName.value;
                if (currentTypeNodeName.startsWith("$")) {
                    return;
                }
                if (unresolvedTypeNodeName.equals(currentTypeNodeName)) {
                    visitedNodes.add(currentTypeNodeName);
                    this.dlog.error((DiagnosticPos)unresolvedType.getPosition(), DiagnosticCode.CYCLIC_TYPE_REFERENCE, visitedNodes);
                    visitedNodes.remove(visitedNodes.lastIndexOf(currentTypeNodeName));
                    break;
                }
                if (visitedNodes.contains(currentTypeNodeName)) {
                    LinkedList<String> dependencyList = new LinkedList<String>();
                    for (int i = visitedNodes.indexOf(currentTypeNodeName); i < visitedNodes.size(); ++i) {
                        dependencyList.add(visitedNodes.get(i));
                    }
                    dependencyList.add(currentTypeNodeName);
                    this.dlog.error((DiagnosticPos)unresolvedType.getPosition(), DiagnosticCode.CYCLIC_TYPE_REFERENCE, dependencyList);
                    break;
                }
                List typeDefinitions = this.unresolvedTypes.stream().filter(typeDefinition -> typeDefinition.getName().getValue().equals(currentTypeNodeName)).collect(Collectors.toList());
                if (typeDefinitions.isEmpty()) {
                    LocationData locationData = new LocationData(currentTypeNodeName, currentTypeNode.pos.sLine, currentTypeNode.pos.sCol);
                    if (encounteredUnknownTypes.contains(locationData)) break;
                    this.dlog.error(currentTypeNode.pos, DiagnosticCode.UNKNOWN_TYPE, currentTypeNodeName);
                    encounteredUnknownTypes.add(locationData);
                    break;
                }
                for (TypeDefinition typeDefinition2 : typeDefinitions) {
                    String typeName = typeDefinition2.getName().getValue();
                    visitedNodes.add(typeName);
                    this.checkErrors(unresolvedType, (BLangType)typeDefinition2.getTypeNode(), visitedNodes, encounteredUnknownTypes);
                    visitedNodes.remove(visitedNodes.lastIndexOf(typeName));
                }
                break;
            }
            case BUILT_IN_REF_TYPE: 
            case FINITE_TYPE_NODE: 
            case FUNCTION_TYPE: 
            case VALUE_TYPE: 
            case RECORD_TYPE: 
            case OBJECT_TYPE: 
            case ERROR_TYPE: {
                break;
            }
            default: {
                throw new RuntimeException("unhandled type kind: " + (Object)((Object)currentTypeNode.getKind()));
            }
        }
    }

    @Override
    public void visit(BLangTypeDefinition typeDefinition) {
        BType definedType = this.symResolver.resolveTypeNode(typeDefinition.typeNode, this.env);
        if (definedType == this.symTable.semanticError) {
            return;
        }
        if (definedType == this.symTable.noType) {
            if (!this.unresolvedTypes.contains(typeDefinition)) {
                this.unresolvedTypes.add(typeDefinition);
            }
            return;
        }
        if (typeDefinition.typeNode.getKind() == NodeKind.OBJECT_TYPE || typeDefinition.typeNode.getKind() == NodeKind.RECORD_TYPE) {
            BLangStructureTypeNode structureTypeNode = (BLangStructureTypeNode)typeDefinition.typeNode;
            for (BLangType typeRef : structureTypeNode.typeRefs) {
                BType referencedType = this.symResolver.resolveTypeNode(typeRef, this.env);
                if (referencedType != this.symTable.noType || this.unresolvedTypes.contains(typeDefinition)) continue;
                this.unresolvedTypes.add(typeDefinition);
                return;
            }
        }
        if (typeDefinition.typeNode.getKind() == NodeKind.FUNCTION_TYPE && definedType.tsymbol == null) {
            definedType.tsymbol = Symbols.createTypeSymbol(33554460, Flags.asMask(typeDefinition.flagSet), Names.EMPTY, this.env.enclPkg.symbol.pkgID, definedType, this.env.scope.owner);
        }
        typeDefinition.precedence = this.typePrecedence++;
        BTypeSymbol typeDefSymbol = definedType.tsymbol.name != Names.EMPTY ? definedType.tsymbol.createLabelSymbol() : definedType.tsymbol;
        typeDefSymbol.markdownDocumentation = this.getMarkdownDocAttachment(typeDefinition.markdownDocumentationAttachment);
        typeDefSymbol.name = this.names.fromIdNode(typeDefinition.getName());
        typeDefSymbol.pkgID = this.env.enclPkg.packageID;
        typeDefSymbol.flags |= Flags.asMask(typeDefinition.flagSet);
        typeDefSymbol.flags &= this.getPublicFlagResetingMask(typeDefinition.flagSet, typeDefinition.typeNode);
        if (this.isDeprecated(typeDefinition.annAttachments)) {
            typeDefSymbol.flags |= 0x10;
        }
        definedType.flags = typeDefSymbol.flags;
        if (typeDefinition.annAttachments.stream().anyMatch(attachment -> attachment.annotationName.value.equals(Names.ANNOTATION_TYPE_PARAM.value))) {
            if (PackageID.isLangLibPackageID(this.env.enclPkg.packageID)) {
                typeDefSymbol.type = this.typeParamAnalyzer.createTypeParam(typeDefSymbol.type, typeDefSymbol.name);
                typeDefSymbol.flags |= 0x400000;
                if (typeDefinition.typeNode.getKind() == NodeKind.ERROR_TYPE) {
                    typeDefSymbol.isLabel = false;
                }
            } else {
                this.dlog.error(typeDefinition.pos, DiagnosticCode.TYPE_PARAM_OUTSIDE_LANG_MODULE, new Object[0]);
            }
        }
        typeDefinition.symbol = typeDefSymbol;
        boolean isLanglibModule = PackageID.isLangLibPackageID(this.env.enclPkg.packageID);
        if (isLanglibModule) {
            this.handleLangLibTypes(typeDefinition);
            return;
        }
        this.defineSymbol(typeDefinition.name.pos, typeDefSymbol);
        if (typeDefinition.typeNode.getKind() == NodeKind.ERROR_TYPE) {
            this.defineErrorConstructorSymbol(typeDefinition.name.pos, typeDefSymbol);
        }
    }

    private void handleLangLibTypes(BLangTypeDefinition typeDefinition) {
        Iterator<BLangAnnotationAttachment> iterator = typeDefinition.annAttachments.iterator();
        if (iterator.hasNext()) {
            BLangAnnotationAttachment attachment = iterator.next();
            if (attachment.annotationName.value.equals(Names.ANNOTATION_TYPE_PARAM.value)) {
                BTypeSymbol typeDefSymbol = typeDefinition.symbol;
                typeDefSymbol.type = this.typeParamAnalyzer.createTypeParam(typeDefSymbol.type, typeDefSymbol.name);
                typeDefSymbol.flags |= 0x400000;
            } else if (attachment.annotationName.value.equals(Names.ANNOTATION_BUILTIN_SUBTYPE.value)) {
                BType type = this.symTable.getLangLibSubType(typeDefinition.name.value);
                typeDefinition.symbol = type.tsymbol;
                typeDefinition.type = type;
                typeDefinition.typeNode.type = type;
                typeDefinition.isBuiltinTypeDef = true;
            } else {
                throw new IllegalStateException("Not supported annotation attachment at:" + attachment.pos);
            }
        }
        this.defineSymbol(typeDefinition.name.pos, typeDefinition.symbol);
    }

    private int getPublicFlagResetingMask(Set<Flag> flagSet, BLangType typeNode) {
        boolean isAnonType;
        boolean bl = isAnonType = typeNode instanceof BLangStructureTypeNode && ((BLangStructureTypeNode)typeNode).isAnonymous;
        if (flagSet.contains((Object)Flag.PUBLIC) || isAnonType) {
            return Integer.MAX_VALUE;
        }
        return -2;
    }

    private void defineErrorConstructorSymbol(DiagnosticPos pos, BTypeSymbol typeDefSymbol) {
        BErrorType errorType = (BErrorType)typeDefSymbol.type;
        BConstructorSymbol symbol = new BConstructorSymbol(0x4000100, typeDefSymbol.flags, typeDefSymbol.name, typeDefSymbol.pkgID, errorType, typeDefSymbol.owner);
        symbol.kind = SymbolKind.ERROR_CONSTRUCTOR;
        symbol.scope = new Scope(symbol);
        symbol.retType = errorType;
        if (this.symResolver.checkForUniqueSymbol(pos, this.env, symbol)) {
            this.env.scope.define(symbol.name, symbol);
        }
        ((BErrorTypeSymbol)typeDefSymbol).ctorSymbol = symbol;
    }

    @Override
    public void visit(BLangWorker workerNode) {
        BInvokableSymbol workerSymbol = Symbols.createWorkerSymbol(Flags.asMask(workerNode.flagSet), this.names.fromIdNode(workerNode.name), this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner);
        workerSymbol.markdownDocumentation = this.getMarkdownDocAttachment(workerNode.markdownDocumentationAttachment);
        workerNode.symbol = workerSymbol;
        this.defineSymbolWithCurrentEnvOwner(workerNode.pos, workerSymbol);
    }

    @Override
    public void visit(BLangService serviceNode) {
        BServiceSymbol serviceSymbol = Symbols.createServiceSymbol(Flags.asMask(serviceNode.flagSet), this.names.fromIdNode(serviceNode.name), this.env.enclPkg.symbol.pkgID, serviceNode.type, this.env.scope.owner);
        serviceSymbol.markdownDocumentation = this.getMarkdownDocAttachment(serviceNode.markdownDocumentationAttachment);
        BType serviceObjectType = serviceNode.serviceTypeDefinition.symbol.type;
        serviceNode.symbol = serviceSymbol;
        serviceNode.symbol.type = new BServiceType(serviceObjectType.tsymbol);
        serviceSymbol.scope = new Scope(serviceSymbol);
        if (serviceNode.serviceTypeDefinition.typeNode.getKind() == NodeKind.OBJECT_TYPE) {
            BLangObjectTypeNode objectTypeNode = (BLangObjectTypeNode)serviceNode.serviceTypeDefinition.typeNode;
            objectTypeNode.functions.stream().filter(func -> func.flagSet.contains((Object)Flag.RESOURCE)).forEach(func -> serviceNode.resourceFunctions.add((BLangFunction)func));
        }
    }

    @Override
    public void visit(BLangFunction funcNode) {
        boolean validAttachedFunc = this.validateFuncReceiver(funcNode);
        boolean remoteFlagSetOnNode = Symbols.isFlagOn(Flags.asMask(funcNode.flagSet), 65536);
        if (!funcNode.attachedFunction && Symbols.isFlagOn(Flags.asMask(funcNode.flagSet), 1024)) {
            this.dlog.error(funcNode.pos, DiagnosticCode.PRIVATE_FUNCTION_VISIBILITY, funcNode.name);
        }
        if (funcNode.receiver == null && !funcNode.attachedFunction && remoteFlagSetOnNode) {
            this.dlog.error(funcNode.pos, DiagnosticCode.REMOTE_IN_NON_OBJECT_FUNCTION, funcNode.name.value);
        }
        if (PackageID.isLangLibPackageID(this.env.enclPkg.symbol.pkgID)) {
            funcNode.flagSet.add(Flag.LANG_LIB);
        }
        BInvokableSymbol funcSymbol = Symbols.createFunctionSymbol(Flags.asMask(funcNode.flagSet), this.getFuncSymbolName(funcNode), this.env.enclPkg.symbol.pkgID, null, this.env.scope.owner, funcNode.hasBody());
        funcSymbol.markdownDocumentation = this.getMarkdownDocAttachment(funcNode.markdownDocumentationAttachment);
        SymbolEnv invokableEnv = SymbolEnv.createFunctionEnv(funcNode, funcSymbol.scope, this.env);
        this.defineInvokableSymbol(funcNode, funcSymbol, invokableEnv);
        if (this.isDeprecated(funcNode.annAttachments)) {
            funcSymbol.flags |= 0x10;
        }
        if (funcNode.receiver != null) {
            this.defineAttachedFunctions(funcNode, funcSymbol, invokableEnv, validAttachedFunc);
        }
    }

    private boolean isDeprecated(List<BLangAnnotationAttachment> annAttachments) {
        for (BLangAnnotationAttachment annotationAttachment : annAttachments) {
            if (!annotationAttachment.annotationName.getValue().equals(DEPRECATION_ANNOTATION)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visit(BLangResource resourceNode) {
    }

    @Override
    public void visit(BLangConstant constant) {
        BConstantSymbol constantSymbol;
        BType staticType;
        if (constant.typeNode != null) {
            staticType = this.symResolver.resolveTypeNode(constant.typeNode, this.env);
            if (staticType == this.symTable.noType) {
                constant.symbol = this.getConstantSymbol(constant);
                if (!this.unresolvedTypes.contains(constant)) {
                    this.unresolvedTypes.add(constant);
                }
                return;
            }
        } else {
            staticType = this.symTable.semanticError;
        }
        constant.symbol = constantSymbol = this.getConstantSymbol(constant);
        NodeKind nodeKind = constant.expr.getKind();
        if (nodeKind == NodeKind.LITERAL || nodeKind == NodeKind.NUMERIC_LITERAL) {
            if (constant.typeNode != null) {
                if (this.types.isValidLiteral((BLangLiteral)constant.expr, staticType)) {
                    BLangFiniteTypeNode finiteType = (BLangFiniteTypeNode)constant.associatedTypeDefinition.typeNode;
                    BLangExpression valueSpaceExpr = finiteType.valueSpace.iterator().next();
                    valueSpaceExpr.type = staticType;
                    this.defineNode(constant.associatedTypeDefinition, this.env);
                    constantSymbol.type = constant.associatedTypeDefinition.symbol.type;
                    constantSymbol.literalType = staticType;
                } else {
                    this.defineNode(constant.associatedTypeDefinition, this.env);
                    constantSymbol.type = staticType;
                    constantSymbol.literalType = constant.expr.type;
                }
            } else {
                this.defineNode(constant.associatedTypeDefinition, this.env);
                constantSymbol.type = constant.associatedTypeDefinition.symbol.type;
                constantSymbol.literalType = constant.expr.type;
            }
        } else if (constant.typeNode != null) {
            constantSymbol.type = constantSymbol.literalType = staticType;
        }
        constantSymbol.markdownDocumentation = this.getMarkdownDocAttachment(constant.markdownDocumentationAttachment);
        if (this.isDeprecated(constant.annAttachments)) {
            constantSymbol.flags |= 0x10;
        }
        if (!this.symResolver.checkForUniqueSymbol(constant.name.pos, this.env, constantSymbol)) {
            return;
        }
        if (constant.symbol.name == Names.IGNORE) {
            return;
        }
        this.env.scope.define(constantSymbol.name, constantSymbol);
    }

    private BConstantSymbol getConstantSymbol(BLangConstant constant) {
        Name name = this.names.fromIdNode(constant.name);
        PackageID pkgID = this.env.enclPkg.symbol.pkgID;
        return new BConstantSymbol(Flags.asMask(constant.flagSet), name, pkgID, this.symTable.semanticError, this.symTable.noType, this.env.scope.owner);
    }

    @Override
    public void visit(BLangSimpleVariable varNode) {
        Name varName;
        if (varNode.type == null) {
            varNode.type = varNode.typeNode != null ? this.symResolver.resolveTypeNode(varNode.typeNode, this.env) : this.symTable.noType;
        }
        if ((varName = this.names.fromIdNode(varNode.name)) == Names.EMPTY || varName == Names.IGNORE) {
            return;
        }
        BVarSymbol varSymbol = this.defineVarSymbol(varNode.name.pos, varNode.flagSet, varNode.type, varName, this.env);
        if (this.isDeprecated(varNode.annAttachments)) {
            varSymbol.flags |= 0x10;
        }
        varSymbol.markdownDocumentation = this.getMarkdownDocAttachment(varNode.markdownDocumentationAttachment);
        varNode.symbol = varSymbol;
        if (varNode.symbol.type.tsymbol != null && Symbols.isFlagOn(varNode.symbol.type.tsymbol.flags, 131072)) {
            varSymbol.tag = 32820;
        }
        if (varSymbol.type.tag == 30 && ((BFutureType)varSymbol.type).workerDerivative) {
            Iterator lambdaFunctions = this.env.enclPkg.lambdaFunctions.iterator();
            while (lambdaFunctions.hasNext()) {
                BLangLambdaFunction lambdaFunction = (BLangLambdaFunction)lambdaFunctions.next();
                BLangInvokableNode enclInvokable = lambdaFunction.capturedClosureEnv.enclInvokable;
                if (!lambdaFunctions.hasNext() || enclInvokable == null || varSymbol.owner != enclInvokable.symbol) continue;
                lambdaFunction.capturedClosureEnv.scope.define(varSymbol.name, varSymbol);
            }
        }
        if (varSymbol.type.tag == 16) {
            BInvokableSymbol symbol = (BInvokableSymbol)varSymbol;
            BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)symbol.type.tsymbol;
            symbol.params = tsymbol.params;
            symbol.restParam = tsymbol.restParam;
            symbol.retType = tsymbol.returnType;
        }
    }

    @Override
    public void visit(BLangTupleVariable varNode) {
        if (varNode.type == null) {
            varNode.type = this.symResolver.resolveTypeNode(varNode.typeNode, this.env);
        }
    }

    @Override
    public void visit(BLangRecordVariable varNode) {
        if (varNode.type == null) {
            varNode.type = this.symResolver.resolveTypeNode(varNode.typeNode, this.env);
        }
    }

    @Override
    public void visit(BLangErrorVariable varNode) {
        if (varNode.type == null) {
            varNode.type = this.symResolver.resolveTypeNode(varNode.typeNode, this.env);
        }
    }

    @Override
    public void visit(BLangEndpoint endpoint) {
    }

    @Override
    public void visit(BLangXMLAttribute bLangXMLAttribute) {
        BXMLNSSymbol xmlnsSymbol;
        String symbolName;
        if (bLangXMLAttribute.name.getKind() != NodeKind.XML_QNAME) {
            return;
        }
        BLangXMLQName qname = (BLangXMLQName)bLangXMLAttribute.name;
        if (!bLangXMLAttribute.isNamespaceDeclr) {
            BXMLAttributeSymbol attrSymbol = new BXMLAttributeSymbol(qname.localname.value, qname.namespaceURI, this.env.enclPkg.symbol.pkgID, this.env.scope.owner);
            if (this.symResolver.checkForUniqueMemberSymbol(bLangXMLAttribute.pos, this.env, attrSymbol)) {
                this.env.scope.define(attrSymbol.name, attrSymbol);
                bLangXMLAttribute.symbol = attrSymbol;
            }
            return;
        }
        List<BLangExpression> exprs = bLangXMLAttribute.value.textFragments;
        String nsURI = null;
        NodeKind nodeKind = exprs.get(0).getKind();
        if (exprs.size() == 1 && (nodeKind == NodeKind.LITERAL || nodeKind == NodeKind.NUMERIC_LITERAL)) {
            nsURI = (String)((BLangLiteral)exprs.get((int)0)).value;
        }
        if ((symbolName = qname.localname.value).equals("xmlns")) {
            symbolName = "";
        }
        if (this.symResolver.checkForUniqueMemberSymbol(bLangXMLAttribute.pos, this.env, xmlnsSymbol = new BXMLNSSymbol(this.names.fromString(symbolName), nsURI, this.env.enclPkg.symbol.pkgID, this.env.scope.owner))) {
            this.env.scope.define(xmlnsSymbol.name, xmlnsSymbol);
            bLangXMLAttribute.symbol = xmlnsSymbol;
        }
    }

    @Override
    public void visit(BLangRecordTypeNode recordTypeNode) {
        SymbolEnv typeDefEnv = SymbolEnv.createTypeEnv(recordTypeNode, recordTypeNode.symbol.scope, this.env);
        this.defineRecordTypeNode(recordTypeNode, typeDefEnv);
    }

    private void defineRecordTypeNode(BLangRecordTypeNode recordTypeNode, SymbolEnv env) {
        BRecordType recordType = (BRecordType)recordTypeNode.symbol.type;
        recordTypeNode.type = recordType;
        this.resolveReferencedFields(recordTypeNode, env);
        recordType.fields = Stream.concat(recordTypeNode.fields.stream(), recordTypeNode.referencedFields.stream()).peek(field -> this.defineNode((BLangNode)field, env)).filter(field -> field.symbol.type != this.symTable.semanticError).map(field -> new BField(this.names.fromIdNode(field.name), field.pos, field.symbol)).collect(Collectors.toList());
        recordType.sealed = recordTypeNode.sealed;
        if (recordTypeNode.sealed && recordTypeNode.restFieldType != null) {
            this.dlog.error(recordTypeNode.restFieldType.pos, DiagnosticCode.REST_FIELD_NOT_ALLOWED_IN_SEALED_RECORDS, new Object[0]);
            return;
        }
        if (recordTypeNode.restFieldType == null) {
            if (recordTypeNode.sealed) {
                recordType.restFieldType = this.symTable.noType;
                return;
            }
            recordType.restFieldType = this.symTable.anydataType;
            return;
        }
        recordType.restFieldType = this.symResolver.resolveTypeNode(recordTypeNode.restFieldType, env);
    }

    private void populateLangLibInSymTable(BPackageSymbol packageSymbol) {
        PackageID langLib = packageSymbol.pkgID;
        if (langLib.equals(PackageID.ARRAY)) {
            this.symTable.langArrayModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.DECIMAL)) {
            this.symTable.langDecimalModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.ERROR)) {
            this.symTable.langErrorModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.FLOAT)) {
            this.symTable.langFloatModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.FUTURE)) {
            this.symTable.langFutureModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.INT)) {
            this.symTable.langIntModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.MAP)) {
            this.symTable.langMapModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.OBJECT)) {
            this.symTable.langObjectModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.STREAM)) {
            this.symTable.langStreamModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.STRING)) {
            this.symTable.langStringModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.TABLE)) {
            this.symTable.langTableModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.TYPEDESC)) {
            this.symTable.langTypedescModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.VALUE)) {
            this.symTable.langValueModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.XML)) {
            this.symTable.langXmlModuleSymbol = packageSymbol;
            return;
        }
        if (langLib.equals(PackageID.BOOLEAN)) {
            this.symTable.langBooleanModuleSymbol = packageSymbol;
            return;
        }
    }

    private boolean isValidAnnotationType(BType type) {
        if (type == this.symTable.semanticError) {
            return false;
        }
        switch (type.tag) {
            case 12: 
            case 15: {
                return true;
            }
            case 19: {
                BType elementType = ((BArrayType)type).eType;
                return (elementType.tag == 15 || elementType.tag == 12) && this.isValidAnnotationType(elementType);
            }
        }
        return this.types.isAssignable(type, this.symTable.trueType);
    }

    private void populatePackageNode(BLangPackage pkgNode) {
        List<BLangCompilationUnit> compUnits = pkgNode.getCompilationUnits();
        compUnits.forEach(compUnit -> this.populateCompilationUnit(pkgNode, (BLangCompilationUnit)compUnit));
    }

    private void populatePackageNode(BLangTestablePackage pkgNode, List<BLangImportPackage> enclPkgImports) {
        this.populatePackageNode(pkgNode);
    }

    private void populateCompilationUnit(BLangPackage pkgNode, BLangCompilationUnit compUnit) {
        compUnit.getTopLevelNodes().forEach(node -> this.addTopLevelNode(pkgNode, (TopLevelNode)node));
    }

    private void addTopLevelNode(BLangPackage pkgNode, TopLevelNode node) {
        NodeKind kind = node.getKind();
        if (kind != NodeKind.PACKAGE_DECLARATION && kind != NodeKind.IMPORT) {
            pkgNode.topLevelNodes.add(node);
        }
        switch (kind) {
            case IMPORT: {
                pkgNode.imports.add((BLangImportPackage)node);
                break;
            }
            case FUNCTION: {
                pkgNode.functions.add((BLangFunction)node);
                break;
            }
            case TYPE_DEFINITION: {
                pkgNode.typeDefinitions.add((BLangTypeDefinition)node);
                break;
            }
            case SERVICE: {
                pkgNode.services.add((BLangService)node);
                break;
            }
            case VARIABLE: {
                pkgNode.globalVars.add((BLangSimpleVariable)node);
                break;
            }
            case ANNOTATION: {
                pkgNode.annotations.add((BLangAnnotation)node);
                break;
            }
            case XMLNS: {
                pkgNode.xmlnsList.add((BLangXMLNS)node);
                break;
            }
            case CONSTANT: {
                pkgNode.constants.add((BLangConstant)node);
            }
        }
    }

    private void defineErrorDetails(List<BLangTypeDefinition> typeDefNodes, SymbolEnv pkgEnv) {
        for (BLangTypeDefinition typeDef : typeDefNodes) {
            if (typeDef.typeNode.getKind() != NodeKind.ERROR_TYPE) continue;
            BLangErrorType errorTypeNode = (BLangErrorType)typeDef.typeNode;
            SymbolEnv typeDefEnv = SymbolEnv.createTypeEnv(errorTypeNode, typeDef.symbol.scope, pkgEnv);
            BType reasonType = Optional.ofNullable(errorTypeNode.reasonType).map(bLangType -> this.symResolver.resolveTypeNode((BLangType)bLangType, typeDefEnv)).orElse(this.symTable.stringType);
            BType detailType = Optional.ofNullable(errorTypeNode.detailType).map(bLangType -> this.symResolver.resolveTypeNode((BLangType)bLangType, typeDefEnv)).orElse(this.symTable.detailType);
            if (reasonType == this.symTable.stringType && detailType == this.symTable.detailType) {
                typeDef.symbol.type = this.symTable.errorType;
                continue;
            }
            BErrorType errorType = (BErrorType)typeDef.symbol.type;
            errorType.reasonType = reasonType;
            errorType.detailType = detailType;
        }
    }

    private void defineFields(List<BLangTypeDefinition> typeDefNodes, SymbolEnv pkgEnv) {
        for (BLangTypeDefinition typeDef : typeDefNodes) {
            NodeKind nodeKind = typeDef.typeNode.getKind();
            if (nodeKind != NodeKind.OBJECT_TYPE && nodeKind != NodeKind.RECORD_TYPE) continue;
            BStructureType structureType = (BStructureType)typeDef.symbol.type;
            BLangStructureTypeNode structureTypeNode = (BLangStructureTypeNode)typeDef.typeNode;
            SymbolEnv typeDefEnv = SymbolEnv.createTypeEnv(structureTypeNode, typeDef.symbol.scope, pkgEnv);
            this.resolveReferencedFields(structureTypeNode, typeDefEnv);
            structureType.fields = Stream.concat(structureTypeNode.fields.stream(), structureTypeNode.referencedFields.stream()).peek(field -> this.defineNode((BLangNode)field, typeDefEnv)).filter(field -> field.symbol.type != this.symTable.semanticError).map(field -> new BField(this.names.fromIdNode(field.name), field.pos, field.symbol)).collect(Collectors.toList());
            if (typeDef.symbol.kind != SymbolKind.RECORD) continue;
            BLangRecordTypeNode recordTypeNode = (BLangRecordTypeNode)structureTypeNode;
            BRecordType recordType = (BRecordType)structureType;
            recordType.sealed = recordTypeNode.sealed;
            if (recordTypeNode.sealed && recordTypeNode.restFieldType != null) {
                this.dlog.error(recordTypeNode.restFieldType.pos, DiagnosticCode.REST_FIELD_NOT_ALLOWED_IN_SEALED_RECORDS, new Object[0]);
                continue;
            }
            if (recordTypeNode.restFieldType == null) {
                if (recordTypeNode.sealed) {
                    recordType.restFieldType = this.symTable.noType;
                    continue;
                }
                recordType.restFieldType = this.symTable.anydataType;
                continue;
            }
            recordType.restFieldType = this.symResolver.resolveTypeNode(recordTypeNode.restFieldType, typeDefEnv);
        }
    }

    private void defineMembers(List<BLangTypeDefinition> typeDefNodes, SymbolEnv pkgEnv) {
        for (BLangTypeDefinition typeDef : typeDefNodes) {
            if (typeDef.typeNode.getKind() == NodeKind.USER_DEFINED_TYPE || typeDef.typeNode.getKind() != NodeKind.OBJECT_TYPE) continue;
            BLangObjectTypeNode objTypeNode = (BLangObjectTypeNode)typeDef.typeNode;
            SymbolEnv objMethodsEnv = SymbolEnv.createObjectMethodsEnv(objTypeNode, (BObjectTypeSymbol)objTypeNode.symbol, pkgEnv);
            this.defineObjectInitFunction(objTypeNode, objMethodsEnv);
            objTypeNode.functions.forEach(f -> {
                f.setReceiver(ASTBuilderUtil.createReceiver(typeDef.pos, typeDef.symbol.type));
                this.defineNode((BLangNode)f, objMethodsEnv);
            });
            ArrayList<String> referencedFunctions = new ArrayList<String>();
            for (BLangType typeRef : objTypeNode.typeRefs) {
                if (typeRef.type.tsymbol == null || typeRef.type.tsymbol.kind != SymbolKind.OBJECT) continue;
                List functions = ((BObjectTypeSymbol)typeRef.type.tsymbol).attachedFuncs;
                for (BAttachedFunction function : functions) {
                    this.defineReferencedFunction(typeDef, objMethodsEnv, typeRef, function, referencedFunctions);
                }
            }
        }
    }

    private void defineInvokableSymbol(BLangInvokableNode invokableNode, BInvokableSymbol funcSymbol, SymbolEnv invokableEnv) {
        invokableNode.symbol = funcSymbol;
        this.defineSymbol(invokableNode.name.pos, funcSymbol);
        invokableEnv.scope = funcSymbol.scope;
        this.defineInvokableSymbolParams(invokableNode, funcSymbol, invokableEnv);
    }

    private void defineInvokableSymbolParams(BLangInvokableNode invokableNode, BInvokableSymbol invokableSymbol, SymbolEnv invokableEnv) {
        boolean foundDefaultableParam = false;
        ArrayList<BVarSymbol> paramSymbols = new ArrayList<BVarSymbol>();
        invokableNode.clonedEnv = invokableEnv.shallowClone();
        for (BLangSimpleVariable varNode : invokableNode.requiredParams) {
            this.defineNode(varNode, invokableEnv);
            if (varNode.expr != null) {
                foundDefaultableParam = true;
            }
            if (varNode.expr == null && foundDefaultableParam) {
                this.dlog.error(varNode.pos, DiagnosticCode.REQUIRED_PARAM_DEFINED_AFTER_DEFAULTABLE_PARAM, new Object[0]);
            }
            BVarSymbol symbol = varNode.symbol;
            if (varNode.flagSet.contains((Object)Flag.PUBLIC)) {
                symbol.flags |= 1;
            }
            if (varNode.expr != null) {
                symbol.flags |= 0x2000;
                symbol.defaultableParam = true;
            }
            paramSymbols.add(symbol);
        }
        if (!invokableNode.desugaredReturnType) {
            this.symResolver.resolveTypeNode(invokableNode.returnTypeNode, invokableEnv);
        }
        invokableSymbol.params = paramSymbols;
        invokableSymbol.retType = invokableNode.returnTypeNode.type;
        List<BType> paramTypes = paramSymbols.stream().map(paramSym -> paramSym.type).collect(Collectors.toList());
        BInvokableTypeSymbol functionTypeSymbol = Symbols.createInvokableTypeSymbol(33554460, invokableSymbol.flags, this.env.enclPkg.symbol.pkgID, invokableSymbol.type, this.env.scope.owner);
        functionTypeSymbol.params = invokableSymbol.params;
        functionTypeSymbol.returnType = invokableSymbol.retType;
        BType restType = null;
        if (invokableNode.restParam != null) {
            this.defineNode(invokableNode.restParam, invokableEnv);
            functionTypeSymbol.restParam = invokableSymbol.restParam = invokableNode.restParam.symbol;
            restType = invokableSymbol.restParam.type;
        }
        invokableSymbol.type = new BInvokableType(paramTypes, restType, invokableNode.returnTypeNode.type, null);
        invokableSymbol.type.tsymbol = functionTypeSymbol;
    }

    private void defineSymbol(DiagnosticPos pos, BSymbol symbol) {
        symbol.scope = new Scope(symbol);
        if (this.symResolver.checkForUniqueSymbol(pos, this.env, symbol)) {
            this.env.scope.define(symbol.name, symbol);
        }
    }

    public void defineSymbol(DiagnosticPos pos, BSymbol symbol, SymbolEnv env) {
        symbol.scope = new Scope(symbol);
        if (this.symResolver.checkForUniqueSymbol(pos, env, symbol)) {
            env.scope.define(symbol.name, symbol);
        }
    }

    public void defineShadowedSymbol(DiagnosticPos pos, BSymbol symbol, SymbolEnv env) {
        symbol.scope = new Scope(symbol);
        if (this.symResolver.checkForUniqueSymbolInCurrentScope(pos, env, symbol, symbol.tag)) {
            env.scope.define(symbol.name, symbol);
        }
    }

    public void defineTypeNarrowedSymbol(DiagnosticPos pos, SymbolEnv targetEnv, BVarSymbol symbol, BType type) {
        if (symbol.owner.tag == 4097) {
            return;
        }
        BVarSymbol varSymbol = this.createVarSymbol(symbol.flags, type, symbol.name, targetEnv);
        if (type.tag == 16 && type.tsymbol != null) {
            BInvokableTypeSymbol tsymbol = (BInvokableTypeSymbol)type.tsymbol;
            BInvokableSymbol invokableSymbol = (BInvokableSymbol)varSymbol;
            invokableSymbol.params = tsymbol.params;
            invokableSymbol.restParam = tsymbol.restParam;
            invokableSymbol.retType = tsymbol.returnType;
            invokableSymbol.flags = tsymbol.flags;
        }
        varSymbol.owner = symbol.owner;
        varSymbol.originalSymbol = symbol;
        this.defineShadowedSymbol(pos, varSymbol, targetEnv);
    }

    private void defineSymbolWithCurrentEnvOwner(DiagnosticPos pos, BSymbol symbol) {
        symbol.scope = new Scope(this.env.scope.owner);
        if (this.symResolver.checkForUniqueSymbol(pos, this.env, symbol)) {
            this.env.scope.define(symbol.name, symbol);
        }
    }

    public BVarSymbol defineVarSymbol(DiagnosticPos pos, Set<Flag> flagSet, BType varType, Name varName, SymbolEnv env) {
        Scope enclScope = env.scope;
        BVarSymbol varSymbol = this.createVarSymbol(flagSet, varType, varName, env);
        if (!this.symResolver.checkForUniqueSymbol(pos, env, varSymbol)) {
            varSymbol.type = this.symTable.semanticError;
        }
        enclScope.define(varSymbol.name, varSymbol);
        return varSymbol;
    }

    public void defineExistingVarSymbolInEnv(BVarSymbol varSymbol, SymbolEnv env) {
        if (!this.symResolver.checkForUniqueSymbol(env, varSymbol)) {
            varSymbol.type = this.symTable.semanticError;
        }
        env.scope.define(varSymbol.name, varSymbol);
    }

    public BVarSymbol createVarSymbol(Set<Flag> flagSet, BType varType, Name varName, SymbolEnv env) {
        return this.createVarSymbol(Flags.asMask(flagSet), varType, varName, env);
    }

    public BVarSymbol createVarSymbol(int flags, BType varType, Name varName, SymbolEnv env) {
        BVarSymbol varSymbol;
        BType safeType = this.types.getSafeType(varType, true, false);
        if (safeType.tag == 16) {
            varSymbol = new BInvokableSymbol(52, flags, varName, env.enclPkg.symbol.pkgID, varType, env.scope.owner);
            varSymbol.kind = SymbolKind.FUNCTION;
        } else {
            varSymbol = new BVarSymbol(flags, varName, env.enclPkg.symbol.pkgID, varType, env.scope.owner);
            if (varType.tsymbol != null && Symbols.isFlagOn(varType.tsymbol.flags, 131072)) {
                varSymbol.tag = 32820;
            }
        }
        return varSymbol;
    }

    private void defineObjectInitFunction(BLangObjectTypeNode object, SymbolEnv conEnv) {
        BLangFunction initFunction = object.initFunction;
        if (initFunction == null) {
            return;
        }
        initFunction.receiver = ASTBuilderUtil.createReceiver(object.pos, object.type);
        initFunction.attachedFunction = true;
        initFunction.flagSet.add(Flag.ATTACHED);
        this.defineNode(initFunction, conEnv);
    }

    private void defineAttachedFunctions(BLangFunction funcNode, BInvokableSymbol funcSymbol, SymbolEnv invokableEnv, boolean isValidAttachedFunc) {
        BTypeSymbol typeSymbol = funcNode.receiver.type.tsymbol;
        if (isValidAttachedFunc) {
            if (typeSymbol.tag == 196700) {
                this.validateFunctionsAttachedToObject(funcNode, funcSymbol);
            } else if (typeSymbol.tag == 327772) {
                this.validateFunctionsAttachedToRecords(funcNode, funcSymbol);
            }
        }
        this.defineNode(funcNode.receiver, invokableEnv);
        funcSymbol.receiverSymbol = funcNode.receiver.symbol;
    }

    private void validateFunctionsAttachedToRecords(BLangFunction funcNode, BInvokableSymbol funcSymbol) {
        BInvokableType funcType = (BInvokableType)funcSymbol.type;
        BRecordTypeSymbol recordSymbol = (BRecordTypeSymbol)funcNode.receiver.type.tsymbol;
        recordSymbol.initializerFunc = new BAttachedFunction(this.names.fromIdNode(funcNode.name), funcSymbol, funcType);
    }

    private void validateFunctionsAttachedToObject(BLangFunction funcNode, BInvokableSymbol funcSymbol) {
        BInvokableType funcType = (BInvokableType)funcSymbol.type;
        BObjectTypeSymbol objectSymbol = (BObjectTypeSymbol)funcNode.receiver.type.tsymbol;
        BAttachedFunction attachedFunc = new BAttachedFunction(this.names.fromIdNode(funcNode.name), funcSymbol, funcType);
        this.validateRemoteFunctionAttachedToObject(funcNode, objectSymbol);
        this.validateResourceFunctionAttachedToObject(funcNode, objectSymbol);
        if (!funcNode.objInitFunction) {
            objectSymbol.attachedFuncs.add(attachedFunc);
            return;
        }
        this.types.validateErrorOrNilReturn(funcNode, DiagnosticCode.INVALID_OBJECT_CONSTRUCTOR);
        objectSymbol.initializerFunc = attachedFunc;
    }

    private void validateRemoteFunctionAttachedToObject(BLangFunction funcNode, BObjectTypeSymbol objectSymbol) {
        if (!Symbols.isFlagOn(Flags.asMask(funcNode.flagSet), 65536)) {
            return;
        }
        funcNode.symbol.flags |= 0x10000;
        if (!Symbols.isFlagOn(objectSymbol.flags, 131072)) {
            this.dlog.error(funcNode.pos, DiagnosticCode.REMOTE_FUNCTION_IN_NON_CLIENT_OBJECT, new Object[0]);
        }
    }

    private void validateResourceFunctionAttachedToObject(BLangFunction funcNode, BObjectTypeSymbol objectSymbol) {
        if (Symbols.isFlagOn(objectSymbol.flags, 524288) && (Symbols.isFlagOn(Flags.asMask(funcNode.flagSet), 1) || Symbols.isFlagOn(Flags.asMask(funcNode.flagSet), 1024))) {
            this.dlog.error(funcNode.pos, DiagnosticCode.SERVICE_FUNCTION_INVALID_MODIFIER, new Object[0]);
        }
        if (!Symbols.isFlagOn(Flags.asMask(funcNode.flagSet), 262144)) {
            return;
        }
        funcNode.symbol.flags |= 0x40000;
        if (!Symbols.isFlagOn(objectSymbol.flags, 524288)) {
            this.dlog.error(funcNode.pos, DiagnosticCode.RESOURCE_FUNCTION_IN_NON_SERVICE_OBJECT, new Object[0]);
        }
        this.types.validateErrorOrNilReturn(funcNode, DiagnosticCode.RESOURCE_FUNCTION_INVALID_RETURN_TYPE);
    }

    private StatementNode createAssignmentStmt(BLangSimpleVariable variable, BVarSymbol varSym, BSymbol fieldVar) {
        BLangSimpleVarRef varRef = (BLangSimpleVarRef)TreeBuilder.createSimpleVariableReferenceNode();
        varRef.pos = variable.pos;
        varRef.variableName = (BLangIdentifier)this.createIdentifier(fieldVar.name.getValue());
        varRef.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        varRef.symbol = fieldVar;
        varRef.type = fieldVar.type;
        BLangSimpleVarRef exprVar = (BLangSimpleVarRef)TreeBuilder.createSimpleVariableReferenceNode();
        exprVar.pos = variable.pos;
        exprVar.variableName = (BLangIdentifier)this.createIdentifier(varSym.name.getValue());
        exprVar.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        exprVar.symbol = varSym;
        exprVar.type = varSym.type;
        BLangAssignment assignmentStmt = (BLangAssignment)TreeBuilder.createAssignmentNode();
        assignmentStmt.expr = exprVar;
        assignmentStmt.pos = variable.pos;
        assignmentStmt.setVariable(varRef);
        return assignmentStmt;
    }

    private IdentifierNode createIdentifier(String value) {
        IdentifierNode node = TreeBuilder.createIdentifierNode();
        if (value != null) {
            node.setValue(value);
        }
        return node;
    }

    private boolean validateFuncReceiver(BLangFunction funcNode) {
        if (funcNode.receiver == null) {
            return true;
        }
        if (funcNode.receiver.type == null) {
            funcNode.receiver.type = this.symResolver.resolveTypeNode(funcNode.receiver.typeNode, this.env);
        }
        if (funcNode.receiver.type.tag == 26) {
            return true;
        }
        if (funcNode.receiver.type.tag == 32 && !this.env.enclPkg.symbol.pkgID.equals(funcNode.receiver.type.tsymbol.pkgID)) {
            this.dlog.error(funcNode.receiver.pos, DiagnosticCode.FUNC_DEFINED_ON_NON_LOCAL_TYPE, funcNode.name.value, funcNode.receiver.type.toString());
            return false;
        }
        return true;
    }

    private Name getFuncSymbolName(BLangFunction funcNode) {
        if (funcNode.receiver != null) {
            return this.names.fromString(Symbols.getAttachedFuncSymbolName(funcNode.receiver.type.tsymbol.name.value, funcNode.name.value));
        }
        return this.names.fromIdNode(funcNode.name);
    }

    private Name getFieldSymbolName(BLangSimpleVariable receiver, BLangSimpleVariable variable) {
        return this.names.fromString(Symbols.getAttachedFuncSymbolName(receiver.type.tsymbol.name.value, variable.name.value));
    }

    private MarkdownDocAttachment getMarkdownDocAttachment(BLangMarkdownDocumentation docNode) {
        if (docNode == null) {
            return new MarkdownDocAttachment();
        }
        MarkdownDocAttachment docAttachment = new MarkdownDocAttachment();
        docAttachment.description = docNode.getDocumentation();
        docNode.getParameters().forEach(p -> docAttachment.parameters.add(new MarkdownDocAttachment.Parameter(p.parameterName.value, p.getParameterDocumentation())));
        docAttachment.returnValueDescription = docNode.getReturnParameterDocumentation();
        return docAttachment;
    }

    private void createDummyTypeDefSymbol(TypeDefinition typeDefNode, SymbolEnv env) {
        if (typeDefNode.getKind() == NodeKind.CONSTANT) {
            return;
        }
        BLangTypeDefinition typeDef = (BLangTypeDefinition)typeDefNode;
        typeDef.symbol = Symbols.createTypeSymbol(65564, Flags.asMask(typeDef.flagSet), this.names.fromIdNode(typeDef.name), env.enclPkg.symbol.pkgID, typeDef.typeNode.type, env.scope.owner);
        typeDef.symbol.scope = env.scope;
        switch (typeDef.typeNode.type.tag) {
            case 12: 
            case 32: {
                typeDef.symbol.kind = ((BLangStructureTypeNode)typeDef.typeNode).symbol.kind;
                ((BLangStructureTypeNode)typeDef.typeNode).symbol.scope = env.scope;
            }
        }
        this.defineSymbol(typeDef.pos, typeDef.symbol, env);
    }

    private void resolveReferencedFields(BLangStructureTypeNode structureTypeNode, SymbolEnv typeDefEnv) {
        ArrayList referencedTypes = new ArrayList();
        ArrayList invalidTypeRefs = new ArrayList();
        structureTypeNode.referencedFields = structureTypeNode.typeRefs.stream().flatMap(typeRef -> {
            BType referredType = this.symResolver.resolveTypeNode((BLangType)typeRef, typeDefEnv);
            if (referredType == this.symTable.semanticError) {
                return Stream.empty();
            }
            if (referencedTypes.contains(referredType.tsymbol)) {
                this.dlog.error(typeRef.pos, DiagnosticCode.REDECLARED_TYPE_REFERENCE, typeRef);
                invalidTypeRefs.add(typeRef);
                return Stream.empty();
            }
            if (structureTypeNode.type.tag == 32) {
                if (referredType.tag != 32 || !Symbols.isFlagOn(referredType.tsymbol.flags, 4096)) {
                    this.dlog.error(typeRef.pos, DiagnosticCode.INCOMPATIBLE_TYPE_REFERENCE, typeRef);
                    invalidTypeRefs.add(typeRef);
                    return Stream.empty();
                }
                BObjectType objectType = (BObjectType)referredType;
                if (structureTypeNode.type.tsymbol.owner != referredType.tsymbol.owner && (objectType.fields.stream().anyMatch(field -> !Symbols.isPublic(field.symbol)) || ((BObjectTypeSymbol)objectType.tsymbol).attachedFuncs.stream().anyMatch(func -> !Symbols.isPublic(func.symbol)))) {
                    this.dlog.error(typeRef.pos, DiagnosticCode.INCOMPATIBLE_TYPE_REFERENCE_NON_PUBLIC_MEMBERS, typeRef);
                    invalidTypeRefs.add(typeRef);
                    return Stream.empty();
                }
            }
            if (structureTypeNode.type.tag == 12 && referredType.tag != 12) {
                this.dlog.error(typeRef.pos, DiagnosticCode.INCOMPATIBLE_RECORD_TYPE_REFERENCE, typeRef);
                return Stream.empty();
            }
            referencedTypes.add(referredType.tsymbol);
            return ((BStructureType)referredType).fields.stream().map(field -> {
                BLangSimpleVariable var = ASTBuilderUtil.createVariable(typeRef.pos, field.name.value, field.type);
                var.flagSet = field.symbol.getFlags();
                return var;
            });
        }).collect(Collectors.toList());
        structureTypeNode.typeRefs.removeAll(invalidTypeRefs);
    }

    private void defineReferencedFunction(BLangTypeDefinition typeDef, SymbolEnv objEnv, BLangType typeRef, BAttachedFunction referencedFunc, List<String> referencedFunctions) {
        String referencedFuncName = referencedFunc.funcName.value;
        Name funcName = this.names.fromString(Symbols.getAttachedFuncSymbolName(typeDef.symbol.name.value, referencedFuncName));
        BSymbol matchingObjFuncSym = this.symResolver.lookupSymbolInMainSpace(objEnv, funcName);
        if (matchingObjFuncSym != this.symTable.notFoundSymbol) {
            DiagnosticPos pos;
            Optional<BLangFunction> matchingFunc;
            if (referencedFunctions.contains(referencedFuncName)) {
                this.dlog.error(typeRef.pos, DiagnosticCode.REDECLARED_SYMBOL, referencedFuncName);
                return;
            }
            referencedFunctions.add(referencedFuncName);
            if (Symbols.isFunctionDeclaration(matchingObjFuncSym) && Symbols.isFunctionDeclaration(referencedFunc.symbol)) {
                matchingFunc = ((BLangObjectTypeNode)typeDef.typeNode).functions.stream().filter(fn -> fn.symbol == matchingObjFuncSym).findFirst();
                pos = matchingFunc.isPresent() ? matchingFunc.get().pos : typeRef.pos;
                this.dlog.error(pos, DiagnosticCode.REDECLARED_FUNCTION_FROM_TYPE_REFERENCE, referencedFunc.funcName, typeRef);
            }
            if (!this.hasSameFunctionSignature((BInvokableSymbol)matchingObjFuncSym, referencedFunc.symbol)) {
                matchingFunc = ((BLangObjectTypeNode)typeDef.typeNode).functions.stream().filter(fn -> fn.symbol == matchingObjFuncSym).findFirst();
                pos = matchingFunc.isPresent() ? matchingFunc.get().pos : typeRef.pos;
                this.dlog.error(pos, DiagnosticCode.REFERRED_FUNCTION_SIGNATURE_MISMATCH, this.getCompleteFunctionSignature(referencedFunc.symbol), this.getCompleteFunctionSignature((BInvokableSymbol)matchingObjFuncSym));
            }
            return;
        }
        if (Symbols.isPrivate(referencedFunc.symbol)) {
            return;
        }
        BInvokableSymbol funcSymbol = ASTBuilderUtil.duplicateInvokableSymbol(referencedFunc.symbol, typeDef.symbol, funcName, typeDef.symbol.pkgID);
        this.defineSymbol(typeRef.pos, funcSymbol, objEnv);
        SymbolEnv funcEnv = SymbolEnv.createFunctionEnv(null, funcSymbol.scope, objEnv);
        funcSymbol.params.forEach(param -> this.defineSymbol(typeRef.pos, (BSymbol)param, funcEnv));
        if (funcSymbol.restParam != null) {
            this.defineSymbol(typeRef.pos, funcSymbol.restParam, funcEnv);
        }
        funcSymbol.receiverSymbol = this.defineVarSymbol(typeDef.pos, typeDef.flagSet, typeDef.symbol.type, Names.SELF, funcEnv);
        BAttachedFunction attachedFunc = new BAttachedFunction(referencedFunc.funcName, funcSymbol, (BInvokableType)funcSymbol.type);
        ((BObjectTypeSymbol)typeDef.symbol).attachedFuncs.add(attachedFunc);
        ((BObjectTypeSymbol)typeDef.symbol).referencedFunctions.add(attachedFunc);
    }

    private boolean hasSameFunctionSignature(BInvokableSymbol attachedFuncSym, BInvokableSymbol referencedFuncSym) {
        if (!this.hasSameVisibilityModifier(referencedFuncSym.flags, attachedFuncSym.flags)) {
            return false;
        }
        if (!this.types.isSameType(referencedFuncSym.type, attachedFuncSym.type)) {
            return false;
        }
        List<BVarSymbol> params = referencedFuncSym.params;
        for (int i = 0; i < params.size(); ++i) {
            BVarSymbol referencedFuncParam = params.get(i);
            BVarSymbol attachedFuncParam = attachedFuncSym.params.get(i);
            if (referencedFuncParam.name.value.equals(attachedFuncParam.name.value) && this.hasSameVisibilityModifier(referencedFuncParam.flags, attachedFuncParam.flags)) continue;
            return false;
        }
        if (referencedFuncSym.restParam != null && attachedFuncSym.restParam != null) {
            return referencedFuncSym.restParam.name.value.equals(attachedFuncSym.restParam.name.value);
        }
        return referencedFuncSym.restParam == null && attachedFuncSym.restParam == null;
    }

    private boolean hasSameVisibilityModifier(int flags1, int flags2) {
        int xorOfFlags = flags1 ^ flags2;
        return (xorOfFlags & 1) != 1 && (xorOfFlags & 0x400) != 1024;
    }

    private String getCompleteFunctionSignature(BInvokableSymbol funcSymbol) {
        StringBuilder signatureBuilder = new StringBuilder();
        StringJoiner paramListBuilder = new StringJoiner(", ", "(", ")");
        String visibilityModifier = "";
        if (Symbols.isPublic(funcSymbol)) {
            visibilityModifier = "public ";
        } else if (Symbols.isPrivate(funcSymbol)) {
            visibilityModifier = "private ";
        }
        signatureBuilder.append(visibilityModifier).append("function ").append(funcSymbol.name.value.split("\\.")[1]);
        funcSymbol.params.forEach(param -> paramListBuilder.add((Symbols.isPublic(param) ? "public " : "") + param.type.toString() + " " + param.name.value));
        if (funcSymbol.restParam != null) {
            paramListBuilder.add(((BArrayType)funcSymbol.restParam.type).eType.toString() + "... " + funcSymbol.restParam.name.value);
        }
        signatureBuilder.append(paramListBuilder.toString());
        if (funcSymbol.retType != this.symTable.nilType) {
            signatureBuilder.append(" returns ").append(funcSymbol.retType.toString());
        }
        return signatureBuilder.toString();
    }

    private BPackageSymbol duplicatePackagSymbol(BPackageSymbol originalSymbol) {
        BPackageSymbol copy = new BPackageSymbol(originalSymbol.pkgID, originalSymbol.owner, originalSymbol.flags);
        copy.initFunctionSymbol = originalSymbol.initFunctionSymbol;
        copy.startFunctionSymbol = originalSymbol.startFunctionSymbol;
        copy.stopFunctionSymbol = originalSymbol.stopFunctionSymbol;
        copy.testInitFunctionSymbol = originalSymbol.testInitFunctionSymbol;
        copy.testStartFunctionSymbol = originalSymbol.testStartFunctionSymbol;
        copy.testStopFunctionSymbol = originalSymbol.testStopFunctionSymbol;
        copy.packageFile = originalSymbol.packageFile;
        copy.compiledPackage = originalSymbol.compiledPackage;
        copy.entryPointExists = originalSymbol.entryPointExists;
        copy.scope = originalSymbol.scope;
        copy.owner = originalSymbol.owner;
        return copy;
    }

    private boolean isSameImport(BLangImportPackage importPkgNode, BPackageSymbol importSymbol) {
        if (!importPkgNode.orgName.value.equals(importSymbol.pkgID.orgName.value)) {
            return false;
        }
        BLangIdentifier pkgName = importPkgNode.pkgNameComps.get(importPkgNode.pkgNameComps.size() - 1);
        return pkgName.value.equals(importSymbol.pkgID.name.value);
    }

    private void resolveAndSetFunctionTypeFromRHSLambda(BLangSimpleVariable variable, SymbolEnv env) {
        BLangFunction function = ((BLangLambdaFunction)variable.expr).function;
        variable.type = this.symResolver.createInvokableType(function.getParameters(), function.restParam, function.returnTypeNode, Flags.asMask(variable.flagSet), env);
    }

    class LocationData {
        private String name;
        private int row;
        private int column;

        LocationData(String name, int row, int column) {
            this.name = name;
            this.row = row;
            this.column = column;
        }

        public boolean equals(Object o) {
            if (!(o instanceof LocationData)) {
                return false;
            }
            LocationData data = (LocationData)o;
            return this.name.equals(data.name) && this.row == data.row && this.column == data.column;
        }
    }

    public static class ImportResolveHolder {
        public BLangImportPackage resolved;
        public List<BLangImportPackage> unresolved;

        public ImportResolveHolder() {
            this.unresolved = new ArrayList<BLangImportPackage>();
        }

        public ImportResolveHolder(BLangImportPackage resolved) {
            this.resolved = resolved;
            this.unresolved = new ArrayList<BLangImportPackage>();
        }
    }
}

