/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.expressions.TypeConversionNode;
import org.ballerinalang.model.tree.types.TypeNode;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;

public class BLangTypeConversionExpr
extends BLangExpression
implements TypeConversionNode {
    public BLangExpression expr;
    public BLangType typeNode;
    public BType targetType;
    public List<BLangAnnotationAttachment> annAttachments = new ArrayList<BLangAnnotationAttachment>();
    public Set<Flag> flagSet = EnumSet.noneOf(Flag.class);
    public boolean checkTypes = true;

    @Override
    public ExpressionNode getExpression() {
        return this.expr;
    }

    @Override
    public void setExpression(ExpressionNode expr) {
        this.expr = (BLangExpression)expr;
    }

    @Override
    public BLangType getTypeNode() {
        return this.typeNode;
    }

    @Override
    public void setTypeNode(TypeNode typeNode) {
        this.typeNode = (BLangType)typeNode;
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.TYPE_CONVERSION_EXPR;
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "<" + (this.annAttachments.isEmpty() ? "" : this.attachmentsToString()) + (this.targetType != null ? this.targetType.toString() : "") + "> " + String.valueOf(this.expr);
    }

    private String attachmentsToString() {
        return this.annAttachments.stream().map(a -> "@" + a.getAnnotationName()).collect(Collectors.joining(", "));
    }

    @Override
    public Set<? extends Flag> getFlags() {
        return this.flagSet;
    }

    @Override
    public void addFlag(Flag flag) {
        this.flagSet.add(flag);
    }

    @Override
    public List<? extends AnnotationAttachmentNode> getAnnotationAttachments() {
        return this.annAttachments;
    }

    @Override
    public void addAnnotationAttachment(AnnotationAttachmentNode annAttachment) {
        this.annAttachments.add((BLangAnnotationAttachment)annAttachment);
    }
}

