/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.toml.model;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.toml.model.Dependency;
import org.ballerinalang.toml.model.DependencyMetadata;
import org.ballerinalang.toml.model.Platform;
import org.ballerinalang.toml.model.Project;
import org.wso2.ballerinalang.programfile.ProgramFileConstants;

public class Manifest {
    private Project project = new Project();
    private Map<String, Object> dependencies = new LinkedHashMap<String, Object>();
    public Platform platform = new Platform();

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Map<String, Object> getDependenciesAsObjectMap() {
        return this.dependencies.entrySet().stream().collect(Collectors.toMap(d -> ((String)d.getKey()).replaceAll("^\"|\"$", ""), Map.Entry::getValue));
    }

    public List<Dependency> getDependencies() {
        return this.dependencies.entrySet().stream().map(entry -> {
            Dependency dependency = new Dependency();
            dependency.setModuleID((String)entry.getKey());
            dependency.setMetadata(this.convertObjectToDependencyMetadata(entry.getValue()));
            return dependency;
        }).collect(Collectors.toList());
    }

    private DependencyMetadata convertObjectToDependencyMetadata(Object obj) {
        DependencyMetadata metadata = new DependencyMetadata();
        if (obj instanceof String) {
            metadata.setVersion((String)obj);
        } else if (obj instanceof Map) {
            Map metadataMap = (Map)obj;
            if (metadataMap.keySet().contains("version") && metadataMap.get("version") instanceof String) {
                metadata.setVersion((String)metadataMap.get("version"));
            }
            if (metadataMap.keySet().contains("path") && metadataMap.get("path") instanceof String) {
                metadata.setPath((String)metadataMap.get("path"));
            }
        }
        return metadata;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public String getTargetPlatform(String moduleName) {
        if (this.isTemplateModule(moduleName)) {
            return "any";
        }
        if (null != this.platform.libraries) {
            if (null == this.platform.target) {
                throw new BLangCompilerException("Platform target is not specified in the Ballerina.toml");
            }
            if (!Arrays.stream(ProgramFileConstants.SUPPORTED_PLATFORMS).anyMatch(this.platform.getTarget()::equals)) {
                throw new BLangCompilerException("Platform target is not supported by installed Ballerina distribution.\nSupported platforms : " + this.supportedPlatforms());
            }
            List deps = this.platform.libraries.stream().filter(library -> {
                if (library.getModules() == null) return true;
                if (!Arrays.stream(library.getModules()).anyMatch(moduleName::equals)) return false;
                return true;
            }).collect(Collectors.toList());
            if (deps.size() > 0) {
                return this.platform.target;
            }
        }
        return "any";
    }

    private String supportedPlatforms() {
        String platforms = String.join((CharSequence)",", ProgramFileConstants.SUPPORTED_PLATFORMS);
        return platforms;
    }

    public boolean isTemplateModule(String moduleName) {
        return this.getProject().getTemplates().contains(moduleName);
    }
}

