/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmLabelGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.Nilable;
import org.wso2.ballerinalang.compiler.bir.codegen.interop.InteropMethodGen;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;

public class JvmErrorGen {
    @Nilable
    private static BIRNode.BIRErrorEntry findErrorEntry(@Nilable List<BIRNode.BIRErrorEntry> errors, BIRNode.BIRBasicBlock currentBB) {
        for (BIRNode.BIRErrorEntry err : errors) {
            if (err == null || !err.endBB.id.value.equals(currentBB.id.value)) continue;
            return err;
        }
        return null;
    }

    public static class ErrorHandlerGenerator {
        MethodVisitor mv;
        JvmMethodGen.BalToJVMIndexMap indexMap;
        String currentPackageName;

        public ErrorHandlerGenerator(MethodVisitor mv, JvmMethodGen.BalToJVMIndexMap indexMap, String currentPackageName) {
            this.mv = mv;
            this.indexMap = indexMap;
            this.currentPackageName = currentPackageName;
        }

        void printStackTraceFromFutureValue(MethodVisitor mv, JvmMethodGen.BalToJVMIndexMap indexMap) {
            mv.visitInsn(89);
            mv.visitInsn(89);
            mv.visitFieldInsn(180, "org/ballerinalang/jvm/values/FutureValue", "strand", String.format("L%s;", "org/ballerinalang/jvm/scheduling/Strand"));
            mv.visitFieldInsn(180, "org/ballerinalang/jvm/scheduling/Strand", "scheduler", String.format("L%s;", "org/ballerinalang/jvm/scheduling/Scheduler"));
            mv.visitMethodInsn(182, "org/ballerinalang/jvm/scheduling/Scheduler", "start", "()V", false);
            mv.visitFieldInsn(180, "org/ballerinalang/jvm/values/FutureValue", "panic", String.format("L%s;", "java/lang/Throwable"));
            Label labelIf = new Label();
            mv.visitJumpInsn(198, labelIf);
            mv.visitFieldInsn(180, "org/ballerinalang/jvm/values/FutureValue", "panic", String.format("L%s;", "java/lang/Throwable"));
            mv.visitMethodInsn(184, "org/ballerinalang/jvm/util/RuntimeUtils", "handleRuntimeErrors", String.format("(L%s;)V", "java/lang/Throwable"), false);
            mv.visitInsn(177);
            mv.visitLabel(labelIf);
        }

        void genPanic(BIRTerminator.Panic panicTerm) {
            BIRNode.BIRVariableDcl varDcl = panicTerm.errorOp.variableDcl;
            int errorIndex = this.getJVMIndexOfVarRef(varDcl);
            JvmInstructionGen.generateVarLoad(this.mv, varDcl, this.currentPackageName, errorIndex);
            this.mv.visitInsn(191);
        }

        void generateTryCatch(BIRNode.BIRFunction func, String funcName, BIRNode.BIRBasicBlock currentBB, JvmInstructionGen.InstructionGenerator instGen, JvmTerminatorGen.TerminatorGenerator termGen, JvmLabelGen.LabelGenerator labelGen) {
            BIRNode.BIRErrorEntry currentEE = JvmErrorGen.findErrorEntry(func.errorTable, currentBB);
            if (currentEE == null) {
                return;
            }
            Label startLabel = labelGen.getLabel(funcName + currentEE.trapBB.id.value);
            Label endLabel = new Label();
            Label jumpLabel = new Label();
            this.mv.visitLabel(endLabel);
            this.mv.visitJumpInsn(167, jumpLabel);
            if (currentEE instanceof InteropMethodGen.JErrorEntry) {
                InteropMethodGen.JErrorEntry jCurrentEE = (InteropMethodGen.JErrorEntry)currentEE;
                BIRNode.BIRVariableDcl retVarDcl = currentEE.errorOp.variableDcl;
                int retIndex = this.indexMap.getIndex(retVarDcl);
                boolean exeptionExist = false;
                for (InteropMethodGen.CatchIns catchIns : jCurrentEE.catchIns) {
                    if ("org/ballerinalang/jvm/values/ErrorValue".equals(catchIns.errorClass)) {
                        exeptionExist = true;
                    }
                    Label errorValueLabel = new Label();
                    this.mv.visitTryCatchBlock(startLabel, endLabel, errorValueLabel, catchIns.errorClass);
                    this.mv.visitLabel(errorValueLabel);
                    this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/BallerinaErrors", "createInteropError", String.format("(L%s;)L%s;", "java/lang/Throwable", "org/ballerinalang/jvm/values/ErrorValue"), false);
                    JvmInstructionGen.generateVarStore(this.mv, retVarDcl, this.currentPackageName, retIndex);
                    BIRTerminator.Return term = catchIns.term;
                    termGen.genReturnTerm(term, retIndex, func, false, -1);
                    this.mv.visitJumpInsn(167, jumpLabel);
                }
                if (!exeptionExist) {
                    Label errorValErrorLabel = new Label();
                    this.mv.visitTryCatchBlock(startLabel, endLabel, errorValErrorLabel, "org/ballerinalang/jvm/values/ErrorValue");
                    this.mv.visitLabel(errorValErrorLabel);
                    this.mv.visitInsn(191);
                    this.mv.visitJumpInsn(167, jumpLabel);
                }
                Label otherErrorLabel = new Label();
                this.mv.visitTryCatchBlock(startLabel, endLabel, otherErrorLabel, "java/lang/Throwable");
                this.mv.visitLabel(otherErrorLabel);
                this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/BallerinaErrors", "createInteropError", String.format("(L%s;)L%s;", "java/lang/Throwable", "org/ballerinalang/jvm/values/ErrorValue"), false);
                this.mv.visitInsn(191);
                this.mv.visitJumpInsn(167, jumpLabel);
                this.mv.visitLabel(jumpLabel);
                return;
            }
            Label errorValueLabel = new Label();
            Label otherErrorLabel = new Label();
            this.mv.visitTryCatchBlock(startLabel, endLabel, errorValueLabel, "org/ballerinalang/jvm/values/ErrorValue");
            this.mv.visitTryCatchBlock(startLabel, endLabel, otherErrorLabel, "java/lang/StackOverflowError");
            this.mv.visitLabel(errorValueLabel);
            BIRNode.BIRVariableDcl varDcl = currentEE.errorOp.variableDcl;
            int lhsIndex = this.indexMap.getIndex(varDcl);
            JvmInstructionGen.generateVarStore(this.mv, varDcl, this.currentPackageName, lhsIndex);
            this.mv.visitJumpInsn(167, jumpLabel);
            this.mv.visitLabel(otherErrorLabel);
            this.mv.visitMethodInsn(184, "org/ballerinalang/jvm/BallerinaErrors", "trapError", String.format("(L%s;)L%s;", "java/lang/Throwable", "org/ballerinalang/jvm/values/ErrorValue"), false);
            this.mv.visitVarInsn(58, lhsIndex);
            this.mv.visitLabel(jumpLabel);
        }

        int getJVMIndexOfVarRef(BIRNode.BIRVariableDcl varDcl) {
            return this.indexMap.getIndex(varDcl);
        }
    }
}

