/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.emit;

import java.util.HashMap;
import java.util.Map;
import org.wso2.ballerinalang.compiler.bir.emit.EmitterUtils;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BHandleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;

class TypeEmitter {
    static final Map<String, BType> B_TYPES = new HashMap<String, BType>();

    TypeEmitter() {
    }

    static String emitType(BType bType, int tabs) {
        switch (bType.tag) {
            case 1: {
                return "int";
            }
            case 6: {
                return "boolean";
            }
            case 17: {
                return "any";
            }
            case 10: {
                return "()";
            }
            case 2: {
                return "byte";
            }
            case 3: {
                return "float";
            }
            case 5: {
                return "string";
            }
            case 11: {
                return "anydata";
            }
            case 22: {
                return "none";
            }
            case 7: {
                return "json";
            }
            case 8: {
                return "xml";
            }
            case 4: {
                return "decimal";
            }
            case 20: {
                return TypeEmitter.emitBUnionType((BUnionType)bType, tabs);
            }
            case 29: {
                return TypeEmitter.emitBTupleType((BTupleType)bType, tabs);
            }
            case 16: {
                return TypeEmitter.emitBInvokableType((BInvokableType)bType, tabs);
            }
            case 19: {
                return TypeEmitter.emitBArrayType((BArrayType)bType, tabs);
            }
            case 12: {
                return TypeEmitter.emitBRecordType((BRecordType)bType, tabs);
            }
            case 32: {
                if (bType instanceof BServiceType) {
                    return TypeEmitter.emitBServiceType((BServiceType)bType, tabs);
                }
                return TypeEmitter.emitBObjectType((BObjectType)bType, tabs);
            }
            case 15: {
                return TypeEmitter.emitBMapType((BMapType)bType, tabs);
            }
            case 27: {
                return TypeEmitter.emitBErrorType((BErrorType)bType, tabs);
            }
            case 30: {
                return TypeEmitter.emitBFutureType((BFutureType)bType, tabs);
            }
            case 13: {
                return TypeEmitter.emitBTypeDesc((BTypedescType)bType, tabs);
            }
            case 31: {
                return TypeEmitter.emitBFiniteType((BFiniteType)bType, tabs);
            }
            case 9: {
                return TypeEmitter.emitBTableType((BTableType)bType, tabs);
            }
            case 35: {
                return TypeEmitter.emitBTypeHandle((BHandleType)bType, tabs);
            }
        }
        throw new IllegalStateException("Invalid type");
    }

    private static String emitBUnionType(BUnionType bType, int tabs) {
        StringBuilder unionStr = new StringBuilder();
        int length = bType.getMemberTypes().size();
        int i = 0;
        for (BType mType : bType.getMemberTypes()) {
            if (mType == null) continue;
            unionStr.append(TypeEmitter.emitTypeRef(mType, tabs));
            if (++i >= length) continue;
            unionStr.append(EmitterUtils.emitSpaces(1));
            unionStr.append("|");
            unionStr.append(EmitterUtils.emitSpaces(1));
        }
        return unionStr.toString();
    }

    private static String emitBTupleType(BTupleType bType, int tabs) {
        StringBuilder tupleStr = new StringBuilder("(");
        int length = bType.tupleTypes.size();
        int i = 0;
        for (BType mType : bType.tupleTypes) {
            if (mType == null) continue;
            tupleStr.append(TypeEmitter.emitTypeRef(mType, tabs));
            if (++i >= length) continue;
            tupleStr.append(",");
            tupleStr.append(EmitterUtils.emitSpaces(1));
        }
        tupleStr.append(")");
        return tupleStr.toString();
    }

    private static String emitBInvokableType(BInvokableType bType, int tabs) {
        StringBuilder invString = new StringBuilder("function(");
        int pLength = bType.paramTypes.size();
        int i = 0;
        for (BType pType : bType.paramTypes) {
            if (pType == null) continue;
            invString.append(TypeEmitter.emitTypeRef(pType, tabs));
            if (++i >= pLength) continue;
            invString.append(",");
            invString.append(EmitterUtils.emitSpaces(1));
        }
        invString.append(")");
        BType retType = bType.retType;
        if (retType != null) {
            invString.append(EmitterUtils.emitSpaces(1));
            invString.append("->");
            invString.append(EmitterUtils.emitSpaces(1));
            invString.append(TypeEmitter.emitTypeRef(retType, tabs));
        }
        return invString.toString();
    }

    private static String emitBArrayType(BArrayType bType, int tabs) {
        String arrStr = TypeEmitter.emitTypeRef(bType.eType, 0);
        arrStr = arrStr + "[";
        if (bType.size > 0) {
            arrStr = arrStr + bType.size;
        }
        arrStr = arrStr + "]";
        return arrStr;
    }

    private static String emitBRecordType(BRecordType bType, int tabs) {
        StringBuilder recordStr = new StringBuilder("record");
        recordStr.append(EmitterUtils.emitSpaces(1));
        recordStr.append("{");
        recordStr.append(EmitterUtils.emitLBreaks(1));
        for (BField bField : bType.fields) {
            if (bField == null) continue;
            recordStr.append(EmitterUtils.emitTabs(tabs + 1));
            String flags = EmitterUtils.emitFlags(bField.type.flags);
            recordStr.append(flags);
            if (!flags.equals("")) {
                recordStr.append(EmitterUtils.emitSpaces(1));
            }
            recordStr.append(TypeEmitter.emitTypeRef(bField.type, tabs + 1));
            recordStr.append(EmitterUtils.emitSpaces(1));
            recordStr.append(EmitterUtils.emitName(bField.name));
            recordStr.append(";");
            recordStr.append(EmitterUtils.emitLBreaks(1));
        }
        recordStr.append("}");
        return recordStr.toString();
    }

    private static String emitBObjectType(BObjectType bType, int tabs) {
        StringBuilder str = new StringBuilder("object");
        str.append(EmitterUtils.emitSpaces(1));
        str.append("{");
        str.append(EmitterUtils.emitLBreaks(1));
        for (BField bField : bType.fields) {
            if (bField == null) continue;
            str.append(EmitterUtils.emitTabs(tabs + 1));
            String flags = EmitterUtils.emitFlags(bField.type.flags);
            str.append(flags);
            if (!flags.equals("")) {
                str.append(EmitterUtils.emitSpaces(1));
            }
            str.append(TypeEmitter.emitTypeRef(bField.type, tabs + 1));
            str.append(EmitterUtils.emitSpaces(1));
            str.append(EmitterUtils.emitName(bField.name));
            str.append(";");
            str.append(EmitterUtils.emitLBreaks(1));
        }
        int nTab = tabs + 1;
        BObjectTypeSymbol objectSymbol = (BObjectTypeSymbol)bType.tsymbol;
        BAttachedFunction generatedInitializerFunc = objectSymbol.generatedInitializerFunc;
        if (generatedInitializerFunc != null) {
            str.append(TypeEmitter.emitBAttachedFunction(generatedInitializerFunc, nTab));
        }
        str.append(EmitterUtils.emitLBreaks(1));
        BAttachedFunction initializerFunc = objectSymbol.initializerFunc;
        if (initializerFunc != null) {
            str.append(TypeEmitter.emitBAttachedFunction(initializerFunc, nTab));
        }
        str.append(EmitterUtils.emitLBreaks(1));
        for (BAttachedFunction attachedFunc : objectSymbol.attachedFuncs) {
            if (attachedFunc == null) continue;
            str.append(TypeEmitter.emitBAttachedFunction(attachedFunc, nTab));
            str.append(EmitterUtils.emitLBreaks(1));
        }
        str.append("}");
        return str.toString();
    }

    private static String emitBAttachedFunction(BAttachedFunction func, int tabs) {
        String str = "";
        str = str + EmitterUtils.emitTabs(tabs);
        str = str + EmitterUtils.emitName(func.funcName);
        str = str + EmitterUtils.emitSpaces(1);
        str = str + TypeEmitter.emitType(func.type, 0);
        return str;
    }

    private static String emitBMapType(BMapType bType, int tabs) {
        String str = "map";
        str = str + "<";
        str = str + TypeEmitter.emitTypeRef(bType.constraint, 0);
        str = str + ">";
        return str;
    }

    private static String emitBErrorType(BErrorType bType, int tabs) {
        String errStr = "error{";
        errStr = errStr + TypeEmitter.emitTypeRef(bType.reasonType, tabs);
        errStr = errStr + ",";
        errStr = errStr + EmitterUtils.emitSpaces(1);
        errStr = errStr + TypeEmitter.emitTypeRef(bType.detailType, tabs);
        errStr = errStr + "}";
        return errStr;
    }

    private static String emitBFutureType(BFutureType bType, int tabs) {
        String str = "future";
        str = str + "<";
        str = str + TypeEmitter.emitTypeRef(bType.getReturnType(), 0);
        str = str + ">";
        return str;
    }

    private static String emitBTypeDesc(BTypedescType bType, int tabs) {
        String str = "typeDesc";
        str = str + "<";
        str = str + TypeEmitter.emitTypeRef(bType.constraint, 0);
        str = str + ">";
        return str;
    }

    private static String emitBServiceType(BServiceType bType, int tabs) {
        String str = "service";
        str = str + "<";
        str = str + TypeEmitter.emitTypeRef(bType.tsymbol.type, 0);
        str = str + ">";
        return str;
    }

    private static String emitBFiniteType(BFiniteType bType, int tabs) {
        StringBuilder str = new StringBuilder();
        str.append("[");
        int i = 0;
        int length = bType.getValueSpace().size();
        for (BLangExpression v : bType.getValueSpace()) {
            str.append(v.toString());
            if (++i >= length) continue;
            str.append(",");
            str.append(EmitterUtils.emitSpaces(1));
        }
        str.append("]");
        return str.toString();
    }

    private static String emitBTableType(BTableType bType, int tabs) {
        String str = "table";
        str = str + "<";
        str = str + TypeEmitter.emitTypeRef(bType.constraint, 0);
        str = str + ">";
        return str;
    }

    private static String emitBTypeHandle(BHandleType bType, int tabs) {
        String str = "handle";
        str = str + "<";
        str = str + ">";
        return str;
    }

    static String emitTypeRef(BType bType, int tabs) {
        String tName = EmitterUtils.getTypeName(bType);
        if (!"".equals(tName)) {
            return tName;
        }
        if (bType.tag == 27) {
            B_TYPES.put(bType.tsymbol.toString(), bType);
        }
        if (bType.tag == 12 || bType.tag == 32) {
            return bType.tsymbol.toString();
        }
        return TypeEmitter.emitType(bType, tabs);
    }
}

