/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.writer;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIRVisitor;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.writer.BIRBinaryWriter;
import org.wso2.ballerinalang.compiler.bir.writer.BIRTypeWriter;
import org.wso2.ballerinalang.compiler.bir.writer.CPEntry;
import org.wso2.ballerinalang.compiler.bir.writer.ConstantPool;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class BIRInstructionWriter
extends BIRVisitor {
    private ByteBuf buf;
    private BIRTypeWriter typeWriter;
    private ConstantPool cp;
    private BIRBinaryWriter binaryWriter;

    public BIRInstructionWriter(ByteBuf buf, BIRTypeWriter typeWriter, ConstantPool cp, BIRBinaryWriter birBinaryWriter) {
        this.buf = buf;
        this.typeWriter = typeWriter;
        this.binaryWriter = birBinaryWriter;
        this.cp = cp;
    }

    public void writeBBs(List<BIRNode.BIRBasicBlock> bbList) {
        this.buf.writeInt(bbList.size());
        bbList.forEach(bb -> bb.accept(this));
    }

    @Override
    public void visit(BIRNode.BIRBasicBlock birBasicBlock) {
        this.addCpAndWriteString(birBasicBlock.id.value);
        this.buf.writeInt(birBasicBlock.instructions.size() + 1);
        birBasicBlock.instructions.forEach(instruction -> instruction.accept(this));
        if (birBasicBlock.terminator == null) {
            throw new BLangCompilerException("Basic block without a terminator : " + birBasicBlock.id);
        }
        birBasicBlock.terminator.accept(this);
    }

    public void writeErrorTable(List<BIRNode.BIRErrorEntry> errorEntries) {
        this.buf.writeInt(errorEntries.size());
        errorEntries.forEach(birErrorEntry -> birErrorEntry.accept(this));
    }

    @Override
    public void visit(BIRNode.BIRErrorEntry errorEntry) {
        this.addCpAndWriteString(errorEntry.trapBB.id.value);
        this.addCpAndWriteString(errorEntry.endBB.id.value);
        errorEntry.errorOp.accept(this);
        this.addCpAndWriteString(errorEntry.targetBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.GOTO birGoto) {
        this.writePosition(birGoto.pos);
        this.buf.writeByte((int)birGoto.kind.getValue());
        this.addCpAndWriteString(birGoto.targetBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.Lock lock) {
        this.writePosition(lock.pos);
        this.buf.writeByte((int)lock.kind.getValue());
        this.addCpAndWriteString(lock.lockedBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.FieldLock lock) {
        this.writePosition(lock.pos);
        this.buf.writeByte((int)lock.kind.getValue());
        this.addCpAndWriteString(lock.localVar.variableDcl.name.value);
        this.addCpAndWriteString(lock.field);
        this.addCpAndWriteString(lock.lockedBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.Unlock unlock) {
        this.writePosition(unlock.pos);
        this.buf.writeByte((int)unlock.kind.getValue());
        this.addCpAndWriteString(unlock.unlockBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.Return birReturn) {
        this.writePosition(birReturn.pos);
        this.buf.writeByte((int)birReturn.kind.getValue());
    }

    @Override
    public void visit(BIRTerminator.Branch birBranch) {
        this.writePosition(birBranch.pos);
        this.buf.writeByte((int)birBranch.kind.getValue());
        birBranch.op.accept(this);
        this.addCpAndWriteString(birBranch.trueBB.id.value);
        this.addCpAndWriteString(birBranch.falseBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.Wait waitEntry) {
        this.writePosition(waitEntry.pos);
        this.buf.writeByte((int)waitEntry.kind.getValue());
        this.buf.writeInt(waitEntry.exprList.size());
        for (BIROperand expr : waitEntry.exprList) {
            expr.accept(this);
        }
        waitEntry.lhsOp.accept(this);
        this.addCpAndWriteString(waitEntry.thenBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.Flush entry) {
        this.writePosition(entry.pos);
        this.buf.writeByte((int)entry.kind.getValue());
        this.buf.writeInt(entry.channels.length);
        for (BIRNode.ChannelDetails detail : entry.channels) {
            this.addCpAndWriteString(detail.name);
            this.buf.writeBoolean(detail.channelInSameStrand);
            this.buf.writeBoolean(detail.send);
        }
        entry.lhsOp.accept(this);
        this.addCpAndWriteString(entry.thenBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.WorkerReceive entry) {
        this.writePosition(entry.pos);
        this.buf.writeByte((int)entry.kind.getValue());
        this.buf.writeInt(this.addStringCPEntry(entry.workerName.getValue()));
        entry.lhsOp.accept(this);
        this.buf.writeBoolean(entry.isSameStrand);
        this.addCpAndWriteString(entry.thenBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.WorkerSend entry) {
        this.writePosition(entry.pos);
        this.buf.writeByte((int)entry.kind.getValue());
        this.buf.writeInt(this.addStringCPEntry(entry.channel.getValue()));
        entry.data.accept(this);
        this.buf.writeBoolean(entry.isSameStrand);
        this.buf.writeBoolean(entry.isSync);
        if (entry.isSync) {
            entry.lhsOp.accept(this);
        }
        this.addCpAndWriteString(entry.thenBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.WaitAll waitAll) {
        this.writePosition(waitAll.pos);
        this.buf.writeByte((int)waitAll.kind.getValue());
        waitAll.lhsOp.accept(this);
        this.buf.writeInt(waitAll.keys.size());
        waitAll.keys.forEach(key -> this.buf.writeInt(this.addStringCPEntry((String)key)));
        waitAll.valueExprs.forEach(val -> val.accept(this));
        this.addCpAndWriteString(waitAll.thenBB.id.value);
    }

    @Override
    public void visit(BIRNonTerminator.Move birMove) {
        this.writePosition(birMove.pos);
        this.buf.writeByte((int)birMove.kind.getValue());
        birMove.rhsOp.accept(this);
        birMove.lhsOp.accept(this);
    }

    @Override
    public void visit(BIRTerminator.Call birCall) {
        this.writePosition(birCall.pos);
        this.buf.writeByte((int)birCall.kind.getValue());
        PackageID calleePkg = birCall.calleePkg;
        int pkgIndex = this.addPkgCPEntry(calleePkg);
        this.buf.writeBoolean(birCall.isVirtual);
        this.buf.writeInt(pkgIndex);
        this.buf.writeInt(this.addStringCPEntry(birCall.name.getValue()));
        this.buf.writeInt(birCall.args.size());
        for (BIROperand arg : birCall.args) {
            arg.accept(this);
        }
        if (birCall.lhsOp != null) {
            this.buf.writeByte(1);
            birCall.lhsOp.accept(this);
        } else {
            this.buf.writeByte(0);
        }
        this.addCpAndWriteString(birCall.thenBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.AsyncCall birAsyncCall) {
        this.writePosition(birAsyncCall.pos);
        this.buf.writeByte((int)birAsyncCall.kind.getValue());
        PackageID calleePkg = birAsyncCall.calleePkg;
        int pkgIndex = this.addPkgCPEntry(calleePkg);
        this.buf.writeBoolean(birAsyncCall.isVirtual);
        this.buf.writeInt(pkgIndex);
        this.buf.writeInt(this.addStringCPEntry(birAsyncCall.name.getValue()));
        this.buf.writeInt(birAsyncCall.args.size());
        for (BIROperand arg : birAsyncCall.args) {
            arg.accept(this);
        }
        if (birAsyncCall.lhsOp != null) {
            this.buf.writeByte(1);
            birAsyncCall.lhsOp.accept(this);
        } else {
            this.buf.writeByte(0);
        }
        this.binaryWriter.writeAnnotAttachments(this.buf, this, birAsyncCall.annotAttachments);
        this.addCpAndWriteString(birAsyncCall.thenBB.id.value);
    }

    @Override
    public void visit(BIRTerminator.FPCall fpCall) {
        this.writePosition(fpCall.pos);
        this.buf.writeByte((int)fpCall.kind.getValue());
        fpCall.fp.accept(this);
        this.buf.writeInt(fpCall.args.size());
        for (BIROperand arg : fpCall.args) {
            arg.accept(this);
        }
        if (fpCall.lhsOp != null) {
            this.buf.writeByte(1);
            fpCall.lhsOp.accept(this);
        } else {
            this.buf.writeByte(0);
        }
        this.buf.writeBoolean(fpCall.isAsync);
        this.addCpAndWriteString(fpCall.thenBB.id.value);
    }

    @Override
    public void visit(BIRNonTerminator.BinaryOp birBinaryOp) {
        this.writePosition(birBinaryOp.pos);
        this.buf.writeByte((int)birBinaryOp.kind.getValue());
        birBinaryOp.rhsOp1.accept(this);
        birBinaryOp.rhsOp2.accept(this);
        birBinaryOp.lhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.UnaryOP birUnaryOp) {
        this.writePosition(birUnaryOp.pos);
        this.buf.writeByte((int)birUnaryOp.kind.getValue());
        birUnaryOp.rhsOp.accept(this);
        birUnaryOp.lhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.ConstantLoad birConstantLoad) {
        this.writePosition(birConstantLoad.pos);
        this.buf.writeByte((int)birConstantLoad.kind.getValue());
        this.writeType(birConstantLoad.type);
        birConstantLoad.lhsOp.accept(this);
        BType type = birConstantLoad.type;
        switch (type.tag) {
            case 1: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.buf.writeInt(this.cp.addCPEntry(new CPEntry.IntegerCPEntry((Long)birConstantLoad.value)));
                break;
            }
            case 2: {
                int byteValue = ((Number)birConstantLoad.value).intValue();
                this.buf.writeInt(this.cp.addCPEntry(new CPEntry.ByteCPEntry(byteValue)));
                break;
            }
            case 6: {
                this.buf.writeBoolean(((Boolean)birConstantLoad.value).booleanValue());
                break;
            }
            case 4: 
            case 5: 
            case 42: {
                this.buf.writeInt(this.cp.addCPEntry(new CPEntry.StringCPEntry(birConstantLoad.value.toString())));
                break;
            }
            case 3: {
                double value = birConstantLoad.value instanceof Double ? (Double)birConstantLoad.value : Double.parseDouble((String)birConstantLoad.value);
                this.buf.writeInt(this.cp.addCPEntry(new CPEntry.FloatCPEntry(value)));
                break;
            }
            case 10: {
                break;
            }
            default: {
                throw new IllegalStateException("unsupported constant type: " + type);
            }
        }
    }

    @Override
    public void visit(BIRNonTerminator.NewStructure birNewStructure) {
        this.writePosition(birNewStructure.pos);
        this.buf.writeByte((int)birNewStructure.kind.getValue());
        this.writeType(birNewStructure.type);
        this.buf.writeBoolean(birNewStructure.isExternalDef);
        if (birNewStructure.isExternalDef) {
            assert (birNewStructure.externalPackageId != null);
            this.buf.writeInt(this.addPkgCPEntry(birNewStructure.externalPackageId));
            this.buf.writeInt(this.addStringCPEntry(birNewStructure.recordName));
        }
        birNewStructure.lhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewInstance newInstance) {
        this.writePosition(newInstance.pos);
        this.buf.writeByte((int)newInstance.kind.getValue());
        this.buf.writeBoolean(newInstance.isExternalDef);
        if (newInstance.isExternalDef) {
            assert (newInstance.externalPackageId != null);
            this.buf.writeInt(this.addPkgCPEntry(newInstance.externalPackageId));
            this.buf.writeInt(this.addStringCPEntry(newInstance.objectName));
        } else {
            this.buf.writeInt(newInstance.def.index);
        }
        newInstance.lhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewArray birNewArray) {
        this.writePosition(birNewArray.pos);
        this.buf.writeByte((int)birNewArray.kind.getValue());
        this.writeType(birNewArray.type);
        birNewArray.lhsOp.accept(this);
        birNewArray.sizeOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.FieldAccess birFieldAccess) {
        this.writePosition(birFieldAccess.pos);
        this.buf.writeByte((int)birFieldAccess.kind.getValue());
        if (birFieldAccess.kind == InstructionKind.MAP_LOAD || birFieldAccess.kind == InstructionKind.ARRAY_LOAD) {
            this.buf.writeBoolean(birFieldAccess.optionalFieldAccess);
            this.buf.writeBoolean(birFieldAccess.fillingRead);
        }
        birFieldAccess.lhsOp.accept(this);
        birFieldAccess.keyOp.accept(this);
        birFieldAccess.rhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.TypeCast birTypeCast) {
        this.writePosition(birTypeCast.pos);
        this.buf.writeByte((int)birTypeCast.kind.getValue());
        birTypeCast.lhsOp.accept(this);
        birTypeCast.rhsOp.accept(this);
        this.writeType(birTypeCast.type);
        this.buf.writeBoolean(birTypeCast.checkTypes);
    }

    @Override
    public void visit(BIRNonTerminator.IsLike birIsLike) {
        this.writePosition(birIsLike.pos);
        this.buf.writeByte((int)birIsLike.kind.getValue());
        this.writeType(birIsLike.type);
        birIsLike.lhsOp.accept(this);
        birIsLike.rhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.TypeTest birTypeTest) {
        this.writePosition(birTypeTest.pos);
        this.buf.writeByte((int)birTypeTest.kind.getValue());
        this.writeType(birTypeTest.type);
        birTypeTest.lhsOp.accept(this);
        birTypeTest.rhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewTable newTable) {
        this.writePosition(newTable.pos);
        this.buf.writeByte((int)newTable.kind.getValue());
        this.writeType(newTable.type);
        newTable.lhsOp.accept(this);
        newTable.columnsOp.accept(this);
        newTable.dataOp.accept(this);
        newTable.keyColOp.accept(this);
    }

    @Override
    public void visit(BIROperand birOperand) {
        if (birOperand.variableDcl.ignoreVariable) {
            this.buf.writeBoolean(true);
            this.writeType(birOperand.variableDcl.type);
            return;
        }
        this.buf.writeBoolean(false);
        this.buf.writeByte((int)birOperand.variableDcl.kind.getValue());
        this.buf.writeByte((int)birOperand.variableDcl.scope.getValue());
        this.addCpAndWriteString(birOperand.variableDcl.name.value);
        if (birOperand.variableDcl.kind == VarKind.GLOBAL || birOperand.variableDcl.kind == VarKind.CONSTANT) {
            int pkgIndex = this.addPkgCPEntry(((BIRNode.BIRGlobalVariableDcl)birOperand.variableDcl).pkgId);
            this.buf.writeInt(pkgIndex);
            this.writeType(birOperand.variableDcl.type);
        }
    }

    @Override
    public void visit(BIRNonTerminator.NewError birNewError) {
        this.writePosition(birNewError.pos);
        this.buf.writeByte((int)birNewError.kind.getValue());
        this.writeType(birNewError.type);
        birNewError.lhsOp.accept(this);
        birNewError.reasonOp.accept(this);
        birNewError.detailOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.FPLoad fpLoad) {
        this.writePosition(fpLoad.pos);
        this.buf.writeByte((int)fpLoad.kind.getValue());
        fpLoad.lhsOp.accept(this);
        PackageID pkgId = fpLoad.pkgId;
        int pkgIndex = this.addPkgCPEntry(pkgId);
        this.buf.writeInt(pkgIndex);
        this.buf.writeInt(this.addStringCPEntry(fpLoad.funcName.getValue()));
        this.writeType(fpLoad.retType);
        this.buf.writeInt(fpLoad.closureMaps.size());
        for (BIROperand op : fpLoad.closureMaps) {
            op.accept(this);
        }
        this.buf.writeInt(fpLoad.params.size());
        fpLoad.params.forEach(param -> {
            this.buf.writeByte((int)param.kind.getValue());
            this.writeType(param.type);
            this.buf.writeInt(this.addStringCPEntry(param.name.value));
        });
    }

    @Override
    public void visit(BIRTerminator.Panic birPanic) {
        this.writePosition(birPanic.pos);
        this.buf.writeByte((int)birPanic.kind.getValue());
        birPanic.errorOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewXMLElement newXMLElement) {
        this.writePosition(newXMLElement.pos);
        this.buf.writeByte((int)newXMLElement.kind.getValue());
        newXMLElement.lhsOp.accept(this);
        newXMLElement.startTagOp.accept(this);
        newXMLElement.defaultNsURIOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewXMLText newXMLText) {
        this.writePosition(newXMLText.pos);
        this.buf.writeByte((int)newXMLText.kind.getValue());
        newXMLText.lhsOp.accept(this);
        newXMLText.textOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewXMLQName newXMLQName) {
        this.writePosition(newXMLQName.pos);
        this.buf.writeByte((int)newXMLQName.kind.getValue());
        newXMLQName.lhsOp.accept(this);
        newXMLQName.localnameOp.accept(this);
        newXMLQName.nsURIOp.accept(this);
        newXMLQName.prefixOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewStringXMLQName newStringXMLQName) {
        this.writePosition(newStringXMLQName.pos);
        this.buf.writeByte((int)newStringXMLQName.kind.getValue());
        newStringXMLQName.lhsOp.accept(this);
        newStringXMLQName.stringQNameOP.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.XMLAccess xmlAccess) {
        this.writePosition(xmlAccess.pos);
        this.buf.writeByte((int)xmlAccess.kind.getValue());
        xmlAccess.lhsOp.accept(this);
        xmlAccess.rhsOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewXMLComment newXMLComment) {
        this.writePosition(newXMLComment.pos);
        this.buf.writeByte((int)newXMLComment.kind.getValue());
        newXMLComment.lhsOp.accept(this);
        newXMLComment.textOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewXMLProcIns newXMLProcIns) {
        this.writePosition(newXMLProcIns.pos);
        this.buf.writeByte((int)newXMLProcIns.kind.getValue());
        newXMLProcIns.lhsOp.accept(this);
        newXMLProcIns.dataOp.accept(this);
        newXMLProcIns.targetOp.accept(this);
    }

    @Override
    public void visit(BIRNonTerminator.NewTypeDesc newTypeDesc) {
        this.writePosition(newTypeDesc.pos);
        this.buf.writeByte((int)newTypeDesc.kind.getValue());
        newTypeDesc.lhsOp.accept(this);
        this.writeType(newTypeDesc.type);
    }

    void writePosition(DiagnosticPos pos) {
        int sLine = Integer.MIN_VALUE;
        int eLine = Integer.MIN_VALUE;
        int sCol = Integer.MIN_VALUE;
        int eCol = Integer.MIN_VALUE;
        String sourceFileName = "";
        if (pos != null) {
            sLine = pos.sLine;
            eLine = pos.eLine;
            sCol = pos.sCol;
            eCol = pos.eCol;
            if (pos.src != null) {
                sourceFileName = pos.src.cUnitName;
            }
        }
        this.buf.writeInt(sLine);
        this.buf.writeInt(eLine);
        this.buf.writeInt(sCol);
        this.buf.writeInt(eCol);
        this.buf.writeInt(this.addStringCPEntry(sourceFileName));
    }

    void writePosition(ByteBuf buf, DiagnosticPos pos) {
        int sLine = Integer.MIN_VALUE;
        int eLine = Integer.MIN_VALUE;
        int sCol = Integer.MIN_VALUE;
        int eCol = Integer.MIN_VALUE;
        String sourceFileName = "";
        if (pos != null) {
            sLine = pos.sLine;
            eLine = pos.eLine;
            sCol = pos.sCol;
            eCol = pos.eCol;
            if (pos.src != null) {
                sourceFileName = pos.src.cUnitName;
            }
        }
        buf.writeInt(sLine);
        buf.writeInt(eLine);
        buf.writeInt(sCol);
        buf.writeInt(eCol);
        buf.writeInt(this.addStringCPEntry(sourceFileName));
    }

    int addPkgCPEntry(PackageID packageID) {
        int orgCPIndex = this.addStringCPEntry(packageID.orgName.value);
        int nameCPIndex = this.addStringCPEntry(packageID.name.value);
        int versionCPIndex = this.addStringCPEntry(packageID.version.value);
        return this.cp.addCPEntry(new CPEntry.PackageCPEntry(orgCPIndex, nameCPIndex, versionCPIndex));
    }

    private void addCpAndWriteString(String string) {
        this.buf.writeInt(this.addStringCPEntry(string));
    }

    private int addStringCPEntry(String value) {
        return this.cp.addCPEntry(new CPEntry.StringCPEntry(value));
    }

    private void writeType(BType type) {
        this.buf.writeInt(this.cp.addShapeCPEntry(type));
    }
}

