/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.tree.statements.VariableDefinitionNode;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.desugar.Desugar;
import org.wso2.ballerinalang.compiler.parser.BLangAnonymousModelHelper;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolEnter;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;
import org.wso2.ballerinalang.util.Lists;

public class QueryDesugar
extends BLangNodeVisitor {
    private static final CompilerContext.Key<QueryDesugar> QUERY_DESUGAR_KEY = new CompilerContext.Key();
    private final SymbolEnter symbolEnter;
    private final Desugar desugar;
    private final SymbolTable symTable;
    private final BLangAnonymousModelHelper anonymousModelHelper;
    private BLangDiagnosticLogHelper dlog;
    private final SymbolResolver symResolver;
    private final Names names;
    private final Types types;
    private BLangBlockStmt parentBlock = null;
    private SymbolEnv env;

    private QueryDesugar(CompilerContext context) {
        context.put(QUERY_DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.symbolEnter = SymbolEnter.getInstance(context);
        this.names = Names.getInstance(context);
        this.types = Types.getInstance(context);
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
        this.desugar = Desugar.getInstance(context);
        this.anonymousModelHelper = BLangAnonymousModelHelper.getInstance(context);
    }

    public static QueryDesugar getInstance(CompilerContext context) {
        QueryDesugar desugar = context.get(QUERY_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new QueryDesugar(context);
        }
        return desugar;
    }

    BLangStatementExpression desugarQueryExpr(BLangQueryExpr queryExpr, SymbolEnv env) {
        this.env = env;
        List<BLangFromClause> fromClauseList = queryExpr.fromClauseList;
        BLangFromClause fromClause = fromClauseList.get(0);
        BLangSelectClause selectClause = queryExpr.selectClause;
        List<BLangWhereClause> whereClauseList = queryExpr.whereClauseList;
        List<BLangLetClause> letClauseList = queryExpr.letClausesList;
        DiagnosticPos pos = fromClause.pos;
        this.parentBlock = ASTBuilderUtil.createBlockStmt(fromClause.pos);
        BType queryExpOutputType = queryExpr.type;
        BType outputType = this.types.getSafeType(queryExpOutputType, true, true);
        if (outputType.tag == 19) {
            BVarSymbol outputVarSymbol = new BVarSymbol(0, new Name("$outputDataArray$"), env.scope.owner.pkgID, queryExpOutputType, env.scope.owner);
            BLangLiteral outputInitExpression = ASTBuilderUtil.createLiteral(fromClause.pos, this.symTable.nilType, null);
            BLangSimpleVariable outputVariable = ASTBuilderUtil.createVariable(pos, "$outputDataArray$", queryExpOutputType, outputInitExpression, outputVarSymbol);
            BLangSimpleVariableDef outputVariableDef = ASTBuilderUtil.createVariableDef(pos, outputVariable);
            BLangSimpleVarRef outputVarRef = ASTBuilderUtil.createVariableRef(pos, outputVariable.symbol);
            BVarSymbol tempArrayVarSymbol = new BVarSymbol(0, new Name("$tempDataArray$"), env.scope.owner.pkgID, outputType, env.scope.owner);
            BLangListConstructorExpr.BLangArrayLiteral emptyArrayExpr = ASTBuilderUtil.createEmptyArrayLiteral(pos, (BArrayType)outputType);
            BLangSimpleVariable tempArrayVariable = ASTBuilderUtil.createVariable(pos, "$tempDataArray$", outputType, emptyArrayExpr, tempArrayVarSymbol);
            BLangSimpleVariableDef tempArrayVariableDef = ASTBuilderUtil.createVariableDef(pos, tempArrayVariable);
            BLangSimpleVarRef tempArrayVarRef = ASTBuilderUtil.createVariableRef(pos, tempArrayVariable.symbol);
            this.parentBlock.addStatement(outputVariableDef);
            this.parentBlock.addStatement(tempArrayVariableDef);
            BLangBlockStmt leafElseBlock = this.buildFromClauseBlock(fromClauseList, outputVarRef);
            BLangBlockStmt bodyBlock = ASTBuilderUtil.createBlockStmt(pos);
            BLangInvocation arrPushInvocation = this.createLangLibInvocation("push", tempArrayVarRef, new ArrayList<BLangExpression>(), Lists.of(ASTBuilderUtil.generateConversionExpr(selectClause.expression, this.symTable.anyOrErrorType, this.symResolver)), this.symTable.nilType, pos);
            BLangExpressionStmt pushInvocationStmt = ASTBuilderUtil.createExpressionStmt(pos, bodyBlock);
            pushInvocationStmt.expr = arrPushInvocation;
            this.buildWhereClauseBlock(whereClauseList, letClauseList, leafElseBlock, bodyBlock, selectClause.pos);
            BLangBlockStmt nullCheckIfBody = ASTBuilderUtil.createBlockStmt(fromClause.pos);
            BLangAssignment outputAssignment = ASTBuilderUtil.createAssignmentStmt(fromClause.pos, outputVarRef, tempArrayVarRef);
            nullCheckIfBody.addStatement(outputAssignment);
            BLangIf nullCheckIf = this.createTypeCheckIfNode(fromClause.pos, outputVarRef, this.desugar.getNillTypeNode(), nullCheckIfBody);
            this.parentBlock.addStatement(nullCheckIf);
            BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(this.parentBlock, outputVarRef);
            stmtExpr.type = queryExpOutputType;
            return stmtExpr;
        }
        throw new IllegalStateException();
    }

    BLangStatementExpression desugarQueryAction(BLangQueryAction queryAction, SymbolEnv env) {
        this.env = env;
        List<BLangFromClause> fromClauseList = queryAction.fromClauseList;
        List<BLangLetClause> letClauseList = queryAction.letClauseList;
        BLangFromClause fromClause = fromClauseList.get(0);
        BLangDoClause doClause = queryAction.doClause;
        List<BLangWhereClause> whereClauseList = queryAction.whereClauseList;
        DiagnosticPos pos = fromClause.pos;
        this.parentBlock = ASTBuilderUtil.createBlockStmt(fromClause.pos);
        BLangLiteral nilExpression = ASTBuilderUtil.createLiteral(pos, this.symTable.nilType, Names.NIL_VALUE);
        BVarSymbol outputVarSymbol = new BVarSymbol(0, new Name("$outputVar$"), env.scope.owner.pkgID, this.symTable.errorOrNilType, env.scope.owner);
        BLangSimpleVariable outputVariable = ASTBuilderUtil.createVariable(pos, "$outputVar$", this.symTable.errorOrNilType, nilExpression, outputVarSymbol);
        BLangSimpleVariableDef outputVariableDef = ASTBuilderUtil.createVariableDef(pos, outputVariable);
        BLangSimpleVarRef outputVarRef = ASTBuilderUtil.createVariableRef(pos, outputVariable.symbol);
        this.parentBlock.addStatement(outputVariableDef);
        BLangBlockStmt leafElseBlock = this.buildFromClauseBlock(fromClauseList, outputVarRef);
        this.buildWhereClauseBlock(whereClauseList, letClauseList, leafElseBlock, doClause.body, doClause.pos);
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(this.parentBlock, outputVarRef);
        stmtExpr.type = this.symTable.errorOrNilType;
        return stmtExpr;
    }

    private BLangBlockStmt buildFromClauseBlock(List<BLangFromClause> fromClauseList, BLangSimpleVarRef outputVarRef) {
        BLangBlockStmt leafElseBody = null;
        for (BLangFromClause fromClause : fromClauseList) {
            BLangSimpleVariableDef iteratorVarDef;
            BInvokableSymbol iteratorInvSymbol;
            BVarSymbol dataSymbol = new BVarSymbol(0, this.names.fromString("$data$"), this.env.scope.owner.pkgID, fromClause.collection.type, this.env.scope.owner);
            BLangSimpleVariable dataVariable = ASTBuilderUtil.createVariable(fromClause.pos, "$data$", fromClause.collection.type, fromClause.collection, dataSymbol);
            BLangSimpleVariableDef dataVarDef = ASTBuilderUtil.createVariableDef(fromClause.pos, dataVariable);
            BVarSymbol collectionSymbol = dataVariable.symbol;
            if (collectionSymbol.type.tag == 32) {
                iteratorInvSymbol = this.desugar.getIterableObjectIteratorInvokableSymbol(collectionSymbol);
                iteratorVarDef = this.desugar.getIteratorVariableDefinition(fromClause.pos, collectionSymbol, iteratorInvSymbol, false);
            } else {
                iteratorInvSymbol = this.desugar.getLangLibIteratorInvokableSymbol(collectionSymbol);
                iteratorVarDef = this.desugar.getIteratorVariableDefinition(fromClause.pos, collectionSymbol, iteratorInvSymbol, true);
            }
            BVarSymbol iteratorSymbol = iteratorVarDef.var.symbol;
            BVarSymbol resultSymbol = new BVarSymbol(0, this.names.fromString("$result$"), this.env.scope.owner.pkgID, fromClause.nillableResultType, this.env.scope.owner);
            BLangSimpleVariableDef resultVariableDefinition = this.desugar.getIteratorNextVariableDefinition(fromClause.pos, fromClause.nillableResultType, iteratorSymbol, resultSymbol);
            BLangSimpleVarRef resultReferenceInWhile = ASTBuilderUtil.createVariableRef(fromClause.pos, resultSymbol);
            BLangLiteral conditionLiteral = ASTBuilderUtil.createLiteral(fromClause.pos, this.symTable.booleanType, true);
            BLangGroupExpr whileCondition = new BLangGroupExpr();
            whileCondition.type = this.symTable.booleanType;
            whileCondition.expression = conditionLiteral;
            BLangWhile whileNode = (BLangWhile)TreeBuilder.createWhileNode();
            whileNode.expr = whileCondition;
            BLangBlockStmt nullCheckIfBody = ASTBuilderUtil.createBlockStmt(fromClause.pos);
            nullCheckIfBody.addStatement(TreeBuilder.createBreakNode());
            BLangIf nullCheckIf = this.createTypeCheckIfNode(fromClause.pos, resultReferenceInWhile, this.desugar.getNillTypeNode(), nullCheckIfBody);
            BLangBlockStmt errorCheckIfBody = ASTBuilderUtil.createBlockStmt(fromClause.pos);
            BLangAssignment errorValueAssignment = ASTBuilderUtil.createAssignmentStmt(fromClause.pos, outputVarRef, resultReferenceInWhile);
            errorCheckIfBody.addStatement(errorValueAssignment);
            errorCheckIfBody.addStatement(TreeBuilder.createBreakNode());
            BLangIf errorCheckIf = this.createTypeCheckIfNode(fromClause.pos, resultReferenceInWhile, this.desugar.getErrorTypeNode(), errorCheckIfBody);
            nullCheckIf.elseStmt = errorCheckIf;
            BLangBlockStmt elseBody = ASTBuilderUtil.createBlockStmt(fromClause.pos);
            BLangAssignment resultAssignment = this.desugar.getIteratorNextAssignment(fromClause.pos, iteratorSymbol, resultSymbol);
            VariableDefinitionNode variableDefinitionNode = fromClause.variableDefinitionNode;
            BLangFieldBasedAccess valueAccessExpr = this.desugar.getValueAccessExpression(fromClause.pos, fromClause.varType, resultSymbol);
            valueAccessExpr.expr = this.desugar.addConversionExprIfRequired(valueAccessExpr.expr, this.types.getSafeType(valueAccessExpr.expr.type, true, false));
            variableDefinitionNode.getVariable().setInitialExpression(this.desugar.addConversionExprIfRequired(valueAccessExpr, fromClause.varType));
            elseBody.stmts.add(0, (BLangStatement)((Object)variableDefinitionNode));
            errorCheckIf.elseStmt = elseBody;
            BLangBlockStmt outputErrorCheckIfBody = ASTBuilderUtil.createBlockStmt(fromClause.pos);
            outputErrorCheckIfBody.addStatement(TreeBuilder.createBreakNode());
            BLangIf outputErrorCheckIf = this.createTypeCheckIfNode(fromClause.pos, outputVarRef, this.desugar.getErrorTypeNode(), outputErrorCheckIfBody);
            BLangBlockStmt whileBody = ASTBuilderUtil.createBlockStmt(fromClause.pos);
            whileBody.addStatement(nullCheckIf);
            whileBody.addStatement(outputErrorCheckIf);
            whileBody.addStatement(resultAssignment);
            whileNode.body = whileBody;
            if (leafElseBody != null) {
                BLangBlockStmt childBlock = ASTBuilderUtil.createBlockStmt(fromClause.pos);
                childBlock.addStatement(dataVarDef);
                childBlock.addStatement(iteratorVarDef);
                childBlock.addStatement(resultVariableDefinition);
                childBlock.addStatement(whileNode);
                leafElseBody.addStatement(childBlock);
            } else {
                this.parentBlock.addStatement(dataVarDef);
                this.parentBlock.addStatement(iteratorVarDef);
                this.parentBlock.addStatement(resultVariableDefinition);
                this.parentBlock.addStatement(whileNode);
            }
            leafElseBody = elseBody;
        }
        return leafElseBody;
    }

    private BLangIf createTypeCheckIfNode(DiagnosticPos pos, BLangExpression expr, BLangType type, BLangBlockStmt body) {
        BLangTypeTestExpr testExpr = ASTBuilderUtil.createTypeTestExpr(pos, expr, type);
        testExpr.type = this.symTable.booleanType;
        BLangIf typeCheckIf = (BLangIf)TreeBuilder.createIfElseStatementNode();
        typeCheckIf.pos = pos;
        typeCheckIf.expr = testExpr;
        typeCheckIf.body = body;
        return typeCheckIf;
    }

    private void buildLetClauseBlock(List<BLangLetClause> letClauseList, BLangBlockStmt bLangBlockStmt) {
        if (letClauseList != null) {
            for (BLangLetClause letClause : letClauseList) {
                for (BLangLetVariable letVariable : letClause.letVarDeclarations) {
                    bLangBlockStmt.addStatement(letVariable.definitionNode);
                }
            }
        }
    }

    private void buildWhereClauseBlock(List<BLangWhereClause> whereClauseList, List<BLangLetClause> letClauseList, BLangBlockStmt elseBlock, BLangBlockStmt bodyBlock, DiagnosticPos pos) {
        BLangBlockStmt stmtBlock = ASTBuilderUtil.createBlockStmt(pos);
        if (whereClauseList.size() > 0) {
            BLangIf outerIf = null;
            BLangIf innerIf = null;
            for (BLangWhereClause whereClause : whereClauseList) {
                BLangIf bLangIf = (BLangIf)TreeBuilder.createIfElseStatementNode();
                bLangIf.pos = whereClause.pos;
                bLangIf.expr = whereClause.expression;
                if (innerIf != null) {
                    BLangBlockStmt bLangBlockStmt = ASTBuilderUtil.createBlockStmt(whereClause.pos);
                    bLangBlockStmt.addStatement(bLangIf);
                    innerIf.setBody(bLangBlockStmt);
                } else {
                    outerIf = bLangIf;
                }
                innerIf = bLangIf;
            }
            innerIf.setBody(bodyBlock);
            this.buildLetClauseBlock(letClauseList, stmtBlock);
            stmtBlock.addStatement(outerIf);
        } else {
            this.buildLetClauseBlock(letClauseList, stmtBlock);
            stmtBlock.stmts.addAll(bodyBlock.getStatements());
        }
        elseBlock.getStatements().addAll(stmtBlock.getStatements());
    }

    private BLangInvocation createLangLibInvocation(String functionName, final BLangExpression onExpr, final List<BLangExpression> requiredArgs, final List<BLangExpression> restArgs, BType retType, DiagnosticPos pos) {
        BLangInvocation invocationNode = (BLangInvocation)TreeBuilder.createInvocationNode();
        invocationNode.pos = pos;
        BLangIdentifier name = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        name.setLiteral(false);
        name.setValue(functionName);
        name.pos = pos;
        invocationNode.name = name;
        invocationNode.pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        invocationNode.symbol = this.symResolver.lookupLangLibMethod(onExpr.type, this.names.fromString(functionName));
        invocationNode.argExprs = new ArrayList<BLangExpression>(){
            {
                this.add(onExpr);
                this.addAll(requiredArgs);
                this.addAll(restArgs);
            }
        };
        invocationNode.requiredArgs = new ArrayList<BLangExpression>(){
            {
                this.add(onExpr);
                this.addAll(requiredArgs);
            }
        };
        invocationNode.restArgs = restArgs;
        invocationNode.type = retType != null ? retType : ((BInvokableSymbol)invocationNode.symbol).retType;
        return invocationNode;
    }
}

