/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.parser;

import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.ballerinalang.model.Whitespace;
import org.ballerinalang.model.tree.CompilationUnitNode;
import org.wso2.ballerinalang.compiler.parser.BLangParserListener;
import org.wso2.ballerinalang.compiler.parser.antlr4.BallerinaLexer;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.diagnotic.BDiagnosticSource;

public class BLangWSPreservingParserListener
extends BLangParserListener {
    private final Stack<Stack<TokenRange>> rangesOfRuleContext = new Stack();
    private Set<Whitespace> usedTokens = new TreeSet<Whitespace>();
    private final CommonTokenStream tokenStream;
    private final CompilationUnitNode compUnit;
    private ParserRuleContext getWSWasCalledOn;
    private SortedSet<Whitespace> wsSinceLastNode = new TreeSet<Whitespace>();

    public BLangWSPreservingParserListener(CompilerContext context, CommonTokenStream tokenStream, CompilationUnitNode compUnit, BDiagnosticSource diagnosticSrc) {
        super(context, compUnit, diagnosticSrc);
        this.tokenStream = tokenStream;
        this.compUnit = compUnit;
        this.createNewRange(-1);
    }

    private void createNewRange(int tokenIndex) {
        Stack<TokenRange> current = new Stack<TokenRange>();
        current.push(new TokenRange(tokenIndex));
        this.rangesOfRuleContext.push(current);
    }

    private void closeLastRange(int rangeEndIndex) {
        if (!this.rangesOfRuleContext.isEmpty()) {
            Stack<TokenRange> rangesOfLastRuleContext = this.rangesOfRuleContext.peek();
            TokenRange range = rangesOfLastRuleContext.peek();
            range.to = rangeEndIndex;
        }
    }

    private ParseTree getLastTerminalNode(ParserRuleContext parserRuleContext) {
        int childCount = parserRuleContext.getChildCount();
        ParseTree child = null;
        for (int i = childCount - 1; i >= 0; --i) {
            if (!(parserRuleContext.getChild(i) instanceof TerminalNode)) continue;
            child = parserRuleContext.getChild(i);
            break;
        }
        return child;
    }

    @Override
    public void enterEveryRule(ParserRuleContext parserRuleContext) {
        int tokenIndex = parserRuleContext.start.getTokenIndex();
        this.closeLastRange(tokenIndex);
        this.createNewRange(tokenIndex);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void exitEveryRule(ParserRuleContext parserRuleContext) {
        int rangeEndTokenIndex;
        if (this.getWSWasCalledOn == parserRuleContext) {
            return;
        }
        if (parserRuleContext.stop == null) {
            ParseTree child = this.getLastTerminalNode(parserRuleContext);
            if (!(child instanceof TerminalNode)) {
                this.rangesOfRuleContext.pop();
                return;
            }
            rangeEndTokenIndex = ((TerminalNode)child).getSymbol().getTokenIndex() + 1;
        } else {
            rangeEndTokenIndex = parserRuleContext.stop.getTokenIndex() + 1;
        }
        this.closeLastRange(rangeEndTokenIndex);
        Stack<Object> tokenRanges = new Stack();
        if (!this.rangesOfRuleContext.isEmpty()) {
            tokenRanges = this.rangesOfRuleContext.pop();
        }
        Stack<Whitespace> ws = new Stack<Whitespace>();
        for (TokenRange tokenRange : tokenRanges) {
            this.addWSFromRange(ws, tokenRange);
        }
        this.wsSinceLastNode.addAll(ws);
        if (!this.rangesOfRuleContext.isEmpty()) {
            this.rangesOfRuleContext.peek().add(new TokenRange(rangeEndTokenIndex));
        }
    }

    private void addWSFromRange(Stack<Whitespace> ws, TokenRange range) {
        int rangeStart = range.from;
        int rangeEnd = range.to;
        boolean lastTokenWasHidden = true;
        Token previousNonWS = null;
        for (int j = rangeEnd - 1; j >= -1; --j) {
            if (j == -1) {
                if (lastTokenWasHidden) break;
                this.pushWS(ws, previousNonWS, "");
                break;
            }
            Token token = this.tokenStream.get(j);
            if (previousNonWS == null && token.getChannel() == 1) continue;
            if (token.getChannel() == 0) {
                if (j < rangeStart) {
                    if (lastTokenWasHidden) break;
                    this.pushWS(ws, previousNonWS, "");
                    break;
                }
                if (!lastTokenWasHidden) {
                    this.pushWS(ws, previousNonWS, "");
                }
                lastTokenWasHidden = false;
                previousNonWS = token;
                continue;
            }
            if (lastTokenWasHidden) {
                ws.peek().prependWS(token.getText());
            } else {
                this.pushWS(ws, previousNonWS, token.getText());
            }
            lastTokenWasHidden = true;
        }
    }

    private static boolean isAllUpper(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (Character.isUpperCase(ch) || ch == '_') continue;
            return false;
        }
        return true;
    }

    private void pushWS(Stack<Whitespace> whitespaceStack, Token previousNonWS, String wsString) {
        boolean isStatic = BLangWSPreservingParserListener.isAllUpper(BallerinaLexer.VOCABULARY.getSymbolicName(previousNonWS.getType()));
        Whitespace wsToken = new Whitespace(previousNonWS.getTokenIndex(), wsString, previousNonWS.getText(), isStatic);
        whitespaceStack.push(wsToken);
    }

    @Override
    protected Set<Whitespace> getWS(ParserRuleContext parserRuleContext) {
        this.exitEveryRule(parserRuleContext);
        this.getWSWasCalledOn = parserRuleContext;
        SortedSet<Whitespace> wsForThisNode = this.wsSinceLastNode;
        Iterator iterator = wsForThisNode.iterator();
        while (iterator.hasNext()) {
            Whitespace ws = (Whitespace)iterator.next();
            if (this.usedTokens.contains(ws)) {
                iterator.remove();
                continue;
            }
            this.usedTokens.add(ws);
        }
        this.wsSinceLastNode = new TreeSet<Whitespace>();
        return wsForThisNode;
    }

    private static class TokenRange {
        int from;
        int to;

        TokenRange(int from) {
            this.from = from;
            this.to = -1;
        }

        public String toString() {
            return "(" + this.from + "," + this.to + ")";
        }
    }
}

