/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util.diagnotic;

import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticCode;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.diagnotic.BDiagnostic;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLog;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class BLangDiagnosticLogHelper
implements DiagnosticLog {
    private final BLangDiagnosticLog consoleDLog;
    private final ErrorCountingBLangDiagnosticLog nonConsoleDLog;
    private BLangDiagnosticLog currentLog;
    private static final CompilerContext.Key<BLangDiagnosticLogHelper> DIAGNOSTIC_LOG_HELPER_KEY = new CompilerContext.Key();

    public static BLangDiagnosticLogHelper getInstance(CompilerContext context) {
        BLangDiagnosticLogHelper dLogHelper = context.get(DIAGNOSTIC_LOG_HELPER_KEY);
        if (dLogHelper == null) {
            dLogHelper = new BLangDiagnosticLogHelper(context);
        }
        return dLogHelper;
    }

    private BLangDiagnosticLogHelper(CompilerContext context) {
        context.put(DIAGNOSTIC_LOG_HELPER_KEY, this);
        this.currentLog = this.consoleDLog = BLangDiagnosticLog.getInstance(context);
        this.nonConsoleDLog = new ErrorCountingBLangDiagnosticLog();
    }

    public void error(DiagnosticPos pos, DiagnosticCode code, Object ... args) {
        this.currentLog.error(pos, code, args);
    }

    public void warning(DiagnosticPos pos, DiagnosticCode code, Object ... args) {
        this.currentLog.warning(pos, code, args);
    }

    public void note(DiagnosticPos pos, DiagnosticCode code, Object ... args) {
        this.currentLog.note(pos, code, args);
    }

    @Override
    public void logDiagnostic(Diagnostic.Kind kind, Diagnostic.DiagnosticPosition pos, CharSequence message) {
        this.currentLog.reportDiagnostic(new BDiagnostic(kind, (DiagnosticPos)pos, message.toString()));
    }

    public BLangDiagnosticLog getCurrentLog() {
        return this.currentLog;
    }

    public void setCurrentLog(BLangDiagnosticLog bLangDiagnosticLog) {
        this.currentLog = bLangDiagnosticLog;
    }

    public void setNonConsoleDLog() {
        this.currentLog = this.nonConsoleDLog;
    }

    public int getErrorCount() {
        return this.currentLog.errorCount;
    }

    public void resetErrorCount() {
        this.currentLog.errorCount = 0;
    }

    static class ErrorCountingBLangDiagnosticLog
    extends BLangDiagnosticLog {
        ErrorCountingBLangDiagnosticLog() {
        }

        @Override
        protected void reportDiagnostic(BDiagnostic diagnostic) {
            if (diagnostic.kind == Diagnostic.Kind.ERROR) {
                ++this.errorCount;
            }
        }
    }
}

