/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.repo;

import java.nio.file.Path;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.converters.PathConverter;
import org.wso2.ballerinalang.compiler.packaging.repo.Repo;
import org.wso2.ballerinalang.util.RepoUtils;

public class HomeBirRepo
implements Repo<Path> {
    private PathConverter pathConverter;

    public HomeBirRepo() {
        Path repoLocation = RepoUtils.createAndGetHomeReposPath().resolve("bir_cache-" + RepoUtils.getBallerinaVersion());
        this.pathConverter = new PathConverter(repoLocation);
    }

    @Override
    public Patten calculate(PackageID moduleID) {
        String orgName = moduleID.getOrgName().getValue();
        String pkgName = moduleID.getName().getValue();
        String versionStr = moduleID.getPackageVersion().getValue();
        Patten.Part version = versionStr.isEmpty() ? Patten.LATEST_VERSION_DIR : Patten.path(versionStr);
        return new Patten(Patten.path(orgName, pkgName), version, Patten.path(pkgName + ".bir"));
    }

    @Override
    public Converter<Path> getConverterInstance() {
        return this.pathConverter;
    }

    public String toString() {
        return "{t:'HomeBirRepo', c:'" + this.pathConverter + "'}";
    }
}

