/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.symbols;

import java.util.Set;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.model.symbols.SymbolKind;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BErrorTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BPackageSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BServiceSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BXMLNSSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;

public class Symbols {
    public static BPackageSymbol createPackageSymbol(PackageID packageID, SymbolTable symTable) {
        BPackageSymbol pkgSymbol = new BPackageSymbol(packageID, symTable.rootPkgSymbol);
        return Symbols.createPackageSymbolScope(symTable, pkgSymbol);
    }

    public static BPackageSymbol createPackageSymbol(PackageID packageID, SymbolTable symTable, int flags) {
        BPackageSymbol pkgSymbol = new BPackageSymbol(packageID, symTable.rootPkgSymbol, flags);
        return Symbols.createPackageSymbolScope(symTable, pkgSymbol);
    }

    private static BPackageSymbol createPackageSymbolScope(SymbolTable symTable, BPackageSymbol pkgSymbol) {
        pkgSymbol.scope = pkgSymbol.pkgID.equals(PackageID.ANNOTATIONS) ? symTable.rootScope : new Scope(pkgSymbol);
        return pkgSymbol;
    }

    public static BTypeSymbol createObjectSymbol(int flags, Name name, PackageID pkgID, BType type, BSymbol owner) {
        BObjectTypeSymbol typeSymbol = new BObjectTypeSymbol(196700, flags, name, pkgID, type, owner);
        typeSymbol.kind = SymbolKind.OBJECT;
        return typeSymbol;
    }

    public static BRecordTypeSymbol createRecordSymbol(int flags, Name name, PackageID pkgID, BType type, BSymbol owner) {
        BRecordTypeSymbol typeSymbol = new BRecordTypeSymbol(327772, flags, name, pkgID, type, owner);
        typeSymbol.kind = SymbolKind.RECORD;
        return typeSymbol;
    }

    public static BErrorTypeSymbol createErrorSymbol(int flags, Name name, PackageID pkgID, BType type, BSymbol owner) {
        BErrorTypeSymbol typeSymbol = new BErrorTypeSymbol(589852, flags, name, pkgID, type, owner);
        typeSymbol.kind = SymbolKind.ERROR;
        return typeSymbol;
    }

    @Deprecated
    public static BAnnotationSymbol createAnnotationSymbol(int flags, int maskedPoints, Name name, PackageID pkgID, BType type, BSymbol owner) {
        BAnnotationSymbol annotationSymbol = new BAnnotationSymbol(name, flags, maskedPoints, pkgID, type, owner);
        annotationSymbol.kind = SymbolKind.ANNOTATION;
        return annotationSymbol;
    }

    public static BAnnotationSymbol createAnnotationSymbol(int flags, Set<AttachPoint> points, Name name, PackageID pkgID, BType type, BSymbol owner) {
        BAnnotationSymbol annotationSymbol = new BAnnotationSymbol(name, flags, points, pkgID, type, owner);
        annotationSymbol.kind = SymbolKind.ANNOTATION;
        return annotationSymbol;
    }

    public static BInvokableSymbol createWorkerSymbol(int flags, Name name, PackageID pkgID, BType type, BSymbol owner) {
        BInvokableSymbol symbol = Symbols.createInvokableSymbol(1284, flags, name, pkgID, type, owner);
        symbol.kind = SymbolKind.WORKER;
        return symbol;
    }

    public static BServiceSymbol createServiceSymbol(int flags, Name name, PackageID pkgID, BType type, BSymbol owner) {
        BServiceSymbol serviceSymbol = new BServiceSymbol(flags, name, pkgID, type, owner);
        serviceSymbol.kind = SymbolKind.SERVICE;
        return serviceSymbol;
    }

    public static BInvokableSymbol createFunctionSymbol(int flags, Name name, PackageID pkgID, BType type, BSymbol owner, boolean bodyExist) {
        BInvokableSymbol symbol = Symbols.createInvokableSymbol(820, flags, name, pkgID, type, owner);
        symbol.bodyExist = bodyExist;
        symbol.kind = SymbolKind.FUNCTION;
        return symbol;
    }

    public static BTypeSymbol createTypeSymbol(int symTag, int flags, Name name, PackageID pkgID, BType type, BSymbol owner) {
        if (type != null && type.tag == 16) {
            return Symbols.createInvokableTypeSymbol(symTag, flags, pkgID, type, owner);
        }
        return new BTypeSymbol(symTag, flags, name, pkgID, type, owner);
    }

    public static BInvokableTypeSymbol createInvokableTypeSymbol(int symTag, int flags, PackageID pkgID, BType type, BSymbol owner) {
        return new BInvokableTypeSymbol(symTag, flags, pkgID, type, owner);
    }

    public static BInvokableSymbol createInvokableSymbol(int kind, int flags, Name name, PackageID pkgID, BType type, BSymbol owner) {
        return new BInvokableSymbol(kind, flags, name, pkgID, type, owner);
    }

    public static BXMLNSSymbol createXMLNSSymbol(Name name, String nsURI, PackageID pkgID, BSymbol owner) {
        return new BXMLNSSymbol(name, nsURI, pkgID, owner);
    }

    public static String getAttachedFuncSymbolName(String typeName, String funcName) {
        return typeName + Names.DOT.value + funcName;
    }

    public static boolean isNative(BSymbol sym) {
        return (sym.flags & 2) == 2;
    }

    public static boolean isPublic(BSymbol sym) {
        return (sym.flags & 1) == 1;
    }

    public static boolean isPrivate(BSymbol sym) {
        return (sym.flags & 0x400) == 1024;
    }

    public static boolean isFlagOn(int mask, int flag) {
        return (mask & flag) == flag;
    }

    public static boolean isAttachPointPresent(int mask, int attachPoint) {
        return (mask & attachPoint) != 0;
    }

    public static boolean isOptional(BSymbol sym) {
        return (sym.flags & 0x2000) == 8192;
    }

    public static boolean isFunctionDeclaration(BSymbol sym) {
        return (sym.flags & 0x80) == 128;
    }
}

