/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.repository;

import java.util.LinkedHashSet;
import java.util.Set;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.repository.PackageEntity;
import org.ballerinalang.repository.PackageRepository;

public abstract class HierarchicalPackageRepository
implements PackageRepository {
    private static final String BALLERINA_SYSTEM_PKG_PREFIX = "ballerina";
    private PackageRepository systemRepo;
    private PackageRepository parentRepo;
    private Set<PackageID> cachedPackageIds;

    public HierarchicalPackageRepository(PackageRepository systemRepo, PackageRepository parentRepo) {
        this.systemRepo = systemRepo;
        this.parentRepo = parentRepo;
    }

    public abstract PackageEntity lookupPackage(PackageID var1);

    public abstract PackageEntity lookupPackage(PackageID var1, String var2);

    public abstract Set<PackageID> lookupPackageIDs(int var1);

    @Override
    public PackageEntity loadPackage(PackageID pkgId) {
        PackageEntity result = null;
        if (this.isSystemPackage(pkgId)) {
            result = this.systemRepo.loadPackage(pkgId);
        }
        if (result != null) {
            return result;
        }
        result = this.lookupPackage(pkgId);
        if (result == null && this.parentRepo != null) {
            result = this.parentRepo.loadPackage(pkgId);
        }
        return result;
    }

    @Override
    public PackageEntity loadPackage(PackageID pkgId, String entryName) {
        PackageEntity result = null;
        if (this.isSystemPackage(pkgId)) {
            result = this.systemRepo.loadPackage(pkgId, entryName);
        }
        if (result != null) {
            return result;
        }
        result = this.lookupPackage(pkgId, entryName);
        if (result == null && this.parentRepo != null) {
            result = this.parentRepo.loadPackage(pkgId, entryName);
        }
        return result;
    }

    private boolean isSystemPackage(PackageID pkgID) {
        return pkgID.getNameComp(0).getValue().equals(BALLERINA_SYSTEM_PKG_PREFIX);
    }

    @Override
    public Set<PackageID> listPackages(int maxDepth) {
        if (this.cachedPackageIds == null) {
            this.cachedPackageIds = new LinkedHashSet<PackageID>(this.systemRepo.listPackages(maxDepth));
            if (this.parentRepo != null) {
                this.cachedPackageIds.addAll(this.parentRepo.listPackages(maxDepth));
            }
            this.cachedPackageIds.addAll(this.lookupPackageIDs(maxDepth));
        }
        return this.cachedPackageIds;
    }
}

