/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.Nilable;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.InstructionKind;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class JvmDesugarPhase {
    public static void addDefaultableBooleanVarsToSignature(@Nilable BIRNode.BIRFunction func) {
        BIRNode.BIRFunction currentFunc = JvmMethodGen.getFunction(func);
        BInvokableType type = currentFunc.type = new BInvokableType(currentFunc.type.paramTypes, currentFunc.type.restType, currentFunc.type.retType, currentFunc.type.tsymbol);
        currentFunc.type.paramTypes = JvmDesugarPhase.updateParamTypesWithDefaultableBooleanVar(currentFunc.type.paramTypes, type != null ? type.restType : type);
        int index = 0;
        ArrayList<BIRNode.BIRVariableDcl> updatedVars = new ArrayList<BIRNode.BIRVariableDcl>();
        List<BIRNode.BIRVariableDcl> localVars = currentFunc.localVars;
        int nameIndex = 0;
        for (BIRNode.BIRVariableDcl localVar : localVars) {
            updatedVars.add(index, localVar);
            ++index;
            if (!(localVar instanceof BIRNode.BIRFunctionParameter)) continue;
            String argName = "%syn" + nameIndex;
            ++nameIndex;
            BIRNode.BIRFunctionParameter booleanVar = new BIRNode.BIRFunctionParameter(null, JvmPackageGen.symbolTable.booleanType, new Name(argName), VarScope.FUNCTION, VarKind.ARG, "", false);
            updatedVars.add(index, booleanVar);
            ++index;
        }
        currentFunc.localVars = updatedVars;
    }

    public static void enrichWithDefaultableParamInits(BIRNode.BIRFunction currentFunc) {
        ArrayList<BIRNode.BIRFunctionParameter> functionParams = new ArrayList<BIRNode.BIRFunctionParameter>();
        List<BIRNode.BIRVariableDcl> localVars = currentFunc.localVars;
        for (int k = 1; k < localVars.size(); ++k) {
            BIRNode.BIRVariableDcl localVar = JvmMethodGen.getVariableDcl(localVars.get(k));
            if (!(localVar instanceof BIRNode.BIRFunctionParameter)) continue;
            functionParams.add((BIRNode.BIRFunctionParameter)localVar);
        }
        JvmMethodGen.nextId = -1;
        JvmMethodGen.nextVarId = -1;
        ArrayList<BIRNode.BIRBasicBlock> basicBlocks = new ArrayList<BIRNode.BIRBasicBlock>();
        BIRNode.BIRBasicBlock nextBB = JvmDesugarPhase.insertAndGetNextBasicBlock(basicBlocks, "desugaredBB");
        DiagnosticPos pos = currentFunc.pos;
        for (int paramCounter = 0; paramCounter < functionParams.size(); paramCounter += 2) {
            BIRNode.BIRFunctionParameter funcParam = (BIRNode.BIRFunctionParameter)functionParams.get(paramCounter);
            if (funcParam == null || !funcParam.hasDefaultExpr) continue;
            int boolParam = paramCounter + 1;
            BIRNode.BIRFunctionParameter funcBooleanParam = JvmMethodGen.getFunctionParam((BIRNode.BIRFunctionParameter)functionParams.get(boolParam));
            BIROperand boolRef = new BIROperand(funcBooleanParam);
            BIRNonTerminator.UnaryOP notOp = new BIRNonTerminator.UnaryOP(pos, InstructionKind.NOT, boolRef, boolRef);
            nextBB.instructions.add(notOp);
            List<BIRNode.BIRBasicBlock> bbArray = currentFunc.parameters.get(funcParam);
            BIRNode.BIRBasicBlock trueBB = JvmMethodGen.getBasicBlock(bbArray.get(0));
            for (BIRNode.BIRBasicBlock defaultBB : bbArray) {
                basicBlocks.add(JvmMethodGen.getBasicBlock(defaultBB));
            }
            BIRNode.BIRBasicBlock falseBB = JvmDesugarPhase.insertAndGetNextBasicBlock(basicBlocks, "desugaredBB");
            nextBB.terminator = new BIRTerminator.Branch(pos, boolRef, trueBB, falseBB);
            BIRNode.BIRBasicBlock lastBB = JvmMethodGen.getBasicBlock(bbArray.get(bbArray.size() - 1));
            lastBB.terminator = new BIRTerminator.GOTO(pos, falseBB);
            nextBB = falseBB;
        }
        if (basicBlocks.size() == 1) {
            return;
        }
        if (currentFunc.basicBlocks.size() == 0) {
            currentFunc.basicBlocks = basicBlocks;
            return;
        }
        BIRNode.BIRBasicBlock firstBB = JvmMethodGen.getBasicBlock(currentFunc.basicBlocks.get(0));
        nextBB.terminator = new BIRTerminator.GOTO(pos, firstBB);
        basicBlocks.addAll(currentFunc.basicBlocks);
        currentFunc.basicBlocks = basicBlocks;
    }

    public static BIRNode.BIRBasicBlock insertAndGetNextBasicBlock(@Nilable List<BIRNode.BIRBasicBlock> basicBlocks, String prefix) {
        BIRNode.BIRBasicBlock nextbb = new BIRNode.BIRBasicBlock(JvmDesugarPhase.getNextDesugarBBId(prefix));
        basicBlocks.add(nextbb);
        return nextbb;
    }

    public static Name getNextDesugarBBId(String prefix) {
        return new Name(prefix + ++JvmMethodGen.nextId);
    }

    @Nilable
    private static List<BType> updateParamTypesWithDefaultableBooleanVar(@Nilable List<BType> funcParams, @Nilable BType restType) {
        int size;
        ArrayList<BType> paramTypes = new ArrayList<BType>();
        int index = 0;
        int n = size = funcParams == null ? 0 : funcParams.size();
        for (int counter = 0; counter < size; ++counter) {
            paramTypes.add(index, funcParams.get(counter));
            paramTypes.add(index + 1, JvmPackageGen.symbolTable.booleanType);
            index += 2;
        }
        if (restType != null) {
            paramTypes.add(index, restType);
            paramTypes.add(index + 1, JvmPackageGen.symbolTable.booleanType);
        }
        return paramTypes;
    }

    static void rewriteRecordInits(@Nilable List<BIRNode.BIRTypeDefinition> typeDefs) {
        for (BIRNode.BIRTypeDefinition typeDef : typeDefs) {
            BType recordType = typeDef.type;
            if (recordType.tag != 12) continue;
            List<BIRNode.BIRFunction> attachFuncs = typeDef.attachedFuncs;
            for (BIRNode.BIRFunction func : attachFuncs) {
                JvmDesugarPhase.rewriteRecordInitFunction(func, (BRecordType)recordType);
            }
        }
    }

    private static void rewriteRecordInitFunction(BIRNode.BIRFunction func, BRecordType recordType) {
        BIRNode.BIRVariableDcl receiver = func.receiver;
        func.name = new Name(JvmMethodGen.cleanupFunctionName(JvmTerminatorGen.TerminatorGenerator.toNameString(recordType) + func.name.value));
        receiver.kind = VarKind.ARG;
        String paramName = "$_" + receiver.name.value;
        receiver.name = new Name(paramName);
        BIRNode.BIRFunctionParameter selfParam = new BIRNode.BIRFunctionParameter(null, receiver.type, receiver.name, receiver.scope, VarKind.ARG, paramName, false);
        func.type = new BInvokableType(Collections.singletonList(receiver.type), func.type.restType, func.type.retType, null);
        func.type.paramTypes = Collections.singletonList(receiver.type);
        List<BIRNode.BIRVariableDcl> localVars = func.localVars;
        ArrayList<BIRNode.BIRVariableDcl> updatedLocalVars = new ArrayList<BIRNode.BIRVariableDcl>();
        updatedLocalVars.add(localVars.get(0));
        updatedLocalVars.add(selfParam);
        for (int index = 1; index < localVars.size(); ++index) {
            updatedLocalVars.add(localVars.get(index));
        }
        func.localVars = updatedLocalVars;
    }
}

