/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.elements.MarkdownDocAttachment;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.bir.model.BIRNonTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIROperand;
import org.wso2.ballerinalang.compiler.bir.model.BIRTerminator;
import org.wso2.ballerinalang.compiler.bir.model.BIRVisitor;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.NamedNode;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public abstract class BIRNode {
    public DiagnosticPos pos;

    public BIRNode(DiagnosticPos pos) {
        this.pos = pos;
    }

    public abstract void accept(BIRVisitor var1);

    public static class BIRLockDetailsHolder {
        public long numLocks = 0L;

        public boolean isEmpty() {
            return this.numLocks == 0L;
        }
    }

    public static abstract class BIRDocumentableNode
    extends BIRNode {
        public MarkdownDocAttachment markdownDocAttachment;

        public BIRDocumentableNode(DiagnosticPos pos) {
            super(pos);
        }

        public void setMarkdownDocAttachment(MarkdownDocAttachment markdownDocAttachment) {
            this.markdownDocAttachment = markdownDocAttachment;
        }
    }

    public static class TaintTable {
        public int columnCount;
        public int rowCount;
        public Map<Integer, List<Byte>> taintTable = new LinkedHashMap<Integer, List<Byte>>();
    }

    public static class ConstValue {
        public BType type;
        public Object value;

        public ConstValue(Object value, BType type) {
            this.value = value;
            this.type = type;
        }
    }

    public static class BIRAnnotationArrayValue
    extends BIRAnnotationValue {
        public BIRAnnotationValue[] annotArrayValue;

        public BIRAnnotationArrayValue(BType type, BIRAnnotationValue[] annotArrayValue) {
            super(type);
            this.annotArrayValue = annotArrayValue;
        }
    }

    public static class BIRAnnotationRecordValue
    extends BIRAnnotationValue {
        public Map<String, BIRAnnotationValue> annotValueEntryMap;

        public BIRAnnotationRecordValue(BType type, Map<String, BIRAnnotationValue> annotValueEntryMap) {
            super(type);
            this.annotValueEntryMap = annotValueEntryMap;
        }
    }

    public static class BIRAnnotationLiteralValue
    extends BIRAnnotationValue {
        public Object value;

        public BIRAnnotationLiteralValue(BType type, Object value) {
            super(type);
            this.value = value;
        }
    }

    public static abstract class BIRAnnotationValue {
        public BType type;

        public BIRAnnotationValue(BType type) {
            this.type = type;
        }
    }

    public static class BIRAnnotationAttachment
    extends BIRNode {
        public PackageID packageID;
        public Name annotTagRef;
        public List<BIRAnnotationValue> annotValues;

        public BIRAnnotationAttachment(DiagnosticPos pos, Name annotTagRef) {
            super(pos);
            this.annotTagRef = annotTagRef;
            this.annotValues = new ArrayList<BIRAnnotationValue>();
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRConstant
    extends BIRDocumentableNode {
        public Name name;
        public int flags;
        public BType type;
        public ConstValue constValue;

        public BIRConstant(DiagnosticPos pos, Name name, int flags, BType type, ConstValue constValue) {
            super(pos);
            this.name = name;
            this.flags = flags;
            this.type = type;
            this.constValue = constValue;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRAnnotation
    extends BIRDocumentableNode {
        public Name name;
        public int flags;
        public Set<AttachPoint> attachPoints;
        public BType annotationType;

        public BIRAnnotation(DiagnosticPos pos, Name name, int flags, Set<AttachPoint> points, BType annotationType) {
            super(pos);
            this.name = name;
            this.flags = flags;
            this.attachPoints = points;
            this.annotationType = annotationType;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class ChannelDetails {
        public String name;
        public boolean channelInSameStrand;
        public boolean send;

        public ChannelDetails(String name, boolean channelInSameStrand, boolean send) {
            this.name = name;
            this.channelInSameStrand = channelInSameStrand;
            this.send = send;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class BIRErrorEntry
    extends BIRNode {
        public BIRBasicBlock trapBB;
        public BIRBasicBlock endBB;
        public BIROperand errorOp;
        public BIRBasicBlock targetBB;

        public BIRErrorEntry(BIRBasicBlock trapBB, BIRBasicBlock endBB, BIROperand errorOp, BIRBasicBlock targetBB) {
            super(null);
            this.trapBB = trapBB;
            this.endBB = endBB;
            this.errorOp = errorOp;
            this.targetBB = targetBB;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRTypeDefinition
    extends BIRDocumentableNode
    implements NamedNode {
        public Name name;
        public List<BIRFunction> attachedFuncs;
        public int flags;
        public BType type;
        public boolean isLabel;
        public boolean isBuiltin;
        public List<BType> referencedTypes;
        public int index;

        public BIRTypeDefinition(DiagnosticPos pos, Name name, int flags, boolean isLabel, boolean isBuiltin, BType type, List<BIRFunction> attachedFuncs) {
            super(pos);
            this.name = name;
            this.flags = flags;
            this.isLabel = isLabel;
            this.isBuiltin = isBuiltin;
            this.type = type;
            this.attachedFuncs = attachedFuncs;
            this.referencedTypes = new ArrayList<BType>();
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return String.valueOf(this.type) + " " + String.valueOf(this.name);
        }

        @Override
        public Name getName() {
            return this.name;
        }
    }

    public static class BIRBasicBlock
    extends BIRNode {
        public Name id;
        public List<BIRNonTerminator> instructions;
        public BIRTerminator terminator;

        public BIRBasicBlock(Name id) {
            super(null);
            this.id = id;
            this.instructions = new ArrayList<BIRNonTerminator>();
            this.terminator = null;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        public String toString() {
            return this.id.value;
        }
    }

    public static class BIRFunction
    extends BIRDocumentableNode
    implements NamedNode {
        public Name name;
        public int flags;
        public BInvokableType type;
        public List<BIRParameter> requiredParams;
        public BIRVariableDcl receiver;
        public BIRParameter restParam;
        public int argsCount;
        public List<BIRVariableDcl> localVars;
        public BIRVariableDcl returnVariable;
        public Map<BIRFunctionParameter, List<BIRBasicBlock>> parameters;
        public List<BIRBasicBlock> basicBlocks;
        public List<BIRErrorEntry> errorTable;
        public Name workerName;
        public ChannelDetails[] workerChannels;
        public TaintTable taintTable;
        public List<BIRAnnotationAttachment> annotAttachments;

        public BIRFunction(DiagnosticPos pos, Name name, int flags, BInvokableType type, Name workerName, int sendInsCount, TaintTable taintTable) {
            super(pos);
            this.name = name;
            this.flags = flags;
            this.type = type;
            this.localVars = new ArrayList<BIRVariableDcl>();
            this.parameters = new LinkedHashMap<BIRFunctionParameter, List<BIRBasicBlock>>();
            this.requiredParams = new ArrayList<BIRParameter>();
            this.basicBlocks = new ArrayList<BIRBasicBlock>();
            this.errorTable = new ArrayList<BIRErrorEntry>();
            this.workerName = workerName;
            this.workerChannels = new ChannelDetails[sendInsCount];
            this.taintTable = taintTable;
            this.annotAttachments = new ArrayList<BIRAnnotationAttachment>();
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        public BIRFunction duplicate() {
            BIRFunction f = new BIRFunction(this.pos, this.name, this.flags, this.type, this.workerName, 0, this.taintTable);
            f.localVars = this.localVars;
            f.parameters = this.parameters;
            f.requiredParams = this.requiredParams;
            f.basicBlocks = this.basicBlocks;
            f.errorTable = this.errorTable;
            f.workerChannels = this.workerChannels;
            f.annotAttachments = this.annotAttachments;
            return f;
        }

        @Override
        public Name getName() {
            return this.name;
        }
    }

    public static class BIRFunctionParameter
    extends BIRVariableDcl {
        public final boolean hasDefaultExpr;

        public BIRFunctionParameter(DiagnosticPos pos, BType type, Name name, VarScope scope, VarKind kind, String metaVarName, boolean hasDefaultExpr) {
            super(pos, type, name, scope, kind, metaVarName);
            this.hasDefaultExpr = hasDefaultExpr;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRGlobalVariableDcl
    extends BIRVariableDcl {
        public int flags;
        public PackageID pkgId;

        public BIRGlobalVariableDcl(DiagnosticPos pos, int flags, BType type, PackageID pkgId, Name name, VarScope scope, VarKind kind, String metaVarName) {
            super(pos, type, name, scope, kind, metaVarName);
            this.flags = flags;
            this.pkgId = pkgId;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRParameter
    extends BIRNode {
        public Name name;
        public int flags;

        public BIRParameter(DiagnosticPos pos, Name name, int flags) {
            super(pos);
            this.name = name;
            this.flags = flags;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRVariableDcl
    extends BIRDocumentableNode {
        public BType type;
        public Name name;
        public String metaVarName;
        public VarKind kind;
        public VarScope scope;
        public boolean ignoreVariable;
        public BIRBasicBlock endBB;
        public BIRBasicBlock startBB;
        public int insOffset;

        public BIRVariableDcl(DiagnosticPos pos, BType type, Name name, VarScope scope, VarKind kind, String metaVarName) {
            super(pos);
            this.type = type;
            this.name = name;
            this.scope = scope;
            this.kind = kind;
            this.metaVarName = metaVarName;
        }

        public BIRVariableDcl(BType type, Name name, VarScope scope, VarKind kind) {
            this(null, type, name, scope, kind, null);
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BIRVariableDcl)) {
                return false;
            }
            BIRVariableDcl otherVarDecl = (BIRVariableDcl)other;
            return this.name.equals(otherVarDecl.name);
        }

        public int hashCode() {
            return this.name.value.hashCode();
        }

        public String toString() {
            return this.name.toString();
        }
    }

    public static class BIRImportModule
    extends BIRNode {
        public Name org;
        public Name name;
        public Name version;

        public BIRImportModule(DiagnosticPos pos, Name org, Name name, Name version) {
            super(pos);
            this.org = org;
            this.name = name;
            this.version = version;
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BIRPackage
    extends BIRNode {
        public Name org;
        public Name name;
        public Name version;
        public Name sourceFileName;
        public List<BIRImportModule> importModules;
        public List<BIRTypeDefinition> typeDefs;
        public List<BIRGlobalVariableDcl> globalVars;
        public List<BIRFunction> functions;
        public List<BIRAnnotation> annotations;
        public List<BIRConstant> constants;

        public BIRPackage(DiagnosticPos pos, Name org, Name name, Name version, Name sourceFileName) {
            super(pos);
            this.org = org;
            this.name = name;
            this.version = version;
            this.sourceFileName = sourceFileName;
            this.importModules = new ArrayList<BIRImportModule>();
            this.typeDefs = new ArrayList<BIRTypeDefinition>();
            this.globalVars = new ArrayList<BIRGlobalVariableDcl>();
            this.functions = new ArrayList<BIRFunction>();
            this.annotations = new ArrayList<BIRAnnotation>();
            this.constants = new ArrayList<BIRConstant>();
        }

        @Override
        public void accept(BIRVisitor visitor) {
            visitor.visit(this);
        }

        public Name getSourceFileName() {
            return this.sourceFileName;
        }
    }
}

