/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.writer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ballerinalang.compiler.BLangCompilerException;
import org.wso2.ballerinalang.compiler.bir.writer.BIRTypeWriter;
import org.wso2.ballerinalang.compiler.bir.writer.CPEntry;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;

public class ConstantPool {
    private static final int NULL_VALUE_FIELD_SIZE_TAG = -1;
    private final Map<CPEntry, Integer> cpEntriesMap = new HashMap<CPEntry, Integer>();
    private final List<CPEntry> cpEntries = new ArrayList<CPEntry>();

    public int addCPEntry(CPEntry cpEntry) {
        int size = this.cpEntries.size();
        Integer position = this.cpEntriesMap.get(cpEntry);
        if (position == null) {
            this.cpEntries.add(cpEntry);
            this.cpEntriesMap.put(cpEntry, size);
            return size;
        }
        return position;
    }

    public int addShapeCPEntry(BType shape) {
        CPEntry.ShapeCPEntry shapeCPEntry = new CPEntry.ShapeCPEntry(shape);
        return this.addCPEntry(shapeCPEntry);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] serialize() {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        try (DataOutputStream dataStream = new DataOutputStream(byteArrayStream);){
            this.writeToStream(dataStream);
            dataStream.flush();
            byte[] bytes = byteArrayStream.toByteArray();
            this.overwriteSize(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        catch (IOException e) {
            throw new BLangCompilerException("failed to create bir consent pool", e);
        }
    }

    private void overwriteSize(byte[] bytes) {
        int v = this.cpEntries.size();
        bytes[0] = (byte)(v >>> 24 & 0xFF);
        bytes[1] = (byte)(v >>> 16 & 0xFF);
        bytes[2] = (byte)(v >>> 8 & 0xFF);
        bytes[3] = (byte)(v >>> 0 & 0xFF);
    }

    private void writeToStream(DataOutputStream stream) throws IOException {
        stream.writeInt(-1);
        block9: for (int i = 0; i < this.cpEntries.size(); ++i) {
            CPEntry cpEntry = this.cpEntries.get(i);
            stream.writeByte(cpEntry.entryType.value);
            switch (cpEntry.entryType) {
                case CP_ENTRY_INTEGER: {
                    stream.writeLong(((CPEntry.IntegerCPEntry)cpEntry).value);
                    continue block9;
                }
                case CP_ENTRY_BYTE: {
                    stream.writeInt(((CPEntry.ByteCPEntry)cpEntry).value);
                    continue block9;
                }
                case CP_ENTRY_FLOAT: {
                    stream.writeDouble(((CPEntry.FloatCPEntry)cpEntry).value);
                    continue block9;
                }
                case CP_ENTRY_BOOLEAN: {
                    stream.writeBoolean(((CPEntry.BooleanCPEntry)cpEntry).value);
                    continue block9;
                }
                case CP_ENTRY_STRING: {
                    CPEntry.StringCPEntry stringCPEntry = (CPEntry.StringCPEntry)cpEntry;
                    if (stringCPEntry.value != null) {
                        byte[] strBytes = stringCPEntry.value.getBytes(StandardCharsets.UTF_8);
                        stream.writeInt(strBytes.length);
                        stream.write(strBytes);
                        continue block9;
                    }
                    stream.writeShort(-1);
                    continue block9;
                }
                case CP_ENTRY_PACKAGE: {
                    CPEntry.PackageCPEntry pkgCPEntry = (CPEntry.PackageCPEntry)cpEntry;
                    stream.writeInt(pkgCPEntry.orgNameCPIndex);
                    stream.writeInt(pkgCPEntry.pkgNameCPIndex);
                    stream.writeInt(pkgCPEntry.versionCPIndex);
                    continue block9;
                }
                case CP_ENTRY_SHAPE: {
                    CPEntry.ShapeCPEntry shapeCPEntry = (CPEntry.ShapeCPEntry)cpEntry;
                    ByteBuf typeBuf = Unpooled.buffer();
                    BIRTypeWriter birTypeWriter = new BIRTypeWriter(typeBuf, this);
                    birTypeWriter.visitType(shapeCPEntry.shape);
                    byte[] bytes = Arrays.copyOfRange(typeBuf.array(), 0, typeBuf.writerIndex());
                    stream.writeInt(bytes.length);
                    stream.write(bytes);
                    continue block9;
                }
                default: {
                    throw new IllegalStateException("unsupported constant pool entry type: " + cpEntry.entryType.name());
                }
            }
        }
    }
}

