/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.desugar;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.AttachPoint;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.OperatorKind;
import org.ballerinalang.model.tree.expressions.RecordLiteralNode;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.semantics.analyzer.SymbolResolver;
import org.wso2.ballerinalang.compiler.semantics.analyzer.Types;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAnnotationSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BOperatorSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BStructureTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class HttpFiltersDesugar {
    private final SymbolTable symTable;
    private final SymbolResolver symResolver;
    private final Names names;
    private final Types types;
    private static final String HTTP_ENDPOINT_CONFIG = "config";
    private static final String HTTP_FILTERS_VAR = "filters";
    private static final String HTTP_FILTER_VAR = "filter";
    private static final String HTTP_FILTERCONTEXT_VAR = "filterContext";
    private static final String FILTER_REQUEST_FUNCTION = "filterRequest";
    private static final String ANN_RESOURCE_CONFIG = "ResourceConfig";
    private static final String ANN_RESOURCE_ATTR_PATH = "path";
    private static final String ANN_RESOURCE_ATTR_WS_UPGRADE = "webSocketUpgrade";
    private static final String ANN_RESOURCE_ATTR_WS_UPGRADE_PATH = "upgradePath";
    private static final String ANN_RESOURCE_PARAM_ORDER_CONFIG = "ParamOrderConfig";
    private static final String ANN_RECORD_PARAM_ORDER_CONFIG = "HttpParamOrderConfig";
    private static final String ANN_FIELD_PATH_PARAM_ORDER = "pathParamOrder";
    private static final String ORG_NAME = "ballerina";
    private static final String PACKAGE_NAME = "http";
    private static final String CALLER_TYPE_NAME = "Caller";
    private static final String ORG_SEPARATOR = "/";
    private static final int ENDPOINT_PARAM_NUM = 0;
    private static final int REQUEST_PARAM_NUM = 1;
    private static final int FILTER_CONTEXT_FIELD_INDEX = 1;
    private static final int ENDPOINT_CONFIG_INDEX = 0;
    private static final int FILTERS_CONFIG_INDEX = 4;
    private static final CompilerContext.Key<HttpFiltersDesugar> HTTP_FILTERS_DESUGAR_KEY = new CompilerContext.Key();

    public static HttpFiltersDesugar getInstance(CompilerContext context) {
        HttpFiltersDesugar desugar = context.get(HTTP_FILTERS_DESUGAR_KEY);
        if (desugar == null) {
            desugar = new HttpFiltersDesugar(context);
        }
        return desugar;
    }

    private HttpFiltersDesugar(CompilerContext context) {
        context.put(HTTP_FILTERS_DESUGAR_KEY, this);
        this.symTable = SymbolTable.getInstance(context);
        this.symResolver = SymbolResolver.getInstance(context);
        this.names = Names.getInstance(context);
        this.types = Types.getInstance(context);
    }

    void addHttpFilterStatementsToResource(BLangFunction resourceNode, SymbolEnv env) {
        if (this.isHttpResource(resourceNode)) {
            this.addFilterStatements(resourceNode, env);
        }
    }

    private boolean isHttpResource(BLangFunction resourceNode) {
        if (resourceNode.requiredParams.size() < 2) {
            return false;
        }
        BTypeSymbol tsymbol = ((BLangSimpleVariable)resourceNode.requiredParams.get((int)0)).type.tsymbol;
        return ORG_NAME.equals(tsymbol.pkgID.orgName.value) && PACKAGE_NAME.equals(tsymbol.pkgID.name.value) && CALLER_TYPE_NAME.equals(tsymbol.name.value);
    }

    private void addFilterStatements(BLangFunction resourceNode, SymbolEnv env) {
        BLangSimpleVariable filterContextVar = this.addFilterContextCreation(resourceNode, env);
        this.addAssignmentAndForEach(resourceNode, filterContextVar, env);
    }

    private BLangSimpleVariable addFilterContextCreation(BLangFunction resourceNode, SymbolEnv env) {
        BLangIdentifier pkgAlias = ASTBuilderUtil.createIdentifier(resourceNode.pos, this.getPackageAlias(env, resourceNode));
        BLangUserDefinedType filterContextUserDefinedType = new BLangUserDefinedType(pkgAlias, ASTBuilderUtil.createIdentifier(resourceNode.pos, "FilterContext"));
        filterContextUserDefinedType.pos = resourceNode.pos;
        BType filterContextType = this.symResolver.resolveTypeNode(filterContextUserDefinedType, env);
        String filterContextVarName = Names.GEN_VAR_PREFIX.value + HTTP_FILTERCONTEXT_VAR;
        BLangSimpleVariable serviceSelf = (BLangSimpleVariable)resourceNode.getReceiver();
        BLangSimpleVarRef.BLangLocalVarRef serviceRef = new BLangSimpleVarRef.BLangLocalVarRef(serviceSelf.symbol);
        serviceRef.type = serviceSelf.type;
        serviceRef.pos = resourceNode.pos;
        BLangLiteral serviceName = new BLangLiteral();
        serviceName.value = this.getServiceName(serviceSelf.type.tsymbol.name.value);
        serviceName.type = this.symTable.stringType;
        serviceName.pos = resourceNode.pos;
        BLangLiteral resourceName = new BLangLiteral();
        resourceName.value = resourceNode.name.value;
        resourceName.type = this.symTable.stringType;
        resourceName.pos = resourceNode.pos;
        BLangInvocation filterInvocation = (BLangInvocation)TreeBuilder.createInvocationNode();
        filterInvocation.name = ASTBuilderUtil.createIdentifier(resourceNode.pos, "new");
        filterInvocation.symbol = ((BObjectTypeSymbol)filterContextType.tsymbol).initializerFunc.symbol;
        filterInvocation.pos = resourceNode.pos;
        filterInvocation.requiredArgs.add(serviceRef);
        filterInvocation.requiredArgs.add(serviceName);
        filterInvocation.requiredArgs.add(resourceName);
        filterInvocation.argExprs.add(serviceRef);
        filterInvocation.argExprs.add(serviceName);
        filterInvocation.argExprs.add(resourceName);
        filterInvocation.type = this.symTable.nilType;
        BLangTypeInit filterInitNode = (BLangTypeInit)TreeBuilder.createInitNode();
        filterInitNode.pos = resourceNode.pos;
        filterInitNode.type = filterContextType;
        filterInitNode.initInvocation = filterInvocation;
        filterInitNode.argsExpr.add(serviceRef);
        filterInitNode.argsExpr.add(serviceName);
        filterInitNode.argsExpr.add(resourceName);
        BLangSimpleVariable filterContextVar = ASTBuilderUtil.createVariable(resourceNode.pos, filterContextVarName, filterContextType, filterInitNode, new BVarSymbol(0, this.names.fromString(filterContextVarName), resourceNode.symbol.pkgID, filterContextType, resourceNode.symbol));
        filterContextVar.typeNode = filterContextUserDefinedType;
        this.addStatementToResourceBody(resourceNode.body, ASTBuilderUtil.createVariableDef(resourceNode.pos, filterContextVar), 0);
        return filterContextVar;
    }

    private void addStatementToResourceBody(BLangFunctionBody body, BLangStatement stmt, int index) {
        NodeKind bodyKind = body.getKind();
        if (bodyKind == NodeKind.BLOCK_FUNCTION_BODY) {
            ((BLangBlockFunctionBody)body).stmts.add(index, stmt);
        } else if (bodyKind == NodeKind.EXPR_FUNCTION_BODY) {
            BLangExprFunctionBody exprFnBody = (BLangExprFunctionBody)body;
            exprFnBody.expr = this.desugarExprFuncBody(exprFnBody.expr, stmt);
        } else {
            throw new IllegalStateException("Invalid resource method body type: " + bodyKind.toString());
        }
    }

    private BLangStatementExpression desugarExprFuncBody(BLangExpression expr, BLangStatement stmt) {
        if (expr.getKind() == NodeKind.STATEMENT_EXPRESSION) {
            BLangStatementExpression stmtExpr = (BLangStatementExpression)expr;
            ((BLangBlockStmt)stmtExpr.stmt).addStatement(stmt);
            return stmtExpr;
        }
        BLangBlockStmt blockStmt = ASTBuilderUtil.createBlockStmt(expr.pos);
        blockStmt.addStatement(stmt);
        BLangStatementExpression stmtExpr = ASTBuilderUtil.createStatementExpression(blockStmt, expr);
        stmtExpr.type = expr.type;
        return stmtExpr;
    }

    private String getServiceName(String serviceTypeName) {
        int serviceIndex = serviceTypeName.lastIndexOf("$$service$");
        return serviceTypeName.substring(0, serviceIndex);
    }

    private String getPackageAlias(SymbolEnv env, BLangNode node) {
        String compUnitName = node.pos.getSource().getCompilationUnitName();
        for (BLangImportPackage importStmt : env.enclPkg.imports) {
            if (!ORG_NAME.equals(importStmt.symbol.pkgID.orgName.value) || !PACKAGE_NAME.equals(importStmt.symbol.pkgID.name.value) || !importStmt.compUnit.value.equals(compUnitName)) continue;
            return importStmt.alias.value;
        }
        return PACKAGE_NAME;
    }

    private void addAssignmentAndForEach(BLangFunction resourceNode, BLangSimpleVariable filterContextVar, SymbolEnv env) {
        BLangSimpleVariable endpointVar = (BLangSimpleVariable)resourceNode.requiredParams.get(0);
        BLangSimpleVarRef.BLangLocalVarRef callerRef = new BLangSimpleVarRef.BLangLocalVarRef(endpointVar.symbol);
        callerRef.type = endpointVar.type;
        callerRef.pos = resourceNode.pos;
        BLangLiteral filterContextName = new BLangLiteral();
        filterContextName.value = HTTP_FILTERCONTEXT_VAR;
        filterContextName.type = this.symTable.stringType;
        filterContextName.pos = resourceNode.pos;
        BField filterContextVal = (BField)((BObjectType)endpointVar.type).fields.get(1);
        BLangIndexBasedAccess.BLangStructFieldAccessExpr filterContextField = new BLangIndexBasedAccess.BLangStructFieldAccessExpr(resourceNode.pos, callerRef, filterContextName, filterContextVal.symbol, false);
        filterContextField.type = filterContextVal.type;
        BLangSimpleVarRef.BLangLocalVarRef filterContextRef = new BLangSimpleVarRef.BLangLocalVarRef(filterContextVar.symbol);
        filterContextRef.variableName = filterContextVar.name;
        filterContextRef.type = filterContextVar.type;
        filterContextRef.pos = resourceNode.pos;
        BLangAssignment filterContextAssignment = ASTBuilderUtil.createAssignmentStmt(resourceNode.pos, filterContextField, filterContextRef, false);
        this.addStatementToResourceBody(resourceNode.body, filterContextAssignment, 1);
        BField configVal = (BField)((BObjectType)endpointVar.type).fields.get(0);
        BField filtersVal = (BField)((BRecordType)configVal.type).fields.get(4);
        BType filtersType = filtersVal.type;
        BUnionType filterUnionType = (BUnionType)((BArrayType)filtersType).eType;
        BLangIdentifier pkgAlias = ASTBuilderUtil.createIdentifier(resourceNode.pos, this.getPackageAlias(env, resourceNode));
        BLangUserDefinedType filterUserDefinedType = new BLangUserDefinedType(pkgAlias, ASTBuilderUtil.createIdentifier(resourceNode.pos, "RequestFilter"));
        filterUserDefinedType.pos = resourceNode.pos;
        BObjectType filterType = (BObjectType)this.symResolver.resolveTypeNode(filterUserDefinedType, env);
        BLangLiteral configName = new BLangLiteral();
        configName.value = HTTP_ENDPOINT_CONFIG;
        configName.type = this.symTable.stringType;
        configName.pos = resourceNode.pos;
        BLangIndexBasedAccess.BLangStructFieldAccessExpr configField = new BLangIndexBasedAccess.BLangStructFieldAccessExpr(resourceNode.pos, callerRef, configName, configVal.symbol, false);
        configField.type = configVal.type;
        BLangLiteral filtersName = new BLangLiteral();
        filtersName.value = HTTP_FILTERS_VAR;
        filtersName.type = this.symTable.stringType;
        filtersName.pos = resourceNode.pos;
        BLangIndexBasedAccess.BLangStructFieldAccessExpr filtersField = new BLangIndexBasedAccess.BLangStructFieldAccessExpr(resourceNode.pos, configField, filtersName, filtersVal.symbol, true);
        filtersField.type = filtersType;
        String filterVarName = Names.GEN_VAR_PREFIX + HTTP_FILTER_VAR;
        BLangSimpleVarRef unionFilterRef = ASTBuilderUtil.createVariableRef(resourceNode.pos, new BVarSymbol(0, new Name(filterVarName), resourceNode.symbol.pkgID, filterUnionType, resourceNode.symbol));
        unionFilterRef.variableName = ASTBuilderUtil.createIdentifier(resourceNode.pos, filterVarName);
        unionFilterRef.type = filterType;
        unionFilterRef.pos = resourceNode.pos;
        BLangSimpleVariable variable = ASTBuilderUtil.createVariable(resourceNode.pos, filterVarName, filterType, null, (BVarSymbol)unionFilterRef.symbol);
        BLangSimpleVariableDef variableDefinition = ASTBuilderUtil.createVariableDef(resourceNode.pos, variable);
        BLangLiteral returnName = new BLangLiteral();
        returnName.value = Names.NIL_VALUE;
        returnName.type = this.symTable.nilType;
        returnName.pos = resourceNode.pos;
        BLangReturn returnNode = (BLangReturn)TreeBuilder.createReturnNode();
        returnNode.expr = returnName;
        returnNode.statementLink = new BLangStatement.BLangStatementLink();
        returnNode.statementLink.statement = returnNode;
        returnNode.pos = resourceNode.pos;
        BLangBlockStmt doneStatement = ASTBuilderUtil.createBlockStmt(resourceNode.pos, this.createSingletonArrayList(returnNode));
        BLangTypeTestExpr filterTypeCheckExpr = ASTBuilderUtil.createTypeTestExpr(resourceNode.pos, unionFilterRef, filterUserDefinedType);
        BLangSimpleVariable requestVar = (BLangSimpleVariable)resourceNode.requiredParams.get(1);
        BLangSimpleVarRef.BLangLocalVarRef requestRef = new BLangSimpleVarRef.BLangLocalVarRef(requestVar.symbol);
        requestRef.variableName = requestVar.name;
        requestRef.type = requestVar.type;
        requestRef.pos = requestVar.pos;
        ArrayList<BLangExpression> requiredArgs = new ArrayList<BLangExpression>();
        requiredArgs.add(callerRef);
        requiredArgs.add(requestRef);
        requiredArgs.add(filterContextRef);
        BLangInvocation filterRequestInvocation = ASTBuilderUtil.createInvocationExprForMethod(resourceNode.pos, this.getFilterRequestFuncSymbol(filterType), requiredArgs, this.symResolver);
        filterRequestInvocation.expr = unionFilterRef;
        filterRequestInvocation.type = this.symTable.booleanType;
        filterRequestInvocation.async = false;
        BInvokableType type = new BInvokableType(this.createSingletonArrayList(this.symTable.booleanType), this.symTable.booleanType, null);
        BOperatorSymbol notOperatorSymbol = new BOperatorSymbol(this.names.fromString(OperatorKind.NOT.value()), this.symTable.rootPkgSymbol.pkgID, type, this.symTable.rootPkgSymbol);
        BLangUnaryExpr unaryExpr = ASTBuilderUtil.createUnaryExpr(resourceNode.pos, filterRequestInvocation, this.symTable.booleanType, OperatorKind.NOT, notOperatorSymbol);
        BOperatorSymbol andOperatorSymbol = new BOperatorSymbol(this.names.fromString(OperatorKind.AND.value()), this.symTable.rootPkgSymbol.pkgID, type, this.symTable.rootPkgSymbol);
        BLangBinaryExpr binaryExpr = ASTBuilderUtil.createBinaryExpr(resourceNode.pos, filterTypeCheckExpr, unaryExpr, this.symTable.booleanType, OperatorKind.AND, andOperatorSymbol);
        BLangGroupExpr groupExpr = new BLangGroupExpr();
        groupExpr.expression = binaryExpr;
        groupExpr.typedescType = this.symTable.booleanType;
        BLangIf ifNode = (BLangIf)TreeBuilder.createIfElseStatementNode();
        ifNode.pos = resourceNode.pos;
        ifNode.body = doneStatement;
        ifNode.expr = groupExpr;
        ifNode.statementLink = new BLangStatement.BLangStatementLink();
        ifNode.statementLink.statement = ifNode;
        BLangBlockStmt ifStatement = ASTBuilderUtil.createBlockStmt(resourceNode.pos, this.createSingletonArrayList(ifNode));
        BLangForeach foreach = (BLangForeach)TreeBuilder.createForeachNode();
        foreach.pos = resourceNode.pos;
        foreach.body = ifStatement;
        foreach.collection = filtersField;
        foreach.isDeclaredWithVar = false;
        this.types.setForeachTypedBindingPatternType(foreach);
        foreach.variableDefinitionNode = variableDefinition;
        this.addStatementToResourceBody(resourceNode.body, foreach, 2);
    }

    private <E> List<E> createSingletonArrayList(E val) {
        ArrayList<E> list = new ArrayList<E>();
        list.add(val);
        return list;
    }

    private BInvokableSymbol getFilterRequestFuncSymbol(BType filterType) {
        return ((BObjectTypeSymbol)filterType.tsymbol).attachedFuncs.stream().filter((Predicate<BAttachedFunction>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getFilterRequestFuncSymbol$0(org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction ), (Lorg/wso2/ballerinalang/compiler/semantics/model/symbols/BAttachedFunction;)Z)()).findFirst().get().symbol;
    }

    void addCustomAnnotationToResource(BLangFunction resourceNode, SymbolEnv env) {
        if (this.isHttpResource(resourceNode)) {
            this.addOrderParamConfig(resourceNode, env);
        }
    }

    private void addOrderParamConfig(BLangFunction resourceNode, SymbolEnv env) {
        List<RecordLiteralNode.RecordField> annotationValues = null;
        for (BLangAnnotationAttachment annotationAttachment : resourceNode.getAnnotationAttachments()) {
            if (!ANN_RESOURCE_CONFIG.equals(annotationAttachment.getAnnotationName().getValue()) || annotationAttachment.getExpression() == null) continue;
            annotationValues = ((BLangRecordLiteral)annotationAttachment.getExpression()).fields;
            break;
        }
        if (annotationValues == null) {
            return;
        }
        block9: for (RecordLiteralNode.RecordField field : annotationValues) {
            BLangExpression expression = field.isKeyValueField() ? ((BLangRecordLiteral.BLangRecordKeyValueField)field).valueExpr : (BLangRecordLiteral.BLangRecordVarNameField)field;
            block4 : switch (HttpFiltersDesugar.getAnnotationFieldKey(field)) {
                case "webSocketUpgrade": {
                    for (RecordLiteralNode.RecordField upgradeField : ((BLangRecordLiteral)expression).getFields()) {
                        if (!HttpFiltersDesugar.getAnnotationFieldKey(upgradeField).equals(ANN_RESOURCE_ATTR_WS_UPGRADE_PATH)) continue;
                        this.addParamOrderConfigAnnotation(resourceNode, upgradeField.isKeyValueField() ? ((BLangRecordLiteral.BLangRecordKeyValueField)upgradeField).valueExpr : (BLangRecordLiteral.BLangRecordVarNameField)upgradeField, env);
                        break block4;
                    }
                    continue block9;
                }
                case "path": {
                    this.addParamOrderConfigAnnotation(resourceNode, expression, env);
                }
            }
        }
    }

    private static String getAnnotationFieldKey(RecordLiteralNode.RecordField field) {
        if (!field.isKeyValueField()) {
            return ((BLangSimpleVarRef)((Object)field)).variableName.getValue();
        }
        return ((BLangSimpleVarRef)((BLangRecordLiteral.BLangRecordKeyValueField)field).key.expr).variableName.getValue();
    }

    private static boolean checkForPathParam(List<BLangSimpleVariable> parameters, BLangExpression value) {
        return parameters.size() > 2 && value.toString().contains("{") && value.toString().contains("}");
    }

    private void addParamOrderConfigAnnotation(BLangFunction resourceNode, BLangExpression value, SymbolEnv env) {
        if (!HttpFiltersDesugar.checkForPathParam(resourceNode.getParameters(), value)) {
            return;
        }
        DiagnosticPos pos = resourceNode.pos;
        BLangAnnotationAttachment annoAttachment = (BLangAnnotationAttachment)TreeBuilder.createAnnotAttachmentNode();
        resourceNode.addAnnotationAttachment(annoAttachment);
        BSymbol annSymbol = this.lookupAnnotationSpaceSymbolInPackage(this.symResolver, resourceNode.pos, env, this.names.fromString(PACKAGE_NAME), this.names.fromString(ANN_RESOURCE_PARAM_ORDER_CONFIG));
        if (annSymbol == this.symTable.notFoundSymbol) {
            return;
        }
        if (annSymbol instanceof BAnnotationSymbol) {
            annoAttachment.annotationSymbol = (BAnnotationSymbol)annSymbol;
        }
        annoAttachment.annotationName = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        annoAttachment.annotationName.value = ANN_RESOURCE_PARAM_ORDER_CONFIG;
        annoAttachment.pos = pos;
        BLangRecordLiteral literalNode = (BLangRecordLiteral)TreeBuilder.createRecordLiteralNode();
        annoAttachment.expr = literalNode;
        BLangIdentifier pkgAlias = (BLangIdentifier)TreeBuilder.createIdentifierNode();
        pkgAlias.setValue(PACKAGE_NAME);
        annoAttachment.pkgAlias = pkgAlias;
        annoAttachment.attachPoints.add(AttachPoint.Point.RESOURCE);
        literalNode.pos = pos;
        BSymbol annTypeSymbol = this.lookupMainSpaceSymbolInPackage(this.symResolver, resourceNode.pos, env, this.names.fromString(PACKAGE_NAME), this.names.fromString(ANN_RECORD_PARAM_ORDER_CONFIG));
        if (annTypeSymbol == this.symTable.notFoundSymbol) {
            return;
        }
        if (annTypeSymbol instanceof BStructureTypeSymbol) {
            BStructureTypeSymbol bStructSymbol = (BStructureTypeSymbol)annTypeSymbol;
            literalNode.type = bStructSymbol.type;
        }
        BLangRecordLiteral.BLangRecordKeyValueField pathParamOrderKeyValue = (BLangRecordLiteral.BLangRecordKeyValueField)TreeBuilder.createRecordKeyValue();
        literalNode.fields.add(pathParamOrderKeyValue);
        BLangLiteral keyLiteral = (BLangLiteral)TreeBuilder.createLiteralExpression();
        keyLiteral.value = ANN_FIELD_PATH_PARAM_ORDER;
        keyLiteral.type = this.symTable.stringType;
        BLangRecordLiteral paramOrderLiteralNode = (BLangRecordLiteral)TreeBuilder.createRecordLiteralNode();
        paramOrderLiteralNode.type = new BMapType(15, this.symTable.intType, this.symTable.mapType.tsymbol);
        pathParamOrderKeyValue.key = new BLangRecordLiteral.BLangRecordKey(keyLiteral);
        pathParamOrderKeyValue.valueExpr = paramOrderLiteralNode;
        this.getParamMapper(resourceNode.getParameters(), value.toString()).forEach((paramName, paramIndex) -> {
            BLangLiteral paramKeyLiteral = (BLangLiteral)TreeBuilder.createLiteralExpression();
            paramKeyLiteral.value = paramName;
            paramKeyLiteral.type = this.symTable.stringType;
            BLangLiteral paramValueLiteral = new BLangLiteral();
            paramValueLiteral.value = (long)paramIndex.intValue();
            paramValueLiteral.type = this.symTable.intType;
            BLangRecordLiteral.BLangRecordKeyValueField pathParamOrderEntry = new BLangRecordLiteral.BLangRecordKeyValueField();
            pathParamOrderEntry.key = new BLangRecordLiteral.BLangRecordKey(paramKeyLiteral);
            pathParamOrderEntry.valueExpr = paramValueLiteral;
            paramOrderLiteralNode.fields.add(pathParamOrderEntry);
        });
    }

    private HashMap<String, Integer> getParamMapper(List<BLangSimpleVariable> parameters, String path) {
        HashMap<String, Integer> mapper = new HashMap<String, Integer>();
        int startIndex = 0;
        block4: for (int pointerIndex = 0; pointerIndex < path.length(); ++pointerIndex) {
            char ch = path.charAt(pointerIndex);
            switch (ch) {
                case '{': {
                    startIndex = pointerIndex + 1;
                    continue block4;
                }
                case '}': {
                    String token = path.substring(startIndex, pointerIndex);
                    IntStream.range(2, parameters.size()).filter(i -> ((BLangSimpleVariable)parameters.get(i)).getName().getValue().equals(token)).findFirst().ifPresent(i -> mapper.put(token, i));
                }
            }
        }
        return mapper;
    }

    private BSymbol lookupMainSpaceSymbolInPackage(SymbolResolver symResolver, DiagnosticPos pos, SymbolEnv env, Name pkgAlias, Name name) {
        if (pkgAlias == Names.EMPTY) {
            return symResolver.lookupSymbolInMainSpace(env, name);
        }
        BSymbol pkgSymbol = symResolver.resolvePkgSymbol(pos, env, pkgAlias);
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            return pkgSymbol;
        }
        Scope.ScopeEntry entry = pkgSymbol.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 4) == 4) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        return this.symTable.notFoundSymbol;
    }

    private BSymbol lookupAnnotationSpaceSymbolInPackage(SymbolResolver symResolver, DiagnosticPos pos, SymbolEnv env, Name pkgAlias, Name name) {
        if (pkgAlias == Names.EMPTY) {
            return symResolver.lookupSymbolInAnnotationSpace(env, name);
        }
        BSymbol pkgSymbol = symResolver.resolvePkgSymbol(pos, env, pkgAlias);
        if (pkgSymbol == this.symTable.notFoundSymbol) {
            return pkgSymbol;
        }
        Scope.ScopeEntry entry = pkgSymbol.scope.lookup(name);
        while (entry != Scope.NOT_FOUND_ENTRY) {
            if ((entry.symbol.tag & 2) == 2) {
                return entry.symbol;
            }
            entry = entry.next;
        }
        return this.symTable.notFoundSymbol;
    }

    private static /* synthetic */ boolean lambda$getFilterRequestFuncSymbol$0(BAttachedFunction func) {
        return FILTER_REQUEST_FUNCTION.equals(func.funcName.value);
    }
}

