/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.packaging.repo;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.toml.model.Manifest;
import org.wso2.ballerinalang.compiler.packaging.Patten;
import org.wso2.ballerinalang.compiler.packaging.converters.Converter;
import org.wso2.ballerinalang.compiler.packaging.converters.SortablePath;
import org.wso2.ballerinalang.compiler.packaging.converters.ZipConverter;
import org.wso2.ballerinalang.compiler.packaging.repo.Repo;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.programfile.ProgramFileConstants;
import org.wso2.ballerinalang.util.RepoUtils;

public class HomeBaloRepo
implements Repo<Path> {
    private Path repoLocation;
    private ZipConverter zipConverter;
    private List<String> supportedPlatforms = Arrays.stream(ProgramFileConstants.SUPPORTED_PLATFORMS).collect(Collectors.toList());
    private Map<PackageID, Manifest> dependencyManifests;

    public HomeBaloRepo(Map<PackageID, Manifest> dependencyManifests) {
        this.repoLocation = RepoUtils.createAndGetHomeReposPath().resolve("balo_cache");
        this.dependencyManifests = dependencyManifests;
        this.zipConverter = new ZipConverter(this.repoLocation);
        this.supportedPlatforms.add("any");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Patten calculate(PackageID moduleID) {
        try {
            String orgName = moduleID.getOrgName().getValue();
            String pkgName = moduleID.getName().getValue();
            String versionStr = moduleID.getPackageVersion().getValue();
            if (Files.notExists(this.repoLocation.resolve(orgName).resolve(pkgName), new LinkOption[0])) {
                return Patten.NULL;
            }
            for (String platform : this.supportedPlatforms) {
                Path baloFilePath;
                if (versionStr.isEmpty()) {
                    Optional<Path> latestVersionPath = this.getLatestBaloFile(this.repoLocation.resolve(orgName).resolve(pkgName));
                    if (!latestVersionPath.isPresent()) return Patten.NULL;
                    Path latestVersionDirectoryName = latestVersionPath.get().getFileName();
                    if (null == latestVersionDirectoryName) return Patten.NULL;
                    versionStr = latestVersionDirectoryName.toString();
                    baloFilePath = this.findBaloPath(this.repoLocation, orgName, pkgName, platform, versionStr);
                } else {
                    baloFilePath = this.findBaloPath(this.repoLocation, orgName, pkgName, platform, versionStr);
                }
                Path baloFileName = baloFilePath.getFileName();
                if (!Files.exists(baloFilePath, new LinkOption[0]) || null == baloFileName) continue;
                moduleID.version = new Name(versionStr);
                this.dependencyManifests.put(moduleID, RepoUtils.getManifestFromBalo(baloFilePath.toAbsolutePath()));
                return new Patten(Patten.path(orgName, pkgName), Patten.path(versionStr), Patten.path(baloFileName.toString(), "src", pkgName), Patten.WILDCARD_SOURCE);
            }
            return Patten.NULL;
        }
        catch (IOException e) {
            return Patten.NULL;
        }
    }

    private Optional<Path> getLatestBaloFile(Path moduleFolder) throws IOException {
        Optional<Path> path;
        try (Stream<Path> fileStream = Files.list(moduleFolder);){
            path = fileStream.map(SortablePath::new).filter(SortablePath::valid).sorted(Comparator.reverseOrder()).limit(1L).map(SortablePath::getPath).findFirst();
        }
        return path;
    }

    @Override
    public Converter<Path> getConverterInstance() {
        return this.zipConverter;
    }

    public String toString() {
        return "{t:'HomeBaloRepo', c:'" + this.zipConverter + "'}";
    }

    private Path findBaloPath(Path repoLocation, String orgName, String pkgName, String platform, String versionStr) throws IOException {
        Path baloFilePath = this.repoLocation.resolve(orgName).resolve(pkgName).resolve(versionStr);
        if (Files.exists(baloFilePath, new LinkOption[0])) {
            Stream<Path> list = Files.list(baloFilePath);
            PathMatcher pathMatcher = baloFilePath.getFileSystem().getPathMatcher("glob:**/" + pkgName + "-*-" + platform + "-" + versionStr + ".balo");
            for (Path file : list::iterator) {
                if (!pathMatcher.matches(file)) continue;
                return file;
            }
        }
        String baloFileName = pkgName + "-" + "2020r1" + "-" + platform + "-" + versionStr + ".balo";
        return baloFilePath.resolve(baloFileName);
    }
}

