/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.model.types.TypeKind;
import org.ballerinalang.model.types.UnionType;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;
import org.wso2.ballerinalang.compiler.util.Names;

public class BUnionType
extends BType
implements UnionType {
    private boolean nullable;
    private LinkedHashSet<BType> memberTypes;
    private Optional<Boolean> isAnyData = Optional.empty();
    private Optional<Boolean> isPureType = Optional.empty();

    private BUnionType(BTypeSymbol tsymbol, LinkedHashSet<BType> memberTypes, boolean nullable) {
        super(20, tsymbol);
        this.memberTypes = memberTypes;
        this.nullable = nullable;
    }

    public Set<BType> getMemberTypes() {
        return Collections.unmodifiableSet(this.memberTypes);
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.UNION;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        StringJoiner joiner = new StringJoiner(this.getKind().typeName());
        this.memberTypes.stream().filter(memberType -> memberType.tag != 10).forEach(memberType -> joiner.add(memberType.toString()));
        String typeStr = this.memberTypes.stream().filter(memberType -> memberType.tag != 10).count() > 1L ? "(" + joiner.toString() + ")" : joiner.toString();
        boolean hasNilType = this.memberTypes.stream().anyMatch(type -> type.tag == 10);
        return this.nullable && hasNilType ? typeStr + Names.QUESTION_MARK.value : typeStr;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public static BUnionType create(BTypeSymbol tsymbol, LinkedHashSet<BType> types) {
        LinkedHashSet memberTypes = BUnionType.toFlatTypeSet(types);
        boolean hasNilableType = memberTypes.stream().anyMatch(t -> t.isNullable() && t.tag != 10);
        if (hasNilableType) {
            memberTypes = memberTypes.stream().filter(t -> t.tag != 10).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return new BUnionType(tsymbol, memberTypes, memberTypes.stream().anyMatch(BType::isNullable));
    }

    public static BUnionType create(BTypeSymbol tsymbol, BType ... types) {
        LinkedHashSet memberTypes = Arrays.stream(types).collect(Collectors.toCollection(LinkedHashSet::new));
        return BUnionType.create(tsymbol, memberTypes);
    }

    public void add(BType type) {
        if (type.tag == 20 && !BUnionType.isTypeParamAvailable(type)) {
            assert (type instanceof BUnionType);
            this.memberTypes.addAll(BUnionType.toFlatTypeSet(((BUnionType)type).memberTypes));
        } else {
            this.memberTypes.add(type);
        }
        this.nullable = this.nullable || type.isNullable();
    }

    public void addAll(LinkedHashSet<BType> types) {
        types.forEach(this::add);
    }

    public void remove(BType type) {
        if (type.tag == 20) {
            assert (type instanceof BUnionType);
            this.memberTypes.removeAll(((BUnionType)type).getMemberTypes());
        } else {
            this.memberTypes.remove(type);
        }
        if (type.isNullable()) {
            this.nullable = false;
        }
    }

    public Iterator<BType> iterator() {
        return this.memberTypes.iterator();
    }

    @Override
    public boolean isAnydata() {
        if (this.isAnyData.isPresent()) {
            return this.isAnyData.get();
        }
        for (BType memberType : this.memberTypes) {
            if (memberType.isAnydata()) continue;
            this.isAnyData = Optional.of(false);
            return false;
        }
        this.isAnyData = Optional.of(true);
        return true;
    }

    @Override
    public boolean isPureType() {
        if (this.isPureType.isPresent()) {
            return this.isPureType.get();
        }
        for (BType memberType : this.memberTypes) {
            if (memberType.isPureType()) continue;
            this.isPureType = Optional.of(false);
            return false;
        }
        this.isPureType = Optional.of(true);
        return true;
    }

    private static LinkedHashSet<BType> toFlatTypeSet(LinkedHashSet<BType> types) {
        return types.stream().flatMap(type -> type.tag == 20 && !BUnionType.isTypeParamAvailable(type) ? ((BUnionType)type).memberTypes.stream() : Stream.of(type)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static boolean isTypeParamAvailable(BType type) {
        return type.tsymbol != null && Symbols.isFlagOn(type.tsymbol.flags, 0x400000);
    }
}

