/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.stream.Stream;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;

public class FileUtils {
    private static final String SRC_DIR = "src";

    public static void deleteFile(Path filePath) throws IOException {
        Files.deleteIfExists(filePath);
    }

    static void generateBalo(BLangPackage bLangPackage, String projectPath, Stream<Path> paths) {
        PackageID packageID = bLangPackage.packageID;
        Path destPath = Paths.get(projectPath, ".ballerina", "caches", "central.ballerina.io", packageID.getOrgName().getValue(), packageID.getName().getValue(), packageID.getPackageVersion().getValue());
        if (!Files.exists(destPath, new LinkOption[0])) {
            try {
                Files.createDirectories(destPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new BLangCompilerException("error creating directories in ./ballerina/repo/ to save the artifact");
            }
        }
        String fileName = packageID.getName() + ".zip";
        Path baloDirPath = destPath.resolve(fileName);
        FileUtils.deleteBalo(baloDirPath);
        FileUtils.createArchive(paths, baloDirPath);
    }

    private static void deleteBalo(Path baloDirPath) {
        try {
            Files.deleteIfExists(baloDirPath);
        }
        catch (IOException ignore) {
            throw new BLangCompilerException("error deleting artifact : " + baloDirPath);
        }
    }

    private static void createArchive(Stream<Path> filesToBeArchived, Path outDirPath) {
        URI zipFileURI;
        HashMap<String, String> zipFSEnv = new HashMap<String, String>();
        zipFSEnv.put("create", "true");
        URI filepath = outDirPath.toUri();
        try {
            zipFileURI = new URI("jar:" + filepath.getScheme(), filepath.getUserInfo(), filepath.getHost(), filepath.getPort(), filepath.getPath() + "!/", filepath.getQuery(), filepath.getFragment());
        }
        catch (URISyntaxException ignore) {
            throw new BLangCompilerException("error creating artifact: " + outDirPath.getFileName());
        }
        try (FileSystem zipFS = FileSystems.newFileSystem(zipFileURI, zipFSEnv);){
            FileUtils.addFileToArchive(filesToBeArchived, zipFS, outDirPath);
        }
        catch (IOException e) {
            throw new BLangCompilerException("error creating artifact: " + outDirPath.getFileName());
        }
    }

    private static void addFileToArchive(Stream<Path> filesToBeArchived, FileSystem zipFS, Path outDirPath) {
        filesToBeArchived.forEach(path -> {
            String fileName = path.getFileName().toString();
            Path dest = zipFS.getPath(SRC_DIR, fileName);
            if (fileName.equals("Module.md")) {
                dest = zipFS.getPath(zipFS.getSeparator(), fileName);
            }
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    FileUtils.copyFileToArchive(new FileInputStream(path.toFile()), dest);
                }
            }
            catch (IOException e) {
                throw new BLangCompilerException("error generating artifact: " + outDirPath.getFileName());
            }
        });
    }

    private static void copyFileToArchive(InputStream srcInputStream, Path destPath) throws IOException {
        Path parent = destPath.getParent();
        if (parent != null) {
            if (Files.notExists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.copy(srcInputStream, destPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static String cleanupFileExtension(String targetFileName) {
        String updatedFileName = targetFileName;
        if (updatedFileName == null || updatedFileName.isEmpty()) {
            throw new IllegalArgumentException("invalid target file name");
        }
        if (updatedFileName.endsWith(".bal")) {
            updatedFileName = updatedFileName.substring(0, updatedFileName.length() - ".bal".length());
        }
        return updatedFileName;
    }
}

