/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.util;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import org.ballerinalang.model.TreeBuilder;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.desugar.ASTBuilderUtil;
import org.wso2.ballerinalang.compiler.semantics.model.Scope;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolEnv;
import org.wso2.ballerinalang.compiler.semantics.model.SymbolTable;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BInvokableTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BRecordTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.TaintRecord;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.Names;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;
import org.wso2.ballerinalang.util.Flags;

public class TypeDefBuilderHelper {
    public static BLangRecordTypeNode createRecordTypeNode(BRecordType recordType, PackageID packageID, SymbolTable symTable, DiagnosticPos pos) {
        ArrayList<BLangSimpleVariable> fieldList = new ArrayList<BLangSimpleVariable>();
        for (BField field : recordType.fields) {
            BVarSymbol symbol = field.symbol;
            if (symbol == null) {
                symbol = new BVarSymbol(1, field.name, packageID, symTable.pureType, null);
            }
            BLangSimpleVariable fieldVar = ASTBuilderUtil.createVariable(field.pos, symbol.name.value, field.type, null, symbol);
            fieldList.add(fieldVar);
        }
        return TypeDefBuilderHelper.createRecordTypeNode(fieldList, recordType, pos);
    }

    public static BLangRecordTypeNode createRecordTypeNode(List<BLangSimpleVariable> typeDefFields, BRecordType recordType, DiagnosticPos pos) {
        BLangRecordTypeNode recordTypeNode = (BLangRecordTypeNode)TreeBuilder.createRecordTypeNode();
        recordTypeNode.type = recordType;
        recordTypeNode.fields = typeDefFields;
        recordTypeNode.symbol = recordType.tsymbol;
        recordTypeNode.pos = pos;
        return recordTypeNode;
    }

    public static BLangFunction createInitFunctionForRecordType(BLangRecordTypeNode recordTypeNode, SymbolEnv env, Names names, SymbolTable symTable) {
        BLangFunction initFunction = TypeDefBuilderHelper.createInitFunctionForStructureType(recordTypeNode, env, Names.INIT_FUNCTION_SUFFIX, names, symTable);
        BRecordTypeSymbol recordSymbol = (BRecordTypeSymbol)recordTypeNode.type.tsymbol;
        recordSymbol.initializerFunc = new BAttachedFunction(initFunction.symbol.name, initFunction.symbol, (BInvokableType)initFunction.type);
        recordTypeNode.initFunction = initFunction;
        recordSymbol.scope.define(recordSymbol.initializerFunc.symbol.name, recordSymbol.initializerFunc.symbol);
        return initFunction;
    }

    public static BLangFunction createInitFunctionForStructureType(BLangStructureTypeNode structureTypeNode, SymbolEnv env, Name suffix, Names names, SymbolTable symTable) {
        BVarSymbol receiverSymbol;
        String structTypeName = structureTypeNode.type.tsymbol.name.value;
        BLangFunction initFunction = ASTBuilderUtil.createInitFunctionWithNilReturn(structureTypeNode.pos, structTypeName, suffix);
        initFunction.receiver = ASTBuilderUtil.createReceiver(structureTypeNode.pos, structureTypeNode.type);
        initFunction.receiver.symbol = receiverSymbol = new BVarSymbol(Flags.asMask(EnumSet.noneOf(Flag.class)), names.fromIdNode(initFunction.receiver.name), env.enclPkg.symbol.pkgID, structureTypeNode.type, null);
        initFunction.attachedFunction = true;
        initFunction.flagSet.add(Flag.ATTACHED);
        initFunction.type = new BInvokableType(new ArrayList<BType>(), symTable.nilType, null);
        Name funcSymbolName = names.fromString(Symbols.getAttachedFuncSymbolName(structTypeName, suffix.value));
        initFunction.symbol = Symbols.createFunctionSymbol(Flags.asMask(initFunction.flagSet), funcSymbolName, env.enclPkg.symbol.pkgID, initFunction.type, structureTypeNode.symbol, initFunction.body != null);
        initFunction.symbol.scope = new Scope(initFunction.symbol);
        initFunction.symbol.scope.define(receiverSymbol.name, receiverSymbol);
        initFunction.symbol.receiverSymbol = receiverSymbol;
        initFunction.name = ASTBuilderUtil.createIdentifier(structureTypeNode.pos, funcSymbolName.value);
        BInvokableTypeSymbol tsymbol = Symbols.createInvokableTypeSymbol(33554460, initFunction.symbol.flags, env.enclPkg.packageID, initFunction.type, initFunction.symbol);
        tsymbol.params = initFunction.symbol.params;
        tsymbol.restParam = initFunction.symbol.restParam;
        tsymbol.returnType = initFunction.symbol.retType;
        initFunction.type.tsymbol = tsymbol;
        receiverSymbol.owner = initFunction.symbol;
        initFunction.symbol.retType = symTable.nilType;
        initFunction.symbol.taintTable = new HashMap<Integer, TaintRecord>();
        TaintRecord taintRecord = new TaintRecord(TaintRecord.TaintedStatus.UNTAINTED, new ArrayList<TaintRecord.TaintedStatus>());
        initFunction.symbol.taintTable.put(-1, taintRecord);
        return initFunction;
    }

    public static void addTypeDefinition(BType type, BTypeSymbol symbol, BLangType typeNode, SymbolEnv env) {
        BLangTypeDefinition typeDefinition = (BLangTypeDefinition)TreeBuilder.createTypeDefinition();
        env.enclPkg.addTypeDefinition(typeDefinition);
        typeDefinition.typeNode = typeNode;
        typeDefinition.type = type;
        typeDefinition.symbol = symbol;
    }
}

