/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import org.wso2.ballerinalang.compiler.TypeCreator;
import org.wso2.ballerinalang.compiler.util.Names;

public class TypeSignatureReader<T> {
    public int createBTypeFromSig(TypeCreator<T> typeCreator, char[] chars, int index, Stack<T> typeStack) {
        char typeChar = chars[index];
        switch (typeChar) {
            case 'A': 
            case 'B': 
            case 'F': 
            case 'I': 
            case 'K': 
            case 'L': 
            case 'N': 
            case 'S': 
            case 'W': 
            case 'Y': {
                typeStack.push(typeCreator.getBasicType(typeChar));
                return index + 1;
            }
            case 'R': {
                int nameIndex = ++index;
                while (chars[nameIndex] != ';') {
                    ++nameIndex;
                }
                String typeName = new String(Arrays.copyOfRange(chars, index, nameIndex));
                typeStack.push(typeCreator.getBuiltinRefType(typeName));
                return nameIndex + 1;
            }
            case 'C': 
            case 'D': 
            case 'E': 
            case 'G': 
            case 'T': 
            case 'X': 
            case 'Z': {
                int nameIndex = index;
                while (chars[nameIndex] != ';') {
                    ++nameIndex;
                }
                String name = new String(Arrays.copyOfRange(chars, index, nameIndex + 1));
                T type = this.getBTypeFromDescriptor(typeCreator, name);
                typeStack.push(type);
                return nameIndex + 1;
            }
            case '[': {
                int endIndex = index + 1;
                int j = index + 1;
                while (chars[j] != ';') {
                    ++endIndex;
                    ++j;
                }
                int size = Integer.parseInt(String.valueOf(Arrays.copyOfRange(chars, index + 1, endIndex)));
                index = this.createBTypeFromSig(typeCreator, chars, endIndex + 1, typeStack);
                T elemType = typeStack.pop();
                typeStack.push(typeCreator.getArrayType(elemType, size));
                return index;
            }
            case 'H': 
            case 'M': 
            case 'Q': {
                index = this.createBTypeFromSig(typeCreator, chars, index + 1, typeStack);
                T constraintType = typeStack.pop();
                typeStack.push(typeCreator.getConstrainedType(typeChar, constraintType));
                return index;
            }
            case 'U': {
                ++index;
                index = this.createFunctionType(typeCreator, chars, index, typeStack);
                return index + 1;
            }
            case 'O': 
            case 'P': {
                int nameIndex = ++index;
                while (chars[nameIndex] != ';') {
                    ++nameIndex;
                }
                ArrayList<T> memberTypes = new ArrayList<T>();
                int memberCount = Integer.parseInt(new String(Arrays.copyOfRange(chars, index, nameIndex)));
                index = nameIndex;
                for (int i = 0; i < memberCount; ++i) {
                    index = this.createBTypeFromSig(typeCreator, chars, index + 1, typeStack) - 1;
                    memberTypes.add(typeStack.pop());
                }
                typeStack.push(typeCreator.getCollectionType(typeChar, memberTypes));
                return index + 1;
            }
        }
        throw new IllegalArgumentException("unsupported base type char: " + typeChar);
    }

    public T getBTypeFromDescriptor(TypeCreator<T> typeCreator, String desc) {
        char ch = desc.charAt(0);
        switch (ch) {
            case 'A': 
            case 'B': 
            case 'F': 
            case 'I': 
            case 'K': 
            case 'L': 
            case 'N': 
            case 'S': 
            case 'W': 
            case 'Y': {
                return typeCreator.getBasicType(ch);
            }
            case 'R': {
                String typeName = desc.substring(1, desc.length() - 1);
                return typeCreator.getBuiltinRefType(typeName);
            }
            case 'H': 
            case 'M': 
            case 'Q': {
                T constraintType = this.getBTypeFromDescriptor(typeCreator, desc.substring(1));
                return typeCreator.getConstrainedType(ch, constraintType);
            }
            case 'C': 
            case 'D': 
            case 'E': 
            case 'G': 
            case 'T': 
            case 'X': 
            case 'Z': {
                String name;
                String pkgPath;
                String typeName = desc.substring(1, desc.length() - 1);
                String[] parts = typeName.split(":");
                if (parts.length == 1 && ch == 'D') {
                    return typeCreator.getConstrainedType(ch, null);
                }
                if (parts.length == 2) {
                    pkgPath = parts[0];
                    name = parts[1];
                } else {
                    pkgPath = String.join((CharSequence)Names.VERSION_SEPARATOR.value, parts[0], parts[1]);
                    name = parts[2];
                }
                T constraintType = typeCreator.getRefType(ch, pkgPath, name);
                return typeCreator.getConstrainedType(ch, constraintType);
            }
            case '[': {
                int index = 1;
                char[] size = null;
                if (desc.contains(";")) {
                    index = desc.indexOf(";");
                    size = new char[index - 1];
                    desc.getChars(1, index, size, 0);
                    ++index;
                }
                T elemType = this.getBTypeFromDescriptor(typeCreator, desc.substring(index));
                return typeCreator.getArrayType(elemType, Integer.parseInt(String.valueOf(size)));
            }
            case 'O': 
            case 'P': 
            case 'U': {
                Stack typeStack = new Stack();
                this.createBTypeFromSig(typeCreator, desc.toCharArray(), 0, typeStack);
                return (T)typeStack.pop();
            }
        }
        throw new IllegalArgumentException("unsupported base type char: " + ch);
    }

    public int createFunctionType(TypeCreator<T> typeCreator, char[] chars, int index, Stack<T> typeStack) {
        Object retType;
        ++index;
        Stack funcParamsStack = new Stack();
        while (chars[index] != ')' || chars[index + 1] != '(') {
            index = this.createBTypeFromSig(typeCreator, chars, index, funcParamsStack);
        }
        if (chars[index += 2] == ')') {
            retType = null;
        } else {
            Stack returnParamsStack = new Stack();
            index = this.createBTypeFromSig(typeCreator, chars, index, returnParamsStack);
            retType = returnParamsStack.pop();
        }
        typeStack.push(typeCreator.getFunctionType(funcParamsStack, retType));
        return index;
    }
}

