/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.bir.codegen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmInstructionGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmMethodGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmPackageGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmTerminatorGen;
import org.wso2.ballerinalang.compiler.bir.codegen.JvmValueGen;
import org.wso2.ballerinalang.compiler.bir.codegen.Nilable;
import org.wso2.ballerinalang.compiler.bir.model.BIRNode;
import org.wso2.ballerinalang.compiler.bir.model.VarKind;
import org.wso2.ballerinalang.compiler.bir.model.VarScope;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BAttachedFunction;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BObjectTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BArrayType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BErrorType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFiniteType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BFutureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BInvokableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BMapType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BObjectType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BRecordType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BServiceType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStreamType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTableType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTupleType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypedescType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BUnionType;
import org.wso2.ballerinalang.compiler.semantics.model.types.TypeFlags;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.util.Name;
import org.wso2.ballerinalang.compiler.util.TypeTags;

class JvmTypeGen {
    public static String typeOwnerClass = "";

    JvmTypeGen() {
    }

    static void generateUserDefinedTypeFields(ClassWriter cw, @Nilable List<BIRNode.BIRTypeDefinition> typeDefs) {
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            BIRNode.BIRTypeDefinition typeDef = JvmMethodGen.getTypeDef(optionalTypeDef);
            String fieldName = JvmTypeGen.getTypeFieldName(typeDef.name.value);
            BType bType = typeDef.type;
            if (bType.tag != 12 && bType.tag != 27 && bType.tag != 32) continue;
            FieldVisitor fv = cw.visitField(9, fieldName, String.format("L%s;", "org/ballerinalang/jvm/types/BType"), null, null);
            fv.visitEnd();
        }
    }

    public static void generateUserDefinedTypes(MethodVisitor mv) {
        mv.visitMethodInsn(184, typeOwnerClass, "$createTypes", "()V", false);
    }

    static void generateCreateTypesMethod(ClassWriter cw, @Nilable List<BIRNode.BIRTypeDefinition> typeDefs) {
        JvmTypeGen.createTypesInstance(cw, typeDefs);
        List<String> populateTypeFuncNames = JvmTypeGen.populateTypes(cw, typeDefs);
        MethodVisitor mv = cw.visitMethod(9, "$createTypes", "()V", null, null);
        mv.visitCode();
        mv.visitMethodInsn(184, typeOwnerClass, "$createTypeInstances", "()V", false);
        for (String funcName : populateTypeFuncNames) {
            mv.visitMethodInsn(184, typeOwnerClass, funcName, "()V", false);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void createTypesInstance(ClassWriter cw, @Nilable List<BIRNode.BIRTypeDefinition> typeDefs) {
        MethodVisitor mv = cw.visitMethod(9, "$createTypeInstances", "()V", null, null);
        mv.visitCode();
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            BIRNode.BIRTypeDefinition typeDef = JvmMethodGen.getTypeDef(optionalTypeDef);
            String fieldName = JvmTypeGen.getTypeFieldName(typeDef.name.value);
            BType bType = typeDef.type;
            if (bType.tag == 12) {
                JvmTypeGen.createRecordType(mv, (BRecordType)bType, typeDef);
            } else if (bType.tag == 32) {
                if (bType instanceof BServiceType) {
                    JvmTypeGen.createServiceType(mv, (BServiceType)bType, typeDef.type);
                } else {
                    JvmTypeGen.createObjectType(mv, (BObjectType)bType, typeDef);
                }
            } else {
                if (bType.tag != 27) continue;
                JvmTypeGen.createErrorType(mv, (BErrorType)bType, bType.tsymbol.name.value);
            }
            mv.visitFieldInsn(179, typeOwnerClass, fieldName, String.format("L%s;", "org/ballerinalang/jvm/types/BType"));
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static List<String> populateTypes(ClassWriter cw, @Nilable List<BIRNode.BIRTypeDefinition> typeDefs) {
        ArrayList<String> funcNames = new ArrayList<String>();
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            BIRNode.BIRTypeDefinition typeDef = JvmMethodGen.getTypeDef(optionalTypeDef);
            BType bType = typeDef.type;
            if (bType.tag != 12 && bType.tag != 32 && bType.tag != 27) continue;
            String fieldName = JvmTypeGen.getTypeFieldName(typeDef.name.value);
            String methodName = String.format("$populate%s", fieldName);
            funcNames.add(methodName);
            MethodVisitor mv = cw.visitMethod(9, methodName, "()V", null, null);
            mv.visitCode();
            mv.visitFieldInsn(178, typeOwnerClass, fieldName, String.format("L%s;", "org/ballerinalang/jvm/types/BType"));
            JvmMethodGen.BalToJVMIndexMap indexMap = new JvmMethodGen.BalToJVMIndexMap();
            if (bType.tag == 12) {
                BRecordType recordType = (BRecordType)bType;
                mv.visitTypeInsn(192, "org/ballerinalang/jvm/types/BRecordType");
                mv.visitInsn(89);
                JvmTypeGen.addRecordFields(mv, recordType.fields);
                JvmTypeGen.addRecordRestField(mv, recordType.restFieldType);
            } else if (bType.tag == 32) {
                if (bType instanceof BServiceType) {
                    BServiceType serviceType = (BServiceType)bType;
                    mv.visitTypeInsn(192, "org/ballerinalang/jvm/types/BObjectType");
                    mv.visitInsn(89);
                    JvmTypeGen.addObjectFields(mv, serviceType.fields);
                    JvmTypeGen.addObjectAttachedFunctions(mv, ((BObjectTypeSymbol)serviceType.tsymbol).attachedFuncs, serviceType, indexMap);
                } else {
                    BObjectType objectType = (BObjectType)bType;
                    mv.visitTypeInsn(192, "org/ballerinalang/jvm/types/BObjectType");
                    mv.visitInsn(89);
                    JvmTypeGen.addObjectFields(mv, objectType.fields);
                    BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)objectType.tsymbol;
                    JvmTypeGen.addObjectInitFunction(mv, objectTypeSymbol.generatedInitializerFunc, objectType, indexMap, "$__init$", "setGeneratedInitializer");
                    JvmTypeGen.addObjectInitFunction(mv, objectTypeSymbol.initializerFunc, objectType, indexMap, "__init", "setInitializer");
                    JvmTypeGen.addObjectAttachedFunctions(mv, objectTypeSymbol.attachedFuncs, objectType, indexMap);
                }
            } else if (bType.tag == 27) {
                mv.visitTypeInsn(192, "org/ballerinalang/jvm/types/BErrorType");
                mv.visitInsn(89);
                mv.visitInsn(89);
                JvmTypeGen.loadType(mv, ((BErrorType)bType).detailType);
                mv.visitMethodInsn(182, "org/ballerinalang/jvm/types/BErrorType", "setDetailType", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BType"), false);
            }
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
        return funcNames;
    }

    static void generateValueCreatorMethods(ClassWriter cw, @Nilable List<BIRNode.BIRTypeDefinition> typeDefs, BIRNode.BIRPackage moduleId) {
        BType bType;
        BIRNode.BIRTypeDefinition typeDef;
        ArrayList<BIRNode.BIRTypeDefinition> recordTypeDefs = new ArrayList<BIRNode.BIRTypeDefinition>();
        ArrayList<BIRNode.BIRTypeDefinition> objectTypeDefs = new ArrayList<BIRNode.BIRTypeDefinition>();
        int i = 0;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            typeDef = JvmMethodGen.getTypeDef(optionalTypeDef);
            bType = typeDef.type;
            if (bType.tag != 12) continue;
            recordTypeDefs.add(i, typeDef);
            ++i;
        }
        i = 0;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            typeDef = JvmMethodGen.getTypeDef(optionalTypeDef);
            bType = typeDef.type;
            if (bType.tag != 32 || Symbols.isFlagOn(((BObjectType)bType).tsymbol.flags, 4096)) continue;
            objectTypeDefs.add(i, typeDef);
            ++i;
        }
        JvmTypeGen.generateRecordValueCreateMethod(cw, recordTypeDefs, moduleId);
        JvmTypeGen.generateObjectValueCreateMethod(cw, objectTypeDefs, moduleId);
    }

    private static void generateRecordValueCreateMethod(ClassWriter cw, @Nilable List<BIRNode.BIRTypeDefinition> recordTypeDefs, BIRNode.BIRPackage moduleId) {
        MethodVisitor mv = cw.visitMethod(1, "createRecordValue", String.format("(L%s;)L%s;", "java/lang/String", "org/ballerinalang/jvm/values/MapValue"), String.format("(L%s;)L%s<L%s;L%s;>;", "java/lang/String", "org/ballerinalang/jvm/values/MapValue", "java/lang/String", "java/lang/Object"), null);
        mv.visitCode();
        int fieldNameRegIndex = 1;
        Label defaultCaseLabel = new Label();
        recordTypeDefs.sort(JvmValueGen.NAME_HASH_COMPARATOR);
        List<Label> labels = JvmValueGen.createLabelsForSwitch(mv, fieldNameRegIndex, recordTypeDefs, defaultCaseLabel);
        List<Label> targetLabels = JvmValueGen.createLabelsForEqualCheck(mv, fieldNameRegIndex, recordTypeDefs, labels, defaultCaseLabel);
        int i = 0;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : recordTypeDefs) {
            BIRNode.BIRTypeDefinition typeDef = JvmMethodGen.getTypeDef(optionalTypeDef);
            String fieldName = JvmTypeGen.getTypeFieldName(typeDef.name.value);
            Label targetLabel = targetLabels.get(i);
            mv.visitLabel(targetLabel);
            mv.visitVarInsn(25, 0);
            String className = JvmValueGen.getTypeValueClassName(moduleId, typeDef.name.value);
            mv.visitTypeInsn(187, className);
            mv.visitInsn(89);
            mv.visitFieldInsn(178, typeOwnerClass, fieldName, String.format("L%s;", "org/ballerinalang/jvm/types/BType"));
            mv.visitMethodInsn(183, className, "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BType"), false);
            mv.visitInsn(89);
            mv.visitTypeInsn(187, "org/ballerinalang/jvm/scheduling/Strand");
            mv.visitInsn(89);
            mv.visitInsn(1);
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/scheduling/Strand", "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/scheduling/Scheduler"), false);
            mv.visitInsn(95);
            mv.visitMethodInsn(184, className, "$init", String.format("(L%s;L%s;)V", "org/ballerinalang/jvm/scheduling/Strand", "org/ballerinalang/jvm/values/MapValue"), false);
            mv.visitInsn(176);
            ++i;
        }
        JvmValueGen.createDefaultCase(mv, defaultCaseLabel, fieldNameRegIndex);
        mv.visitMaxs(recordTypeDefs.size() + 10, recordTypeDefs.size() + 10);
        mv.visitEnd();
    }

    private static void generateObjectValueCreateMethod(ClassWriter cw, @Nilable List<BIRNode.BIRTypeDefinition> objectTypeDefs, BIRNode.BIRPackage moduleId) {
        MethodVisitor mv = cw.visitMethod(1, "createObjectValue", String.format("(L%s;L%s;L%s;L%s;[L%s;)L%s;", "java/lang/String", "org/ballerinalang/jvm/scheduling/Scheduler", "org/ballerinalang/jvm/scheduling/Strand", "java/util/Map", "java/lang/Object", "org/ballerinalang/jvm/values/ObjectValue"), null, null);
        JvmMethodGen.BalToJVMIndexMap indexMap = new JvmMethodGen.BalToJVMIndexMap();
        BIRNode.BIRVariableDcl selfVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("self"), VarScope.FUNCTION, VarKind.ARG);
        BIRNode.BIRVariableDcl var1 = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.stringType, new Name("var1"), VarScope.FUNCTION, VarKind.ARG);
        BIRNode.BIRVariableDcl scheduler = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("scheduler"), VarScope.FUNCTION, VarKind.ARG);
        BIRNode.BIRVariableDcl parent = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("parent"), VarScope.FUNCTION, VarKind.ARG);
        BIRNode.BIRVariableDcl properties = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("properties"), VarScope.FUNCTION, VarKind.ARG);
        BIRNode.BIRVariableDcl args = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("args"), VarScope.FUNCTION, VarKind.ARG);
        indexMap.getIndex(selfVar);
        int var1Index = indexMap.getIndex(var1);
        int schedulerIndex = indexMap.getIndex(scheduler);
        int parentIndex = indexMap.getIndex(parent);
        int propertiesIndex = indexMap.getIndex(properties);
        int argsIndex = indexMap.getIndex(args);
        mv.visitCode();
        Label defaultCaseLabel = new Label();
        objectTypeDefs.sort(JvmValueGen.NAME_HASH_COMPARATOR);
        List<Label> labels = JvmValueGen.createLabelsForSwitch(mv, var1Index, objectTypeDefs, defaultCaseLabel);
        List<Label> targetLabels = JvmValueGen.createLabelsForEqualCheck(mv, var1Index, objectTypeDefs, labels, defaultCaseLabel);
        int i = 0;
        for (BIRNode.BIRTypeDefinition optionalTypeDef : objectTypeDefs) {
            BIRNode.BIRTypeDefinition typeDef = JvmMethodGen.getTypeDef(optionalTypeDef);
            String fieldName = JvmTypeGen.getTypeFieldName(typeDef.name.value);
            Label targetLabel = targetLabels.get(i);
            mv.visitLabel(targetLabel);
            mv.visitVarInsn(25, 0);
            String className = JvmValueGen.getTypeValueClassName(moduleId, typeDef.name.value);
            mv.visitTypeInsn(187, className);
            mv.visitInsn(89);
            mv.visitFieldInsn(178, typeOwnerClass, fieldName, String.format("L%s;", "org/ballerinalang/jvm/types/BType"));
            mv.visitTypeInsn(192, "org/ballerinalang/jvm/types/BObjectType");
            mv.visitMethodInsn(183, className, "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BObjectType"), false);
            BIRNode.BIRVariableDcl tempVar = new BIRNode.BIRVariableDcl(typeDef.type, new Name("tempVar"), VarScope.FUNCTION, VarKind.LOCAL);
            int tempVarIndex = indexMap.getIndex(tempVar);
            mv.visitVarInsn(58, tempVarIndex);
            mv.visitTypeInsn(187, "org/ballerinalang/jvm/scheduling/Strand");
            mv.visitInsn(89);
            mv.visitVarInsn(25, schedulerIndex);
            mv.visitVarInsn(25, parentIndex);
            mv.visitVarInsn(25, propertiesIndex);
            mv.visitMethodInsn(183, "org/ballerinalang/jvm/scheduling/Strand", "<init>", String.format("(L%s;L%s;L%s;)V", "org/ballerinalang/jvm/scheduling/Scheduler", "org/ballerinalang/jvm/scheduling/Strand", "java/util/Map"), false);
            BIRNode.BIRVariableDcl strandVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("strandVar"), VarScope.FUNCTION, VarKind.LOCAL);
            int strandVarIndex = indexMap.getIndex(strandVar);
            mv.visitVarInsn(58, strandVarIndex);
            mv.visitVarInsn(25, tempVarIndex);
            mv.visitVarInsn(25, strandVarIndex);
            mv.visitLdcInsn((Object)"$__init$");
            mv.visitVarInsn(25, argsIndex);
            String methodDesc = String.format("(L%s;L%s;[L%s;)L%s;", "org/ballerinalang/jvm/scheduling/Strand", "java/lang/String", "java/lang/Object", "java/lang/Object");
            mv.visitMethodInsn(185, "org/ballerinalang/jvm/values/ObjectValue", "call", methodDesc, true);
            BIRNode.BIRVariableDcl tempResult = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name("tempResult"), VarScope.FUNCTION, VarKind.LOCAL);
            int tempResultIndex = indexMap.getIndex(tempResult);
            mv.visitVarInsn(58, tempResultIndex);
            mv.visitVarInsn(25, tempResultIndex);
            mv.visitTypeInsn(193, "org/ballerinalang/jvm/values/ErrorValue");
            Label noErrorLabel = new Label();
            mv.visitJumpInsn(153, noErrorLabel);
            mv.visitVarInsn(25, tempResultIndex);
            mv.visitTypeInsn(192, "org/ballerinalang/jvm/values/ErrorValue");
            mv.visitInsn(191);
            mv.visitLabel(noErrorLabel);
            mv.visitVarInsn(25, tempVarIndex);
            mv.visitInsn(176);
            ++i;
        }
        JvmValueGen.createDefaultCase(mv, defaultCaseLabel, var1Index);
        mv.visitMaxs(objectTypeDefs.size() + 100, objectTypeDefs.size() + 100);
        mv.visitEnd();
    }

    private static void createRecordType(MethodVisitor mv, BRecordType recordType, BIRNode.BIRTypeDefinition typeDef) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BRecordType");
        mv.visitInsn(89);
        BTypeSymbol typeSymbol = recordType.tsymbol;
        String name = typeSymbol.name.getValue();
        mv.visitLdcInsn((Object)name);
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BPackage");
        mv.visitInsn(89);
        PackageID packageID = recordType.tsymbol.pkgID;
        mv.visitLdcInsn((Object)packageID.orgName.value);
        mv.visitLdcInsn((Object)packageID.name.value);
        mv.visitLdcInsn((Object)packageID.version.value);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BPackage", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", false);
        mv.visitLdcInsn((Object)recordType.tsymbol.flags);
        mv.visitLdcInsn((Object)recordType.sealed);
        mv.visitLdcInsn((Object)JvmTypeGen.typeFlag(recordType));
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BRecordType", "<init>", String.format("(L%s;L%s;IZI)V", "java/lang/String", "org/ballerinalang/jvm/types/BPackage"), false);
    }

    private static void addRecordFields(MethodVisitor mv, @Nilable List<BField> fields) {
        mv.visitTypeInsn(187, "java/util/LinkedHashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V", false);
        for (BField optionalField : fields) {
            BField field = JvmMethodGen.getRecordField(optionalField);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)field.name.value);
            JvmTypeGen.createRecordField(mv, field);
            mv.visitMethodInsn(185, "java/util/Map", "put", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "java/lang/Object", "java/lang/Object"), true);
            mv.visitInsn(87);
        }
        mv.visitMethodInsn(182, "org/ballerinalang/jvm/types/BRecordType", "setFields", String.format("(L%s;)V", "java/util/Map"), false);
    }

    private static void createRecordField(MethodVisitor mv, BField field) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BField");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, field.type);
        mv.visitLdcInsn((Object)field.name.value);
        mv.visitLdcInsn((Object)field.symbol.flags);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BField", "<init>", String.format("(L%s;L%s;I)V", "org/ballerinalang/jvm/types/BType", "java/lang/String"), false);
    }

    private static int typeFlag(BType type) {
        return TypeFlags.asMask(type.isNullable(), type.isAnydata(), type.isPureType());
    }

    private static void addRecordRestField(MethodVisitor mv, BType restFieldType) {
        JvmTypeGen.loadType(mv, restFieldType);
        mv.visitFieldInsn(181, "org/ballerinalang/jvm/types/BRecordType", "restFieldType", String.format("L%s;", "org/ballerinalang/jvm/types/BType"));
    }

    private static void createObjectType(MethodVisitor mv, BObjectType objectType, BIRNode.BIRTypeDefinition typeDef) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BObjectType");
        mv.visitInsn(89);
        BTypeSymbol typeSymbol = objectType.tsymbol;
        String name = typeSymbol.name.getValue();
        mv.visitLdcInsn((Object)name);
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BPackage");
        mv.visitInsn(89);
        PackageID packageID = objectType.tsymbol.pkgID;
        mv.visitLdcInsn((Object)packageID.orgName.value);
        mv.visitLdcInsn((Object)packageID.name.value);
        mv.visitLdcInsn((Object)packageID.version.value);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BPackage", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", false);
        mv.visitLdcInsn((Object)typeSymbol.flags);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BObjectType", "<init>", String.format("(L%s;L%s;I)V", "java/lang/String", "org/ballerinalang/jvm/types/BPackage"), false);
    }

    private static void createServiceType(MethodVisitor mv, BObjectType objectType, BType typeDef) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BServiceType");
        mv.visitInsn(89);
        BTypeSymbol typeSymbol = objectType.tsymbol;
        String name = typeSymbol.name.getValue();
        mv.visitLdcInsn((Object)name);
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BPackage");
        mv.visitInsn(89);
        PackageID packageID = objectType.tsymbol.pkgID;
        mv.visitLdcInsn((Object)packageID.orgName.value);
        mv.visitLdcInsn((Object)packageID.name.value);
        mv.visitLdcInsn((Object)packageID.version.value);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BPackage", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", false);
        mv.visitLdcInsn((Object)typeSymbol.flags);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BServiceType", "<init>", String.format("(L%s;L%s;I)V", "java/lang/String", "org/ballerinalang/jvm/types/BPackage"), false);
    }

    static void duplicateServiceTypeWithAnnots(MethodVisitor mv, BObjectType objectType, String pkgName, int strandIndex) {
        JvmTypeGen.createServiceType(mv, objectType, objectType);
        mv.visitInsn(89);
        String pkgClassName = pkgName.equals(".") || pkgName.equals("") ? "___init" : JvmPackageGen.lookupGlobalVarClassName(pkgName, "$annotation_data");
        mv.visitFieldInsn(178, pkgClassName, "$annotation_data", String.format("L%s;", "org/ballerinalang/jvm/values/MapValue"));
        mv.visitVarInsn(25, strandIndex);
        JvmTypeGen.loadType(mv, objectType);
        mv.visitTypeInsn(192, "org/ballerinalang/jvm/types/BServiceType");
        BObjectTypeSymbol objectTypeSymbol = (BObjectTypeSymbol)objectType.tsymbol;
        List attachedFunctions = objectTypeSymbol.attachedFuncs;
        mv.visitLdcInsn((Object)attachedFunctions.size());
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "org/ballerinalang/jvm/types/AttachedFunction");
        int i = 0;
        for (BAttachedFunction attachedFunc : attachedFunctions) {
            if (attachedFunc == null) continue;
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)i);
            mv.visitInsn(136);
            JvmTypeGen.createObjectAttachedFunction(mv, attachedFunc, objectType);
            mv.visitInsn(83);
            ++i;
        }
        mv.visitMethodInsn(182, "org/ballerinalang/jvm/types/BServiceType", "setAttachedFuncsAndProcessAnnots", String.format("(L%s;L%s;L%s;[L%s;)V", "org/ballerinalang/jvm/values/MapValue", "org/ballerinalang/jvm/scheduling/Strand", "org/ballerinalang/jvm/types/BServiceType", "org/ballerinalang/jvm/types/AttachedFunction"), false);
    }

    private static void addObjectFields(MethodVisitor mv, @Nilable List<BField> fields) {
        mv.visitTypeInsn(187, "java/util/LinkedHashMap");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashMap", "<init>", "()V", false);
        for (BField optionalField : fields) {
            BField field = JvmMethodGen.getObjectField(optionalField);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)field.name.value);
            JvmTypeGen.createObjectField(mv, field);
            mv.visitMethodInsn(185, "java/util/Map", "put", String.format("(L%s;L%s;)L%s;", "java/lang/Object", "java/lang/Object", "java/lang/Object"), true);
            mv.visitInsn(87);
        }
        mv.visitMethodInsn(182, "org/ballerinalang/jvm/types/BObjectType", "setFields", String.format("(L%s;)V", "java/util/Map"), false);
    }

    private static void createObjectField(MethodVisitor mv, BField field) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BField");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, field.type);
        mv.visitLdcInsn((Object)field.name.value);
        mv.visitLdcInsn((Object)field.symbol.flags);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BField", "<init>", String.format("(L%s;L%s;I)V", "org/ballerinalang/jvm/types/BType", "java/lang/String"), false);
    }

    private static void addObjectAttachedFunctions(MethodVisitor mv, List<BAttachedFunction> attachedFunctions, BObjectType objType, JvmMethodGen.BalToJVMIndexMap indexMap) {
        mv.visitLdcInsn((Object)attachedFunctions.size());
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "org/ballerinalang/jvm/types/AttachedFunction");
        int i = 0;
        for (BAttachedFunction attachedFunc : attachedFunctions) {
            if (attachedFunc == null) continue;
            JvmTypeGen.createObjectAttachedFunction(mv, attachedFunc, objType);
            BIRNode.BIRVariableDcl attachedFuncVar = new BIRNode.BIRVariableDcl(JvmPackageGen.symbolTable.anyType, new Name(JvmTerminatorGen.TerminatorGenerator.toNameString(objType) + attachedFunc.funcName.value), VarScope.FUNCTION, VarKind.LOCAL);
            int attachedFunctionVarIndex = indexMap.getIndex(attachedFuncVar);
            mv.visitVarInsn(58, attachedFunctionVarIndex);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)i);
            mv.visitInsn(136);
            mv.visitVarInsn(25, attachedFunctionVarIndex);
            mv.visitInsn(83);
            ++i;
        }
        mv.visitMethodInsn(182, "org/ballerinalang/jvm/types/BObjectType", "setAttachedFunctions", String.format("([L%s;)V", "org/ballerinalang/jvm/types/AttachedFunction"), false);
    }

    private static void addObjectInitFunction(MethodVisitor mv, BAttachedFunction initFunction, BObjectType objType, JvmMethodGen.BalToJVMIndexMap indexMap, String funcName, String initializerFuncName) {
        if (initFunction == null || !initFunction.funcName.value.contains(funcName)) {
            return;
        }
        mv.visitInsn(89);
        JvmTypeGen.createObjectAttachedFunction(mv, initFunction, objType);
        BType anyType = JvmPackageGen.symbolTable.anyType;
        BIRNode.BIRVariableDcl attachedFuncVar = new BIRNode.BIRVariableDcl(anyType, new Name(objType.name + initFunction.funcName.value), VarScope.FUNCTION, VarKind.LOCAL);
        int attachedFunctionVarIndex = indexMap.getIndex(attachedFuncVar);
        mv.visitVarInsn(58, attachedFunctionVarIndex);
        mv.visitVarInsn(25, attachedFunctionVarIndex);
        mv.visitInsn(89);
        mv.visitInsn(87);
        mv.visitMethodInsn(182, "org/ballerinalang/jvm/types/BObjectType", initializerFuncName, String.format("(L%s;)V", "org/ballerinalang/jvm/types/AttachedFunction"), false);
    }

    private static void createObjectAttachedFunction(MethodVisitor mv, BAttachedFunction attachedFunc, BObjectType objType) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/AttachedFunction");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)attachedFunc.funcName.value);
        JvmTypeGen.loadType(mv, objType);
        mv.visitTypeInsn(192, "org/ballerinalang/jvm/types/BObjectType");
        JvmTypeGen.loadType(mv, attachedFunc.type);
        mv.visitLdcInsn((Object)attachedFunc.symbol.flags);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/AttachedFunction", "<init>", String.format("(L%s;L%s;L%s;I)V", "java/lang/String", "org/ballerinalang/jvm/types/BObjectType", "org/ballerinalang/jvm/types/BFunctionType"), false);
    }

    private static void createErrorType(MethodVisitor mv, BErrorType errorType, String name) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BErrorType");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)name);
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BPackage");
        mv.visitInsn(89);
        PackageID packageID = errorType.tsymbol.pkgID;
        mv.visitLdcInsn((Object)packageID.orgName.value);
        mv.visitLdcInsn((Object)packageID.name.value);
        mv.visitLdcInsn((Object)packageID.version.value);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BPackage", "<init>", String.format("(L%s;L%s;L%s;)V", "java/lang/String", "java/lang/String", "java/lang/String"), false);
        JvmTypeGen.loadType(mv, errorType.reasonType);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BErrorType", "<init>", String.format("(L%s;L%s;L%s;)V", "java/lang/String", "org/ballerinalang/jvm/types/BPackage", "org/ballerinalang/jvm/types/BType"), false);
    }

    private static String typeRefToClassName(PackageID typeRef, String className) {
        return JvmPackageGen.getModuleLevelClassName(typeRef.orgName.value, typeRef.name.value, className);
    }

    static void loadExternalType(MethodVisitor mv, PackageID pkgId, String name) {
        String fieldName = JvmTypeGen.getTypeFieldName(name);
        String externlTypeOwner = JvmTypeGen.typeRefToClassName(pkgId, "___init");
        mv.visitFieldInsn(178, externlTypeOwner, fieldName, String.format("L%s;", "org/ballerinalang/jvm/types/BType"));
    }

    static void loadLocalType(MethodVisitor mv, BIRNode.BIRTypeDefinition typeDefinition) {
        JvmTypeGen.loadType(mv, typeDefinition.type);
    }

    static void loadType(MethodVisitor mv, @Nilable BType bType) {
        String typeFieldName = "";
        if (bType == null || bType.tag == 10) {
            typeFieldName = "typeNull";
        } else if (bType.tag == 1) {
            typeFieldName = "typeInt";
        } else if (bType.tag == 36) {
            typeFieldName = "typeIntSigned32";
        } else if (bType.tag == 37) {
            typeFieldName = "typeIntSigned16";
        } else if (bType.tag == 38) {
            typeFieldName = "typeIntSigned8";
        } else if (bType.tag == 39) {
            typeFieldName = "typeIntUnsigned32";
        } else if (bType.tag == 40) {
            typeFieldName = "typeIntUnsigned16";
        } else if (bType.tag == 41) {
            typeFieldName = "typeIntUnsigned8";
        } else if (bType.tag == 3) {
            typeFieldName = "typeFloat";
        } else if (bType.tag == 5) {
            typeFieldName = "typeString";
        } else if (bType.tag == 42) {
            typeFieldName = "typeStringChar";
        } else if (bType.tag == 4) {
            typeFieldName = "typeDecimal";
        } else if (bType.tag == 6) {
            typeFieldName = "typeBoolean";
        } else if (bType.tag == 2) {
            typeFieldName = "typeByte";
        } else if (bType.tag == 17) {
            typeFieldName = "typeAny";
        } else if (bType.tag == 11) {
            typeFieldName = "typeAnydata";
        } else if (bType.tag == 7) {
            typeFieldName = "typeJSON";
        } else if (bType.tag == 8) {
            typeFieldName = "typeXML";
        } else if (bType.tag == 43) {
            typeFieldName = "typeElement";
        } else if (bType.tag == 44) {
            typeFieldName = "typeProcessingInstruction";
        } else if (bType.tag == 45) {
            typeFieldName = "typeComment";
        } else if (bType.tag == 46) {
            typeFieldName = "typeText";
        } else {
            if (bType.tag == 13) {
                JvmTypeGen.loadTypedescType(mv, (BTypedescType)bType);
                return;
            }
            if (bType.tag == 32) {
                if (bType instanceof BServiceType) {
                    if (!Objects.equals(JvmTypeGen.getTypeFieldName(JvmTerminatorGen.TerminatorGenerator.toNameString(bType)), "$type$service")) {
                        JvmTypeGen.loadUserDefinedType(mv, bType);
                        return;
                    }
                    typeFieldName = "typeAnyService";
                } else if (bType instanceof BObjectType) {
                    JvmTypeGen.loadUserDefinedType(mv, bType);
                    return;
                }
            } else if (bType.tag == 35) {
                typeFieldName = "typeHandle";
            } else {
                if (bType.tag == 19) {
                    JvmTypeGen.loadArrayType(mv, (BArrayType)bType);
                    return;
                }
                if (bType.tag == 15) {
                    JvmTypeGen.loadMapType(mv, (BMapType)bType);
                    return;
                }
                if (bType.tag == 9) {
                    JvmTypeGen.loadTableType(mv, (BTableType)bType);
                    return;
                }
                if (bType.tag == 14) {
                    JvmTypeGen.loadStreamType(mv, (BStreamType)bType);
                    return;
                }
                if (bType.tag == 27) {
                    JvmTypeGen.loadErrorType(mv, (BErrorType)bType);
                    return;
                }
                if (bType.tag == 20) {
                    JvmTypeGen.loadUnionType(mv, (BUnionType)bType);
                    return;
                }
                if (bType.tag == 12) {
                    JvmTypeGen.loadUserDefinedType(mv, bType);
                    return;
                }
                if (bType.tag == 16) {
                    JvmTypeGen.loadInvokableType(mv, (BInvokableType)bType);
                    return;
                }
                if (bType.tag == 22) {
                    mv.visitInsn(1);
                    return;
                }
                if (bType.tag == 29) {
                    JvmTypeGen.loadTupleType(mv, (BTupleType)bType);
                    return;
                }
                if (bType.tag == 31) {
                    JvmTypeGen.loadFiniteType(mv, (BFiniteType)bType);
                    return;
                }
                if (bType.tag == 30) {
                    JvmTypeGen.loadFutureType(mv, (BFutureType)bType);
                    return;
                }
                return;
            }
        }
        mv.visitFieldInsn(178, "org/ballerinalang/jvm/types/BTypes", typeFieldName, String.format("L%s;", "org/ballerinalang/jvm/types/BType"));
    }

    private static void loadArrayType(MethodVisitor mv, BArrayType bType) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BArrayType");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, bType.eType);
        int arraySize = bType.size;
        mv.visitLdcInsn((Object)arraySize);
        mv.visitInsn(136);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BArrayType", "<init>", String.format("(L%s;I)V", "org/ballerinalang/jvm/types/BType"), false);
    }

    private static void loadTypedescType(MethodVisitor mv, BTypedescType bType) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BTypedescType");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, bType.constraint);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BTypedescType", "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BType"), false);
    }

    private static void loadMapType(MethodVisitor mv, BMapType bType) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BMapType");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, bType.constraint);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BMapType", "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BType"), false);
    }

    private static void loadTableType(MethodVisitor mv, BTableType bType) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BTableType");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, bType.constraint);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BTableType", "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BType"), false);
    }

    private static void loadStreamType(MethodVisitor mv, BStreamType bType) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BStreamType");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, bType.constraint);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BStreamType", "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BType"), false);
    }

    private static void loadErrorType(MethodVisitor mv, BErrorType errorType) {
        PackageID packageID = errorType.tsymbol.pkgID;
        if (packageID.orgName.value.equals("ballerina") && packageID.name.value.equals("lang.annotations")) {
            mv.visitFieldInsn(178, "org/ballerinalang/jvm/types/BTypes", "typeError", String.format("L%s;", "org/ballerinalang/jvm/types/BErrorType"));
            return;
        }
        String typeOwner = JvmPackageGen.getPackageName(packageID.orgName.value, packageID.name.value) + "___init";
        String fieldName = JvmTypeGen.getTypeFieldName(JvmTerminatorGen.TerminatorGenerator.toNameString(errorType));
        mv.visitFieldInsn(178, typeOwner, fieldName, String.format("L%s;", "org/ballerinalang/jvm/types/BType"));
    }

    private static void loadUnionType(MethodVisitor mv, BUnionType bType) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BUnionType");
        mv.visitInsn(89);
        Set<BType> memberTypes = bType.getMemberTypes();
        mv.visitLdcInsn((Object)memberTypes.size());
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "org/ballerinalang/jvm/types/BType");
        int i = 0;
        for (BType memberType : memberTypes) {
            BType mType = JvmMethodGen.getType(memberType);
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)i);
            mv.visitInsn(136);
            JvmTypeGen.loadType(mv, mType);
            mv.visitInsn(83);
            ++i;
        }
        mv.visitLdcInsn((Object)JvmTypeGen.typeFlag(bType));
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BUnionType", "<init>", String.format("([L%s;I)V", "org/ballerinalang/jvm/types/BType"), false);
    }

    private static void loadTupleType(MethodVisitor mv, BTupleType bType) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BTupleType");
        mv.visitInsn(89);
        mv.visitTypeInsn(187, "java/util/ArrayList");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/ArrayList", "<init>", "()V", false);
        List<BType> tupleTypes = bType.tupleTypes;
        for (BType tupleType : tupleTypes) {
            BType tType = JvmMethodGen.getType(tupleType);
            mv.visitInsn(89);
            JvmTypeGen.loadType(mv, tType);
            mv.visitMethodInsn(185, "java/util/List", "add", String.format("(L%s;)Z", "java/lang/Object"), true);
            mv.visitInsn(87);
        }
        BType restType = bType.restType;
        if (restType == null) {
            mv.visitInsn(1);
        } else {
            JvmTypeGen.loadType(mv, restType);
        }
        mv.visitLdcInsn((Object)JvmTypeGen.typeFlag(bType));
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BTupleType", "<init>", String.format("(L%s;L%s;I)V", "java/util/List", "org/ballerinalang/jvm/types/BType"), false);
    }

    private static void loadUserDefinedType(MethodVisitor mv, BType bType) {
        PackageID packageID = bType.tsymbol.pkgID;
        String typeOwner = JvmPackageGen.getPackageName(packageID.orgName.value, packageID.name.value) + "___init";
        String fieldName = JvmTypeGen.getTypeFieldName(JvmTerminatorGen.TerminatorGenerator.toNameString(bType));
        mv.visitFieldInsn(178, typeOwner, fieldName, String.format("L%s;", "org/ballerinalang/jvm/types/BType"));
    }

    private static String getTypeFieldName(String typeName) {
        return String.format("$type$%s", typeName);
    }

    private static void loadFutureType(MethodVisitor mv, BFutureType bType) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BFutureType");
        mv.visitInsn(89);
        JvmTypeGen.loadType(mv, bType.constraint);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BFutureType", "<init>", String.format("(L%s;)V", "org/ballerinalang/jvm/types/BType"), false);
    }

    private static void loadInvokableType(MethodVisitor mv, BInvokableType bType) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BFunctionType");
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)bType.paramTypes.size());
        mv.visitInsn(136);
        mv.visitTypeInsn(189, "org/ballerinalang/jvm/types/BType");
        int i = 0;
        for (BType paramType : bType.paramTypes) {
            mv.visitInsn(89);
            mv.visitLdcInsn((Object)i);
            mv.visitInsn(136);
            JvmTypeGen.loadType(mv, paramType);
            mv.visitInsn(83);
            ++i;
        }
        BType restType = bType.restType;
        if (restType == null) {
            mv.visitInsn(1);
        } else {
            JvmTypeGen.loadType(mv, restType);
        }
        JvmTypeGen.loadType(mv, bType.retType);
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BFunctionType", "<init>", String.format("([L%s;L%s;L%s;)V", "org/ballerinalang/jvm/types/BType", "org/ballerinalang/jvm/types/BType", "org/ballerinalang/jvm/types/BType"), false);
    }

    static String getTypeDesc(BType bType) {
        if (TypeTags.isIntegerTypeTag(bType.tag)) {
            return "J";
        }
        if (bType.tag == 2) {
            return "I";
        }
        if (bType.tag == 3) {
            return "D";
        }
        if (TypeTags.isStringTypeTag(bType.tag)) {
            return String.format("L%s;", JvmInstructionGen.isBString ? "org/ballerinalang/jvm/values/api/BString" : "java/lang/String");
        }
        if (bType.tag == 6) {
            return "Z";
        }
        if (bType.tag == 10) {
            return String.format("L%s;", "java/lang/Object");
        }
        if (bType.tag == 19 || bType.tag == 29) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/ArrayValue");
        }
        if (bType.tag == 27) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/ErrorValue");
        }
        if (bType.tag == 30) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/FutureValue");
        }
        if (bType.tag == 15 || bType.tag == 12) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/MapValue");
        }
        if (bType.tag == 13) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/TypedescValue");
        }
        if (bType.tag == 9) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/TableValue");
        }
        if (bType.tag == 14) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/StreamValue");
        }
        if (bType.tag == 4) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/DecimalValue");
        }
        if (bType.tag == 32) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/ObjectValue");
        }
        if (TypeTags.isXMLTypeTag(bType.tag)) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/XMLValue");
        }
        if (bType.tag == 35) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/HandleValue");
        }
        if (bType.tag == 17 || bType.tag == 11 || bType.tag == 20 || bType.tag == 7 || bType.tag == 31) {
            return String.format("L%s;", "java/lang/Object");
        }
        if (bType.tag == 16) {
            return String.format("L%s;", "org/ballerinalang/jvm/values/FPValue");
        }
        throw new BLangCompilerException("JVM generation is not supported for type " + String.format("%s", bType));
    }

    private static void loadFiniteType(MethodVisitor mv, BFiniteType finiteType) {
        mv.visitTypeInsn(187, "org/ballerinalang/jvm/types/BFiniteType");
        mv.visitInsn(89);
        String name = JvmTerminatorGen.TerminatorGenerator.toNameString(finiteType);
        mv.visitLdcInsn((Object)name);
        mv.visitTypeInsn(187, "java/util/LinkedHashSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/LinkedHashSet", "<init>", "()V", false);
        for (BLangExpression valueTypePair : finiteType.getValueSpace()) {
            Object value = ((BLangLiteral)valueTypePair).value;
            BType valueType = valueTypePair.type;
            mv.visitInsn(89);
            JvmInstructionGen.loadConstantValue(valueType, value, mv);
            if (TypeTags.isIntegerTypeTag(valueType.tag)) {
                mv.visitMethodInsn(184, "java/lang/Long", "valueOf", String.format("(J)L%s;", "java/lang/Long"), false);
            } else if (valueType.tag == 6) {
                mv.visitMethodInsn(184, "java/lang/Boolean", "valueOf", String.format("(Z)L%s;", "java/lang/Boolean"), false);
            } else if (valueType.tag == 3) {
                mv.visitMethodInsn(184, "java/lang/Double", "valueOf", String.format("(D)L%s;", "java/lang/Double"), false);
            } else if (valueType.tag == 2) {
                mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", String.format("(I)L%s;", "java/lang/Integer"), false);
            } else if (valueType.tag == 4) {
                // empty if block
            }
            mv.visitMethodInsn(185, "java/util/Set", "add", String.format("(L%s;)Z", "java/lang/Object"), true);
            mv.visitInsn(87);
        }
        mv.visitLdcInsn((Object)JvmTypeGen.typeFlag(finiteType));
        mv.visitMethodInsn(183, "org/ballerinalang/jvm/types/BFiniteType", "<init>", String.format("(L%s;L%s;I)V", "java/lang/String", "java/util/Set"), false);
    }

    static boolean isServiceDefAvailable(@Nilable List<BIRNode.BIRTypeDefinition> typeDefs) {
        for (BIRNode.BIRTypeDefinition optionalTypeDef : typeDefs) {
            BIRNode.BIRTypeDefinition typeDef = JvmMethodGen.getTypeDef(optionalTypeDef);
            BType bType = typeDef.type;
            if (!(bType instanceof BServiceType)) continue;
            return true;
        }
        return false;
    }
}

