/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.semantics.model.types;

import java.util.ArrayList;
import java.util.Optional;
import org.ballerinalang.model.types.RecordType;
import org.ballerinalang.model.types.TypeKind;
import org.wso2.ballerinalang.compiler.semantics.model.TypeVisitor;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BTypeSymbol;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.Symbols;
import org.wso2.ballerinalang.compiler.semantics.model.types.BField;
import org.wso2.ballerinalang.compiler.semantics.model.types.BStructureType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BType;
import org.wso2.ballerinalang.compiler.semantics.model.types.BTypeVisitor;

public class BRecordType
extends BStructureType
implements RecordType {
    private static final String SPACE = " ";
    private static final String RECORD = "record";
    private static final String CLOSE_LEFT = "{|";
    private static final String SEMI = ";";
    private static final String CLOSE_RIGHT = "|}";
    private static final String DOLLAR = "$";
    private static final String REST = "...";
    public static final String OPTIONAL = "?";
    public static final String EMPTY = "";
    public boolean sealed;
    public BType restFieldType;
    private Optional<Boolean> isAnyData = Optional.empty();
    private boolean resolving = false;

    public BRecordType(BTypeSymbol tSymbol) {
        super(12, tSymbol);
        this.fields = new ArrayList();
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.RECORD;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T, R> R accept(BTypeVisitor<T, R> visitor, T t) {
        return visitor.visit(this, t);
    }

    @Override
    public String toString() {
        if (this.tsymbol.name != null && (this.tsymbol.name.value.isEmpty() || this.tsymbol.name.value.startsWith(DOLLAR))) {
            StringBuilder sb = new StringBuilder();
            sb.append(RECORD).append(SPACE).append(CLOSE_LEFT);
            for (BField field : this.fields) {
                sb.append(SPACE).append(field.type).append(SPACE).append(field.name).append(Symbols.isOptional(field.symbol) ? OPTIONAL : EMPTY).append(SEMI);
            }
            if (this.sealed) {
                sb.append(SPACE).append(CLOSE_RIGHT);
                return sb.toString();
            }
            sb.append(SPACE).append(this.restFieldType).append(REST).append(SEMI).append(SPACE).append(CLOSE_RIGHT);
            return sb.toString();
        }
        return this.tsymbol.toString();
    }

    @Override
    public final boolean isAnydata() {
        if (!this.isAnyData.isPresent()) {
            if (this.resolving) {
                return true;
            }
            this.resolving = true;
            this.isAnyData = Optional.of(this.findIsAnyData());
            this.resolving = false;
        }
        return this.isAnyData.get();
    }

    private boolean findIsAnyData() {
        for (BField field : this.fields) {
            if (field.type.isPureType()) continue;
            return false;
        }
        return this.sealed || this.restFieldType.isPureType();
    }
}

