/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.tree.expressions;

import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.expressions.IndexBasedAccessNode;
import org.wso2.ballerinalang.compiler.semantics.model.symbols.BVarSymbol;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangExpression;
import org.wso2.ballerinalang.compiler.util.FieldKind;
import org.wso2.ballerinalang.compiler.util.diagnotic.DiagnosticPos;

public class BLangIndexBasedAccess
extends BLangAccessExpression
implements IndexBasedAccessNode {
    public BLangExpression indexExpr;

    @Override
    public BLangExpression getExpression() {
        return this.expr;
    }

    @Override
    public BLangExpression getIndex() {
        return this.indexExpr;
    }

    public String toString() {
        return String.valueOf(this.expr) + "[" + String.valueOf(this.indexExpr) + "]";
    }

    @Override
    public void accept(BLangNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public NodeKind getKind() {
        return NodeKind.INDEX_BASED_ACCESS_EXPR;
    }

    public static class BLangTupleAccessExpr
    extends BLangIndexBasedAccess {
        public BLangTupleAccessExpr(DiagnosticPos pos, BLangExpression varRef, BLangExpression indexExpr) {
            this.pos = pos;
            this.expr = varRef;
            this.indexExpr = indexExpr;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangStructFieldAccessExpr
    extends BLangIndexBasedAccess {
        public BLangStructFieldAccessExpr(DiagnosticPos pos, BLangExpression varRef, BLangExpression keyExpr, BVarSymbol fieldSymbol, boolean except) {
            this.pos = pos;
            this.expr = varRef;
            this.indexExpr = keyExpr;
            this.symbol = fieldSymbol;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangXMLAccessExpr
    extends BLangIndexBasedAccess {
        public FieldKind fieldType;

        public BLangXMLAccessExpr(DiagnosticPos pos, BLangExpression varRef, BLangExpression indexExpr) {
            this.pos = pos;
            this.expr = varRef;
            this.indexExpr = indexExpr;
            this.fieldType = FieldKind.SINGLE;
        }

        public BLangXMLAccessExpr(DiagnosticPos pos, BLangExpression varRef, BLangExpression indexExpr, FieldKind fieldType) {
            this.pos = pos;
            this.expr = varRef;
            this.indexExpr = indexExpr;
            this.fieldType = fieldType;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangStringAccessExpr
    extends BLangIndexBasedAccess {
        public BLangStringAccessExpr(DiagnosticPos pos, BLangExpression varExpr, BLangExpression keyExpr) {
            this.pos = pos;
            this.expr = varExpr;
            this.indexExpr = keyExpr;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangJSONAccessExpr
    extends BLangIndexBasedAccess {
        public BLangJSONAccessExpr(DiagnosticPos pos, BLangExpression varExpr, BLangExpression keyExpr) {
            this.pos = pos;
            this.expr = varExpr;
            this.indexExpr = keyExpr;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangMapAccessExpr
    extends BLangIndexBasedAccess {
        public BLangMapAccessExpr(DiagnosticPos pos, BLangExpression varExpr, BLangExpression keyExpr) {
            this.pos = pos;
            this.expr = varExpr;
            this.indexExpr = keyExpr;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BLangArrayAccessExpr
    extends BLangIndexBasedAccess {
        public BLangArrayAccessExpr(DiagnosticPos pos, BLangExpression varRef, BLangExpression indexExpr) {
            this.pos = pos;
            this.expr = varRef;
            this.indexExpr = indexExpr;
        }

        @Override
        public void accept(BLangNodeVisitor visitor) {
            visitor.visit(this);
        }
    }
}

