/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.util;

import java.io.IOException;
import java.nio.file.Path;
import org.ballerinalang.toml.exceptions.TomlException;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.model.Settings;
import org.ballerinalang.toml.parser.ManifestProcessor;
import org.ballerinalang.toml.parser.SettingsProcessor;
import org.wso2.ballerinalang.util.RepoUtils;

public class TomlParserUtils {
    public static Settings readSettings() {
        Path settingsFilePath = RepoUtils.createAndGetHomeReposPath().resolve("Settings.toml");
        try {
            return SettingsProcessor.parseTomlContentFromFile(settingsFilePath);
        }
        catch (IOException e) {
            return new Settings();
        }
    }

    public static Manifest getManifest(Path projectDirPath) {
        Path manifestFilePath = projectDirPath.resolve("Ballerina.toml");
        try {
            return ManifestProcessor.parseTomlContentFromFile(manifestFilePath);
        }
        catch (IOException | TomlException e) {
            return new Manifest();
        }
    }
}

