/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.ballerinalang.compiler.BLangCompilerException;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.toml.model.Manifest;
import org.ballerinalang.toml.parser.ManifestProcessor;
import org.wso2.ballerinalang.compiler.BinaryFileWriter;
import org.wso2.ballerinalang.compiler.CompilerDriver;
import org.wso2.ballerinalang.compiler.DependencyTree;
import org.wso2.ballerinalang.compiler.PackageLoader;
import org.wso2.ballerinalang.compiler.SourceDirectoryManager;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.util.CompilerContext;
import org.wso2.ballerinalang.compiler.util.ProjectDirs;
import org.wso2.ballerinalang.compiler.util.diagnotic.BLangDiagnosticLogHelper;
import org.wso2.ballerinalang.util.Lists;

public class Compiler {
    private static final CompilerContext.Key<Compiler> COMPILER_KEY = new CompilerContext.Key();
    private final SourceDirectoryManager sourceDirectoryManager;
    private final CompilerDriver compilerDriver;
    private final BinaryFileWriter binaryFileWriter;
    private final DependencyTree dependencyTree;
    private final BLangDiagnosticLogHelper dlog;
    private final PackageLoader pkgLoader;
    private final Manifest manifest;
    private boolean langLibsLoaded;
    private PrintStream outStream;

    private Compiler(CompilerContext context) {
        context.put(COMPILER_KEY, this);
        this.sourceDirectoryManager = SourceDirectoryManager.getInstance(context);
        this.compilerDriver = CompilerDriver.getInstance(context);
        this.binaryFileWriter = BinaryFileWriter.getInstance(context);
        this.dependencyTree = DependencyTree.getInstance(context);
        this.dlog = BLangDiagnosticLogHelper.getInstance(context);
        this.pkgLoader = PackageLoader.getInstance(context);
        this.manifest = ManifestProcessor.getInstance(context).getManifest();
        this.outStream = System.out;
        this.langLibsLoaded = false;
    }

    public static Compiler getInstance(CompilerContext context) {
        Compiler compiler = context.get(COMPILER_KEY);
        if (compiler == null) {
            compiler = new Compiler(context);
        }
        return compiler;
    }

    public void setOutStream(PrintStream outStream) {
        this.outStream = outStream;
    }

    public BLangPackage compile(String sourcePackage) {
        return this.compile(sourcePackage, false);
    }

    public BLangPackage compile(String sourcePackage, boolean isBuild) {
        if (!isBuild && !this.sourceDirectoryManager.checkIfSourcesExists(sourcePackage)) {
            throw new BLangCompilerException("no ballerina source files found in module '" + sourcePackage + "'");
        }
        PackageID packageID = this.sourceDirectoryManager.getPackageID(sourcePackage);
        if (packageID == null) {
            throw ProjectDirs.getPackageNotFoundError(sourcePackage);
        }
        return this.compilePackage(packageID);
    }

    public BLangPackage build(String sourcePackage) {
        if (!this.sourceDirectoryManager.checkIfSourcesExists(sourcePackage)) {
            throw new BLangCompilerException("no ballerina source files found in module '" + sourcePackage + "'");
        }
        this.outStream.println("Compiling source");
        BLangPackage bLangPackage = this.compile(sourcePackage, true);
        if (this.dlog.getErrorCount() > 0) {
            throw new BLangCompilerException("compilation contains errors");
        }
        return bLangPackage;
    }

    public void write(List<BLangPackage> packageList) {
        if (packageList.stream().anyMatch(bLangPackage -> bLangPackage.symbol.entryPointExists)) {
            this.outStream.println("Generating executables");
        }
        packageList.forEach(this.binaryFileWriter::write);
    }

    public void write(BLangPackage bLangPackage, String targetFileName) {
        this.binaryFileWriter.write(bLangPackage, targetFileName);
    }

    public void list() {
        this.compilePackages(true).forEach(this.dependencyTree::listDependencyPackages);
    }

    public void list(String sourcePackage) {
        BLangPackage bLangPackage = this.compile(sourcePackage);
        if (bLangPackage.diagCollector.hasErrors()) {
            throw new BLangCompilerException("compilation contains errors");
        }
        this.dependencyTree.listDependencyPackages(bLangPackage);
    }

    public List<BLangPackage> compilePackages(boolean isBuild) {
        List<PackageID> pkgList = this.sourceDirectoryManager.listSourceFilesAndPackages().collect(Collectors.toList());
        if (pkgList.size() == 0) {
            return new ArrayList<BLangPackage>();
        }
        this.outStream.println("Compiling source");
        List<BLangPackage> compiledPackages = this.compilePackages(pkgList);
        if (isBuild && this.dlog.getErrorCount() > 0) {
            throw new BLangCompilerException("compilation contains errors");
        }
        return compiledPackages;
    }

    private List<BLangPackage> compilePackages(List<PackageID> pkgIdList) {
        if (!this.langLibsLoaded) {
            this.compilerDriver.loadLangModules(pkgIdList);
            this.langLibsLoaded = true;
        }
        ArrayList<BLangPackage> packages = new ArrayList<BLangPackage>();
        for (PackageID pkgId : pkgIdList) {
            BLangPackage bLangPackage = this.pkgLoader.loadEntryPackage(pkgId, null, this.outStream);
            if (bLangPackage == null) continue;
            packages.add(bLangPackage);
        }
        for (BLangPackage pkgNode : packages) {
            if (pkgNode.symbol == null) continue;
            this.compilerDriver.compilePackage(pkgNode);
            this.dlog.resetErrorCount();
        }
        return packages;
    }

    private BLangPackage compilePackage(PackageID packageID) {
        List<BLangPackage> compiledPackages = this.compilePackages(Lists.of(packageID));
        if (compiledPackages.isEmpty()) {
            throw new BLangCompilerException("compilation contains errors");
        }
        return compiledPackages.get(0);
    }
}

