/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ballerinalang.compiler.parser;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.tree.Node;
import org.ballerinalang.model.tree.NodeKind;
import org.ballerinalang.model.tree.TopLevelNode;
import org.ballerinalang.model.tree.expressions.ExpressionNode;
import org.ballerinalang.model.tree.statements.VariableDefinitionNode;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotation;
import org.wso2.ballerinalang.compiler.tree.BLangAnnotationAttachment;
import org.wso2.ballerinalang.compiler.tree.BLangBlockFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangCompilationUnit;
import org.wso2.ballerinalang.compiler.tree.BLangEndpoint;
import org.wso2.ballerinalang.compiler.tree.BLangErrorVariable;
import org.wso2.ballerinalang.compiler.tree.BLangExprFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangExternalFunctionBody;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;
import org.wso2.ballerinalang.compiler.tree.BLangImportPackage;
import org.wso2.ballerinalang.compiler.tree.BLangInvokableNode;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangMarkdownReferenceDocumentation;
import org.wso2.ballerinalang.compiler.tree.BLangNode;
import org.wso2.ballerinalang.compiler.tree.BLangNodeVisitor;
import org.wso2.ballerinalang.compiler.tree.BLangPackage;
import org.wso2.ballerinalang.compiler.tree.BLangRecordVariable;
import org.wso2.ballerinalang.compiler.tree.BLangResource;
import org.wso2.ballerinalang.compiler.tree.BLangService;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTestablePackage;
import org.wso2.ballerinalang.compiler.tree.BLangTupleVariable;
import org.wso2.ballerinalang.compiler.tree.BLangTypeDefinition;
import org.wso2.ballerinalang.compiler.tree.BLangVariable;
import org.wso2.ballerinalang.compiler.tree.BLangWorker;
import org.wso2.ballerinalang.compiler.tree.BLangXMLNS;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangDoClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangFromClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangLetClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangSelectClause;
import org.wso2.ballerinalang.compiler.tree.clauses.BLangWhereClause;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAccessExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangAnnotAccessExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangArrowFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangBinaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckPanickedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangCheckedExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangConstant;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangElvisExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangErrorVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangFieldBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangGroupExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIgnoreExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIndexBasedAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIntRangeExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangInvocation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsAssignableExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangIsLikeExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLambdaFunction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLetExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangListConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkDownDeprecatedParametersDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkDownDeprecationDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownDocumentationLine;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMarkdownReturnParameterDocumentation;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangMatchExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNamedArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangNumericLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryAction;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangQueryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRecordVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangRestArgsExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangServiceConstructorExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangSimpleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStatementExpression;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangStringTemplateLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTableLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTernaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTrapExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTupleVarRef;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeConversionExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeInit;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypeTestExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangTypedescExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangUnaryExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWaitForAllExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerFlushExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerReceive;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangWorkerSyncSendExpr;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttribute;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLAttributeAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLCommentLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementFilter;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLElementLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLNavigationAccess;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLProcInsLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQName;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLQuotedString;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLSequenceLiteral;
import org.wso2.ballerinalang.compiler.tree.expressions.BLangXMLTextLiteral;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAbort;
import org.wso2.ballerinalang.compiler.tree.statements.BLangAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBlockStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangBreak;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangCompoundAssignment;
import org.wso2.ballerinalang.compiler.tree.statements.BLangContinue;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangErrorVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangExpressionStmt;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForeach;
import org.wso2.ballerinalang.compiler.tree.statements.BLangForkJoin;
import org.wso2.ballerinalang.compiler.tree.statements.BLangIf;
import org.wso2.ballerinalang.compiler.tree.statements.BLangLock;
import org.wso2.ballerinalang.compiler.tree.statements.BLangMatch;
import org.wso2.ballerinalang.compiler.tree.statements.BLangPanic;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRecordVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangRetry;
import org.wso2.ballerinalang.compiler.tree.statements.BLangReturn;
import org.wso2.ballerinalang.compiler.tree.statements.BLangSimpleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTransaction;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTryCatchFinally;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleDestructure;
import org.wso2.ballerinalang.compiler.tree.statements.BLangTupleVariableDef;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWhile;
import org.wso2.ballerinalang.compiler.tree.statements.BLangWorkerSend;
import org.wso2.ballerinalang.compiler.tree.statements.BLangXMLNSStatement;
import org.wso2.ballerinalang.compiler.tree.types.BLangArrayType;
import org.wso2.ballerinalang.compiler.tree.types.BLangBuiltInRefTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangConstrainedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangErrorType;
import org.wso2.ballerinalang.compiler.tree.types.BLangFiniteTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangFunctionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangLetVariable;
import org.wso2.ballerinalang.compiler.tree.types.BLangObjectTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangRecordTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangStreamType;
import org.wso2.ballerinalang.compiler.tree.types.BLangStructureTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangTupleTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangType;
import org.wso2.ballerinalang.compiler.tree.types.BLangUnionTypeNode;
import org.wso2.ballerinalang.compiler.tree.types.BLangUserDefinedType;
import org.wso2.ballerinalang.compiler.tree.types.BLangValueType;
import org.wso2.ballerinalang.compiler.util.CompilerContext;

public class NodeCloner
extends BLangNodeVisitor {
    private static final CompilerContext.Key<NodeCloner> NODE_CLONER_KEY = new CompilerContext.Key();
    int currentCloneAttempt;

    private NodeCloner() {
    }

    public static NodeCloner getInstance(CompilerContext context) {
        NodeCloner nodeCloner = context.get(NODE_CLONER_KEY);
        if (nodeCloner == null) {
            nodeCloner = new NodeCloner();
            context.put(NODE_CLONER_KEY, nodeCloner);
        }
        return nodeCloner;
    }

    synchronized BLangCompilationUnit cloneCUnit(BLangCompilationUnit source) {
        ++source.cloneAttempt;
        this.currentCloneAttempt = source.cloneAttempt;
        source.accept(this);
        BLangCompilationUnit clone = (BLangCompilationUnit)source.cloneRef;
        clone.pos = source.pos;
        clone.addWS(source.getWS());
        return clone;
    }

    private <T extends Node> List<T> cloneList(List<T> nodes) {
        if (nodes == null) {
            return null;
        }
        ArrayList<Node> cloneList = new ArrayList<Node>();
        for (Node node : nodes) {
            Node clone = this.clone(node);
            cloneList.add(clone);
        }
        return cloneList;
    }

    public <T extends Node> T clone(T source) {
        BLangNode result;
        if (source == null) {
            return null;
        }
        BLangNode sourceNode = (BLangNode)source;
        if (sourceNode.cloneRef != null && ((BLangNode)source).cloneAttempt == this.currentCloneAttempt) {
            result = sourceNode.cloneRef;
        } else {
            sourceNode.cloneAttempt = this.currentCloneAttempt;
            sourceNode.cloneRef = null;
            sourceNode.accept(this);
            result = sourceNode.cloneRef;
            result.pos = sourceNode.pos;
            result.addWS(source.getWS());
            result.type = sourceNode.type;
        }
        return (T)result;
    }

    private void cloneBLangInvokableNode(BLangInvokableNode source, BLangInvokableNode clone) {
        clone.name = source.name;
        clone.defaultWorkerName = source.defaultWorkerName;
        clone.requiredParams = this.cloneList(source.requiredParams);
        clone.returnTypeNode = this.clone(source.returnTypeNode);
        clone.returnTypeAnnAttachments = this.cloneList(source.returnTypeAnnAttachments);
        clone.body = this.clone(source.body);
        clone.flagSet = this.cloneSet(source.flagSet, Flag.class);
        clone.markdownDocumentationAttachment = this.clone(source.markdownDocumentationAttachment);
        clone.annAttachments = this.cloneList(source.annAttachments);
        clone.restParam = this.clone(source.restParam);
    }

    private void cloneBLangVariable(BLangVariable source, BLangVariable clone) {
        clone.typeNode = this.clone(source.typeNode);
        clone.expr = this.clone(source.expr);
        clone.flagSet = this.cloneSet(source.flagSet, Flag.class);
        clone.annAttachments = this.cloneList(source.annAttachments);
        clone.markdownDocumentationAttachment = this.clone(source.markdownDocumentationAttachment);
        clone.isDeclaredWithVar = source.isDeclaredWithVar;
    }

    private void cloneBLangLiteral(BLangLiteral source, BLangLiteral clone) {
        clone.value = source.value;
        clone.originalValue = source.originalValue;
        clone.isJSONContext = source.isJSONContext;
        clone.isFiniteContext = source.isFiniteContext;
        clone.isConstant = source.isConstant;
        clone.type = source.type;
    }

    private void cloneBLangAccessExpression(BLangAccessExpression source, BLangAccessExpression clone) {
        clone.expr = this.clone(source.expr);
        clone.optionalFieldAccess = source.optionalFieldAccess;
        clone.errorSafeNavigation = source.errorSafeNavigation;
        clone.nilSafeNavigation = source.nilSafeNavigation;
        clone.originalType = source.originalType;
        clone.leafNode = source.leafNode;
    }

    private void cloneBLangIndexBasedAccess(BLangIndexBasedAccess source, BLangIndexBasedAccess clone) {
        clone.indexExpr = this.clone(source.indexExpr);
        this.cloneBLangAccessExpression(source, clone);
    }

    private void cloneBLangStructureTypeNode(BLangStructureTypeNode source, BLangStructureTypeNode clone) {
        clone.fields = this.cloneList(source.fields);
        clone.initFunction = this.clone(source.initFunction);
        clone.isAnonymous = source.isAnonymous;
        clone.isLocal = source.isLocal;
        clone.isFieldAnalyseRequired = source.isFieldAnalyseRequired;
        clone.typeRefs = this.cloneList(source.typeRefs);
    }

    private void cloneBLangMatchBindingPatternClause(BLangMatch.BLangMatchBindingPatternClause source, BLangMatch.BLangMatchBindingPatternClause clone) {
        clone.body = this.clone(source.body);
        clone.matchExpr = this.clone(source.matchExpr);
        clone.isLastPattern = source.isLastPattern;
    }

    private void cloneBLangType(BLangType source, BLangType clone) {
        clone.nullable = source.nullable;
        clone.grouped = source.grouped;
    }

    private <T extends Enum<T>> EnumSet<T> cloneSet(Set<T> source, Class<T> elementType) {
        if (source == null || source.isEmpty()) {
            return EnumSet.noneOf(elementType);
        }
        return EnumSet.copyOf(source);
    }

    @Override
    public void visit(BLangPackage pkgNode) {
    }

    @Override
    public void visit(BLangTestablePackage testablePkgNode) {
    }

    @Override
    public void visit(BLangCompilationUnit source) {
        BLangCompilationUnit clone = new BLangCompilationUnit();
        source.cloneRef = clone;
        clone.name = source.name;
        for (TopLevelNode node : source.topLevelNodes) {
            clone.topLevelNodes.add(this.clone(node));
        }
    }

    @Override
    public void visit(BLangImportPackage source) {
        BLangImportPackage clone = new BLangImportPackage();
        source.cloneRef = clone;
        clone.pkgNameComps = source.pkgNameComps;
        clone.version = source.version;
        clone.alias = source.alias;
        clone.orgName = source.orgName;
        clone.compUnit = source.compUnit;
    }

    @Override
    public void visit(BLangXMLNS source) {
        BLangXMLNS clone = new BLangXMLNS();
        source.cloneRef = clone;
        clone.namespaceURI = this.clone(source.namespaceURI);
        clone.prefix = source.prefix;
    }

    @Override
    public void visit(BLangFunction source) {
        BLangFunction clone = new BLangFunction();
        source.cloneRef = clone;
        clone.attachedFunction = source.attachedFunction;
        clone.objInitFunction = source.objInitFunction;
        clone.interfaceFunction = source.interfaceFunction;
        clone.anonForkName = source.anonForkName;
        this.cloneBLangInvokableNode(source, clone);
    }

    @Override
    public void visit(BLangBlockFunctionBody source) {
        BLangBlockFunctionBody clone = new BLangBlockFunctionBody();
        source.cloneRef = clone;
        clone.pos = source.pos;
        clone.stmts = this.cloneList(source.stmts);
    }

    @Override
    public void visit(BLangExprFunctionBody source) {
        BLangExprFunctionBody clone = new BLangExprFunctionBody();
        source.cloneRef = clone;
        clone.pos = source.pos;
        clone.expr = this.clone(source.expr);
    }

    @Override
    public void visit(BLangExternalFunctionBody source) {
        BLangExternalFunctionBody clone = new BLangExternalFunctionBody();
        source.cloneRef = clone;
        clone.annAttachments = this.cloneList(source.annAttachments);
        clone.pos = source.pos;
    }

    @Override
    public void visit(BLangService source) {
        BLangService clone = new BLangService();
        source.cloneRef = clone;
        clone.flagSet = this.cloneSet(source.flagSet, Flag.class);
        clone.annAttachments = this.cloneList(source.annAttachments);
        clone.markdownDocumentationAttachment = this.clone(source.markdownDocumentationAttachment);
        clone.name = source.name;
        clone.serviceTypeDefinition = this.clone(source.serviceTypeDefinition);
        clone.attachedExprs = this.cloneList(source.attachedExprs);
        clone.variableNode = this.clone(source.variableNode);
        clone.isAnonymousServiceValue = source.isAnonymousServiceValue;
    }

    @Override
    public void visit(BLangResource resourceNode) {
    }

    @Override
    public void visit(BLangTypeDefinition source) {
        BLangTypeDefinition clone = new BLangTypeDefinition();
        source.cloneRef = clone;
        clone.name = source.name;
        clone.typeNode = this.clone(source.typeNode);
        clone.annAttachments = this.cloneList(source.annAttachments);
        clone.markdownDocumentationAttachment = this.clone(source.markdownDocumentationAttachment);
        clone.flagSet = this.cloneSet(source.flagSet, Flag.class);
        clone.precedence = source.precedence;
    }

    @Override
    public void visit(BLangConstant source) {
        BLangConstant clone = new BLangConstant();
        source.cloneRef = clone;
        clone.name = source.name;
        clone.associatedTypeDefinition = this.clone(source.associatedTypeDefinition);
        this.cloneBLangVariable(source, clone);
    }

    @Override
    public void visit(BLangSimpleVariable source) {
        BLangSimpleVariable clone = new BLangSimpleVariable();
        source.cloneRef = clone;
        clone.name = source.name;
        this.cloneBLangVariable(source, clone);
    }

    @Override
    public void visit(BLangWorker workerNode) {
    }

    @Override
    public void visit(BLangEndpoint endpointNode) {
    }

    @Override
    public void visit(BLangIdentifier source) {
        source.cloneRef = source;
    }

    @Override
    public void visit(BLangAnnotation source) {
        BLangAnnotation clone = new BLangAnnotation();
        source.cloneRef = clone;
        clone.name = source.name;
        clone.flagSet = this.cloneSet(source.flagSet, Flag.class);
        clone.annAttachments = this.cloneList(source.annAttachments);
        clone.markdownDocumentationAttachment = this.clone(source.markdownDocumentationAttachment);
        clone.typeNode = this.clone(source.typeNode);
        clone.getAttachPoints().addAll(source.getAttachPoints());
    }

    @Override
    public void visit(BLangAnnotationAttachment source) {
        BLangAnnotationAttachment clone = new BLangAnnotationAttachment();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
        clone.annotationName = source.annotationName;
        clone.attachPoints.addAll(source.attachPoints);
        clone.pkgAlias = source.pkgAlias;
    }

    @Override
    public void visit(BLangBlockStmt source) {
        BLangBlockStmt clone = new BLangBlockStmt();
        source.cloneRef = clone;
        clone.stmts = this.cloneList(source.stmts);
    }

    @Override
    public void visit(BLangLock.BLangLockStmt lockStmtNode) {
    }

    @Override
    public void visit(BLangLock.BLangUnLockStmt unLockNode) {
    }

    @Override
    public void visit(BLangSimpleVariableDef source) {
        BLangSimpleVariableDef clone = new BLangSimpleVariableDef();
        source.cloneRef = clone;
        clone.var = this.clone(source.var);
        clone.isInFork = source.isInFork;
        clone.isWorker = source.isWorker;
    }

    @Override
    public void visit(BLangAssignment source) {
        BLangAssignment clone = new BLangAssignment();
        source.cloneRef = clone;
        clone.varRef = this.clone(source.varRef);
        clone.expr = this.clone(source.expr);
        clone.declaredWithVar = source.declaredWithVar;
    }

    @Override
    public void visit(BLangCompoundAssignment source) {
        BLangCompoundAssignment clone = new BLangCompoundAssignment();
        source.cloneRef = clone;
        clone.varRef = this.clone(source.varRef);
        clone.expr = this.clone(source.expr);
        clone.opKind = source.opKind;
    }

    @Override
    public void visit(BLangAbort source) {
        source.cloneRef = new BLangAbort();
    }

    @Override
    public void visit(BLangRetry source) {
        source.cloneRef = new BLangRetry();
    }

    @Override
    public void visit(BLangContinue source) {
        source.cloneRef = new BLangContinue();
    }

    @Override
    public void visit(BLangBreak source) {
        source.cloneRef = new BLangBreak();
    }

    @Override
    public void visit(BLangReturn source) {
        BLangReturn clone = new BLangReturn();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
    }

    @Override
    public void visit(BLangPanic source) {
        BLangPanic clone = new BLangPanic();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
    }

    @Override
    public void visit(BLangXMLNSStatement source) {
        BLangXMLNSStatement clone = new BLangXMLNSStatement();
        source.cloneRef = clone;
        clone.xmlnsDecl = this.clone(source.xmlnsDecl);
    }

    @Override
    public void visit(BLangExpressionStmt source) {
        BLangExpressionStmt clone = new BLangExpressionStmt();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
    }

    @Override
    public void visit(BLangIf source) {
        BLangIf clone = new BLangIf();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
        clone.body = this.clone(source.body);
        clone.elseStmt = this.clone(source.elseStmt);
    }

    @Override
    public void visit(BLangMatch source) {
        BLangMatch clone = new BLangMatch();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
        clone.patternClauses = this.cloneList(source.patternClauses);
    }

    @Override
    public void visit(BLangMatch.BLangMatchTypedBindingPatternClause source) {
        BLangMatch.BLangMatchTypedBindingPatternClause clone = new BLangMatch.BLangMatchTypedBindingPatternClause();
        source.cloneRef = clone;
        clone.variable = this.clone(source.variable);
        this.cloneBLangMatchBindingPatternClause(source, clone);
    }

    @Override
    public void visit(BLangMatch.BLangMatchStaticBindingPatternClause source) {
        BLangMatch.BLangMatchStaticBindingPatternClause clone = new BLangMatch.BLangMatchStaticBindingPatternClause();
        source.cloneRef = clone;
        clone.literal = this.clone(source.literal);
        this.cloneBLangMatchBindingPatternClause(source, clone);
    }

    @Override
    public void visit(BLangMatch.BLangMatchStructuredBindingPatternClause source) {
        BLangMatch.BLangMatchStructuredBindingPatternClause clone = new BLangMatch.BLangMatchStructuredBindingPatternClause();
        source.cloneRef = clone;
        clone.bindingPatternVariable = this.clone(source.bindingPatternVariable);
        clone.typeGuardExpr = this.clone(source.typeGuardExpr);
        this.cloneBLangMatchBindingPatternClause(source, clone);
    }

    @Override
    public void visit(BLangForeach source) {
        BLangForeach clone = new BLangForeach();
        source.cloneRef = clone;
        clone.collection = this.clone(source.collection);
        clone.body = this.clone(source.body);
        clone.variableDefinitionNode = (VariableDefinitionNode)((Object)this.clone((BLangNode)((Object)source.variableDefinitionNode)));
        clone.isDeclaredWithVar = source.isDeclaredWithVar;
    }

    @Override
    public void visit(BLangWhile source) {
        BLangWhile clone = new BLangWhile();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
        clone.body = this.clone(source.body);
    }

    @Override
    public void visit(BLangLock source) {
        BLangLock clone = new BLangLock();
        source.cloneRef = clone;
        clone.body = this.clone(source.body);
    }

    @Override
    public void visit(BLangTransaction source) {
        BLangTransaction clone = new BLangTransaction();
        source.cloneRef = clone;
        clone.transactionBody = this.clone(source.transactionBody);
        clone.onRetryBody = this.clone(source.onRetryBody);
        clone.committedBody = this.clone(source.committedBody);
        clone.abortedBody = this.clone(source.abortedBody);
        clone.retryCount = this.clone(source.retryCount);
    }

    @Override
    public void visit(BLangTryCatchFinally tryNode) {
    }

    @Override
    public void visit(BLangTupleDestructure source) {
        BLangTupleDestructure clone = new BLangTupleDestructure();
        source.cloneRef = clone;
        clone.varRef = this.clone(source.varRef);
        clone.expr = this.clone(source.expr);
    }

    @Override
    public void visit(BLangRecordDestructure source) {
        BLangRecordDestructure clone = new BLangRecordDestructure();
        source.cloneRef = clone;
        clone.varRef = this.clone(source.varRef);
        clone.expr = this.clone(source.expr);
        clone.declaredWithVar = source.declaredWithVar;
    }

    @Override
    public void visit(BLangErrorDestructure source) {
        BLangErrorDestructure clone = new BLangErrorDestructure();
        source.cloneRef = clone;
        clone.varRef = this.clone(source.varRef);
        clone.expr = this.clone(source.expr);
    }

    @Override
    public void visit(BLangCatch catchNode) {
    }

    @Override
    public void visit(BLangForkJoin source) {
        BLangForkJoin clone = new BLangForkJoin();
        source.cloneRef = clone;
        clone.workers = this.cloneList(source.workers);
    }

    @Override
    public void visit(BLangWorkerSend source) {
        BLangWorkerSend clone = new BLangWorkerSend();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
        clone.workerIdentifier = source.workerIdentifier;
        clone.keyExpr = this.clone(source.keyExpr);
    }

    @Override
    public void visit(BLangWorkerReceive source) {
        BLangWorkerReceive clone = new BLangWorkerReceive();
        source.cloneRef = clone;
        clone.workerIdentifier = source.workerIdentifier;
        clone.keyExpr = this.clone(source.keyExpr);
        clone.isChannel = source.isChannel;
    }

    @Override
    public void visit(BLangLiteral source) {
        if (source.getKind() == NodeKind.NUMERIC_LITERAL) {
            this.visit((BLangNumericLiteral)source);
            return;
        }
        BLangLiteral clone = new BLangLiteral();
        source.cloneRef = clone;
        this.cloneBLangLiteral(source, clone);
    }

    @Override
    public void visit(BLangNumericLiteral source) {
        BLangNumericLiteral clone = new BLangNumericLiteral();
        source.cloneRef = clone;
        this.cloneBLangLiteral(source, clone);
    }

    @Override
    public void visit(BLangTableLiteral source) {
        BLangTableLiteral clone = new BLangTableLiteral();
        source.cloneRef = clone;
        clone.columns.addAll(source.columns);
        clone.tableDataRows = this.cloneList(source.tableDataRows);
        clone.indexColumnsArrayLiteral = this.clone(source.indexColumnsArrayLiteral);
        clone.keyColumnsArrayLiteral = this.clone(source.keyColumnsArrayLiteral);
    }

    @Override
    public void visit(BLangRecordLiteral source) {
        BLangRecordLiteral clone = new BLangRecordLiteral();
        source.cloneRef = clone;
        clone.fields = this.cloneList(source.fields);
    }

    @Override
    public void visit(BLangTupleVarRef source) {
        BLangTupleVarRef clone = new BLangTupleVarRef();
        source.cloneRef = clone;
        clone.pkgAlias = source.pkgAlias;
        clone.expressions = this.cloneList(source.expressions);
        clone.restParam = (ExpressionNode)((Object)this.clone((BLangNode)((Object)source.restParam)));
    }

    @Override
    public void visit(BLangRecordVarRef source) {
        BLangRecordVarRef clone = new BLangRecordVarRef();
        source.cloneRef = clone;
        clone.pkgAlias = source.pkgAlias;
        for (BLangRecordVarRef.BLangRecordVarRefKeyValue field : source.recordRefFields) {
            BLangRecordVarRef.BLangRecordVarRefKeyValue keyValue = new BLangRecordVarRef.BLangRecordVarRefKeyValue();
            keyValue.variableName = field.variableName;
            keyValue.variableReference = this.clone(field.variableReference);
            clone.recordRefFields.add(keyValue);
        }
        clone.restParam = (ExpressionNode)((Object)this.clone((BLangNode)((Object)source.restParam)));
    }

    @Override
    public void visit(BLangErrorVarRef source) {
        BLangErrorVarRef clone = new BLangErrorVarRef();
        source.cloneRef = clone;
        clone.pkgAlias = source.pkgAlias;
        clone.reason = this.clone(source.reason);
        clone.detail = this.cloneList(source.detail);
        clone.restVar = this.clone(source.restVar);
        clone.typeNode = this.clone(source.typeNode);
    }

    @Override
    public void visit(BLangSimpleVarRef source) {
        BLangSimpleVarRef clone = source instanceof BLangRecordLiteral.BLangRecordVarNameField ? new BLangRecordLiteral.BLangRecordVarNameField() : new BLangSimpleVarRef();
        source.cloneRef = clone;
        clone.pkgAlias = source.pkgAlias;
        clone.variableName = source.variableName;
    }

    @Override
    public void visit(BLangFieldBasedAccess source) {
        BLangFieldBasedAccess clone;
        if (source instanceof BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess) {
            BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess fieldBasedAccess = new BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess();
            fieldBasedAccess.nsPrefix = ((BLangFieldBasedAccess.BLangNSPrefixedFieldBasedAccess)source).nsPrefix;
            clone = fieldBasedAccess;
        } else {
            clone = new BLangFieldBasedAccess();
        }
        source.cloneRef = clone;
        clone.field = source.field;
        clone.fieldKind = source.fieldKind;
        this.cloneBLangAccessExpression(source, clone);
    }

    @Override
    public void visit(BLangIndexBasedAccess source) {
        BLangIndexBasedAccess clone = new BLangIndexBasedAccess();
        source.cloneRef = clone;
        this.cloneBLangIndexBasedAccess(source, clone);
    }

    @Override
    public void visit(BLangInvocation source) {
        BLangInvocation clone = new BLangInvocation();
        source.cloneRef = clone;
        clone.pkgAlias = source.pkgAlias;
        clone.name = source.name;
        clone.argExprs = this.cloneList(source.argExprs);
        clone.functionPointerInvocation = source.functionPointerInvocation;
        clone.actionInvocation = source.actionInvocation;
        clone.langLibInvocation = source.langLibInvocation;
        clone.async = source.async;
        clone.flagSet = this.cloneSet(source.flagSet, Flag.class);
        clone.annAttachments = this.cloneList(source.annAttachments);
        clone.requiredArgs = this.cloneList(source.requiredArgs);
        this.cloneBLangAccessExpression(source, clone);
    }

    @Override
    public void visit(BLangTypeInit source) {
        BLangTypeInit clone = new BLangTypeInit();
        source.cloneRef = clone;
        clone.userDefinedType = this.clone(source.userDefinedType);
        clone.argsExpr = this.cloneList(source.argsExpr);
        clone.initInvocation = this.clone(source.initInvocation);
    }

    @Override
    public void visit(BLangInvocation.BLangActionInvocation actionInvocationExpr) {
    }

    @Override
    public void visit(BLangTernaryExpr source) {
        BLangTernaryExpr clone = new BLangTernaryExpr();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
        clone.thenExpr = this.clone(source.thenExpr);
        clone.elseExpr = this.clone(source.elseExpr);
    }

    @Override
    public void visit(BLangWaitExpr source) {
        BLangWaitExpr clone = new BLangWaitExpr();
        source.cloneRef = clone;
        clone.exprList = this.cloneList(source.exprList);
    }

    @Override
    public void visit(BLangTrapExpr source) {
        BLangTrapExpr clone = new BLangTrapExpr();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
    }

    @Override
    public void visit(BLangBinaryExpr source) {
        BLangBinaryExpr clone = new BLangBinaryExpr();
        source.cloneRef = clone;
        clone.lhsExpr = this.clone(source.lhsExpr);
        clone.rhsExpr = this.clone(source.rhsExpr);
        clone.opKind = source.opKind;
        clone.opSymbol = source.opSymbol;
    }

    @Override
    public void visit(BLangElvisExpr source) {
        BLangElvisExpr clone = new BLangElvisExpr();
        source.cloneRef = clone;
        clone.lhsExpr = this.clone(source.lhsExpr);
        clone.rhsExpr = this.clone(source.rhsExpr);
    }

    @Override
    public void visit(BLangGroupExpr source) {
        BLangGroupExpr clone = new BLangGroupExpr();
        source.cloneRef = clone;
        clone.expression = this.clone(source.expression);
        clone.isTypedescExpr = source.isTypedescExpr;
        clone.typedescType = source.typedescType;
    }

    @Override
    public void visit(BLangLetExpression source) {
        BLangLetExpression clone = new BLangLetExpression();
        source.cloneRef = clone;
        clone.letVarDeclarations = this.cloneLetVarDeclarations(source.letVarDeclarations);
        clone.expr = this.clone(source.expr);
    }

    @Override
    public void visit(BLangListConstructorExpr source) {
        BLangListConstructorExpr clone = new BLangListConstructorExpr();
        source.cloneRef = clone;
        clone.exprs = this.cloneList(source.exprs);
        clone.isTypedescExpr = source.isTypedescExpr;
        clone.typedescType = source.typedescType;
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangTupleLiteral tupleLiteral) {
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangArrayLiteral arrayLiteral) {
    }

    @Override
    public void visit(BLangUnaryExpr source) {
        BLangUnaryExpr clone = new BLangUnaryExpr();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
        clone.operator = source.operator;
    }

    @Override
    public void visit(BLangTypedescExpr source) {
        BLangTypedescExpr clone = new BLangTypedescExpr();
        source.cloneRef = clone;
        clone.typeNode = this.clone(source.typeNode);
        clone.resolvedType = source.resolvedType;
    }

    @Override
    public void visit(BLangTypeConversionExpr source) {
        BLangTypeConversionExpr clone = new BLangTypeConversionExpr();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
        clone.typeNode = this.clone(source.typeNode);
        clone.targetType = source.targetType;
        clone.annAttachments = this.cloneList(source.annAttachments);
        clone.flagSet = this.cloneSet(source.flagSet, Flag.class);
        clone.checkTypes = source.checkTypes;
    }

    @Override
    public void visit(BLangXMLQName source) {
        BLangXMLQName clone = new BLangXMLQName();
        source.cloneRef = clone;
        clone.localname = source.localname;
        clone.prefix = source.prefix;
        clone.namespaceURI = source.namespaceURI;
        clone.isUsedInXML = source.isUsedInXML;
    }

    @Override
    public void visit(BLangXMLAttribute source) {
        BLangXMLAttribute clone = new BLangXMLAttribute();
        source.cloneRef = clone;
        clone.name = this.clone(source.name);
        clone.value = this.clone(source.value);
        clone.isNamespaceDeclr = source.isNamespaceDeclr;
    }

    @Override
    public void visit(BLangXMLElementLiteral source) {
        BLangXMLElementLiteral clone = new BLangXMLElementLiteral();
        source.cloneRef = clone;
        clone.startTagName = this.clone(source.startTagName);
        clone.endTagName = this.clone(source.endTagName);
        clone.attributes = this.cloneList(source.attributes);
        clone.children = this.cloneList(source.children);
        clone.inlineNamespaces = this.cloneList(source.inlineNamespaces);
        clone.isRoot = source.isRoot;
    }

    @Override
    public void visit(BLangXMLTextLiteral source) {
        BLangXMLTextLiteral clone = new BLangXMLTextLiteral();
        source.cloneRef = clone;
        clone.textFragments = this.cloneList(source.textFragments);
        clone.concatExpr = this.clone(source.concatExpr);
    }

    @Override
    public void visit(BLangXMLCommentLiteral source) {
        BLangXMLCommentLiteral clone = new BLangXMLCommentLiteral();
        source.cloneRef = clone;
        clone.textFragments = this.cloneList(source.textFragments);
        clone.concatExpr = this.clone(source.concatExpr);
    }

    @Override
    public void visit(BLangXMLProcInsLiteral source) {
        BLangXMLProcInsLiteral clone = new BLangXMLProcInsLiteral();
        source.cloneRef = clone;
        clone.target = this.clone(source.target);
        clone.dataFragments = this.cloneList(source.dataFragments);
        clone.dataConcatExpr = this.clone(source.dataConcatExpr);
    }

    @Override
    public void visit(BLangXMLQuotedString source) {
        BLangXMLQuotedString clone = new BLangXMLQuotedString();
        source.cloneRef = clone;
        clone.textFragments = this.cloneList(source.textFragments);
        clone.quoteType = source.quoteType;
        clone.concatExpr = this.clone(source.concatExpr);
    }

    @Override
    public void visit(BLangStringTemplateLiteral source) {
        BLangStringTemplateLiteral clone = new BLangStringTemplateLiteral();
        source.cloneRef = clone;
        clone.exprs = this.cloneList(source.exprs);
    }

    @Override
    public void visit(BLangLambdaFunction source) {
        BLangLambdaFunction clone = new BLangLambdaFunction();
        source.cloneRef = clone;
        clone.function = this.clone(source.function);
    }

    @Override
    public void visit(BLangArrowFunction source) {
        BLangArrowFunction clone = new BLangArrowFunction();
        source.cloneRef = clone;
        clone.params = this.cloneList(source.params);
        clone.body = this.clone(source.body);
        clone.funcType = source.funcType;
        clone.functionName = source.functionName;
    }

    @Override
    public void visit(BLangXMLAttributeAccess source) {
        BLangXMLAttributeAccess clone = new BLangXMLAttributeAccess();
        source.cloneRef = clone;
        this.cloneBLangIndexBasedAccess(source, clone);
    }

    @Override
    public void visit(BLangIntRangeExpression source) {
        BLangIntRangeExpression clone = new BLangIntRangeExpression();
        source.cloneRef = clone;
        clone.includeStart = source.includeStart;
        clone.includeEnd = source.includeEnd;
        clone.startExpr = this.clone(source.startExpr);
        clone.endExpr = this.clone(source.endExpr);
    }

    @Override
    public void visit(BLangRestArgsExpression source) {
        BLangRestArgsExpression clone = new BLangRestArgsExpression();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
    }

    @Override
    public void visit(BLangNamedArgsExpression source) {
        BLangNamedArgsExpression clone = new BLangNamedArgsExpression();
        source.cloneRef = clone;
        clone.name = source.name;
        clone.expr = this.clone(source.expr);
    }

    @Override
    public void visit(BLangIsAssignableExpr source) {
        BLangIsAssignableExpr clone = new BLangIsAssignableExpr();
        source.cloneRef = clone;
        clone.lhsExpr = this.clone(source.lhsExpr);
        clone.targetType = source.targetType;
        clone.typeNode = this.clone(source.typeNode);
    }

    @Override
    public void visit(BLangMatchExpression bLangMatchExpression) {
    }

    @Override
    public void visit(BLangMatchExpression.BLangMatchExprPatternClause bLangMatchExprPatternClause) {
    }

    @Override
    public void visit(BLangCheckedExpr source) {
        BLangCheckedExpr clone = new BLangCheckedExpr();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
    }

    @Override
    public void visit(BLangCheckPanickedExpr source) {
        BLangCheckPanickedExpr clone = new BLangCheckPanickedExpr();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
    }

    @Override
    public void visit(BLangServiceConstructorExpr source) {
        BLangServiceConstructorExpr clone = new BLangServiceConstructorExpr();
        source.cloneRef = clone;
        clone.serviceNode = this.clone(source.serviceNode);
    }

    @Override
    public void visit(BLangTypeTestExpr source) {
        BLangTypeTestExpr clone = new BLangTypeTestExpr();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
        clone.typeNode = this.clone(source.typeNode);
    }

    @Override
    public void visit(BLangIsLikeExpr typeTestExpr) {
    }

    @Override
    public void visit(BLangIgnoreExpr ignoreExpr) {
    }

    @Override
    public void visit(BLangAnnotAccessExpr source) {
        BLangAnnotAccessExpr clone = new BLangAnnotAccessExpr();
        source.cloneRef = clone;
        clone.pkgAlias = source.pkgAlias;
        clone.annotationName = source.annotationName;
        this.cloneBLangAccessExpression(source, clone);
    }

    @Override
    public void visit(BLangQueryAction source) {
        BLangQueryAction clone = new BLangQueryAction();
        source.cloneRef = clone;
        clone.fromClauseList = this.cloneList(source.fromClauseList);
        clone.letClauseList = this.cloneList(source.letClauseList);
        clone.doClause = this.clone(source.doClause);
        clone.whereClauseList = this.cloneList(source.whereClauseList);
    }

    @Override
    public void visit(BLangQueryExpr source) {
        BLangQueryExpr clone = new BLangQueryExpr();
        source.cloneRef = clone;
        clone.fromClauseList = this.cloneList(source.fromClauseList);
        clone.letClausesList = this.cloneList(source.letClausesList);
        clone.selectClause = this.clone(source.selectClause);
        clone.whereClauseList = this.cloneList(source.whereClauseList);
    }

    @Override
    public void visit(BLangFromClause source) {
        BLangFromClause clone = new BLangFromClause();
        source.cloneRef = clone;
        clone.variableDefinitionNode = (VariableDefinitionNode)((Object)this.clone((BLangNode)((Object)source.variableDefinitionNode)));
        clone.collection = this.clone(source.collection);
        clone.isDeclaredWithVar = source.isDeclaredWithVar;
        clone.varType = source.varType;
        clone.resultType = source.resultType;
        clone.nillableResultType = source.nillableResultType;
    }

    @Override
    public void visit(BLangLetClause source) {
        BLangLetClause clone = new BLangLetClause();
        source.cloneRef = clone;
        clone.letVarDeclarations = this.cloneLetVarDeclarations(source.letVarDeclarations);
    }

    private List<BLangLetVariable> cloneLetVarDeclarations(List<BLangLetVariable> letVarDeclarations) {
        ArrayList<BLangLetVariable> cloneDefs = new ArrayList<BLangLetVariable>();
        for (BLangLetVariable letVarDeclaration : letVarDeclarations) {
            BLangLetVariable clonedVar = new BLangLetVariable();
            clonedVar.definitionNode = this.clone(letVarDeclaration.definitionNode);
            cloneDefs.add(clonedVar);
        }
        return cloneDefs;
    }

    @Override
    public void visit(BLangSelectClause source) {
        BLangSelectClause clone = new BLangSelectClause();
        source.cloneRef = clone;
        clone.expression = this.clone(source.expression);
    }

    @Override
    public void visit(BLangWhereClause source) {
        BLangWhereClause clone = new BLangWhereClause();
        source.cloneRef = clone;
        clone.expression = this.clone(source.expression);
    }

    @Override
    public void visit(BLangDoClause source) {
        BLangDoClause clone = new BLangDoClause();
        source.cloneRef = clone;
        clone.body = this.clone(source.body);
    }

    @Override
    public void visit(BLangValueType source) {
        BLangValueType clone = new BLangValueType();
        source.cloneRef = clone;
        clone.typeKind = source.typeKind;
        this.cloneBLangType(source, clone);
    }

    @Override
    public void visit(BLangArrayType source) {
        BLangArrayType clone = new BLangArrayType();
        source.cloneRef = clone;
        clone.elemtype = this.clone(source.elemtype);
        clone.dimensions = source.dimensions;
        clone.sizes = source.sizes;
        this.cloneBLangType(source, clone);
    }

    @Override
    public void visit(BLangBuiltInRefTypeNode source) {
        BLangBuiltInRefTypeNode clone = new BLangBuiltInRefTypeNode();
        source.cloneRef = clone;
        clone.typeKind = source.typeKind;
        this.cloneBLangType(source, clone);
    }

    @Override
    public void visit(BLangConstrainedType source) {
        BLangConstrainedType clone = new BLangConstrainedType();
        source.cloneRef = clone;
        clone.type = this.clone(source.type);
        clone.constraint = this.clone(source.constraint);
        this.cloneBLangType(source, clone);
    }

    @Override
    public void visit(BLangStreamType source) {
        BLangStreamType clone = new BLangStreamType();
        source.cloneRef = clone;
        clone.type = this.clone(source.type);
        clone.constraint = this.clone(source.constraint);
        clone.error = this.clone(source.error);
        this.cloneBLangType(source, clone);
    }

    @Override
    public void visit(BLangUserDefinedType source) {
        BLangUserDefinedType clone = new BLangUserDefinedType();
        source.cloneRef = clone;
        clone.pkgAlias = source.pkgAlias;
        clone.typeName = source.typeName;
        clone.flagSet = this.cloneSet(source.flagSet, Flag.class);
        this.cloneBLangType(source, clone);
    }

    @Override
    public void visit(BLangFunctionTypeNode source) {
        BLangFunctionTypeNode clone = new BLangFunctionTypeNode();
        source.cloneRef = clone;
        clone.params = this.cloneList(source.params);
        clone.restParam = this.clone(source.restParam);
        clone.returnTypeNode = this.clone(source.returnTypeNode);
        clone.flagSet = this.cloneSet(source.flagSet, Flag.class);
        clone.returnsKeywordExists = source.returnsKeywordExists;
        this.cloneBLangType(source, clone);
    }

    @Override
    public void visit(BLangUnionTypeNode source) {
        BLangUnionTypeNode clone = new BLangUnionTypeNode();
        source.cloneRef = clone;
        clone.memberTypeNodes = this.cloneList(source.memberTypeNodes);
        this.cloneBLangType(source, clone);
    }

    @Override
    public void visit(BLangObjectTypeNode source) {
        BLangObjectTypeNode clone = new BLangObjectTypeNode();
        source.cloneRef = clone;
        clone.functions = this.cloneList(source.functions);
        clone.initFunction = this.clone(source.initFunction);
        clone.receiver = this.clone(source.receiver);
        clone.flagSet = this.cloneSet(source.flagSet, Flag.class);
        this.cloneBLangStructureTypeNode(source, clone);
        this.cloneBLangType(source, clone);
    }

    @Override
    public void visit(BLangRecordTypeNode source) {
        BLangRecordTypeNode clone = new BLangRecordTypeNode();
        source.cloneRef = clone;
        clone.sealed = source.sealed;
        clone.restFieldType = this.clone(source.restFieldType);
        clone.analyzed = source.analyzed;
        this.cloneBLangStructureTypeNode(source, clone);
        this.cloneBLangType(source, clone);
    }

    @Override
    public void visit(BLangFiniteTypeNode source) {
        BLangFiniteTypeNode clone = new BLangFiniteTypeNode();
        source.cloneRef = clone;
        clone.valueSpace = this.cloneList(source.valueSpace);
        this.cloneBLangType(source, clone);
    }

    @Override
    public void visit(BLangTupleTypeNode source) {
        BLangTupleTypeNode clone = new BLangTupleTypeNode();
        source.cloneRef = clone;
        clone.memberTypeNodes = this.cloneList(source.memberTypeNodes);
        clone.restParamType = this.clone(source.restParamType);
        this.cloneBLangType(source, clone);
    }

    @Override
    public void visit(BLangErrorType source) {
        BLangErrorType clone = new BLangErrorType();
        source.cloneRef = clone;
        clone.reasonType = this.clone(source.reasonType);
        clone.detailType = this.clone(source.detailType);
        this.cloneBLangType(source, clone);
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangLocalVarRef localVarRef) {
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFieldVarRef fieldVarRef) {
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangPackageVarRef packageVarRef) {
    }

    @Override
    public void visit(BLangConstRef constRef) {
        BLangConstRef clone = new BLangConstRef();
        constRef.cloneRef = clone;
        clone.pkgAlias = constRef.pkgAlias;
        clone.originalValue = constRef.originalValue;
        clone.value = constRef.value;
        clone.variableName = constRef.variableName;
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangFunctionVarRef functionVarRef) {
    }

    @Override
    public void visit(BLangSimpleVarRef.BLangTypeLoad typeLoad) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStructFieldAccessExpr fieldAccessExpr) {
    }

    @Override
    public void visit(BLangFieldBasedAccess.BLangStructFunctionVarRef functionVarRef) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangMapAccessExpr mapKeyAccessExpr) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangArrayAccessExpr arrayIndexAccessExpr) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangTupleAccessExpr arrayIndexAccessExpr) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangXMLAccessExpr xmlAccessExpr) {
    }

    @Override
    public void visit(BLangRecordLiteral.BLangMapLiteral mapLiteral) {
    }

    @Override
    public void visit(BLangRecordLiteral.BLangStructLiteral structLiteral) {
    }

    @Override
    public void visit(BLangRecordLiteral.BLangChannelLiteral channelLiteral) {
    }

    @Override
    public void visit(BLangInvocation.BFunctionPointerInvocation bFunctionPointerInvocation) {
    }

    @Override
    public void visit(BLangInvocation.BLangAttachedFunctionInvocation iExpr) {
    }

    @Override
    public void visit(BLangListConstructorExpr.BLangJSONArrayLiteral jsonArrayLiteral) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangJSONAccessExpr jsonAccessExpr) {
    }

    @Override
    public void visit(BLangIndexBasedAccess.BLangStringAccessExpr stringAccessExpr) {
    }

    @Override
    public void visit(BLangXMLNS.BLangLocalXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangXMLNS.BLangPackageXMLNS xmlnsNode) {
    }

    @Override
    public void visit(BLangXMLSequenceLiteral bLangXMLSequenceLiteral) {
    }

    @Override
    public void visit(BLangStatementExpression source) {
        BLangStatementExpression clone = new BLangStatementExpression();
        source.cloneRef = clone;
        clone.expr = this.clone(source.expr);
        clone.stmt = this.clone(source.stmt);
    }

    @Override
    public void visit(BLangMarkdownDocumentationLine source) {
        BLangMarkdownDocumentationLine clone = new BLangMarkdownDocumentationLine();
        source.cloneRef = clone;
        clone.text = source.text;
    }

    @Override
    public void visit(BLangMarkdownParameterDocumentation source) {
        BLangMarkdownParameterDocumentation clone = new BLangMarkdownParameterDocumentation();
        source.cloneRef = clone;
        clone.parameterName = source.parameterName;
        clone.parameterDocumentationLines = source.parameterDocumentationLines;
    }

    @Override
    public void visit(BLangMarkdownReturnParameterDocumentation source) {
        BLangMarkdownReturnParameterDocumentation clone = new BLangMarkdownReturnParameterDocumentation();
        source.cloneRef = clone;
        clone.returnParameterDocumentationLines = source.returnParameterDocumentationLines;
        clone.type = source.type;
    }

    @Override
    public void visit(BLangMarkDownDeprecationDocumentation source) {
        BLangMarkDownDeprecationDocumentation clone = new BLangMarkDownDeprecationDocumentation();
        source.cloneRef = clone;
        clone.deprecationLine = source.deprecationLine;
        clone.deprecationDocumentationLines = source.deprecationDocumentationLines;
        clone.isCorrectDeprecationLine = source.isCorrectDeprecationLine;
    }

    @Override
    public void visit(BLangMarkDownDeprecatedParametersDocumentation source) {
        BLangMarkDownDeprecatedParametersDocumentation clone = new BLangMarkDownDeprecatedParametersDocumentation();
        source.cloneRef = clone;
        clone.parameters = source.parameters;
    }

    @Override
    public void visit(BLangMarkdownDocumentation source) {
        BLangMarkdownDocumentation clone = new BLangMarkdownDocumentation();
        source.cloneRef = clone;
        clone.documentationLines.addAll(this.cloneList(source.documentationLines));
        clone.parameters.addAll(this.cloneList(source.parameters));
        clone.references.addAll(this.cloneList(source.references));
        clone.returnParameter = this.clone(source.returnParameter);
        clone.deprecationDocumentation = this.clone(source.deprecationDocumentation);
        clone.deprecatedParametersDocumentation = this.clone(source.deprecatedParametersDocumentation);
    }

    @Override
    public void visit(BLangTupleVariable source) {
        BLangTupleVariable clone = new BLangTupleVariable();
        source.cloneRef = clone;
        clone.memberVariables = this.cloneList(source.memberVariables);
        clone.restVariable = this.clone(source.restVariable);
        this.cloneBLangVariable(source, clone);
    }

    @Override
    public void visit(BLangTupleVariableDef source) {
        BLangTupleVariableDef clone = new BLangTupleVariableDef();
        source.cloneRef = clone;
        clone.var = this.clone(source.var);
    }

    @Override
    public void visit(BLangRecordVariable source) {
        BLangRecordVariable clone = new BLangRecordVariable();
        source.cloneRef = clone;
        for (BLangRecordVariable.BLangRecordVariableKeyValue keyValue : source.variableList) {
            BLangRecordVariable.BLangRecordVariableKeyValue newKeyValue = new BLangRecordVariable.BLangRecordVariableKeyValue();
            newKeyValue.key = keyValue.key;
            newKeyValue.valueBindingPattern = this.clone(keyValue.valueBindingPattern);
            clone.variableList.add(newKeyValue);
        }
        clone.restParam = this.clone((BLangVariable)source.restParam);
        this.cloneBLangVariable(source, clone);
    }

    @Override
    public void visit(BLangRecordVariableDef source) {
        BLangRecordVariableDef clone = new BLangRecordVariableDef();
        source.cloneRef = clone;
        clone.var = this.clone(source.var);
    }

    @Override
    public void visit(BLangErrorVariable source) {
        BLangErrorVariable clone = new BLangErrorVariable();
        source.cloneRef = clone;
        clone.reason = this.clone(source.reason);
        for (BLangErrorVariable.BLangErrorDetailEntry entry : source.detail) {
            clone.detail.add(new BLangErrorVariable.BLangErrorDetailEntry(entry.key, this.clone(entry.valueBindingPattern)));
        }
        clone.restDetail = this.clone(source.restDetail);
        clone.detailExpr = this.clone(source.detailExpr);
        clone.reasonVarPrefixAvailable = source.reasonVarPrefixAvailable;
        clone.reasonMatchConst = source.reasonMatchConst;
        clone.isInMatchStmt = source.isInMatchStmt;
        this.cloneBLangVariable(source, clone);
    }

    @Override
    public void visit(BLangErrorVariableDef source) {
        BLangErrorVariableDef clone = new BLangErrorVariableDef();
        source.cloneRef = clone;
        clone.errorVariable = this.clone(source.errorVariable);
    }

    @Override
    public void visit(BLangWorkerFlushExpr source) {
        BLangWorkerFlushExpr clone = new BLangWorkerFlushExpr();
        source.cloneRef = clone;
        clone.workerIdentifier = source.workerIdentifier;
        clone.workerIdentifierList.addAll(source.workerIdentifierList);
    }

    @Override
    public void visit(BLangWorkerSyncSendExpr source) {
        BLangWorkerSyncSendExpr clone = new BLangWorkerSyncSendExpr();
        source.cloneRef = clone;
        clone.workerIdentifier = source.workerIdentifier;
        clone.expr = this.clone(source.expr);
    }

    @Override
    public void visit(BLangWaitForAllExpr source) {
        BLangWaitForAllExpr clone = new BLangWaitForAllExpr();
        source.cloneRef = clone;
        for (BLangWaitForAllExpr.BLangWaitKeyValue keyValue : source.keyValuePairs) {
            clone.keyValuePairs.add(this.clone(keyValue));
        }
    }

    @Override
    public void visit(BLangMarkdownReferenceDocumentation source) {
        BLangMarkdownReferenceDocumentation clone = new BLangMarkdownReferenceDocumentation();
        source.cloneRef = clone;
        clone.qualifier = source.qualifier;
        clone.typeName = source.typeName;
        clone.identifier = source.identifier;
        clone.referenceName = source.referenceName;
        clone.kind = source.kind;
        clone.type = source.type;
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitLiteral waitLiteral) {
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordKeyValueField source) {
        BLangRecordLiteral.BLangRecordKeyValueField clone = new BLangRecordLiteral.BLangRecordKeyValueField();
        source.cloneRef = clone;
        clone.pos = source.pos;
        clone.addWS(source.getWS());
        BLangRecordLiteral.BLangRecordKey newKey = new BLangRecordLiteral.BLangRecordKey(this.clone(source.key.expr));
        newKey.computedKey = source.key.computedKey;
        clone.key = newKey;
        clone.valueExpr = this.clone(source.valueExpr);
    }

    @Override
    public void visit(BLangRecordLiteral.BLangRecordSpreadOperatorField source) {
        BLangRecordLiteral.BLangRecordSpreadOperatorField clone = new BLangRecordLiteral.BLangRecordSpreadOperatorField();
        source.cloneRef = clone;
        clone.pos = source.pos;
        clone.addWS(source.getWS());
        clone.expr = this.clone(source.expr);
    }

    @Override
    public void visit(BLangWaitForAllExpr.BLangWaitKeyValue source) {
        BLangWaitForAllExpr.BLangWaitKeyValue clone = new BLangWaitForAllExpr.BLangWaitKeyValue();
        source.cloneRef = clone;
        clone.pos = source.pos;
        clone.addWS(source.getWS());
        clone.key = source.key;
        clone.valueExpr = this.clone(source.valueExpr);
        clone.keyExpr = this.clone(source.keyExpr);
    }

    @Override
    public void visit(BLangXMLElementFilter source) {
        BLangXMLElementFilter clone = new BLangXMLElementFilter(source.pos, source.getWS(), source.namespace, source.nsPos, source.name, source.elemNamePos);
        source.cloneRef = clone;
    }

    @Override
    public void visit(BLangXMLElementAccess source) {
        BLangXMLElementAccess clone = new BLangXMLElementAccess(source.pos, source.getWS(), this.clone(source.expr), this.cloneList(source.filters));
        source.cloneRef = clone;
    }

    @Override
    public void visit(BLangXMLNavigationAccess source) {
        BLangXMLNavigationAccess clone = new BLangXMLNavigationAccess(source.pos, source.getWS(), this.clone(source.expr), this.cloneList(source.filters), source.navAccessType, this.clone(source.childIndex));
        source.cloneRef = clone;
    }
}

